/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdvertiserVerificationStatus
extends APINode {
    @SerializedName(value="banner_type")
    private String mBannerType = null;
    @SerializedName(value="grace_period_ends_at")
    private String mGracePeriodEndsAt = null;
    @SerializedName(value="ufac_redirect_uri")
    private String mUfacRedirectUri = null;
    @SerializedName(value="verification_status")
    private String mVerificationStatus = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdvertiserVerificationStatus loadJSON(String json, APIContext context, String header) {
        AdvertiserVerificationStatus advertiserVerificationStatus = (AdvertiserVerificationStatus)AdvertiserVerificationStatus.getGson().fromJson(json, AdvertiserVerificationStatus.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(advertiserVerificationStatus.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        advertiserVerificationStatus.context = context;
        advertiserVerificationStatus.rawValue = json;
        advertiserVerificationStatus.header = header;
        return advertiserVerificationStatus;
    }

    public static APINodeList<AdvertiserVerificationStatus> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdvertiserVerificationStatus> advertiserVerificationStatuss = new APINodeList<AdvertiserVerificationStatus>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        advertiserVerificationStatuss.add(AdvertiserVerificationStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return advertiserVerificationStatuss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            advertiserVerificationStatuss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        advertiserVerificationStatuss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            advertiserVerificationStatuss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            advertiserVerificationStatuss.add(AdvertiserVerificationStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                advertiserVerificationStatuss.add(AdvertiserVerificationStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            advertiserVerificationStatuss.add(AdvertiserVerificationStatus.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return advertiserVerificationStatuss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        advertiserVerificationStatuss.add(AdvertiserVerificationStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return advertiserVerificationStatuss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        advertiserVerificationStatuss.add(AdvertiserVerificationStatus.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return advertiserVerificationStatuss;
                }
                advertiserVerificationStatuss.clear();
                advertiserVerificationStatuss.add(AdvertiserVerificationStatus.loadJSON(json, context, header));
                return advertiserVerificationStatuss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdvertiserVerificationStatus.getGson().toJson((Object)this);
    }

    public String getFieldBannerType() {
        return this.mBannerType;
    }

    public AdvertiserVerificationStatus setFieldBannerType(String value) {
        this.mBannerType = value;
        return this;
    }

    public String getFieldGracePeriodEndsAt() {
        return this.mGracePeriodEndsAt;
    }

    public AdvertiserVerificationStatus setFieldGracePeriodEndsAt(String value) {
        this.mGracePeriodEndsAt = value;
        return this;
    }

    public String getFieldUfacRedirectUri() {
        return this.mUfacRedirectUri;
    }

    public AdvertiserVerificationStatus setFieldUfacRedirectUri(String value) {
        this.mUfacRedirectUri = value;
        return this;
    }

    public String getFieldVerificationStatus() {
        return this.mVerificationStatus;
    }

    public AdvertiserVerificationStatus setFieldVerificationStatus(String value) {
        this.mVerificationStatus = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdvertiserVerificationStatus copyFrom(AdvertiserVerificationStatus instance) {
        this.mBannerType = instance.mBannerType;
        this.mGracePeriodEndsAt = instance.mGracePeriodEndsAt;
        this.mUfacRedirectUri = instance.mUfacRedirectUri;
        this.mVerificationStatus = instance.mVerificationStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdvertiserVerificationStatus> getParser() {
        return new APIRequest.ResponseParser<AdvertiserVerificationStatus>(){

            @Override
            public APINodeList<AdvertiserVerificationStatus> parseResponse(String response, APIContext context, APIRequest<AdvertiserVerificationStatus> request, String header) throws APIException.MalformedResponseException {
                return AdvertiserVerificationStatus.parseResponse(response, context, request, header);
            }
        };
    }
}

