/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class PremiumMusicVideo
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="cross_post_videos")
    private List<Object> mCrossPostVideos = null;
    @SerializedName(value="eligible_cross_post_pages")
    private List<Object> mEligibleCrossPostPages = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="preferred_video_thumbnail_image_uri")
    private String mPreferredVideoThumbnailImageUri = null;
    @SerializedName(value="premium_music_video_metadata")
    private Object mPremiumMusicVideoMetadata = null;
    @SerializedName(value="scheduled_publish_time")
    private Long mScheduledPublishTime = null;
    @SerializedName(value="title")
    private String mTitle = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PremiumMusicVideo loadJSON(String json, APIContext context, String header) {
        PremiumMusicVideo premiumMusicVideo = (PremiumMusicVideo)PremiumMusicVideo.getGson().fromJson(json, PremiumMusicVideo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(premiumMusicVideo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        premiumMusicVideo.context = context;
        premiumMusicVideo.rawValue = json;
        premiumMusicVideo.header = header;
        return premiumMusicVideo;
    }

    public static APINodeList<PremiumMusicVideo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PremiumMusicVideo> premiumMusicVideos = new APINodeList<PremiumMusicVideo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        premiumMusicVideos.add(PremiumMusicVideo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return premiumMusicVideos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            premiumMusicVideos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        premiumMusicVideos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            premiumMusicVideos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            premiumMusicVideos.add(PremiumMusicVideo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                premiumMusicVideos.add(PremiumMusicVideo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            premiumMusicVideos.add(PremiumMusicVideo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return premiumMusicVideos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        premiumMusicVideos.add(PremiumMusicVideo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return premiumMusicVideos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        premiumMusicVideos.add(PremiumMusicVideo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return premiumMusicVideos;
                }
                premiumMusicVideos.clear();
                premiumMusicVideos.add(PremiumMusicVideo.loadJSON(json, context, header));
                return premiumMusicVideos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PremiumMusicVideo.getGson().toJson((Object)this);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public PremiumMusicVideo setFieldCreationTime(String value) {
        this.mCreationTime = value;
        return this;
    }

    public List<Object> getFieldCrossPostVideos() {
        return this.mCrossPostVideos;
    }

    public PremiumMusicVideo setFieldCrossPostVideos(List<Object> value) {
        this.mCrossPostVideos = value;
        return this;
    }

    public List<Object> getFieldEligibleCrossPostPages() {
        return this.mEligibleCrossPostPages;
    }

    public PremiumMusicVideo setFieldEligibleCrossPostPages(List<Object> value) {
        this.mEligibleCrossPostPages = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public PremiumMusicVideo setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldPreferredVideoThumbnailImageUri() {
        return this.mPreferredVideoThumbnailImageUri;
    }

    public PremiumMusicVideo setFieldPreferredVideoThumbnailImageUri(String value) {
        this.mPreferredVideoThumbnailImageUri = value;
        return this;
    }

    public Object getFieldPremiumMusicVideoMetadata() {
        return this.mPremiumMusicVideoMetadata;
    }

    public PremiumMusicVideo setFieldPremiumMusicVideoMetadata(Object value) {
        this.mPremiumMusicVideoMetadata = value;
        return this;
    }

    public Long getFieldScheduledPublishTime() {
        return this.mScheduledPublishTime;
    }

    public PremiumMusicVideo setFieldScheduledPublishTime(Long value) {
        this.mScheduledPublishTime = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public PremiumMusicVideo setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PremiumMusicVideo copyFrom(PremiumMusicVideo instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mCrossPostVideos = instance.mCrossPostVideos;
        this.mEligibleCrossPostPages = instance.mEligibleCrossPostPages;
        this.mId = instance.mId;
        this.mPreferredVideoThumbnailImageUri = instance.mPreferredVideoThumbnailImageUri;
        this.mPremiumMusicVideoMetadata = instance.mPremiumMusicVideoMetadata;
        this.mScheduledPublishTime = instance.mScheduledPublishTime;
        this.mTitle = instance.mTitle;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PremiumMusicVideo> getParser() {
        return new APIRequest.ResponseParser<PremiumMusicVideo>(){

            @Override
            public APINodeList<PremiumMusicVideo> parseResponse(String response, APIContext context, APIRequest<PremiumMusicVideo> request, String header) throws APIException.MalformedResponseException {
                return PremiumMusicVideo.parseResponse(response, context, request, header);
            }
        };
    }
}

