/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class InstagramThread
extends APINode {
    @SerializedName(value="folder")
    private String mFolder = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="participants")
    private Object mParticipants = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    InstagramThread() {
    }

    public InstagramThread(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InstagramThread(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InstagramThread fetch() throws APIException {
        InstagramThread newInstance = InstagramThread.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InstagramThread fetchById(Long id, APIContext context) throws APIException {
        return InstagramThread.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InstagramThread> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InstagramThread.fetchByIdAsync(id.toString(), context);
    }

    public static InstagramThread fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InstagramThread> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InstagramThread> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InstagramThread>(context, "", "/", "GET", InstagramThread.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InstagramThread>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InstagramThread>(context, "", "/", "GET", InstagramThread.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstagramThread loadJSON(String json, APIContext context, String header) {
        InstagramThread instagramThread = (InstagramThread)InstagramThread.getGson().fromJson(json, InstagramThread.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instagramThread.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instagramThread.context = context;
        instagramThread.rawValue = json;
        instagramThread.header = header;
        return instagramThread;
    }

    public static APINodeList<InstagramThread> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InstagramThread> instagramThreads = new APINodeList<InstagramThread>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instagramThreads.add(InstagramThread.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return instagramThreads;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instagramThreads.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instagramThreads.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            instagramThreads.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instagramThreads.add(InstagramThread.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instagramThreads.add(InstagramThread.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instagramThreads.add(InstagramThread.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return instagramThreads;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instagramThreads.add(InstagramThread.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return instagramThreads;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instagramThreads.add(InstagramThread.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instagramThreads;
                }
                instagramThreads.clear();
                instagramThreads.add(InstagramThread.loadJSON(json, context, header));
                return instagramThreads;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstagramThread.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldFolder() {
        return this.mFolder;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Object getFieldParticipants() {
        return this.mParticipants;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstagramThread copyFrom(InstagramThread instance) {
        this.mFolder = instance.mFolder;
        this.mId = instance.mId;
        this.mParticipants = instance.mParticipants;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstagramThread> getParser() {
        return new APIRequest.ResponseParser<InstagramThread>(){

            @Override
            public APINodeList<InstagramThread> parseResponse(String response, APIContext context, APIRequest<InstagramThread> request, String header) throws APIException.MalformedResponseException {
                return InstagramThread.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<InstagramThread> {
        InstagramThread lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"folder", "id", "participants", "updated_time"};

        @Override
        public InstagramThread getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstagramThread parseResponse(String response, String header) throws APIException {
            return InstagramThread.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public InstagramThread execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstagramThread execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<InstagramThread> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstagramThread> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, InstagramThread>(){

                public InstagramThread apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestFolderField() {
            return this.requestFolderField(true);
        }

        public APIRequestGet requestFolderField(boolean value) {
            this.requestField("folder", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestParticipantsField() {
            return this.requestParticipantsField(true);
        }

        public APIRequestGet requestParticipantsField(boolean value) {
            this.requestField("participants", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }
}

