/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ImageCopyright;
import com.facebook.ads.sdk.Profile;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ImageReferenceMatch
extends APINode {
    @SerializedName(value="conflict_status")
    private String mConflictStatus = null;
    @SerializedName(value="conflicting_countries")
    private List<String> mConflictingCountries = null;
    @SerializedName(value="country_resolution_history")
    private List<Map<String, List<Object>>> mCountryResolutionHistory = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="current_conflict_resolved_countries")
    private List<Map<String, Object>> mCurrentConflictResolvedCountries = null;
    @SerializedName(value="displayed_match_state")
    private String mDisplayedMatchState = null;
    @SerializedName(value="dispute_form_data_entries_with_translations")
    private List<Object> mDisputeFormDataEntriesWithTranslations = null;
    @SerializedName(value="expiration_time")
    private String mExpirationTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="match_state")
    private String mMatchState = null;
    @SerializedName(value="matched_reference_copyright")
    private ImageCopyright mMatchedReferenceCopyright = null;
    @SerializedName(value="matched_reference_owner")
    private Profile mMatchedReferenceOwner = null;
    @SerializedName(value="modification_history")
    private List<Object> mModificationHistory = null;
    @SerializedName(value="reference_copyright")
    private ImageCopyright mReferenceCopyright = null;
    @SerializedName(value="reference_owner")
    private Profile mReferenceOwner = null;
    @SerializedName(value="rejection_form_data_entries_with_translations")
    private List<Object> mRejectionFormDataEntriesWithTranslations = null;
    @SerializedName(value="resolution_reason")
    private String mResolutionReason = null;
    @SerializedName(value="update_time")
    private String mUpdateTime = null;
    protected static Gson gson = null;

    ImageReferenceMatch() {
    }

    public ImageReferenceMatch(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ImageReferenceMatch(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ImageReferenceMatch fetch() throws APIException {
        ImageReferenceMatch newInstance = ImageReferenceMatch.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ImageReferenceMatch fetchById(Long id, APIContext context) throws APIException {
        return ImageReferenceMatch.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ImageReferenceMatch> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ImageReferenceMatch.fetchByIdAsync(id.toString(), context);
    }

    public static ImageReferenceMatch fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ImageReferenceMatch> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ImageReferenceMatch> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ImageReferenceMatch>(context, "", "/", "GET", ImageReferenceMatch.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ImageReferenceMatch>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ImageReferenceMatch>(context, "", "/", "GET", ImageReferenceMatch.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ImageReferenceMatch loadJSON(String json, APIContext context, String header) {
        ImageReferenceMatch imageReferenceMatch = (ImageReferenceMatch)ImageReferenceMatch.getGson().fromJson(json, ImageReferenceMatch.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(imageReferenceMatch.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        imageReferenceMatch.context = context;
        imageReferenceMatch.rawValue = json;
        imageReferenceMatch.header = header;
        return imageReferenceMatch;
    }

    public static APINodeList<ImageReferenceMatch> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ImageReferenceMatch> imageReferenceMatchs = new APINodeList<ImageReferenceMatch>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        imageReferenceMatchs.add(ImageReferenceMatch.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return imageReferenceMatchs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            imageReferenceMatchs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        imageReferenceMatchs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            imageReferenceMatchs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            imageReferenceMatchs.add(ImageReferenceMatch.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                imageReferenceMatchs.add(ImageReferenceMatch.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            imageReferenceMatchs.add(ImageReferenceMatch.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return imageReferenceMatchs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        imageReferenceMatchs.add(ImageReferenceMatch.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return imageReferenceMatchs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        imageReferenceMatchs.add(ImageReferenceMatch.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return imageReferenceMatchs;
                }
                imageReferenceMatchs.clear();
                imageReferenceMatchs.add(ImageReferenceMatch.loadJSON(json, context, header));
                return imageReferenceMatchs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ImageReferenceMatch.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldConflictStatus() {
        return this.mConflictStatus;
    }

    public List<String> getFieldConflictingCountries() {
        return this.mConflictingCountries;
    }

    public List<Map<String, List<Object>>> getFieldCountryResolutionHistory() {
        return this.mCountryResolutionHistory;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public List<Map<String, Object>> getFieldCurrentConflictResolvedCountries() {
        return this.mCurrentConflictResolvedCountries;
    }

    public String getFieldDisplayedMatchState() {
        return this.mDisplayedMatchState;
    }

    public List<Object> getFieldDisputeFormDataEntriesWithTranslations() {
        return this.mDisputeFormDataEntriesWithTranslations;
    }

    public String getFieldExpirationTime() {
        return this.mExpirationTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldMatchState() {
        return this.mMatchState;
    }

    public ImageCopyright getFieldMatchedReferenceCopyright() {
        if (this.mMatchedReferenceCopyright != null) {
            this.mMatchedReferenceCopyright.context = this.getContext();
        }
        return this.mMatchedReferenceCopyright;
    }

    public Profile getFieldMatchedReferenceOwner() {
        if (this.mMatchedReferenceOwner != null) {
            this.mMatchedReferenceOwner.context = this.getContext();
        }
        return this.mMatchedReferenceOwner;
    }

    public List<Object> getFieldModificationHistory() {
        return this.mModificationHistory;
    }

    public ImageCopyright getFieldReferenceCopyright() {
        if (this.mReferenceCopyright != null) {
            this.mReferenceCopyright.context = this.getContext();
        }
        return this.mReferenceCopyright;
    }

    public Profile getFieldReferenceOwner() {
        if (this.mReferenceOwner != null) {
            this.mReferenceOwner.context = this.getContext();
        }
        return this.mReferenceOwner;
    }

    public List<Object> getFieldRejectionFormDataEntriesWithTranslations() {
        return this.mRejectionFormDataEntriesWithTranslations;
    }

    public String getFieldResolutionReason() {
        return this.mResolutionReason;
    }

    public String getFieldUpdateTime() {
        return this.mUpdateTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ImageReferenceMatch copyFrom(ImageReferenceMatch instance) {
        this.mConflictStatus = instance.mConflictStatus;
        this.mConflictingCountries = instance.mConflictingCountries;
        this.mCountryResolutionHistory = instance.mCountryResolutionHistory;
        this.mCreationTime = instance.mCreationTime;
        this.mCurrentConflictResolvedCountries = instance.mCurrentConflictResolvedCountries;
        this.mDisplayedMatchState = instance.mDisplayedMatchState;
        this.mDisputeFormDataEntriesWithTranslations = instance.mDisputeFormDataEntriesWithTranslations;
        this.mExpirationTime = instance.mExpirationTime;
        this.mId = instance.mId;
        this.mMatchState = instance.mMatchState;
        this.mMatchedReferenceCopyright = instance.mMatchedReferenceCopyright;
        this.mMatchedReferenceOwner = instance.mMatchedReferenceOwner;
        this.mModificationHistory = instance.mModificationHistory;
        this.mReferenceCopyright = instance.mReferenceCopyright;
        this.mReferenceOwner = instance.mReferenceOwner;
        this.mRejectionFormDataEntriesWithTranslations = instance.mRejectionFormDataEntriesWithTranslations;
        this.mResolutionReason = instance.mResolutionReason;
        this.mUpdateTime = instance.mUpdateTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ImageReferenceMatch> getParser() {
        return new APIRequest.ResponseParser<ImageReferenceMatch>(){

            @Override
            public APINodeList<ImageReferenceMatch> parseResponse(String response, APIContext context, APIRequest<ImageReferenceMatch> request, String header) throws APIException.MalformedResponseException {
                return ImageReferenceMatch.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ImageReferenceMatch> {
        ImageReferenceMatch lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"conflict_status", "conflicting_countries", "country_resolution_history", "creation_time", "current_conflict_resolved_countries", "displayed_match_state", "dispute_form_data_entries_with_translations", "expiration_time", "id", "match_state", "matched_reference_copyright", "matched_reference_owner", "modification_history", "reference_copyright", "reference_owner", "rejection_form_data_entries_with_translations", "resolution_reason", "update_time"};

        @Override
        public ImageReferenceMatch getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ImageReferenceMatch parseResponse(String response, String header) throws APIException {
            return ImageReferenceMatch.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ImageReferenceMatch execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ImageReferenceMatch execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ImageReferenceMatch> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ImageReferenceMatch> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ImageReferenceMatch>(){

                public ImageReferenceMatch apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestConflictStatusField() {
            return this.requestConflictStatusField(true);
        }

        public APIRequestGet requestConflictStatusField(boolean value) {
            this.requestField("conflict_status", value);
            return this;
        }

        public APIRequestGet requestConflictingCountriesField() {
            return this.requestConflictingCountriesField(true);
        }

        public APIRequestGet requestConflictingCountriesField(boolean value) {
            this.requestField("conflicting_countries", value);
            return this;
        }

        public APIRequestGet requestCountryResolutionHistoryField() {
            return this.requestCountryResolutionHistoryField(true);
        }

        public APIRequestGet requestCountryResolutionHistoryField(boolean value) {
            this.requestField("country_resolution_history", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCurrentConflictResolvedCountriesField() {
            return this.requestCurrentConflictResolvedCountriesField(true);
        }

        public APIRequestGet requestCurrentConflictResolvedCountriesField(boolean value) {
            this.requestField("current_conflict_resolved_countries", value);
            return this;
        }

        public APIRequestGet requestDisplayedMatchStateField() {
            return this.requestDisplayedMatchStateField(true);
        }

        public APIRequestGet requestDisplayedMatchStateField(boolean value) {
            this.requestField("displayed_match_state", value);
            return this;
        }

        public APIRequestGet requestDisputeFormDataEntriesWithTranslationsField() {
            return this.requestDisputeFormDataEntriesWithTranslationsField(true);
        }

        public APIRequestGet requestDisputeFormDataEntriesWithTranslationsField(boolean value) {
            this.requestField("dispute_form_data_entries_with_translations", value);
            return this;
        }

        public APIRequestGet requestExpirationTimeField() {
            return this.requestExpirationTimeField(true);
        }

        public APIRequestGet requestExpirationTimeField(boolean value) {
            this.requestField("expiration_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMatchStateField() {
            return this.requestMatchStateField(true);
        }

        public APIRequestGet requestMatchStateField(boolean value) {
            this.requestField("match_state", value);
            return this;
        }

        public APIRequestGet requestMatchedReferenceCopyrightField() {
            return this.requestMatchedReferenceCopyrightField(true);
        }

        public APIRequestGet requestMatchedReferenceCopyrightField(boolean value) {
            this.requestField("matched_reference_copyright", value);
            return this;
        }

        public APIRequestGet requestMatchedReferenceOwnerField() {
            return this.requestMatchedReferenceOwnerField(true);
        }

        public APIRequestGet requestMatchedReferenceOwnerField(boolean value) {
            this.requestField("matched_reference_owner", value);
            return this;
        }

        public APIRequestGet requestModificationHistoryField() {
            return this.requestModificationHistoryField(true);
        }

        public APIRequestGet requestModificationHistoryField(boolean value) {
            this.requestField("modification_history", value);
            return this;
        }

        public APIRequestGet requestReferenceCopyrightField() {
            return this.requestReferenceCopyrightField(true);
        }

        public APIRequestGet requestReferenceCopyrightField(boolean value) {
            this.requestField("reference_copyright", value);
            return this;
        }

        public APIRequestGet requestReferenceOwnerField() {
            return this.requestReferenceOwnerField(true);
        }

        public APIRequestGet requestReferenceOwnerField(boolean value) {
            this.requestField("reference_owner", value);
            return this;
        }

        public APIRequestGet requestRejectionFormDataEntriesWithTranslationsField() {
            return this.requestRejectionFormDataEntriesWithTranslationsField(true);
        }

        public APIRequestGet requestRejectionFormDataEntriesWithTranslationsField(boolean value) {
            this.requestField("rejection_form_data_entries_with_translations", value);
            return this;
        }

        public APIRequestGet requestResolutionReasonField() {
            return this.requestResolutionReasonField(true);
        }

        public APIRequestGet requestResolutionReasonField(boolean value) {
            this.requestField("resolution_reason", value);
            return this;
        }

        public APIRequestGet requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGet requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }
    }
}

