/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdsValueAdjustmentRuleCollection
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_default_setting")
    private Boolean mIsDefaultSetting = null;
    @SerializedName(value="last_attach_time")
    private String mLastAttachTime = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="product_type")
    private String mProductType = null;
    @SerializedName(value="status")
    private String mStatus = null;
    protected static Gson gson = null;

    AdsValueAdjustmentRuleCollection() {
    }

    public AdsValueAdjustmentRuleCollection(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsValueAdjustmentRuleCollection(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsValueAdjustmentRuleCollection fetch() throws APIException {
        AdsValueAdjustmentRuleCollection newInstance = AdsValueAdjustmentRuleCollection.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsValueAdjustmentRuleCollection fetchById(Long id, APIContext context) throws APIException {
        return AdsValueAdjustmentRuleCollection.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsValueAdjustmentRuleCollection> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsValueAdjustmentRuleCollection.fetchByIdAsync(id.toString(), context);
    }

    public static AdsValueAdjustmentRuleCollection fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsValueAdjustmentRuleCollection> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsValueAdjustmentRuleCollection> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsValueAdjustmentRuleCollection>(context, "", "/", "GET", AdsValueAdjustmentRuleCollection.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsValueAdjustmentRuleCollection>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsValueAdjustmentRuleCollection>(context, "", "/", "GET", AdsValueAdjustmentRuleCollection.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsValueAdjustmentRuleCollection loadJSON(String json, APIContext context, String header) {
        AdsValueAdjustmentRuleCollection adsValueAdjustmentRuleCollection = (AdsValueAdjustmentRuleCollection)AdsValueAdjustmentRuleCollection.getGson().fromJson(json, AdsValueAdjustmentRuleCollection.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsValueAdjustmentRuleCollection.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsValueAdjustmentRuleCollection.context = context;
        adsValueAdjustmentRuleCollection.rawValue = json;
        adsValueAdjustmentRuleCollection.header = header;
        return adsValueAdjustmentRuleCollection;
    }

    public static APINodeList<AdsValueAdjustmentRuleCollection> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsValueAdjustmentRuleCollection> adsValueAdjustmentRuleCollections = new APINodeList<AdsValueAdjustmentRuleCollection>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsValueAdjustmentRuleCollections.add(AdsValueAdjustmentRuleCollection.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsValueAdjustmentRuleCollections;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsValueAdjustmentRuleCollections.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsValueAdjustmentRuleCollections.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsValueAdjustmentRuleCollections.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsValueAdjustmentRuleCollections.add(AdsValueAdjustmentRuleCollection.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsValueAdjustmentRuleCollections.add(AdsValueAdjustmentRuleCollection.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsValueAdjustmentRuleCollections.add(AdsValueAdjustmentRuleCollection.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsValueAdjustmentRuleCollections;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsValueAdjustmentRuleCollections.add(AdsValueAdjustmentRuleCollection.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsValueAdjustmentRuleCollections;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsValueAdjustmentRuleCollections.add(AdsValueAdjustmentRuleCollection.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsValueAdjustmentRuleCollections;
                }
                adsValueAdjustmentRuleCollections.clear();
                adsValueAdjustmentRuleCollections.add(AdsValueAdjustmentRuleCollection.loadJSON(json, context, header));
                return adsValueAdjustmentRuleCollections;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsValueAdjustmentRuleCollection.getGson().toJson((Object)this);
    }

    public APIRequestCreateDeleteRuleSet createDeleteRuleSet() {
        return new APIRequestCreateDeleteRuleSet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetRules getRules() {
        return new APIRequestGetRules(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsDefaultSetting() {
        return this.mIsDefaultSetting;
    }

    public String getFieldLastAttachTime() {
        return this.mLastAttachTime;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldProductType() {
        return this.mProductType;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsValueAdjustmentRuleCollection copyFrom(AdsValueAdjustmentRuleCollection instance) {
        this.mId = instance.mId;
        this.mIsDefaultSetting = instance.mIsDefaultSetting;
        this.mLastAttachTime = instance.mLastAttachTime;
        this.mName = instance.mName;
        this.mProductType = instance.mProductType;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsValueAdjustmentRuleCollection> getParser() {
        return new APIRequest.ResponseParser<AdsValueAdjustmentRuleCollection>(){

            @Override
            public APINodeList<AdsValueAdjustmentRuleCollection> parseResponse(String response, APIContext context, APIRequest<AdsValueAdjustmentRuleCollection> request, String header) throws APIException.MalformedResponseException {
                return AdsValueAdjustmentRuleCollection.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_DELETED("DELETED");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumProductType {
        VALUE_AUDIENCE("AUDIENCE"),
        VALUE_LEADGEN_ADS("LEADGEN_ADS"),
        VALUE_OMNI_CHANNEL("OMNI_CHANNEL");

        private String value;

        private EnumProductType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<AdsValueAdjustmentRuleCollection> {
        AdsValueAdjustmentRuleCollection lastResponse = null;
        public static final String[] PARAMS = new String[]{"is_default_setting", "name", "rules"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsValueAdjustmentRuleCollection getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsValueAdjustmentRuleCollection parseResponse(String response, String header) throws APIException {
            return AdsValueAdjustmentRuleCollection.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsValueAdjustmentRuleCollection execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsValueAdjustmentRuleCollection execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsValueAdjustmentRuleCollection> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsValueAdjustmentRuleCollection> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsValueAdjustmentRuleCollection>(){

                public AdsValueAdjustmentRuleCollection apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setIsDefaultSetting(Boolean isDefaultSetting) {
            this.setParam("is_default_setting", isDefaultSetting);
            return this;
        }

        public APIRequestUpdate setIsDefaultSetting(String isDefaultSetting) {
            this.setParam("is_default_setting", isDefaultSetting);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setRules(List<Map<String, String>> rules) {
            this.setParam("rules", rules);
            return this;
        }

        public APIRequestUpdate setRules(String rules) {
            this.setParam("rules", rules);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<AdsValueAdjustmentRuleCollection> {
        AdsValueAdjustmentRuleCollection lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "is_default_setting", "last_attach_time", "name", "product_type", "status"};

        @Override
        public AdsValueAdjustmentRuleCollection getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsValueAdjustmentRuleCollection parseResponse(String response, String header) throws APIException {
            return AdsValueAdjustmentRuleCollection.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsValueAdjustmentRuleCollection execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsValueAdjustmentRuleCollection execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsValueAdjustmentRuleCollection> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsValueAdjustmentRuleCollection> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsValueAdjustmentRuleCollection>(){

                public AdsValueAdjustmentRuleCollection apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsDefaultSettingField() {
            return this.requestIsDefaultSettingField(true);
        }

        public APIRequestGet requestIsDefaultSettingField(boolean value) {
            this.requestField("is_default_setting", value);
            return this;
        }

        public APIRequestGet requestLastAttachTimeField() {
            return this.requestLastAttachTimeField(true);
        }

        public APIRequestGet requestLastAttachTimeField(boolean value) {
            this.requestField("last_attach_time", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestProductTypeField() {
            return this.requestProductTypeField(true);
        }

        public APIRequestGet requestProductTypeField(boolean value) {
            this.requestField("product_type", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }

    public static class APIRequestGetRules
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetRules(String nodeId, APIContext context) {
            super(context, nodeId, "/rules", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetRules setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetRules setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetRules requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetRules requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRules requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetRules requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRules requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetRules requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateDeleteRuleSet
    extends APIRequest<AdsValueAdjustmentRuleCollection> {
        AdsValueAdjustmentRuleCollection lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsValueAdjustmentRuleCollection getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsValueAdjustmentRuleCollection parseResponse(String response, String header) throws APIException {
            return AdsValueAdjustmentRuleCollection.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsValueAdjustmentRuleCollection execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsValueAdjustmentRuleCollection execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsValueAdjustmentRuleCollection> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsValueAdjustmentRuleCollection> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsValueAdjustmentRuleCollection>(){

                public AdsValueAdjustmentRuleCollection apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateDeleteRuleSet(String nodeId, APIContext context) {
            super(context, nodeId, "/deleteruleset", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateDeleteRuleSet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateDeleteRuleSet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateDeleteRuleSet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateDeleteRuleSet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDeleteRuleSet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateDeleteRuleSet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDeleteRuleSet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateDeleteRuleSet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

