/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class WorkSkill
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    WorkSkill() {
    }

    public WorkSkill(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public WorkSkill(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public WorkSkill fetch() throws APIException {
        WorkSkill newInstance = WorkSkill.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static WorkSkill fetchById(Long id, APIContext context) throws APIException {
        return WorkSkill.fetchById(id.toString(), context);
    }

    public static ListenableFuture<WorkSkill> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return WorkSkill.fetchByIdAsync(id.toString(), context);
    }

    public static WorkSkill fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<WorkSkill> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<WorkSkill> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<WorkSkill>(context, "", "/", "GET", WorkSkill.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<WorkSkill>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<WorkSkill>(context, "", "/", "GET", WorkSkill.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static WorkSkill loadJSON(String json, APIContext context, String header) {
        WorkSkill workSkill = (WorkSkill)WorkSkill.getGson().fromJson(json, WorkSkill.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(workSkill.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        workSkill.context = context;
        workSkill.rawValue = json;
        workSkill.header = header;
        return workSkill;
    }

    public static APINodeList<WorkSkill> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WorkSkill> workSkills = new APINodeList<WorkSkill>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        workSkills.add(WorkSkill.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return workSkills;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            workSkills.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        workSkills.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            workSkills.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            workSkills.add(WorkSkill.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                workSkills.add(WorkSkill.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            workSkills.add(WorkSkill.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return workSkills;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        workSkills.add(WorkSkill.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return workSkills;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        workSkills.add(WorkSkill.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return workSkills;
                }
                workSkills.clear();
                workSkills.add(WorkSkill.loadJSON(json, context, header));
                return workSkills;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WorkSkill.getGson().toJson((Object)this);
    }

    public APIRequestGetUsers getUsers() {
        return new APIRequestGetUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WorkSkill copyFrom(WorkSkill instance) {
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WorkSkill> getParser() {
        return new APIRequest.ResponseParser<WorkSkill>(){

            @Override
            public APINodeList<WorkSkill> parseResponse(String response, APIContext context, APIRequest<WorkSkill> request, String header) throws APIException.MalformedResponseException {
                return WorkSkill.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<WorkSkill> {
        WorkSkill lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name"};

        @Override
        public WorkSkill getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WorkSkill parseResponse(String response, String header) throws APIException {
            return WorkSkill.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WorkSkill execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WorkSkill execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WorkSkill> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WorkSkill> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WorkSkill>(){

                public WorkSkill apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    public static class APIRequestGetUsers
    extends APIRequest<User> {
        APINodeList<User> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "age_range", "birthday", "client_business_id", "community", "cover", "currency", "education", "email", "favorite_athletes", "favorite_teams", "first_name", "gender", "hometown", "id", "inspirational_people", "install_type", "installed", "is_guest_user", "is_work_account", "languages", "last_name", "link", "local_news_megaphone_dismiss_status", "local_news_subscription_status", "locale", "location", "meeting_for", "middle_name", "name", "name_format", "payment_pricepoints", "political", "profile_pic", "quotes", "relationship_status", "religion", "shared_login_upgrade_required_by", "short_name", "significant_other", "sports", "supports_donate_button_in_live_video", "third_party_id", "timezone", "token_for_business", "updated_time", "verified", "video_upload_limits", "website"};

        @Override
        public APINodeList<User> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<User> parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<User> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<User> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<User>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<User>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<User>>(){

                public APINodeList<User> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetUsers requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetUsers requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetUsers requestAgeRangeField() {
            return this.requestAgeRangeField(true);
        }

        public APIRequestGetUsers requestAgeRangeField(boolean value) {
            this.requestField("age_range", value);
            return this;
        }

        public APIRequestGetUsers requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetUsers requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetUsers requestClientBusinessIdField() {
            return this.requestClientBusinessIdField(true);
        }

        public APIRequestGetUsers requestClientBusinessIdField(boolean value) {
            this.requestField("client_business_id", value);
            return this;
        }

        public APIRequestGetUsers requestCommunityField() {
            return this.requestCommunityField(true);
        }

        public APIRequestGetUsers requestCommunityField(boolean value) {
            this.requestField("community", value);
            return this;
        }

        public APIRequestGetUsers requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetUsers requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetUsers requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetUsers requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetUsers requestEducationField() {
            return this.requestEducationField(true);
        }

        public APIRequestGetUsers requestEducationField(boolean value) {
            this.requestField("education", value);
            return this;
        }

        public APIRequestGetUsers requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetUsers requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetUsers requestFavoriteAthletesField() {
            return this.requestFavoriteAthletesField(true);
        }

        public APIRequestGetUsers requestFavoriteAthletesField(boolean value) {
            this.requestField("favorite_athletes", value);
            return this;
        }

        public APIRequestGetUsers requestFavoriteTeamsField() {
            return this.requestFavoriteTeamsField(true);
        }

        public APIRequestGetUsers requestFavoriteTeamsField(boolean value) {
            this.requestField("favorite_teams", value);
            return this;
        }

        public APIRequestGetUsers requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetUsers requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetUsers requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGetUsers requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGetUsers requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetUsers requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetUsers requestInspirationalPeopleField() {
            return this.requestInspirationalPeopleField(true);
        }

        public APIRequestGetUsers requestInspirationalPeopleField(boolean value) {
            this.requestField("inspirational_people", value);
            return this;
        }

        public APIRequestGetUsers requestInstallTypeField() {
            return this.requestInstallTypeField(true);
        }

        public APIRequestGetUsers requestInstallTypeField(boolean value) {
            this.requestField("install_type", value);
            return this;
        }

        public APIRequestGetUsers requestInstalledField() {
            return this.requestInstalledField(true);
        }

        public APIRequestGetUsers requestInstalledField(boolean value) {
            this.requestField("installed", value);
            return this;
        }

        public APIRequestGetUsers requestIsGuestUserField() {
            return this.requestIsGuestUserField(true);
        }

        public APIRequestGetUsers requestIsGuestUserField(boolean value) {
            this.requestField("is_guest_user", value);
            return this;
        }

        public APIRequestGetUsers requestIsWorkAccountField() {
            return this.requestIsWorkAccountField(true);
        }

        public APIRequestGetUsers requestIsWorkAccountField(boolean value) {
            this.requestField("is_work_account", value);
            return this;
        }

        public APIRequestGetUsers requestLanguagesField() {
            return this.requestLanguagesField(true);
        }

        public APIRequestGetUsers requestLanguagesField(boolean value) {
            this.requestField("languages", value);
            return this;
        }

        public APIRequestGetUsers requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetUsers requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetUsers requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetUsers requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetUsers requestLocalNewsMegaphoneDismissStatusField() {
            return this.requestLocalNewsMegaphoneDismissStatusField(true);
        }

        public APIRequestGetUsers requestLocalNewsMegaphoneDismissStatusField(boolean value) {
            this.requestField("local_news_megaphone_dismiss_status", value);
            return this;
        }

        public APIRequestGetUsers requestLocalNewsSubscriptionStatusField() {
            return this.requestLocalNewsSubscriptionStatusField(true);
        }

        public APIRequestGetUsers requestLocalNewsSubscriptionStatusField(boolean value) {
            this.requestField("local_news_subscription_status", value);
            return this;
        }

        public APIRequestGetUsers requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGetUsers requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGetUsers requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetUsers requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetUsers requestMeetingForField() {
            return this.requestMeetingForField(true);
        }

        public APIRequestGetUsers requestMeetingForField(boolean value) {
            this.requestField("meeting_for", value);
            return this;
        }

        public APIRequestGetUsers requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGetUsers requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGetUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetUsers requestNameFormatField() {
            return this.requestNameFormatField(true);
        }

        public APIRequestGetUsers requestNameFormatField(boolean value) {
            this.requestField("name_format", value);
            return this;
        }

        public APIRequestGetUsers requestPaymentPricepointsField() {
            return this.requestPaymentPricepointsField(true);
        }

        public APIRequestGetUsers requestPaymentPricepointsField(boolean value) {
            this.requestField("payment_pricepoints", value);
            return this;
        }

        public APIRequestGetUsers requestPoliticalField() {
            return this.requestPoliticalField(true);
        }

        public APIRequestGetUsers requestPoliticalField(boolean value) {
            this.requestField("political", value);
            return this;
        }

        public APIRequestGetUsers requestProfilePicField() {
            return this.requestProfilePicField(true);
        }

        public APIRequestGetUsers requestProfilePicField(boolean value) {
            this.requestField("profile_pic", value);
            return this;
        }

        public APIRequestGetUsers requestQuotesField() {
            return this.requestQuotesField(true);
        }

        public APIRequestGetUsers requestQuotesField(boolean value) {
            this.requestField("quotes", value);
            return this;
        }

        public APIRequestGetUsers requestRelationshipStatusField() {
            return this.requestRelationshipStatusField(true);
        }

        public APIRequestGetUsers requestRelationshipStatusField(boolean value) {
            this.requestField("relationship_status", value);
            return this;
        }

        public APIRequestGetUsers requestReligionField() {
            return this.requestReligionField(true);
        }

        public APIRequestGetUsers requestReligionField(boolean value) {
            this.requestField("religion", value);
            return this;
        }

        public APIRequestGetUsers requestSharedLoginUpgradeRequiredByField() {
            return this.requestSharedLoginUpgradeRequiredByField(true);
        }

        public APIRequestGetUsers requestSharedLoginUpgradeRequiredByField(boolean value) {
            this.requestField("shared_login_upgrade_required_by", value);
            return this;
        }

        public APIRequestGetUsers requestShortNameField() {
            return this.requestShortNameField(true);
        }

        public APIRequestGetUsers requestShortNameField(boolean value) {
            this.requestField("short_name", value);
            return this;
        }

        public APIRequestGetUsers requestSignificantOtherField() {
            return this.requestSignificantOtherField(true);
        }

        public APIRequestGetUsers requestSignificantOtherField(boolean value) {
            this.requestField("significant_other", value);
            return this;
        }

        public APIRequestGetUsers requestSportsField() {
            return this.requestSportsField(true);
        }

        public APIRequestGetUsers requestSportsField(boolean value) {
            this.requestField("sports", value);
            return this;
        }

        public APIRequestGetUsers requestSupportsDonateButtonInLiveVideoField() {
            return this.requestSupportsDonateButtonInLiveVideoField(true);
        }

        public APIRequestGetUsers requestSupportsDonateButtonInLiveVideoField(boolean value) {
            this.requestField("supports_donate_button_in_live_video", value);
            return this;
        }

        public APIRequestGetUsers requestThirdPartyIdField() {
            return this.requestThirdPartyIdField(true);
        }

        public APIRequestGetUsers requestThirdPartyIdField(boolean value) {
            this.requestField("third_party_id", value);
            return this;
        }

        public APIRequestGetUsers requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGetUsers requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGetUsers requestTokenForBusinessField() {
            return this.requestTokenForBusinessField(true);
        }

        public APIRequestGetUsers requestTokenForBusinessField(boolean value) {
            this.requestField("token_for_business", value);
            return this;
        }

        public APIRequestGetUsers requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetUsers requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetUsers requestVerifiedField() {
            return this.requestVerifiedField(true);
        }

        public APIRequestGetUsers requestVerifiedField(boolean value) {
            this.requestField("verified", value);
            return this;
        }

        public APIRequestGetUsers requestVideoUploadLimitsField() {
            return this.requestVideoUploadLimitsField(true);
        }

        public APIRequestGetUsers requestVideoUploadLimitsField(boolean value) {
            this.requestField("video_upload_limits", value);
            return this;
        }

        public APIRequestGetUsers requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetUsers requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }
    }
}

