/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AudioIsrc
extends APINode {
    @SerializedName(value="all_kg_featured_artists")
    private String mAllKgFeaturedArtists = null;
    @SerializedName(value="all_kg_main_artists")
    private String mAllKgMainArtists = null;
    @SerializedName(value="artist_profile_picture_url")
    private String mArtistProfilePictureUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="isrc")
    private String mIsrc = null;
    @SerializedName(value="publishing_rights_data")
    private Object mPublishingRightsData = null;
    @SerializedName(value="top_searchable_artist_id")
    private String mTopSearchableArtistId = null;
    @SerializedName(value="top_searchable_artist_name")
    private String mTopSearchableArtistName = null;
    @SerializedName(value="top_searchable_artist_profile_pic_url")
    private String mTopSearchableArtistProfilePicUrl = null;
    protected static Gson gson = null;

    AudioIsrc() {
    }

    public AudioIsrc(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AudioIsrc(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AudioIsrc fetch() throws APIException {
        AudioIsrc newInstance = AudioIsrc.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AudioIsrc fetchById(Long id, APIContext context) throws APIException {
        return AudioIsrc.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AudioIsrc> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AudioIsrc.fetchByIdAsync(id.toString(), context);
    }

    public static AudioIsrc fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AudioIsrc> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AudioIsrc> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AudioIsrc>(context, "", "/", "GET", AudioIsrc.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AudioIsrc>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AudioIsrc>(context, "", "/", "GET", AudioIsrc.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AudioIsrc loadJSON(String json, APIContext context, String header) {
        AudioIsrc audioIsrc = (AudioIsrc)AudioIsrc.getGson().fromJson(json, AudioIsrc.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audioIsrc.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audioIsrc.context = context;
        audioIsrc.rawValue = json;
        audioIsrc.header = header;
        return audioIsrc;
    }

    public static APINodeList<AudioIsrc> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudioIsrc> audioIsrcs = new APINodeList<AudioIsrc>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audioIsrcs.add(AudioIsrc.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return audioIsrcs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audioIsrcs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audioIsrcs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audioIsrcs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audioIsrcs.add(AudioIsrc.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audioIsrcs.add(AudioIsrc.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audioIsrcs.add(AudioIsrc.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return audioIsrcs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audioIsrcs.add(AudioIsrc.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return audioIsrcs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audioIsrcs.add(AudioIsrc.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audioIsrcs;
                }
                audioIsrcs.clear();
                audioIsrcs.add(AudioIsrc.loadJSON(json, context, header));
                return audioIsrcs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudioIsrc.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAllKgFeaturedArtists() {
        return this.mAllKgFeaturedArtists;
    }

    public String getFieldAllKgMainArtists() {
        return this.mAllKgMainArtists;
    }

    public String getFieldArtistProfilePictureUrl() {
        return this.mArtistProfilePictureUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIsrc() {
        return this.mIsrc;
    }

    public Object getFieldPublishingRightsData() {
        return this.mPublishingRightsData;
    }

    public String getFieldTopSearchableArtistId() {
        return this.mTopSearchableArtistId;
    }

    public String getFieldTopSearchableArtistName() {
        return this.mTopSearchableArtistName;
    }

    public String getFieldTopSearchableArtistProfilePicUrl() {
        return this.mTopSearchableArtistProfilePicUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudioIsrc copyFrom(AudioIsrc instance) {
        this.mAllKgFeaturedArtists = instance.mAllKgFeaturedArtists;
        this.mAllKgMainArtists = instance.mAllKgMainArtists;
        this.mArtistProfilePictureUrl = instance.mArtistProfilePictureUrl;
        this.mId = instance.mId;
        this.mIsrc = instance.mIsrc;
        this.mPublishingRightsData = instance.mPublishingRightsData;
        this.mTopSearchableArtistId = instance.mTopSearchableArtistId;
        this.mTopSearchableArtistName = instance.mTopSearchableArtistName;
        this.mTopSearchableArtistProfilePicUrl = instance.mTopSearchableArtistProfilePicUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudioIsrc> getParser() {
        return new APIRequest.ResponseParser<AudioIsrc>(){

            @Override
            public APINodeList<AudioIsrc> parseResponse(String response, APIContext context, APIRequest<AudioIsrc> request, String header) throws APIException.MalformedResponseException {
                return AudioIsrc.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AudioIsrc> {
        AudioIsrc lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"all_kg_featured_artists", "all_kg_main_artists", "artist_profile_picture_url", "id", "isrc", "publishing_rights_data", "top_searchable_artist_id", "top_searchable_artist_name", "top_searchable_artist_profile_pic_url"};

        @Override
        public AudioIsrc getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AudioIsrc parseResponse(String response, String header) throws APIException {
            return AudioIsrc.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AudioIsrc execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AudioIsrc execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AudioIsrc> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AudioIsrc> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AudioIsrc>(){

                public AudioIsrc apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAllKgFeaturedArtistsField() {
            return this.requestAllKgFeaturedArtistsField(true);
        }

        public APIRequestGet requestAllKgFeaturedArtistsField(boolean value) {
            this.requestField("all_kg_featured_artists", value);
            return this;
        }

        public APIRequestGet requestAllKgMainArtistsField() {
            return this.requestAllKgMainArtistsField(true);
        }

        public APIRequestGet requestAllKgMainArtistsField(boolean value) {
            this.requestField("all_kg_main_artists", value);
            return this;
        }

        public APIRequestGet requestArtistProfilePictureUrlField() {
            return this.requestArtistProfilePictureUrlField(true);
        }

        public APIRequestGet requestArtistProfilePictureUrlField(boolean value) {
            this.requestField("artist_profile_picture_url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsrcField() {
            return this.requestIsrcField(true);
        }

        public APIRequestGet requestIsrcField(boolean value) {
            this.requestField("isrc", value);
            return this;
        }

        public APIRequestGet requestPublishingRightsDataField() {
            return this.requestPublishingRightsDataField(true);
        }

        public APIRequestGet requestPublishingRightsDataField(boolean value) {
            this.requestField("publishing_rights_data", value);
            return this;
        }

        public APIRequestGet requestTopSearchableArtistIdField() {
            return this.requestTopSearchableArtistIdField(true);
        }

        public APIRequestGet requestTopSearchableArtistIdField(boolean value) {
            this.requestField("top_searchable_artist_id", value);
            return this;
        }

        public APIRequestGet requestTopSearchableArtistNameField() {
            return this.requestTopSearchableArtistNameField(true);
        }

        public APIRequestGet requestTopSearchableArtistNameField(boolean value) {
            this.requestField("top_searchable_artist_name", value);
            return this;
        }

        public APIRequestGet requestTopSearchableArtistProfilePicUrlField() {
            return this.requestTopSearchableArtistProfilePicUrlField(true);
        }

        public APIRequestGet requestTopSearchableArtistProfilePicUrlField(boolean value) {
            this.requestField("top_searchable_artist_profile_pic_url", value);
            return this;
        }
    }
}

