/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AnalyticsSegment
extends APINode {
    @SerializedName(value="custom_audience_ineligiblity_reasons")
    private List<String> mCustomAudienceIneligiblityReasons = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="estimated_custom_audience_size")
    private Long mEstimatedCustomAudienceSize = null;
    @SerializedName(value="event_info_rules")
    private List<Object> mEventInfoRules = null;
    @SerializedName(value="event_rules")
    private List<Object> mEventRules = null;
    @SerializedName(value="filter_set")
    private String mFilterSet = null;
    @SerializedName(value="has_demographic_rules")
    private Boolean mHasDemographicRules = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_all_user")
    private Boolean mIsAllUser = null;
    @SerializedName(value="is_eligible_for_push_campaign")
    private Boolean mIsEligibleForPushCampaign = null;
    @SerializedName(value="is_internal")
    private Boolean mIsInternal = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="percentile_rules")
    private List<Object> mPercentileRules = null;
    @SerializedName(value="time_last_seen")
    private Long mTimeLastSeen = null;
    @SerializedName(value="time_last_updated")
    private Long mTimeLastUpdated = null;
    @SerializedName(value="user_property_rules")
    private List<Object> mUserPropertyRules = null;
    @SerializedName(value="web_param_rules")
    private List<Object> mWebParamRules = null;
    protected static Gson gson = null;

    AnalyticsSegment() {
    }

    public AnalyticsSegment(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AnalyticsSegment(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AnalyticsSegment fetch() throws APIException {
        AnalyticsSegment newInstance = AnalyticsSegment.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AnalyticsSegment fetchById(Long id, APIContext context) throws APIException {
        return AnalyticsSegment.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AnalyticsSegment> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AnalyticsSegment.fetchByIdAsync(id.toString(), context);
    }

    public static AnalyticsSegment fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AnalyticsSegment> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AnalyticsSegment> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AnalyticsSegment>(context, "", "/", "GET", AnalyticsSegment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AnalyticsSegment>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AnalyticsSegment>(context, "", "/", "GET", AnalyticsSegment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AnalyticsSegment loadJSON(String json, APIContext context, String header) {
        AnalyticsSegment analyticsSegment = (AnalyticsSegment)AnalyticsSegment.getGson().fromJson(json, AnalyticsSegment.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(analyticsSegment.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        analyticsSegment.context = context;
        analyticsSegment.rawValue = json;
        analyticsSegment.header = header;
        return analyticsSegment;
    }

    public static APINodeList<AnalyticsSegment> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AnalyticsSegment> analyticsSegments = new APINodeList<AnalyticsSegment>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        analyticsSegments.add(AnalyticsSegment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return analyticsSegments;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            analyticsSegments.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        analyticsSegments.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            analyticsSegments.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            analyticsSegments.add(AnalyticsSegment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                analyticsSegments.add(AnalyticsSegment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            analyticsSegments.add(AnalyticsSegment.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return analyticsSegments;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        analyticsSegments.add(AnalyticsSegment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return analyticsSegments;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        analyticsSegments.add(AnalyticsSegment.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return analyticsSegments;
                }
                analyticsSegments.clear();
                analyticsSegments.add(AnalyticsSegment.loadJSON(json, context, header));
                return analyticsSegments;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AnalyticsSegment.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldCustomAudienceIneligiblityReasons() {
        return this.mCustomAudienceIneligiblityReasons;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Long getFieldEstimatedCustomAudienceSize() {
        return this.mEstimatedCustomAudienceSize;
    }

    public List<Object> getFieldEventInfoRules() {
        return this.mEventInfoRules;
    }

    public List<Object> getFieldEventRules() {
        return this.mEventRules;
    }

    public String getFieldFilterSet() {
        return this.mFilterSet;
    }

    public Boolean getFieldHasDemographicRules() {
        return this.mHasDemographicRules;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsAllUser() {
        return this.mIsAllUser;
    }

    public Boolean getFieldIsEligibleForPushCampaign() {
        return this.mIsEligibleForPushCampaign;
    }

    public Boolean getFieldIsInternal() {
        return this.mIsInternal;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<Object> getFieldPercentileRules() {
        return this.mPercentileRules;
    }

    public Long getFieldTimeLastSeen() {
        return this.mTimeLastSeen;
    }

    public Long getFieldTimeLastUpdated() {
        return this.mTimeLastUpdated;
    }

    public List<Object> getFieldUserPropertyRules() {
        return this.mUserPropertyRules;
    }

    public List<Object> getFieldWebParamRules() {
        return this.mWebParamRules;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AnalyticsSegment copyFrom(AnalyticsSegment instance) {
        this.mCustomAudienceIneligiblityReasons = instance.mCustomAudienceIneligiblityReasons;
        this.mDescription = instance.mDescription;
        this.mEstimatedCustomAudienceSize = instance.mEstimatedCustomAudienceSize;
        this.mEventInfoRules = instance.mEventInfoRules;
        this.mEventRules = instance.mEventRules;
        this.mFilterSet = instance.mFilterSet;
        this.mHasDemographicRules = instance.mHasDemographicRules;
        this.mId = instance.mId;
        this.mIsAllUser = instance.mIsAllUser;
        this.mIsEligibleForPushCampaign = instance.mIsEligibleForPushCampaign;
        this.mIsInternal = instance.mIsInternal;
        this.mName = instance.mName;
        this.mPercentileRules = instance.mPercentileRules;
        this.mTimeLastSeen = instance.mTimeLastSeen;
        this.mTimeLastUpdated = instance.mTimeLastUpdated;
        this.mUserPropertyRules = instance.mUserPropertyRules;
        this.mWebParamRules = instance.mWebParamRules;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AnalyticsSegment> getParser() {
        return new APIRequest.ResponseParser<AnalyticsSegment>(){

            @Override
            public APINodeList<AnalyticsSegment> parseResponse(String response, APIContext context, APIRequest<AnalyticsSegment> request, String header) throws APIException.MalformedResponseException {
                return AnalyticsSegment.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AnalyticsSegment> {
        AnalyticsSegment lastResponse = null;
        public static final String[] PARAMS = new String[]{"async_task_id", "end_date", "start_date"};
        public static final String[] FIELDS = new String[]{"custom_audience_ineligiblity_reasons", "description", "estimated_custom_audience_size", "event_info_rules", "event_rules", "filter_set", "has_demographic_rules", "id", "is_all_user", "is_eligible_for_push_campaign", "is_internal", "name", "percentile_rules", "time_last_seen", "time_last_updated", "user_property_rules", "web_param_rules"};

        @Override
        public AnalyticsSegment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AnalyticsSegment parseResponse(String response, String header) throws APIException {
            return AnalyticsSegment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AnalyticsSegment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AnalyticsSegment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AnalyticsSegment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AnalyticsSegment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AnalyticsSegment>(){

                public AnalyticsSegment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setAsyncTaskId(String asyncTaskId) {
            this.setParam("async_task_id", asyncTaskId);
            return this;
        }

        public APIRequestGet setEndDate(Long endDate) {
            this.setParam("end_date", endDate);
            return this;
        }

        public APIRequestGet setEndDate(String endDate) {
            this.setParam("end_date", endDate);
            return this;
        }

        public APIRequestGet setStartDate(Long startDate) {
            this.setParam("start_date", startDate);
            return this;
        }

        public APIRequestGet setStartDate(String startDate) {
            this.setParam("start_date", startDate);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCustomAudienceIneligiblityReasonsField() {
            return this.requestCustomAudienceIneligiblityReasonsField(true);
        }

        public APIRequestGet requestCustomAudienceIneligiblityReasonsField(boolean value) {
            this.requestField("custom_audience_ineligiblity_reasons", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEstimatedCustomAudienceSizeField() {
            return this.requestEstimatedCustomAudienceSizeField(true);
        }

        public APIRequestGet requestEstimatedCustomAudienceSizeField(boolean value) {
            this.requestField("estimated_custom_audience_size", value);
            return this;
        }

        public APIRequestGet requestEventInfoRulesField() {
            return this.requestEventInfoRulesField(true);
        }

        public APIRequestGet requestEventInfoRulesField(boolean value) {
            this.requestField("event_info_rules", value);
            return this;
        }

        public APIRequestGet requestEventRulesField() {
            return this.requestEventRulesField(true);
        }

        public APIRequestGet requestEventRulesField(boolean value) {
            this.requestField("event_rules", value);
            return this;
        }

        public APIRequestGet requestFilterSetField() {
            return this.requestFilterSetField(true);
        }

        public APIRequestGet requestFilterSetField(boolean value) {
            this.requestField("filter_set", value);
            return this;
        }

        public APIRequestGet requestHasDemographicRulesField() {
            return this.requestHasDemographicRulesField(true);
        }

        public APIRequestGet requestHasDemographicRulesField(boolean value) {
            this.requestField("has_demographic_rules", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsAllUserField() {
            return this.requestIsAllUserField(true);
        }

        public APIRequestGet requestIsAllUserField(boolean value) {
            this.requestField("is_all_user", value);
            return this;
        }

        public APIRequestGet requestIsEligibleForPushCampaignField() {
            return this.requestIsEligibleForPushCampaignField(true);
        }

        public APIRequestGet requestIsEligibleForPushCampaignField(boolean value) {
            this.requestField("is_eligible_for_push_campaign", value);
            return this;
        }

        public APIRequestGet requestIsInternalField() {
            return this.requestIsInternalField(true);
        }

        public APIRequestGet requestIsInternalField(boolean value) {
            this.requestField("is_internal", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPercentileRulesField() {
            return this.requestPercentileRulesField(true);
        }

        public APIRequestGet requestPercentileRulesField(boolean value) {
            this.requestField("percentile_rules", value);
            return this;
        }

        public APIRequestGet requestTimeLastSeenField() {
            return this.requestTimeLastSeenField(true);
        }

        public APIRequestGet requestTimeLastSeenField(boolean value) {
            this.requestField("time_last_seen", value);
            return this;
        }

        public APIRequestGet requestTimeLastUpdatedField() {
            return this.requestTimeLastUpdatedField(true);
        }

        public APIRequestGet requestTimeLastUpdatedField(boolean value) {
            this.requestField("time_last_updated", value);
            return this;
        }

        public APIRequestGet requestUserPropertyRulesField() {
            return this.requestUserPropertyRulesField(true);
        }

        public APIRequestGet requestUserPropertyRulesField(boolean value) {
            this.requestField("user_property_rules", value);
            return this;
        }

        public APIRequestGet requestWebParamRulesField() {
            return this.requestWebParamRulesField(true);
        }

        public APIRequestGet requestWebParamRulesField(boolean value) {
            this.requestField("web_param_rules", value);
            return this;
        }
    }
}

