/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class PageCTSTopic
extends APINode {
    @SerializedName(value="app_id")
    private String mAppId = null;
    @SerializedName(value="frequency")
    private String mFrequency = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="subscriber")
    private Long mSubscriber = null;
    @SerializedName(value="title")
    private String mTitle = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static PageCTSTopic loadJSON(String json, APIContext context, String header) {
        PageCTSTopic pageCTSTopic = (PageCTSTopic)PageCTSTopic.getGson().fromJson(json, PageCTSTopic.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageCTSTopic.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageCTSTopic.context = context;
        pageCTSTopic.rawValue = json;
        pageCTSTopic.header = header;
        return pageCTSTopic;
    }

    public static APINodeList<PageCTSTopic> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageCTSTopic> pageCTSTopics = new APINodeList<PageCTSTopic>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageCTSTopics.add(PageCTSTopic.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return pageCTSTopics;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageCTSTopics.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageCTSTopics.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageCTSTopics.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageCTSTopics.add(PageCTSTopic.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageCTSTopics.add(PageCTSTopic.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageCTSTopics.add(PageCTSTopic.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return pageCTSTopics;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageCTSTopics.add(PageCTSTopic.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return pageCTSTopics;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageCTSTopics.add(PageCTSTopic.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageCTSTopics;
                }
                pageCTSTopics.clear();
                pageCTSTopics.add(PageCTSTopic.loadJSON(json, context, header));
                return pageCTSTopics;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageCTSTopic.getGson().toJson((Object)this);
    }

    public String getFieldAppId() {
        return this.mAppId;
    }

    public PageCTSTopic setFieldAppId(String value) {
        this.mAppId = value;
        return this;
    }

    public String getFieldFrequency() {
        return this.mFrequency;
    }

    public PageCTSTopic setFieldFrequency(String value) {
        this.mFrequency = value;
        return this;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public PageCTSTopic setFieldImageHash(String value) {
        this.mImageHash = value;
        return this;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public PageCTSTopic setFieldImageUrl(String value) {
        this.mImageUrl = value;
        return this;
    }

    public Long getFieldSubscriber() {
        return this.mSubscriber;
    }

    public PageCTSTopic setFieldSubscriber(Long value) {
        this.mSubscriber = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public PageCTSTopic setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageCTSTopic copyFrom(PageCTSTopic instance) {
        this.mAppId = instance.mAppId;
        this.mFrequency = instance.mFrequency;
        this.mImageHash = instance.mImageHash;
        this.mImageUrl = instance.mImageUrl;
        this.mSubscriber = instance.mSubscriber;
        this.mTitle = instance.mTitle;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageCTSTopic> getParser() {
        return new APIRequest.ResponseParser<PageCTSTopic>(){

            @Override
            public APINodeList<PageCTSTopic> parseResponse(String response, APIContext context, APIRequest<PageCTSTopic> request, String header) throws APIException.MalformedResponseException {
                return PageCTSTopic.parseResponse(response, context, request, header);
            }
        };
    }
}

