/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdLimitsEnforcementData
extends APINode {
    @SerializedName(value="ad_limit_on_page")
    private Long mAdLimitOnPage = null;
    @SerializedName(value="ad_limit_on_scope")
    private Long mAdLimitOnScope = null;
    @SerializedName(value="ad_volume_on_page")
    private Long mAdVolumeOnPage = null;
    @SerializedName(value="ad_volume_on_scope")
    private Long mAdVolumeOnScope = null;
    @SerializedName(value="is_admin")
    private Boolean mIsAdmin = null;
    @SerializedName(value="page_name")
    private String mPageName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdLimitsEnforcementData loadJSON(String json, APIContext context, String header) {
        AdLimitsEnforcementData adLimitsEnforcementData = (AdLimitsEnforcementData)AdLimitsEnforcementData.getGson().fromJson(json, AdLimitsEnforcementData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adLimitsEnforcementData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adLimitsEnforcementData.context = context;
        adLimitsEnforcementData.rawValue = json;
        adLimitsEnforcementData.header = header;
        return adLimitsEnforcementData;
    }

    public static APINodeList<AdLimitsEnforcementData> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdLimitsEnforcementData> adLimitsEnforcementDatas = new APINodeList<AdLimitsEnforcementData>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adLimitsEnforcementDatas.add(AdLimitsEnforcementData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adLimitsEnforcementDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adLimitsEnforcementDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adLimitsEnforcementDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adLimitsEnforcementDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adLimitsEnforcementDatas.add(AdLimitsEnforcementData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adLimitsEnforcementDatas.add(AdLimitsEnforcementData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adLimitsEnforcementDatas.add(AdLimitsEnforcementData.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adLimitsEnforcementDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adLimitsEnforcementDatas.add(AdLimitsEnforcementData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adLimitsEnforcementDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adLimitsEnforcementDatas.add(AdLimitsEnforcementData.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adLimitsEnforcementDatas;
                }
                adLimitsEnforcementDatas.clear();
                adLimitsEnforcementDatas.add(AdLimitsEnforcementData.loadJSON(json, context, header));
                return adLimitsEnforcementDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdLimitsEnforcementData.getGson().toJson((Object)this);
    }

    public Long getFieldAdLimitOnPage() {
        return this.mAdLimitOnPage;
    }

    public AdLimitsEnforcementData setFieldAdLimitOnPage(Long value) {
        this.mAdLimitOnPage = value;
        return this;
    }

    public Long getFieldAdLimitOnScope() {
        return this.mAdLimitOnScope;
    }

    public AdLimitsEnforcementData setFieldAdLimitOnScope(Long value) {
        this.mAdLimitOnScope = value;
        return this;
    }

    public Long getFieldAdVolumeOnPage() {
        return this.mAdVolumeOnPage;
    }

    public AdLimitsEnforcementData setFieldAdVolumeOnPage(Long value) {
        this.mAdVolumeOnPage = value;
        return this;
    }

    public Long getFieldAdVolumeOnScope() {
        return this.mAdVolumeOnScope;
    }

    public AdLimitsEnforcementData setFieldAdVolumeOnScope(Long value) {
        this.mAdVolumeOnScope = value;
        return this;
    }

    public Boolean getFieldIsAdmin() {
        return this.mIsAdmin;
    }

    public AdLimitsEnforcementData setFieldIsAdmin(Boolean value) {
        this.mIsAdmin = value;
        return this;
    }

    public String getFieldPageName() {
        return this.mPageName;
    }

    public AdLimitsEnforcementData setFieldPageName(String value) {
        this.mPageName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdLimitsEnforcementData copyFrom(AdLimitsEnforcementData instance) {
        this.mAdLimitOnPage = instance.mAdLimitOnPage;
        this.mAdLimitOnScope = instance.mAdLimitOnScope;
        this.mAdVolumeOnPage = instance.mAdVolumeOnPage;
        this.mAdVolumeOnScope = instance.mAdVolumeOnScope;
        this.mIsAdmin = instance.mIsAdmin;
        this.mPageName = instance.mPageName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdLimitsEnforcementData> getParser() {
        return new APIRequest.ResponseParser<AdLimitsEnforcementData>(){

            @Override
            public APINodeList<AdLimitsEnforcementData> parseResponse(String response, APIContext context, APIRequest<AdLimitsEnforcementData> request, String header) throws APIException.MalformedResponseException {
                return AdLimitsEnforcementData.parseResponse(response, context, request, header);
            }
        };
    }
}

