/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdAccountAgencyFeeConfig
extends APINode {
    @SerializedName(value="can_add_agency_fee_to_invoice")
    private Boolean mCanAddAgencyFeeToInvoice = null;
    @SerializedName(value="default_agency_fee_pct")
    private Double mDefaultAgencyFeePct = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_agency_fee_disabled")
    private Boolean mIsAgencyFeeDisabled = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    protected static Gson gson = null;

    AdAccountAgencyFeeConfig() {
    }

    public AdAccountAgencyFeeConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAccountAgencyFeeConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAccountAgencyFeeConfig fetch() throws APIException {
        AdAccountAgencyFeeConfig newInstance = AdAccountAgencyFeeConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAccountAgencyFeeConfig fetchById(Long id, APIContext context) throws APIException {
        return AdAccountAgencyFeeConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAccountAgencyFeeConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAccountAgencyFeeConfig.fetchByIdAsync(id.toString(), context);
    }

    public static AdAccountAgencyFeeConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAccountAgencyFeeConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAccountAgencyFeeConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAccountAgencyFeeConfig>(context, "", "/", "GET", AdAccountAgencyFeeConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAccountAgencyFeeConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAccountAgencyFeeConfig>(context, "", "/", "GET", AdAccountAgencyFeeConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccountAgencyFeeConfig loadJSON(String json, APIContext context, String header) {
        AdAccountAgencyFeeConfig adAccountAgencyFeeConfig = (AdAccountAgencyFeeConfig)AdAccountAgencyFeeConfig.getGson().fromJson(json, AdAccountAgencyFeeConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountAgencyFeeConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountAgencyFeeConfig.context = context;
        adAccountAgencyFeeConfig.rawValue = json;
        adAccountAgencyFeeConfig.header = header;
        return adAccountAgencyFeeConfig;
    }

    public static APINodeList<AdAccountAgencyFeeConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountAgencyFeeConfig> adAccountAgencyFeeConfigs = new APINodeList<AdAccountAgencyFeeConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountAgencyFeeConfigs.add(AdAccountAgencyFeeConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAccountAgencyFeeConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountAgencyFeeConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountAgencyFeeConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountAgencyFeeConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountAgencyFeeConfigs.add(AdAccountAgencyFeeConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountAgencyFeeConfigs.add(AdAccountAgencyFeeConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountAgencyFeeConfigs.add(AdAccountAgencyFeeConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAccountAgencyFeeConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountAgencyFeeConfigs.add(AdAccountAgencyFeeConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAccountAgencyFeeConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountAgencyFeeConfigs.add(AdAccountAgencyFeeConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountAgencyFeeConfigs;
                }
                adAccountAgencyFeeConfigs.clear();
                adAccountAgencyFeeConfigs.add(AdAccountAgencyFeeConfig.loadJSON(json, context, header));
                return adAccountAgencyFeeConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountAgencyFeeConfig.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldCanAddAgencyFeeToInvoice() {
        return this.mCanAddAgencyFeeToInvoice;
    }

    public Double getFieldDefaultAgencyFeePct() {
        return this.mDefaultAgencyFeePct;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsAgencyFeeDisabled() {
        return this.mIsAgencyFeeDisabled;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountAgencyFeeConfig copyFrom(AdAccountAgencyFeeConfig instance) {
        this.mCanAddAgencyFeeToInvoice = instance.mCanAddAgencyFeeToInvoice;
        this.mDefaultAgencyFeePct = instance.mDefaultAgencyFeePct;
        this.mId = instance.mId;
        this.mIsAgencyFeeDisabled = instance.mIsAgencyFeeDisabled;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountAgencyFeeConfig> getParser() {
        return new APIRequest.ResponseParser<AdAccountAgencyFeeConfig>(){

            @Override
            public APINodeList<AdAccountAgencyFeeConfig> parseResponse(String response, APIContext context, APIRequest<AdAccountAgencyFeeConfig> request, String header) throws APIException.MalformedResponseException {
                return AdAccountAgencyFeeConfig.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_DRAFT("DRAFT"),
        VALUE_UNKNOWN("UNKNOWN");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<AdAccountAgencyFeeConfig> {
        AdAccountAgencyFeeConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"can_add_agency_fee_to_invoice", "default_agency_fee_pct", "id", "is_agency_fee_disabled", "status"};

        @Override
        public AdAccountAgencyFeeConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccountAgencyFeeConfig parseResponse(String response, String header) throws APIException {
            return AdAccountAgencyFeeConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdAccountAgencyFeeConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccountAgencyFeeConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdAccountAgencyFeeConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccountAgencyFeeConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdAccountAgencyFeeConfig>(){

                public AdAccountAgencyFeeConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCanAddAgencyFeeToInvoiceField() {
            return this.requestCanAddAgencyFeeToInvoiceField(true);
        }

        public APIRequestGet requestCanAddAgencyFeeToInvoiceField(boolean value) {
            this.requestField("can_add_agency_fee_to_invoice", value);
            return this;
        }

        public APIRequestGet requestDefaultAgencyFeePctField() {
            return this.requestDefaultAgencyFeePctField(true);
        }

        public APIRequestGet requestDefaultAgencyFeePctField(boolean value) {
            this.requestField("default_agency_fee_pct", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsAgencyFeeDisabledField() {
            return this.requestIsAgencyFeeDisabledField(true);
        }

        public APIRequestGet requestIsAgencyFeeDisabledField(boolean value) {
            this.requestField("is_agency_fee_disabled", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }
}

