/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ALMAdAccountInfo
extends APINode {
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="managed_by")
    private String mManagedBy = null;
    @SerializedName(value="owned_by")
    private String mOwnedBy = null;
    @SerializedName(value="parent_advertiser_id")
    private String mParentAdvertiserId = null;
    @SerializedName(value="sub_vertical")
    private String mSubVertical = null;
    @SerializedName(value="tag")
    private List<String> mTag = null;
    @SerializedName(value="user_ids")
    private List<String> mUserIds = null;
    @SerializedName(value="vertical")
    private String mVertical = null;
    protected static Gson gson = null;

    ALMAdAccountInfo() {
    }

    public ALMAdAccountInfo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ALMAdAccountInfo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ALMAdAccountInfo fetch() throws APIException {
        ALMAdAccountInfo newInstance = ALMAdAccountInfo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ALMAdAccountInfo fetchById(Long id, APIContext context) throws APIException {
        return ALMAdAccountInfo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ALMAdAccountInfo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ALMAdAccountInfo.fetchByIdAsync(id.toString(), context);
    }

    public static ALMAdAccountInfo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ALMAdAccountInfo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ALMAdAccountInfo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ALMAdAccountInfo>(context, "", "/", "GET", ALMAdAccountInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ALMAdAccountInfo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ALMAdAccountInfo>(context, "", "/", "GET", ALMAdAccountInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ALMAdAccountInfo loadJSON(String json, APIContext context, String header) {
        ALMAdAccountInfo almAdAccountInfo = (ALMAdAccountInfo)ALMAdAccountInfo.getGson().fromJson(json, ALMAdAccountInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(almAdAccountInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        almAdAccountInfo.context = context;
        almAdAccountInfo.rawValue = json;
        almAdAccountInfo.header = header;
        return almAdAccountInfo;
    }

    public static APINodeList<ALMAdAccountInfo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ALMAdAccountInfo> almAdAccountInfos = new APINodeList<ALMAdAccountInfo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        almAdAccountInfos.add(ALMAdAccountInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return almAdAccountInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            almAdAccountInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        almAdAccountInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            almAdAccountInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            almAdAccountInfos.add(ALMAdAccountInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                almAdAccountInfos.add(ALMAdAccountInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            almAdAccountInfos.add(ALMAdAccountInfo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return almAdAccountInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        almAdAccountInfos.add(ALMAdAccountInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return almAdAccountInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        almAdAccountInfos.add(ALMAdAccountInfo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return almAdAccountInfos;
                }
                almAdAccountInfos.clear();
                almAdAccountInfos.add(ALMAdAccountInfo.loadJSON(json, context, header));
                return almAdAccountInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ALMAdAccountInfo.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldManagedBy() {
        return this.mManagedBy;
    }

    public String getFieldOwnedBy() {
        return this.mOwnedBy;
    }

    public String getFieldParentAdvertiserId() {
        return this.mParentAdvertiserId;
    }

    public String getFieldSubVertical() {
        return this.mSubVertical;
    }

    public List<String> getFieldTag() {
        return this.mTag;
    }

    public List<String> getFieldUserIds() {
        return this.mUserIds;
    }

    public String getFieldVertical() {
        return this.mVertical;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ALMAdAccountInfo copyFrom(ALMAdAccountInfo instance) {
        this.mAdAccountId = instance.mAdAccountId;
        this.mId = instance.mId;
        this.mManagedBy = instance.mManagedBy;
        this.mOwnedBy = instance.mOwnedBy;
        this.mParentAdvertiserId = instance.mParentAdvertiserId;
        this.mSubVertical = instance.mSubVertical;
        this.mTag = instance.mTag;
        this.mUserIds = instance.mUserIds;
        this.mVertical = instance.mVertical;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ALMAdAccountInfo> getParser() {
        return new APIRequest.ResponseParser<ALMAdAccountInfo>(){

            @Override
            public APINodeList<ALMAdAccountInfo> parseResponse(String response, APIContext context, APIRequest<ALMAdAccountInfo> request, String header) throws APIException.MalformedResponseException {
                return ALMAdAccountInfo.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ALMAdAccountInfo> {
        ALMAdAccountInfo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_id", "id", "managed_by", "owned_by", "parent_advertiser_id", "sub_vertical", "tag", "user_ids", "vertical"};

        @Override
        public ALMAdAccountInfo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ALMAdAccountInfo parseResponse(String response, String header) throws APIException {
            return ALMAdAccountInfo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ALMAdAccountInfo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ALMAdAccountInfo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ALMAdAccountInfo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ALMAdAccountInfo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ALMAdAccountInfo>(){

                public ALMAdAccountInfo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountIdField() {
            return this.requestAdAccountIdField(true);
        }

        public APIRequestGet requestAdAccountIdField(boolean value) {
            this.requestField("ad_account_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestManagedByField() {
            return this.requestManagedByField(true);
        }

        public APIRequestGet requestManagedByField(boolean value) {
            this.requestField("managed_by", value);
            return this;
        }

        public APIRequestGet requestOwnedByField() {
            return this.requestOwnedByField(true);
        }

        public APIRequestGet requestOwnedByField(boolean value) {
            this.requestField("owned_by", value);
            return this;
        }

        public APIRequestGet requestParentAdvertiserIdField() {
            return this.requestParentAdvertiserIdField(true);
        }

        public APIRequestGet requestParentAdvertiserIdField(boolean value) {
            this.requestField("parent_advertiser_id", value);
            return this;
        }

        public APIRequestGet requestSubVerticalField() {
            return this.requestSubVerticalField(true);
        }

        public APIRequestGet requestSubVerticalField(boolean value) {
            this.requestField("sub_vertical", value);
            return this;
        }

        public APIRequestGet requestTagField() {
            return this.requestTagField(true);
        }

        public APIRequestGet requestTagField(boolean value) {
            this.requestField("tag", value);
            return this;
        }

        public APIRequestGet requestUserIdsField() {
            return this.requestUserIdsField(true);
        }

        public APIRequestGet requestUserIdsField(boolean value) {
            this.requestField("user_ids", value);
            return this;
        }

        public APIRequestGet requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGet requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }
    }
}

