/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class PartnerCategory
extends APINode {
    @SerializedName(value="approximate_count")
    private Long mApproximateCount = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="details")
    private String mDetails = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_private")
    private Boolean mIsPrivate = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="parent_category")
    private String mParentCategory = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="targeting_type")
    private String mTargetingType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PartnerCategory loadJSON(String json, APIContext context, String header) {
        PartnerCategory partnerCategory = (PartnerCategory)PartnerCategory.getGson().fromJson(json, PartnerCategory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(partnerCategory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        partnerCategory.context = context;
        partnerCategory.rawValue = json;
        partnerCategory.header = header;
        return partnerCategory;
    }

    public static APINodeList<PartnerCategory> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PartnerCategory> partnerCategorys = new APINodeList<PartnerCategory>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        partnerCategorys.add(PartnerCategory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return partnerCategorys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            partnerCategorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        partnerCategorys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            partnerCategorys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            partnerCategorys.add(PartnerCategory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                partnerCategorys.add(PartnerCategory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            partnerCategorys.add(PartnerCategory.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return partnerCategorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        partnerCategorys.add(PartnerCategory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return partnerCategorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        partnerCategorys.add(PartnerCategory.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return partnerCategorys;
                }
                partnerCategorys.clear();
                partnerCategorys.add(PartnerCategory.loadJSON(json, context, header));
                return partnerCategorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PartnerCategory.getGson().toJson((Object)this);
    }

    public Long getFieldApproximateCount() {
        return this.mApproximateCount;
    }

    public PartnerCategory setFieldApproximateCount(Long value) {
        this.mApproximateCount = value;
        return this;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public PartnerCategory setFieldCountry(String value) {
        this.mCountry = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public PartnerCategory setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldDetails() {
        return this.mDetails;
    }

    public PartnerCategory setFieldDetails(String value) {
        this.mDetails = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public PartnerCategory setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Boolean getFieldIsPrivate() {
        return this.mIsPrivate;
    }

    public PartnerCategory setFieldIsPrivate(Boolean value) {
        this.mIsPrivate = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public PartnerCategory setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldParentCategory() {
        return this.mParentCategory;
    }

    public PartnerCategory setFieldParentCategory(String value) {
        this.mParentCategory = value;
        return this;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public PartnerCategory setFieldSource(String value) {
        this.mSource = value;
        return this;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public PartnerCategory setFieldStatus(String value) {
        this.mStatus = value;
        return this;
    }

    public String getFieldTargetingType() {
        return this.mTargetingType;
    }

    public PartnerCategory setFieldTargetingType(String value) {
        this.mTargetingType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PartnerCategory copyFrom(PartnerCategory instance) {
        this.mApproximateCount = instance.mApproximateCount;
        this.mCountry = instance.mCountry;
        this.mDescription = instance.mDescription;
        this.mDetails = instance.mDetails;
        this.mId = instance.mId;
        this.mIsPrivate = instance.mIsPrivate;
        this.mName = instance.mName;
        this.mParentCategory = instance.mParentCategory;
        this.mSource = instance.mSource;
        this.mStatus = instance.mStatus;
        this.mTargetingType = instance.mTargetingType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PartnerCategory> getParser() {
        return new APIRequest.ResponseParser<PartnerCategory>(){

            @Override
            public APINodeList<PartnerCategory> parseResponse(String response, APIContext context, APIRequest<PartnerCategory> request, String header) throws APIException.MalformedResponseException {
                return PartnerCategory.parseResponse(response, context, request, header);
            }
        };
    }
}

