/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCampaignDeliveryStatsUnsupportedReasons;
import com.facebook.ads.sdk.AdCampaignLearningStageInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdCampaignDeliveryStats
extends APINode {
    @SerializedName(value="bid_recommendation")
    private Long mBidRecommendation = null;
    @SerializedName(value="current_average_cost")
    private Double mCurrentAverageCost = null;
    @SerializedName(value="last_significant_edit_ts")
    private Long mLastSignificantEditTs = null;
    @SerializedName(value="learning_stage_exit_info")
    private Object mLearningStageExitInfo = null;
    @SerializedName(value="learning_stage_info")
    private AdCampaignLearningStageInfo mLearningStageInfo = null;
    @SerializedName(value="unsupported_features")
    private List<Map<String, AdCampaignDeliveryStatsUnsupportedReasons>> mUnsupportedFeatures = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCampaignDeliveryStats loadJSON(String json, APIContext context, String header) {
        AdCampaignDeliveryStats adCampaignDeliveryStats = (AdCampaignDeliveryStats)AdCampaignDeliveryStats.getGson().fromJson(json, AdCampaignDeliveryStats.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCampaignDeliveryStats.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCampaignDeliveryStats.context = context;
        adCampaignDeliveryStats.rawValue = json;
        adCampaignDeliveryStats.header = header;
        return adCampaignDeliveryStats;
    }

    public static APINodeList<AdCampaignDeliveryStats> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCampaignDeliveryStats> adCampaignDeliveryStatss = new APINodeList<AdCampaignDeliveryStats>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCampaignDeliveryStatss.add(AdCampaignDeliveryStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCampaignDeliveryStatss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCampaignDeliveryStatss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCampaignDeliveryStatss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCampaignDeliveryStatss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCampaignDeliveryStatss.add(AdCampaignDeliveryStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCampaignDeliveryStatss.add(AdCampaignDeliveryStats.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCampaignDeliveryStatss.add(AdCampaignDeliveryStats.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCampaignDeliveryStatss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCampaignDeliveryStatss.add(AdCampaignDeliveryStats.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCampaignDeliveryStatss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCampaignDeliveryStatss.add(AdCampaignDeliveryStats.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCampaignDeliveryStatss;
                }
                adCampaignDeliveryStatss.clear();
                adCampaignDeliveryStatss.add(AdCampaignDeliveryStats.loadJSON(json, context, header));
                return adCampaignDeliveryStatss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCampaignDeliveryStats.getGson().toJson((Object)this);
    }

    public Long getFieldBidRecommendation() {
        return this.mBidRecommendation;
    }

    public AdCampaignDeliveryStats setFieldBidRecommendation(Long value) {
        this.mBidRecommendation = value;
        return this;
    }

    public Double getFieldCurrentAverageCost() {
        return this.mCurrentAverageCost;
    }

    public AdCampaignDeliveryStats setFieldCurrentAverageCost(Double value) {
        this.mCurrentAverageCost = value;
        return this;
    }

    public Long getFieldLastSignificantEditTs() {
        return this.mLastSignificantEditTs;
    }

    public AdCampaignDeliveryStats setFieldLastSignificantEditTs(Long value) {
        this.mLastSignificantEditTs = value;
        return this;
    }

    public Object getFieldLearningStageExitInfo() {
        return this.mLearningStageExitInfo;
    }

    public AdCampaignDeliveryStats setFieldLearningStageExitInfo(Object value) {
        this.mLearningStageExitInfo = value;
        return this;
    }

    public AdCampaignLearningStageInfo getFieldLearningStageInfo() {
        return this.mLearningStageInfo;
    }

    public AdCampaignDeliveryStats setFieldLearningStageInfo(AdCampaignLearningStageInfo value) {
        this.mLearningStageInfo = value;
        return this;
    }

    public AdCampaignDeliveryStats setFieldLearningStageInfo(String value) {
        Type type = new TypeToken<AdCampaignLearningStageInfo>(){}.getType();
        this.mLearningStageInfo = (AdCampaignLearningStageInfo)AdCampaignLearningStageInfo.getGson().fromJson(value, type);
        return this;
    }

    public List<Map<String, AdCampaignDeliveryStatsUnsupportedReasons>> getFieldUnsupportedFeatures() {
        return this.mUnsupportedFeatures;
    }

    public AdCampaignDeliveryStats setFieldUnsupportedFeatures(List<Map<String, AdCampaignDeliveryStatsUnsupportedReasons>> value) {
        this.mUnsupportedFeatures = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCampaignDeliveryStats copyFrom(AdCampaignDeliveryStats instance) {
        this.mBidRecommendation = instance.mBidRecommendation;
        this.mCurrentAverageCost = instance.mCurrentAverageCost;
        this.mLastSignificantEditTs = instance.mLastSignificantEditTs;
        this.mLearningStageExitInfo = instance.mLearningStageExitInfo;
        this.mLearningStageInfo = instance.mLearningStageInfo;
        this.mUnsupportedFeatures = instance.mUnsupportedFeatures;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCampaignDeliveryStats> getParser() {
        return new APIRequest.ResponseParser<AdCampaignDeliveryStats>(){

            @Override
            public APINodeList<AdCampaignDeliveryStats> parseResponse(String response, APIContext context, APIRequest<AdCampaignDeliveryStats> request, String header) throws APIException.MalformedResponseException {
                return AdCampaignDeliveryStats.parseResponse(response, context, request, header);
            }
        };
    }
}

