/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class WorkAccessCode
extends APINode {
    @SerializedName(value="code")
    private String mCode = null;
    @SerializedName(value="expiration_time")
    private String mExpirationTime = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static WorkAccessCode loadJSON(String json, APIContext context, String header) {
        WorkAccessCode workAccessCode = (WorkAccessCode)WorkAccessCode.getGson().fromJson(json, WorkAccessCode.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(workAccessCode.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        workAccessCode.context = context;
        workAccessCode.rawValue = json;
        workAccessCode.header = header;
        return workAccessCode;
    }

    public static APINodeList<WorkAccessCode> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WorkAccessCode> workAccessCodes = new APINodeList<WorkAccessCode>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        workAccessCodes.add(WorkAccessCode.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return workAccessCodes;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            workAccessCodes.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        workAccessCodes.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            workAccessCodes.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            workAccessCodes.add(WorkAccessCode.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                workAccessCodes.add(WorkAccessCode.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            workAccessCodes.add(WorkAccessCode.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return workAccessCodes;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        workAccessCodes.add(WorkAccessCode.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return workAccessCodes;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        workAccessCodes.add(WorkAccessCode.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return workAccessCodes;
                }
                workAccessCodes.clear();
                workAccessCodes.add(WorkAccessCode.loadJSON(json, context, header));
                return workAccessCodes;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WorkAccessCode.getGson().toJson((Object)this);
    }

    public String getFieldCode() {
        return this.mCode;
    }

    public WorkAccessCode setFieldCode(String value) {
        this.mCode = value;
        return this;
    }

    public String getFieldExpirationTime() {
        return this.mExpirationTime;
    }

    public WorkAccessCode setFieldExpirationTime(String value) {
        this.mExpirationTime = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WorkAccessCode copyFrom(WorkAccessCode instance) {
        this.mCode = instance.mCode;
        this.mExpirationTime = instance.mExpirationTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WorkAccessCode> getParser() {
        return new APIRequest.ResponseParser<WorkAccessCode>(){

            @Override
            public APINodeList<WorkAccessCode> parseResponse(String response, APIContext context, APIRequest<WorkAccessCode> request, String header) throws APIException.MalformedResponseException {
                return WorkAccessCode.parseResponse(response, context, request, header);
            }
        };
    }
}

