/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProductSet;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ProductSetUsage
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="product_set")
    private ProductSet mProductSet = null;
    @SerializedName(value="usage_type")
    private String mUsageType = null;
    protected static Gson gson = null;

    ProductSetUsage() {
    }

    public ProductSetUsage(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductSetUsage(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductSetUsage fetch() throws APIException {
        ProductSetUsage newInstance = ProductSetUsage.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductSetUsage fetchById(Long id, APIContext context) throws APIException {
        return ProductSetUsage.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductSetUsage> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductSetUsage.fetchByIdAsync(id.toString(), context);
    }

    public static ProductSetUsage fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductSetUsage> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductSetUsage> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductSetUsage>(context, "", "/", "GET", ProductSetUsage.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductSetUsage>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductSetUsage>(context, "", "/", "GET", ProductSetUsage.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductSetUsage loadJSON(String json, APIContext context, String header) {
        ProductSetUsage productSetUsage = (ProductSetUsage)ProductSetUsage.getGson().fromJson(json, ProductSetUsage.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productSetUsage.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productSetUsage.context = context;
        productSetUsage.rawValue = json;
        productSetUsage.header = header;
        return productSetUsage;
    }

    public static APINodeList<ProductSetUsage> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductSetUsage> productSetUsages = new APINodeList<ProductSetUsage>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productSetUsages.add(ProductSetUsage.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productSetUsages;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productSetUsages.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productSetUsages.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productSetUsages.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productSetUsages.add(ProductSetUsage.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productSetUsages.add(ProductSetUsage.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productSetUsages.add(ProductSetUsage.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productSetUsages;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productSetUsages.add(ProductSetUsage.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productSetUsages;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productSetUsages.add(ProductSetUsage.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productSetUsages;
                }
                productSetUsages.clear();
                productSetUsages.add(ProductSetUsage.loadJSON(json, context, header));
                return productSetUsages;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductSetUsage.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public ProductSet getFieldProductSet() {
        if (this.mProductSet != null) {
            this.mProductSet.context = this.getContext();
        }
        return this.mProductSet;
    }

    public String getFieldUsageType() {
        return this.mUsageType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductSetUsage copyFrom(ProductSetUsage instance) {
        this.mId = instance.mId;
        this.mProductSet = instance.mProductSet;
        this.mUsageType = instance.mUsageType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductSetUsage> getParser() {
        return new APIRequest.ResponseParser<ProductSetUsage>(){

            @Override
            public APINodeList<ProductSetUsage> parseResponse(String response, APIContext context, APIRequest<ProductSetUsage> request, String header) throws APIException.MalformedResponseException {
                return ProductSetUsage.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ProductSetUsage> {
        ProductSetUsage lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "product_set", "usage_type"};

        @Override
        public ProductSetUsage getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductSetUsage parseResponse(String response, String header) throws APIException {
            return ProductSetUsage.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ProductSetUsage execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductSetUsage execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ProductSetUsage> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductSetUsage> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ProductSetUsage>(){

                public ProductSetUsage apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestProductSetField() {
            return this.requestProductSetField(true);
        }

        public APIRequestGet requestProductSetField(boolean value) {
            this.requestField("product_set", value);
            return this;
        }

        public APIRequestGet requestUsageTypeField() {
            return this.requestUsageTypeField(true);
        }

        public APIRequestGet requestUsageTypeField(boolean value) {
            this.requestField("usage_type", value);
            return this;
        }
    }
}

