/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class PartnerAccountLinking
extends APINode {
    @SerializedName(value="adaccount")
    private AdAccount mAdaccount = null;
    @SerializedName(value="app")
    private Application mApp = null;
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="externalidentifier")
    private String mExternalidentifier = null;
    @SerializedName(value="externalidentifieruri")
    private String mExternalidentifieruri = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="partnername")
    private String mPartnername = null;
    @SerializedName(value="pixel")
    private String mPixel = null;
    protected static Gson gson = null;

    PartnerAccountLinking() {
    }

    public PartnerAccountLinking(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PartnerAccountLinking(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PartnerAccountLinking fetch() throws APIException {
        PartnerAccountLinking newInstance = PartnerAccountLinking.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PartnerAccountLinking fetchById(Long id, APIContext context) throws APIException {
        return PartnerAccountLinking.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PartnerAccountLinking> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PartnerAccountLinking.fetchByIdAsync(id.toString(), context);
    }

    public static PartnerAccountLinking fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PartnerAccountLinking> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PartnerAccountLinking> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PartnerAccountLinking>(context, "", "/", "GET", PartnerAccountLinking.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PartnerAccountLinking>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PartnerAccountLinking>(context, "", "/", "GET", PartnerAccountLinking.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PartnerAccountLinking loadJSON(String json, APIContext context, String header) {
        PartnerAccountLinking partnerAccountLinking = (PartnerAccountLinking)PartnerAccountLinking.getGson().fromJson(json, PartnerAccountLinking.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(partnerAccountLinking.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        partnerAccountLinking.context = context;
        partnerAccountLinking.rawValue = json;
        partnerAccountLinking.header = header;
        return partnerAccountLinking;
    }

    public static APINodeList<PartnerAccountLinking> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PartnerAccountLinking> partnerAccountLinkings = new APINodeList<PartnerAccountLinking>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        partnerAccountLinkings.add(PartnerAccountLinking.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return partnerAccountLinkings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            partnerAccountLinkings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        partnerAccountLinkings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            partnerAccountLinkings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            partnerAccountLinkings.add(PartnerAccountLinking.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                partnerAccountLinkings.add(PartnerAccountLinking.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            partnerAccountLinkings.add(PartnerAccountLinking.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return partnerAccountLinkings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        partnerAccountLinkings.add(PartnerAccountLinking.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return partnerAccountLinkings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        partnerAccountLinkings.add(PartnerAccountLinking.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return partnerAccountLinkings;
                }
                partnerAccountLinkings.clear();
                partnerAccountLinkings.add(PartnerAccountLinking.loadJSON(json, context, header));
                return partnerAccountLinkings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PartnerAccountLinking.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAccount getFieldAdaccount() {
        if (this.mAdaccount != null) {
            this.mAdaccount.context = this.getContext();
        }
        return this.mAdaccount;
    }

    public Application getFieldApp() {
        if (this.mApp != null) {
            this.mApp.context = this.getContext();
        }
        return this.mApp;
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldExternalidentifier() {
        return this.mExternalidentifier;
    }

    public String getFieldExternalidentifieruri() {
        return this.mExternalidentifieruri;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldPartnername() {
        return this.mPartnername;
    }

    public String getFieldPixel() {
        return this.mPixel;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PartnerAccountLinking copyFrom(PartnerAccountLinking instance) {
        this.mAdaccount = instance.mAdaccount;
        this.mApp = instance.mApp;
        this.mBusiness = instance.mBusiness;
        this.mExternalidentifier = instance.mExternalidentifier;
        this.mExternalidentifieruri = instance.mExternalidentifieruri;
        this.mId = instance.mId;
        this.mPartnername = instance.mPartnername;
        this.mPixel = instance.mPixel;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PartnerAccountLinking> getParser() {
        return new APIRequest.ResponseParser<PartnerAccountLinking>(){

            @Override
            public APINodeList<PartnerAccountLinking> parseResponse(String response, APIContext context, APIRequest<PartnerAccountLinking> request, String header) throws APIException.MalformedResponseException {
                return PartnerAccountLinking.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<PartnerAccountLinking> {
        PartnerAccountLinking lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"adaccount", "app", "business", "externalidentifier", "externalidentifieruri", "id", "partnername", "pixel"};

        @Override
        public PartnerAccountLinking getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PartnerAccountLinking parseResponse(String response, String header) throws APIException {
            return PartnerAccountLinking.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PartnerAccountLinking execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PartnerAccountLinking execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PartnerAccountLinking> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PartnerAccountLinking> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PartnerAccountLinking>(){

                public PartnerAccountLinking apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdaccountField() {
            return this.requestAdaccountField(true);
        }

        public APIRequestGet requestAdaccountField(boolean value) {
            this.requestField("adaccount", value);
            return this;
        }

        public APIRequestGet requestAppField() {
            return this.requestAppField(true);
        }

        public APIRequestGet requestAppField(boolean value) {
            this.requestField("app", value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestExternalidentifierField() {
            return this.requestExternalidentifierField(true);
        }

        public APIRequestGet requestExternalidentifierField(boolean value) {
            this.requestField("externalidentifier", value);
            return this;
        }

        public APIRequestGet requestExternalidentifieruriField() {
            return this.requestExternalidentifieruriField(true);
        }

        public APIRequestGet requestExternalidentifieruriField(boolean value) {
            this.requestField("externalidentifieruri", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPartnernameField() {
            return this.requestPartnernameField(true);
        }

        public APIRequestGet requestPartnernameField(boolean value) {
            this.requestField("partnername", value);
            return this;
        }

        public APIRequestGet requestPixelField() {
            return this.requestPixelField(true);
        }

        public APIRequestGet requestPixelField(boolean value) {
            this.requestField("pixel", value);
            return this;
        }
    }
}

