/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class MessengerBusinessTemplate
extends APINode {
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="components")
    private List<Object> mComponents = null;
    @SerializedName(value="creation_time")
    private Long mCreationTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="language")
    private String mLanguage = null;
    @SerializedName(value="language_count")
    private Long mLanguageCount = null;
    @SerializedName(value="last_updated_time")
    private String mLastUpdatedTime = null;
    @SerializedName(value="library_template_name")
    private String mLibraryTemplateName = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="rejected_reason")
    private String mRejectedReason = null;
    @SerializedName(value="status")
    private String mStatus = null;
    protected static Gson gson = null;

    MessengerBusinessTemplate() {
    }

    public MessengerBusinessTemplate(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MessengerBusinessTemplate(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MessengerBusinessTemplate fetch() throws APIException {
        MessengerBusinessTemplate newInstance = MessengerBusinessTemplate.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MessengerBusinessTemplate fetchById(Long id, APIContext context) throws APIException {
        return MessengerBusinessTemplate.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MessengerBusinessTemplate> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MessengerBusinessTemplate.fetchByIdAsync(id.toString(), context);
    }

    public static MessengerBusinessTemplate fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MessengerBusinessTemplate> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MessengerBusinessTemplate> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MessengerBusinessTemplate>(context, "", "/", "GET", MessengerBusinessTemplate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MessengerBusinessTemplate>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MessengerBusinessTemplate>(context, "", "/", "GET", MessengerBusinessTemplate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MessengerBusinessTemplate loadJSON(String json, APIContext context, String header) {
        MessengerBusinessTemplate messengerBusinessTemplate = (MessengerBusinessTemplate)MessengerBusinessTemplate.getGson().fromJson(json, MessengerBusinessTemplate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(messengerBusinessTemplate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        messengerBusinessTemplate.context = context;
        messengerBusinessTemplate.rawValue = json;
        messengerBusinessTemplate.header = header;
        return messengerBusinessTemplate;
    }

    public static APINodeList<MessengerBusinessTemplate> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MessengerBusinessTemplate> messengerBusinessTemplates = new APINodeList<MessengerBusinessTemplate>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        messengerBusinessTemplates.add(MessengerBusinessTemplate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return messengerBusinessTemplates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            messengerBusinessTemplates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        messengerBusinessTemplates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            messengerBusinessTemplates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            messengerBusinessTemplates.add(MessengerBusinessTemplate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                messengerBusinessTemplates.add(MessengerBusinessTemplate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            messengerBusinessTemplates.add(MessengerBusinessTemplate.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return messengerBusinessTemplates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        messengerBusinessTemplates.add(MessengerBusinessTemplate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return messengerBusinessTemplates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        messengerBusinessTemplates.add(MessengerBusinessTemplate.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return messengerBusinessTemplates;
                }
                messengerBusinessTemplates.clear();
                messengerBusinessTemplates.add(MessengerBusinessTemplate.loadJSON(json, context, header));
                return messengerBusinessTemplates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MessengerBusinessTemplate.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public List<Object> getFieldComponents() {
        return this.mComponents;
    }

    public Long getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLanguage() {
        return this.mLanguage;
    }

    public Long getFieldLanguageCount() {
        return this.mLanguageCount;
    }

    public String getFieldLastUpdatedTime() {
        return this.mLastUpdatedTime;
    }

    public String getFieldLibraryTemplateName() {
        return this.mLibraryTemplateName;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldRejectedReason() {
        return this.mRejectedReason;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MessengerBusinessTemplate copyFrom(MessengerBusinessTemplate instance) {
        this.mCategory = instance.mCategory;
        this.mComponents = instance.mComponents;
        this.mCreationTime = instance.mCreationTime;
        this.mId = instance.mId;
        this.mLanguage = instance.mLanguage;
        this.mLanguageCount = instance.mLanguageCount;
        this.mLastUpdatedTime = instance.mLastUpdatedTime;
        this.mLibraryTemplateName = instance.mLibraryTemplateName;
        this.mName = instance.mName;
        this.mRejectedReason = instance.mRejectedReason;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MessengerBusinessTemplate> getParser() {
        return new APIRequest.ResponseParser<MessengerBusinessTemplate>(){

            @Override
            public APINodeList<MessengerBusinessTemplate> parseResponse(String response, APIContext context, APIRequest<MessengerBusinessTemplate> request, String header) throws APIException.MalformedResponseException {
                return MessengerBusinessTemplate.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatus {
        VALUE_APPROVED("APPROVED"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_DELETED("DELETED"),
        VALUE_DISABLED("DISABLED"),
        VALUE_IN_APPEAL("IN_APPEAL"),
        VALUE_LIMIT_EXCEEDED("LIMIT_EXCEEDED"),
        VALUE_PAUSED("PAUSED"),
        VALUE_PENDING("PENDING"),
        VALUE_PENDING_DELETION("PENDING_DELETION"),
        VALUE_REJECTED("REJECTED");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<MessengerBusinessTemplate> {
        MessengerBusinessTemplate lastResponse = null;
        public static final String[] PARAMS = new String[]{"components"};
        public static final String[] FIELDS = new String[0];

        @Override
        public MessengerBusinessTemplate getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MessengerBusinessTemplate parseResponse(String response, String header) throws APIException {
            return MessengerBusinessTemplate.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public MessengerBusinessTemplate execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MessengerBusinessTemplate execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<MessengerBusinessTemplate> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MessengerBusinessTemplate> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, MessengerBusinessTemplate>(){

                public MessengerBusinessTemplate apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setComponents(List<Map<String, String>> components) {
            this.setParam("components", components);
            return this;
        }

        public APIRequestUpdate setComponents(String components) {
            this.setParam("components", components);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<MessengerBusinessTemplate> {
        MessengerBusinessTemplate lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"category", "components", "creation_time", "id", "language", "language_count", "last_updated_time", "library_template_name", "name", "rejected_reason", "status"};

        @Override
        public MessengerBusinessTemplate getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MessengerBusinessTemplate parseResponse(String response, String header) throws APIException {
            return MessengerBusinessTemplate.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public MessengerBusinessTemplate execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MessengerBusinessTemplate execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<MessengerBusinessTemplate> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MessengerBusinessTemplate> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, MessengerBusinessTemplate>(){

                public MessengerBusinessTemplate apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGet requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGet requestComponentsField() {
            return this.requestComponentsField(true);
        }

        public APIRequestGet requestComponentsField(boolean value) {
            this.requestField("components", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLanguageField() {
            return this.requestLanguageField(true);
        }

        public APIRequestGet requestLanguageField(boolean value) {
            this.requestField("language", value);
            return this;
        }

        public APIRequestGet requestLanguageCountField() {
            return this.requestLanguageCountField(true);
        }

        public APIRequestGet requestLanguageCountField(boolean value) {
            this.requestField("language_count", value);
            return this;
        }

        public APIRequestGet requestLastUpdatedTimeField() {
            return this.requestLastUpdatedTimeField(true);
        }

        public APIRequestGet requestLastUpdatedTimeField(boolean value) {
            this.requestField("last_updated_time", value);
            return this;
        }

        public APIRequestGet requestLibraryTemplateNameField() {
            return this.requestLibraryTemplateNameField(true);
        }

        public APIRequestGet requestLibraryTemplateNameField(boolean value) {
            this.requestField("library_template_name", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestRejectedReasonField() {
            return this.requestRejectedReasonField(true);
        }

        public APIRequestGet requestRejectedReasonField(boolean value) {
            this.requestField("rejected_reason", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }
}

