/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class CloudbridgeDatasetStatus
extends APINode {
    @SerializedName(value="app_redacted_event")
    private List<String> mAppRedactedEvent = null;
    @SerializedName(value="app_sensitive_params")
    private List<Map<String, List<String>>> mAppSensitiveParams = null;
    @SerializedName(value="app_unverified_event")
    private List<String> mAppUnverifiedEvent = null;
    @SerializedName(value="has_app_associated")
    private Boolean mHasAppAssociated = null;
    @SerializedName(value="is_app_prohibited")
    private Boolean mIsAppProhibited = null;
    @SerializedName(value="is_dataset")
    private Boolean mIsDataset = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static CloudbridgeDatasetStatus loadJSON(String json, APIContext context, String header) {
        CloudbridgeDatasetStatus cloudbridgeDatasetStatus = (CloudbridgeDatasetStatus)CloudbridgeDatasetStatus.getGson().fromJson(json, CloudbridgeDatasetStatus.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(cloudbridgeDatasetStatus.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        cloudbridgeDatasetStatus.context = context;
        cloudbridgeDatasetStatus.rawValue = json;
        cloudbridgeDatasetStatus.header = header;
        return cloudbridgeDatasetStatus;
    }

    public static APINodeList<CloudbridgeDatasetStatus> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CloudbridgeDatasetStatus> cloudbridgeDatasetStatuss = new APINodeList<CloudbridgeDatasetStatus>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        cloudbridgeDatasetStatuss.add(CloudbridgeDatasetStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return cloudbridgeDatasetStatuss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            cloudbridgeDatasetStatuss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        cloudbridgeDatasetStatuss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            cloudbridgeDatasetStatuss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            cloudbridgeDatasetStatuss.add(CloudbridgeDatasetStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                cloudbridgeDatasetStatuss.add(CloudbridgeDatasetStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            cloudbridgeDatasetStatuss.add(CloudbridgeDatasetStatus.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return cloudbridgeDatasetStatuss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        cloudbridgeDatasetStatuss.add(CloudbridgeDatasetStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return cloudbridgeDatasetStatuss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        cloudbridgeDatasetStatuss.add(CloudbridgeDatasetStatus.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return cloudbridgeDatasetStatuss;
                }
                cloudbridgeDatasetStatuss.clear();
                cloudbridgeDatasetStatuss.add(CloudbridgeDatasetStatus.loadJSON(json, context, header));
                return cloudbridgeDatasetStatuss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CloudbridgeDatasetStatus.getGson().toJson((Object)this);
    }

    public List<String> getFieldAppRedactedEvent() {
        return this.mAppRedactedEvent;
    }

    public CloudbridgeDatasetStatus setFieldAppRedactedEvent(List<String> value) {
        this.mAppRedactedEvent = value;
        return this;
    }

    public List<Map<String, List<String>>> getFieldAppSensitiveParams() {
        return this.mAppSensitiveParams;
    }

    public CloudbridgeDatasetStatus setFieldAppSensitiveParams(List<Map<String, List<String>>> value) {
        this.mAppSensitiveParams = value;
        return this;
    }

    public List<String> getFieldAppUnverifiedEvent() {
        return this.mAppUnverifiedEvent;
    }

    public CloudbridgeDatasetStatus setFieldAppUnverifiedEvent(List<String> value) {
        this.mAppUnverifiedEvent = value;
        return this;
    }

    public Boolean getFieldHasAppAssociated() {
        return this.mHasAppAssociated;
    }

    public CloudbridgeDatasetStatus setFieldHasAppAssociated(Boolean value) {
        this.mHasAppAssociated = value;
        return this;
    }

    public Boolean getFieldIsAppProhibited() {
        return this.mIsAppProhibited;
    }

    public CloudbridgeDatasetStatus setFieldIsAppProhibited(Boolean value) {
        this.mIsAppProhibited = value;
        return this;
    }

    public Boolean getFieldIsDataset() {
        return this.mIsDataset;
    }

    public CloudbridgeDatasetStatus setFieldIsDataset(Boolean value) {
        this.mIsDataset = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CloudbridgeDatasetStatus copyFrom(CloudbridgeDatasetStatus instance) {
        this.mAppRedactedEvent = instance.mAppRedactedEvent;
        this.mAppSensitiveParams = instance.mAppSensitiveParams;
        this.mAppUnverifiedEvent = instance.mAppUnverifiedEvent;
        this.mHasAppAssociated = instance.mHasAppAssociated;
        this.mIsAppProhibited = instance.mIsAppProhibited;
        this.mIsDataset = instance.mIsDataset;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CloudbridgeDatasetStatus> getParser() {
        return new APIRequest.ResponseParser<CloudbridgeDatasetStatus>(){

            @Override
            public APINodeList<CloudbridgeDatasetStatus> parseResponse(String response, APIContext context, APIRequest<CloudbridgeDatasetStatus> request, String header) throws APIException.MalformedResponseException {
                return CloudbridgeDatasetStatus.parseResponse(response, context, request, header);
            }
        };
    }
}

