/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeLinkData;
import com.facebook.ads.sdk.AdCreativePhotoData;
import com.facebook.ads.sdk.AdCreativeProductData;
import com.facebook.ads.sdk.AdCreativeTextData;
import com.facebook.ads.sdk.AdCreativeVideoData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdCreativeObjectStorySpec
extends APINode {
    @SerializedName(value="instagram_actor_id")
    private String mInstagramActorId = null;
    @SerializedName(value="link_data")
    private AdCreativeLinkData mLinkData = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="photo_data")
    private AdCreativePhotoData mPhotoData = null;
    @SerializedName(value="product_data")
    private List<AdCreativeProductData> mProductData = null;
    @SerializedName(value="template_data")
    private AdCreativeLinkData mTemplateData = null;
    @SerializedName(value="text_data")
    private AdCreativeTextData mTextData = null;
    @SerializedName(value="threads_user_id")
    private String mThreadsUserId = null;
    @SerializedName(value="video_data")
    private AdCreativeVideoData mVideoData = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeObjectStorySpec loadJSON(String json, APIContext context, String header) {
        AdCreativeObjectStorySpec adCreativeObjectStorySpec = (AdCreativeObjectStorySpec)AdCreativeObjectStorySpec.getGson().fromJson(json, AdCreativeObjectStorySpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeObjectStorySpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeObjectStorySpec.context = context;
        adCreativeObjectStorySpec.rawValue = json;
        adCreativeObjectStorySpec.header = header;
        return adCreativeObjectStorySpec;
    }

    public static APINodeList<AdCreativeObjectStorySpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeObjectStorySpec> adCreativeObjectStorySpecs = new APINodeList<AdCreativeObjectStorySpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeObjectStorySpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeObjectStorySpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeObjectStorySpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeObjectStorySpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeObjectStorySpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeObjectStorySpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeObjectStorySpecs;
                }
                adCreativeObjectStorySpecs.clear();
                adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(json, context, header));
                return adCreativeObjectStorySpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeObjectStorySpec.getGson().toJson((Object)this);
    }

    public String getFieldInstagramActorId() {
        return this.mInstagramActorId;
    }

    public AdCreativeObjectStorySpec setFieldInstagramActorId(String value) {
        this.mInstagramActorId = value;
        return this;
    }

    public AdCreativeLinkData getFieldLinkData() {
        return this.mLinkData;
    }

    public AdCreativeObjectStorySpec setFieldLinkData(AdCreativeLinkData value) {
        this.mLinkData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldLinkData(String value) {
        Type type = new TypeToken<AdCreativeLinkData>(){}.getType();
        this.mLinkData = (AdCreativeLinkData)AdCreativeLinkData.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public AdCreativeObjectStorySpec setFieldPageId(String value) {
        this.mPageId = value;
        return this;
    }

    public AdCreativePhotoData getFieldPhotoData() {
        return this.mPhotoData;
    }

    public AdCreativeObjectStorySpec setFieldPhotoData(AdCreativePhotoData value) {
        this.mPhotoData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldPhotoData(String value) {
        Type type = new TypeToken<AdCreativePhotoData>(){}.getType();
        this.mPhotoData = (AdCreativePhotoData)AdCreativePhotoData.getGson().fromJson(value, type);
        return this;
    }

    public List<AdCreativeProductData> getFieldProductData() {
        return this.mProductData;
    }

    public AdCreativeObjectStorySpec setFieldProductData(List<AdCreativeProductData> value) {
        this.mProductData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldProductData(String value) {
        Type type = new TypeToken<List<AdCreativeProductData>>(){}.getType();
        this.mProductData = (List)AdCreativeProductData.getGson().fromJson(value, type);
        return this;
    }

    public AdCreativeLinkData getFieldTemplateData() {
        return this.mTemplateData;
    }

    public AdCreativeObjectStorySpec setFieldTemplateData(AdCreativeLinkData value) {
        this.mTemplateData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldTemplateData(String value) {
        Type type = new TypeToken<AdCreativeLinkData>(){}.getType();
        this.mTemplateData = (AdCreativeLinkData)AdCreativeLinkData.getGson().fromJson(value, type);
        return this;
    }

    public AdCreativeTextData getFieldTextData() {
        return this.mTextData;
    }

    public AdCreativeObjectStorySpec setFieldTextData(AdCreativeTextData value) {
        this.mTextData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldTextData(String value) {
        Type type = new TypeToken<AdCreativeTextData>(){}.getType();
        this.mTextData = (AdCreativeTextData)AdCreativeTextData.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldThreadsUserId() {
        return this.mThreadsUserId;
    }

    public AdCreativeObjectStorySpec setFieldThreadsUserId(String value) {
        this.mThreadsUserId = value;
        return this;
    }

    public AdCreativeVideoData getFieldVideoData() {
        return this.mVideoData;
    }

    public AdCreativeObjectStorySpec setFieldVideoData(AdCreativeVideoData value) {
        this.mVideoData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldVideoData(String value) {
        Type type = new TypeToken<AdCreativeVideoData>(){}.getType();
        this.mVideoData = (AdCreativeVideoData)AdCreativeVideoData.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeObjectStorySpec copyFrom(AdCreativeObjectStorySpec instance) {
        this.mInstagramActorId = instance.mInstagramActorId;
        this.mLinkData = instance.mLinkData;
        this.mPageId = instance.mPageId;
        this.mPhotoData = instance.mPhotoData;
        this.mProductData = instance.mProductData;
        this.mTemplateData = instance.mTemplateData;
        this.mTextData = instance.mTextData;
        this.mThreadsUserId = instance.mThreadsUserId;
        this.mVideoData = instance.mVideoData;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeObjectStorySpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeObjectStorySpec>(){

            @Override
            public APINodeList<AdCreativeObjectStorySpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeObjectStorySpec> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeObjectStorySpec.parseResponse(response, context, request, header);
            }
        };
    }
}

