/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class VideoCopyrightMatch
extends APINode {
    @SerializedName(value="created_date")
    private String mCreatedDate = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_modified_user")
    private User mLastModifiedUser = null;
    @SerializedName(value="match_data")
    private List<Object> mMatchData = null;
    @SerializedName(value="match_status")
    private String mMatchStatus = null;
    @SerializedName(value="notes")
    private String mNotes = null;
    @SerializedName(value="permalink")
    private String mPermalink = null;
    protected static Gson gson = null;

    VideoCopyrightMatch() {
    }

    public VideoCopyrightMatch(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VideoCopyrightMatch(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VideoCopyrightMatch fetch() throws APIException {
        VideoCopyrightMatch newInstance = VideoCopyrightMatch.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VideoCopyrightMatch fetchById(Long id, APIContext context) throws APIException {
        return VideoCopyrightMatch.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VideoCopyrightMatch> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VideoCopyrightMatch.fetchByIdAsync(id.toString(), context);
    }

    public static VideoCopyrightMatch fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<VideoCopyrightMatch> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<VideoCopyrightMatch> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VideoCopyrightMatch>(context, "", "/", "GET", VideoCopyrightMatch.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VideoCopyrightMatch>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<VideoCopyrightMatch>(context, "", "/", "GET", VideoCopyrightMatch.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoCopyrightMatch loadJSON(String json, APIContext context, String header) {
        VideoCopyrightMatch videoCopyrightMatch = (VideoCopyrightMatch)VideoCopyrightMatch.getGson().fromJson(json, VideoCopyrightMatch.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoCopyrightMatch.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoCopyrightMatch.context = context;
        videoCopyrightMatch.rawValue = json;
        videoCopyrightMatch.header = header;
        return videoCopyrightMatch;
    }

    public static APINodeList<VideoCopyrightMatch> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoCopyrightMatch> videoCopyrightMatchs = new APINodeList<VideoCopyrightMatch>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoCopyrightMatchs.add(VideoCopyrightMatch.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoCopyrightMatchs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoCopyrightMatchs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoCopyrightMatchs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoCopyrightMatchs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoCopyrightMatchs.add(VideoCopyrightMatch.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoCopyrightMatchs.add(VideoCopyrightMatch.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoCopyrightMatchs.add(VideoCopyrightMatch.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoCopyrightMatchs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoCopyrightMatchs.add(VideoCopyrightMatch.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoCopyrightMatchs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoCopyrightMatchs.add(VideoCopyrightMatch.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoCopyrightMatchs;
                }
                videoCopyrightMatchs.clear();
                videoCopyrightMatchs.add(VideoCopyrightMatch.loadJSON(json, context, header));
                return videoCopyrightMatchs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoCopyrightMatch.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreatedDate() {
        return this.mCreatedDate;
    }

    public String getFieldId() {
        return this.mId;
    }

    public User getFieldLastModifiedUser() {
        if (this.mLastModifiedUser != null) {
            this.mLastModifiedUser.context = this.getContext();
        }
        return this.mLastModifiedUser;
    }

    public List<Object> getFieldMatchData() {
        return this.mMatchData;
    }

    public String getFieldMatchStatus() {
        return this.mMatchStatus;
    }

    public String getFieldNotes() {
        return this.mNotes;
    }

    public String getFieldPermalink() {
        return this.mPermalink;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoCopyrightMatch copyFrom(VideoCopyrightMatch instance) {
        this.mCreatedDate = instance.mCreatedDate;
        this.mId = instance.mId;
        this.mLastModifiedUser = instance.mLastModifiedUser;
        this.mMatchData = instance.mMatchData;
        this.mMatchStatus = instance.mMatchStatus;
        this.mNotes = instance.mNotes;
        this.mPermalink = instance.mPermalink;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoCopyrightMatch> getParser() {
        return new APIRequest.ResponseParser<VideoCopyrightMatch>(){

            @Override
            public APINodeList<VideoCopyrightMatch> parseResponse(String response, APIContext context, APIRequest<VideoCopyrightMatch> request, String header) throws APIException.MalformedResponseException {
                return VideoCopyrightMatch.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumMatchContentType {
        VALUE_AUDIO_ONLY("AUDIO_ONLY"),
        VALUE_VIDEO_AND_AUDIO("VIDEO_AND_AUDIO"),
        VALUE_VIDEO_ONLY("VIDEO_ONLY");

        private String value;

        private EnumMatchContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumActionReason {
        VALUE_ARTICLE_17_PREFLAGGING("ARTICLE_17_PREFLAGGING"),
        VALUE_ARTIST_OBJECTION("ARTIST_OBJECTION"),
        VALUE_OBJECTIONABLE_CONTENT("OBJECTIONABLE_CONTENT"),
        VALUE_PREMIUM_MUSIC_VIDEO("PREMIUM_MUSIC_VIDEO"),
        VALUE_PRERELEASE_CONTENT("PRERELEASE_CONTENT"),
        VALUE_PRODUCT_PARAMETERS("PRODUCT_PARAMETERS"),
        VALUE_RESTRICTED_CONTENT("RESTRICTED_CONTENT"),
        VALUE_UNAUTHORIZED_COMMERCIAL_USE("UNAUTHORIZED_COMMERCIAL_USE");

        private String value;

        private EnumActionReason(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAction {
        VALUE_BLOCK("BLOCK"),
        VALUE_CLAIM_AD_EARNINGS("CLAIM_AD_EARNINGS"),
        VALUE_MANUAL_REVIEW("MANUAL_REVIEW"),
        VALUE_MONITOR("MONITOR"),
        VALUE_REQUEST_TAKEDOWN("REQUEST_TAKEDOWN");

        private String value;

        private EnumAction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<VideoCopyrightMatch> {
        VideoCopyrightMatch lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"created_date", "id", "last_modified_user", "match_data", "match_status", "notes", "permalink"};

        @Override
        public VideoCopyrightMatch getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoCopyrightMatch parseResponse(String response, String header) throws APIException {
            return VideoCopyrightMatch.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoCopyrightMatch execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoCopyrightMatch execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoCopyrightMatch> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoCopyrightMatch> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoCopyrightMatch>(){

                public VideoCopyrightMatch apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreatedDateField() {
            return this.requestCreatedDateField(true);
        }

        public APIRequestGet requestCreatedDateField(boolean value) {
            this.requestField("created_date", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLastModifiedUserField() {
            return this.requestLastModifiedUserField(true);
        }

        public APIRequestGet requestLastModifiedUserField(boolean value) {
            this.requestField("last_modified_user", value);
            return this;
        }

        public APIRequestGet requestMatchDataField() {
            return this.requestMatchDataField(true);
        }

        public APIRequestGet requestMatchDataField(boolean value) {
            this.requestField("match_data", value);
            return this;
        }

        public APIRequestGet requestMatchStatusField() {
            return this.requestMatchStatusField(true);
        }

        public APIRequestGet requestMatchStatusField(boolean value) {
            this.requestField("match_status", value);
            return this;
        }

        public APIRequestGet requestNotesField() {
            return this.requestNotesField(true);
        }

        public APIRequestGet requestNotesField(boolean value) {
            this.requestField("notes", value);
            return this;
        }

        public APIRequestGet requestPermalinkField() {
            return this.requestPermalinkField(true);
        }

        public APIRequestGet requestPermalinkField(boolean value) {
            this.requestField("permalink", value);
            return this;
        }
    }
}

