/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class PrivateComputationEnvironment
extends APINode {
    @SerializedName(value="publisher_account_id")
    private String mPublisherAccountId = null;
    @SerializedName(value="publisher_pce_deployment_status")
    private Long mPublisherPceDeploymentStatus = null;
    @SerializedName(value="publisher_pce_id")
    private String mPublisherPceId = null;
    @SerializedName(value="publisher_region")
    private String mPublisherRegion = null;
    @SerializedName(value="publisher_vpc_id")
    private String mPublisherVpcId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    PrivateComputationEnvironment() {
    }

    public PrivateComputationEnvironment(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PrivateComputationEnvironment(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PrivateComputationEnvironment fetch() throws APIException {
        PrivateComputationEnvironment newInstance = PrivateComputationEnvironment.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PrivateComputationEnvironment fetchById(Long id, APIContext context) throws APIException {
        return PrivateComputationEnvironment.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PrivateComputationEnvironment> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PrivateComputationEnvironment.fetchByIdAsync(id.toString(), context);
    }

    public static PrivateComputationEnvironment fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PrivateComputationEnvironment> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PrivateComputationEnvironment> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PrivateComputationEnvironment>(context, "", "/", "GET", PrivateComputationEnvironment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PrivateComputationEnvironment>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PrivateComputationEnvironment>(context, "", "/", "GET", PrivateComputationEnvironment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PrivateComputationEnvironment loadJSON(String json, APIContext context, String header) {
        PrivateComputationEnvironment privateComputationEnvironment = (PrivateComputationEnvironment)PrivateComputationEnvironment.getGson().fromJson(json, PrivateComputationEnvironment.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(privateComputationEnvironment.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        privateComputationEnvironment.context = context;
        privateComputationEnvironment.rawValue = json;
        privateComputationEnvironment.header = header;
        return privateComputationEnvironment;
    }

    public static APINodeList<PrivateComputationEnvironment> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PrivateComputationEnvironment> privateComputationEnvironments = new APINodeList<PrivateComputationEnvironment>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        privateComputationEnvironments.add(PrivateComputationEnvironment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return privateComputationEnvironments;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            privateComputationEnvironments.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        privateComputationEnvironments.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            privateComputationEnvironments.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            privateComputationEnvironments.add(PrivateComputationEnvironment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                privateComputationEnvironments.add(PrivateComputationEnvironment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            privateComputationEnvironments.add(PrivateComputationEnvironment.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return privateComputationEnvironments;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        privateComputationEnvironments.add(PrivateComputationEnvironment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return privateComputationEnvironments;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        privateComputationEnvironments.add(PrivateComputationEnvironment.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return privateComputationEnvironments;
                }
                privateComputationEnvironments.clear();
                privateComputationEnvironments.add(PrivateComputationEnvironment.loadJSON(json, context, header));
                return privateComputationEnvironments;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PrivateComputationEnvironment.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldPublisherAccountId() {
        return this.mPublisherAccountId;
    }

    public Long getFieldPublisherPceDeploymentStatus() {
        return this.mPublisherPceDeploymentStatus;
    }

    public String getFieldPublisherPceId() {
        return this.mPublisherPceId;
    }

    public String getFieldPublisherRegion() {
        return this.mPublisherRegion;
    }

    public String getFieldPublisherVpcId() {
        return this.mPublisherVpcId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PrivateComputationEnvironment copyFrom(PrivateComputationEnvironment instance) {
        this.mPublisherAccountId = instance.mPublisherAccountId;
        this.mPublisherPceDeploymentStatus = instance.mPublisherPceDeploymentStatus;
        this.mPublisherPceId = instance.mPublisherPceId;
        this.mPublisherRegion = instance.mPublisherRegion;
        this.mPublisherVpcId = instance.mPublisherVpcId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PrivateComputationEnvironment> getParser() {
        return new APIRequest.ResponseParser<PrivateComputationEnvironment>(){

            @Override
            public APINodeList<PrivateComputationEnvironment> parseResponse(String response, APIContext context, APIRequest<PrivateComputationEnvironment> request, String header) throws APIException.MalformedResponseException {
                return PrivateComputationEnvironment.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<PrivateComputationEnvironment> {
        PrivateComputationEnvironment lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"publisher_account_id", "publisher_pce_deployment_status", "publisher_pce_id", "publisher_region", "publisher_vpc_id", "id"};

        @Override
        public PrivateComputationEnvironment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PrivateComputationEnvironment parseResponse(String response, String header) throws APIException {
            return PrivateComputationEnvironment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PrivateComputationEnvironment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PrivateComputationEnvironment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PrivateComputationEnvironment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PrivateComputationEnvironment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PrivateComputationEnvironment>(){

                public PrivateComputationEnvironment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestPublisherAccountIdField() {
            return this.requestPublisherAccountIdField(true);
        }

        public APIRequestGet requestPublisherAccountIdField(boolean value) {
            this.requestField("publisher_account_id", value);
            return this;
        }

        public APIRequestGet requestPublisherPceDeploymentStatusField() {
            return this.requestPublisherPceDeploymentStatusField(true);
        }

        public APIRequestGet requestPublisherPceDeploymentStatusField(boolean value) {
            this.requestField("publisher_pce_deployment_status", value);
            return this;
        }

        public APIRequestGet requestPublisherPceIdField() {
            return this.requestPublisherPceIdField(true);
        }

        public APIRequestGet requestPublisherPceIdField(boolean value) {
            this.requestField("publisher_pce_id", value);
            return this;
        }

        public APIRequestGet requestPublisherRegionField() {
            return this.requestPublisherRegionField(true);
        }

        public APIRequestGet requestPublisherRegionField(boolean value) {
            this.requestField("publisher_region", value);
            return this;
        }

        public APIRequestGet requestPublisherVpcIdField() {
            return this.requestPublisherVpcIdField(true);
        }

        public APIRequestGet requestPublisherVpcIdField(boolean value) {
            this.requestField("publisher_vpc_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

