/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class OpenBridgeConfiguration
extends APINode {
    @SerializedName(value="active")
    private Boolean mActive = null;
    @SerializedName(value="endpoint")
    private String mEndpoint = null;
    @SerializedName(value="fallback_domain")
    private String mFallbackDomain = null;
    @SerializedName(value="fallback_domain_enabled")
    private Boolean mFallbackDomainEnabled = null;
    @SerializedName(value="host_business_id")
    private String mHostBusinessId = null;
    @SerializedName(value="host_external_id")
    private String mHostExternalId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="instance_id")
    private String mInstanceId = null;
    @SerializedName(value="pixel_id")
    private String mPixelId = null;
    protected static Gson gson = null;

    OpenBridgeConfiguration() {
    }

    public OpenBridgeConfiguration(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public OpenBridgeConfiguration(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public OpenBridgeConfiguration fetch() throws APIException {
        OpenBridgeConfiguration newInstance = OpenBridgeConfiguration.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static OpenBridgeConfiguration fetchById(Long id, APIContext context) throws APIException {
        return OpenBridgeConfiguration.fetchById(id.toString(), context);
    }

    public static ListenableFuture<OpenBridgeConfiguration> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return OpenBridgeConfiguration.fetchByIdAsync(id.toString(), context);
    }

    public static OpenBridgeConfiguration fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<OpenBridgeConfiguration> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<OpenBridgeConfiguration> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<OpenBridgeConfiguration>(context, "", "/", "GET", OpenBridgeConfiguration.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<OpenBridgeConfiguration>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<OpenBridgeConfiguration>(context, "", "/", "GET", OpenBridgeConfiguration.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static OpenBridgeConfiguration loadJSON(String json, APIContext context, String header) {
        OpenBridgeConfiguration openBridgeConfiguration = (OpenBridgeConfiguration)OpenBridgeConfiguration.getGson().fromJson(json, OpenBridgeConfiguration.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(openBridgeConfiguration.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        openBridgeConfiguration.context = context;
        openBridgeConfiguration.rawValue = json;
        openBridgeConfiguration.header = header;
        return openBridgeConfiguration;
    }

    public static APINodeList<OpenBridgeConfiguration> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OpenBridgeConfiguration> openBridgeConfigurations = new APINodeList<OpenBridgeConfiguration>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        openBridgeConfigurations.add(OpenBridgeConfiguration.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return openBridgeConfigurations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            openBridgeConfigurations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        openBridgeConfigurations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            openBridgeConfigurations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            openBridgeConfigurations.add(OpenBridgeConfiguration.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                openBridgeConfigurations.add(OpenBridgeConfiguration.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            openBridgeConfigurations.add(OpenBridgeConfiguration.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return openBridgeConfigurations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        openBridgeConfigurations.add(OpenBridgeConfiguration.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return openBridgeConfigurations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        openBridgeConfigurations.add(OpenBridgeConfiguration.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return openBridgeConfigurations;
                }
                openBridgeConfigurations.clear();
                openBridgeConfigurations.add(OpenBridgeConfiguration.loadJSON(json, context, header));
                return openBridgeConfigurations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OpenBridgeConfiguration.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldActive() {
        return this.mActive;
    }

    public String getFieldEndpoint() {
        return this.mEndpoint;
    }

    public String getFieldFallbackDomain() {
        return this.mFallbackDomain;
    }

    public Boolean getFieldFallbackDomainEnabled() {
        return this.mFallbackDomainEnabled;
    }

    public String getFieldHostBusinessId() {
        return this.mHostBusinessId;
    }

    public String getFieldHostExternalId() {
        return this.mHostExternalId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldInstanceId() {
        return this.mInstanceId;
    }

    public String getFieldPixelId() {
        return this.mPixelId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OpenBridgeConfiguration copyFrom(OpenBridgeConfiguration instance) {
        this.mActive = instance.mActive;
        this.mEndpoint = instance.mEndpoint;
        this.mFallbackDomain = instance.mFallbackDomain;
        this.mFallbackDomainEnabled = instance.mFallbackDomainEnabled;
        this.mHostBusinessId = instance.mHostBusinessId;
        this.mHostExternalId = instance.mHostExternalId;
        this.mId = instance.mId;
        this.mInstanceId = instance.mInstanceId;
        this.mPixelId = instance.mPixelId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OpenBridgeConfiguration> getParser() {
        return new APIRequest.ResponseParser<OpenBridgeConfiguration>(){

            @Override
            public APINodeList<OpenBridgeConfiguration> parseResponse(String response, APIContext context, APIRequest<OpenBridgeConfiguration> request, String header) throws APIException.MalformedResponseException {
                return OpenBridgeConfiguration.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestUpdate
    extends APIRequest<OpenBridgeConfiguration> {
        OpenBridgeConfiguration lastResponse = null;
        public static final String[] PARAMS = new String[]{"active", "endpoint", "fallback_domain", "fallback_domain_enabled", "host_business_id", "host_external_id", "instance_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public OpenBridgeConfiguration getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OpenBridgeConfiguration parseResponse(String response, String header) throws APIException {
            return OpenBridgeConfiguration.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public OpenBridgeConfiguration execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OpenBridgeConfiguration execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<OpenBridgeConfiguration> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OpenBridgeConfiguration> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, OpenBridgeConfiguration>(){

                public OpenBridgeConfiguration apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setActive(Boolean active) {
            this.setParam("active", active);
            return this;
        }

        public APIRequestUpdate setActive(String active) {
            this.setParam("active", active);
            return this;
        }

        public APIRequestUpdate setEndpoint(String endpoint) {
            this.setParam("endpoint", endpoint);
            return this;
        }

        public APIRequestUpdate setFallbackDomain(String fallbackDomain) {
            this.setParam("fallback_domain", fallbackDomain);
            return this;
        }

        public APIRequestUpdate setFallbackDomainEnabled(Boolean fallbackDomainEnabled) {
            this.setParam("fallback_domain_enabled", fallbackDomainEnabled);
            return this;
        }

        public APIRequestUpdate setFallbackDomainEnabled(String fallbackDomainEnabled) {
            this.setParam("fallback_domain_enabled", fallbackDomainEnabled);
            return this;
        }

        public APIRequestUpdate setHostBusinessId(Long hostBusinessId) {
            this.setParam("host_business_id", hostBusinessId);
            return this;
        }

        public APIRequestUpdate setHostBusinessId(String hostBusinessId) {
            this.setParam("host_business_id", hostBusinessId);
            return this;
        }

        public APIRequestUpdate setHostExternalId(String hostExternalId) {
            this.setParam("host_external_id", hostExternalId);
            return this;
        }

        public APIRequestUpdate setInstanceId(String instanceId) {
            this.setParam("instance_id", instanceId);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<OpenBridgeConfiguration> {
        OpenBridgeConfiguration lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"active", "endpoint", "fallback_domain", "fallback_domain_enabled", "host_business_id", "host_external_id", "id", "instance_id", "pixel_id"};

        @Override
        public OpenBridgeConfiguration getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OpenBridgeConfiguration parseResponse(String response, String header) throws APIException {
            return OpenBridgeConfiguration.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public OpenBridgeConfiguration execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OpenBridgeConfiguration execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<OpenBridgeConfiguration> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OpenBridgeConfiguration> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, OpenBridgeConfiguration>(){

                public OpenBridgeConfiguration apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActiveField() {
            return this.requestActiveField(true);
        }

        public APIRequestGet requestActiveField(boolean value) {
            this.requestField("active", value);
            return this;
        }

        public APIRequestGet requestEndpointField() {
            return this.requestEndpointField(true);
        }

        public APIRequestGet requestEndpointField(boolean value) {
            this.requestField("endpoint", value);
            return this;
        }

        public APIRequestGet requestFallbackDomainField() {
            return this.requestFallbackDomainField(true);
        }

        public APIRequestGet requestFallbackDomainField(boolean value) {
            this.requestField("fallback_domain", value);
            return this;
        }

        public APIRequestGet requestFallbackDomainEnabledField() {
            return this.requestFallbackDomainEnabledField(true);
        }

        public APIRequestGet requestFallbackDomainEnabledField(boolean value) {
            this.requestField("fallback_domain_enabled", value);
            return this;
        }

        public APIRequestGet requestHostBusinessIdField() {
            return this.requestHostBusinessIdField(true);
        }

        public APIRequestGet requestHostBusinessIdField(boolean value) {
            this.requestField("host_business_id", value);
            return this;
        }

        public APIRequestGet requestHostExternalIdField() {
            return this.requestHostExternalIdField(true);
        }

        public APIRequestGet requestHostExternalIdField(boolean value) {
            this.requestField("host_external_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInstanceIdField() {
            return this.requestInstanceIdField(true);
        }

        public APIRequestGet requestInstanceIdField(boolean value) {
            this.requestField("instance_id", value);
            return this;
        }

        public APIRequestGet requestPixelIdField() {
            return this.requestPixelIdField(true);
        }

        public APIRequestGet requestPixelIdField(boolean value) {
            this.requestField("pixel_id", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

