/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InsightsValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class InsightsResult
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="description_from_api_doc")
    private String mDescriptionFromApiDoc = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="period")
    private String mPeriod = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="values")
    private List<InsightsValue> mValues = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InsightsResult loadJSON(String json, APIContext context, String header) {
        InsightsResult insightsResult = (InsightsResult)InsightsResult.getGson().fromJson(json, InsightsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(insightsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        insightsResult.context = context;
        insightsResult.rawValue = json;
        insightsResult.header = header;
        return insightsResult;
    }

    public static APINodeList<InsightsResult> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InsightsResult> insightsResults = new APINodeList<InsightsResult>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        insightsResults.add(InsightsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return insightsResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            insightsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        insightsResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            insightsResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            insightsResults.add(InsightsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                insightsResults.add(InsightsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            insightsResults.add(InsightsResult.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return insightsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        insightsResults.add(InsightsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return insightsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        insightsResults.add(InsightsResult.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return insightsResults;
                }
                insightsResults.clear();
                insightsResults.add(InsightsResult.loadJSON(json, context, header));
                return insightsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InsightsResult.getGson().toJson((Object)this);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public InsightsResult setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldDescriptionFromApiDoc() {
        return this.mDescriptionFromApiDoc;
    }

    public InsightsResult setFieldDescriptionFromApiDoc(String value) {
        this.mDescriptionFromApiDoc = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public InsightsResult setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public InsightsResult setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldPeriod() {
        return this.mPeriod;
    }

    public InsightsResult setFieldPeriod(String value) {
        this.mPeriod = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public InsightsResult setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public List<InsightsValue> getFieldValues() {
        return this.mValues;
    }

    public InsightsResult setFieldValues(List<InsightsValue> value) {
        this.mValues = value;
        return this;
    }

    public InsightsResult setFieldValues(String value) {
        Type type = new TypeToken<List<InsightsValue>>(){}.getType();
        this.mValues = (List)InsightsValue.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InsightsResult copyFrom(InsightsResult instance) {
        this.mDescription = instance.mDescription;
        this.mDescriptionFromApiDoc = instance.mDescriptionFromApiDoc;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPeriod = instance.mPeriod;
        this.mTitle = instance.mTitle;
        this.mValues = instance.mValues;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InsightsResult> getParser() {
        return new APIRequest.ResponseParser<InsightsResult>(){

            @Override
            public APINodeList<InsightsResult> parseResponse(String response, APIContext context, APIRequest<InsightsResult> request, String header) throws APIException.MalformedResponseException {
                return InsightsResult.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumMetric {
        VALUE_BLUE_REELS_PLAY_COUNT("blue_reels_play_count"),
        VALUE_CREATOR_MONETIZATION_QUALIFIED_VIEWS("creator_monetization_qualified_views"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_COMMENT_COUNT("fb_media_matching_copyright_comment_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_COMMENT_COUNT("fb_media_matching_copyright_daily_comment_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_LIKE_COUNT("fb_media_matching_copyright_daily_like_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_IMPRESSIONS("fb_media_matching_copyright_daily_post_impressions"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_IMPRESSIONS_BY_AGE_BUCKET_AND_GENDER("fb_media_matching_copyright_daily_post_impressions_by_age_bucket_and_gender"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_IMPRESSIONS_BY_COUNTRY("fb_media_matching_copyright_daily_post_impressions_by_country"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_IMPRESSIONS_BY_LOCALE("fb_media_matching_copyright_daily_post_impressions_by_locale"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_IMPRESSIONS_BY_MATCHING_POST_ID("fb_media_matching_copyright_daily_post_impressions_by_matching_post_id"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_IMPRESSIONS_BY_MATCHING_POST_OWNER_ID("fb_media_matching_copyright_daily_post_impressions_by_matching_post_owner_id"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_REACTIONS_ANGER_COUNT("fb_media_matching_copyright_daily_post_reactions_anger_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_REACTIONS_HAHA_COUNT("fb_media_matching_copyright_daily_post_reactions_haha_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_REACTIONS_LIKE_COUNT("fb_media_matching_copyright_daily_post_reactions_like_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_REACTIONS_LOVE_COUNT("fb_media_matching_copyright_daily_post_reactions_love_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_REACTIONS_SORRY_COUNT("fb_media_matching_copyright_daily_post_reactions_sorry_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_REACTIONS_WOW_COUNT("fb_media_matching_copyright_daily_post_reactions_wow_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_DAILY_POST_SHARE_COUNT("fb_media_matching_copyright_daily_post_share_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_LIKE_COUNT("fb_media_matching_copyright_like_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_IMPRESSIONS("fb_media_matching_copyright_post_impressions"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_IMPRESSIONS_BY_AGE_BUCKET_AND_GENDER("fb_media_matching_copyright_post_impressions_by_age_bucket_and_gender"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_IMPRESSIONS_BY_COUNTRY("fb_media_matching_copyright_post_impressions_by_country"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_IMPRESSIONS_BY_LOCALE("fb_media_matching_copyright_post_impressions_by_locale"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_IMPRESSIONS_BY_MATCHING_POST_ID("fb_media_matching_copyright_post_impressions_by_matching_post_id"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_IMPRESSIONS_BY_MATCHING_POST_OWNER_ID("fb_media_matching_copyright_post_impressions_by_matching_post_owner_id"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_REACTIONS_ANGER_COUNT("fb_media_matching_copyright_post_reactions_anger_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_REACTIONS_HAHA_COUNT("fb_media_matching_copyright_post_reactions_haha_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_REACTIONS_LIKE_COUNT("fb_media_matching_copyright_post_reactions_like_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_REACTIONS_LOVE_COUNT("fb_media_matching_copyright_post_reactions_love_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_REACTIONS_SORRY_COUNT("fb_media_matching_copyright_post_reactions_sorry_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_REACTIONS_WOW_COUNT("fb_media_matching_copyright_post_reactions_wow_count"),
        VALUE_FB_MEDIA_MATCHING_COPYRIGHT_POST_SHARE_COUNT("fb_media_matching_copyright_post_share_count"),
        VALUE_FB_REELS_REPLAY_COUNT("fb_reels_replay_count"),
        VALUE_FB_REELS_TOTAL_PLAYS("fb_reels_total_plays"),
        VALUE_HAS_TOTAL_VIDEO_VIEWS_BY_PUBLISHER_PLATFORM_TYPE("has_total_video_views_by_publisher_platform_type"),
        VALUE_POST_IMPRESSIONS_UNIQUE("post_impressions_unique"),
        VALUE_POST_VIDEO_AVG_TIME_WATCHED("post_video_avg_time_watched"),
        VALUE_POST_VIDEO_FOLLOWERS("post_video_followers"),
        VALUE_POST_VIDEO_LIKES_BY_REACTION_TYPE("post_video_likes_by_reaction_type"),
        VALUE_POST_VIDEO_RETENTION_GRAPH("post_video_retention_graph"),
        VALUE_POST_VIDEO_SOCIAL_ACTIONS("post_video_social_actions"),
        VALUE_POST_VIDEO_VIEW_TIME("post_video_view_time"),
        VALUE_RIGHTS_MANAGER_MATCHING_COPYRIGHT_MATCHING_PAGE_OR_PROFILE_VIEW_COUNT("rights_manager_matching_copyright_matching_page_or_profile_view_count"),
        VALUE_RIGHTS_MANAGER_MATCHING_COPYRIGHT_MATCHING_VIDEO_VIEW_COUNT("rights_manager_matching_copyright_matching_video_view_count"),
        VALUE_RIGHTS_MANAGER_MATCHING_COPYRIGHT_VIDEO_VIEW_COUNT("rights_manager_matching_copyright_video_view_count"),
        VALUE_RIGHTS_MANAGER_MATCHING_COPYRIGHT_VIDEO_VIEW_COUNT_60S("rights_manager_matching_copyright_video_view_count_60s"),
        VALUE_RIGHTS_MANAGER_MATCHING_COPYRIGHT_VIDEO_VIEW_COUNT_60S_BY_AGE_BUCKET_AND_GENDER("rights_manager_matching_copyright_video_view_count_60s_by_age_bucket_and_gender"),
        VALUE_RIGHTS_MANAGER_MATCHING_COPYRIGHT_VIDEO_VIEW_COUNT_60S_BY_COUNTRY_ID("rights_manager_matching_copyright_video_view_count_60s_by_country_id"),
        VALUE_RIGHTS_MANAGER_MATCHING_COPYRIGHT_VIDEO_VIEW_COUNT_60S_BY_LOCALE("rights_manager_matching_copyright_video_view_count_60s_by_locale"),
        VALUE_TOTAL_AUDIO_ONLY_PRODUCT_LISTEN_COUNT("total_audio_only_product_listen_count"),
        VALUE_TOTAL_VIDEO_10S_VIEWS("total_video_10s_views"),
        VALUE_TOTAL_VIDEO_10S_VIEWS_AUTO_PLAYED("total_video_10s_views_auto_played"),
        VALUE_TOTAL_VIDEO_10S_VIEWS_CLICKED_TO_PLAY("total_video_10s_views_clicked_to_play"),
        VALUE_TOTAL_VIDEO_10S_VIEWS_ORGANIC("total_video_10s_views_organic"),
        VALUE_TOTAL_VIDEO_10S_VIEWS_PAID("total_video_10s_views_paid"),
        VALUE_TOTAL_VIDEO_10S_VIEWS_SOUND_ON("total_video_10s_views_sound_on"),
        VALUE_TOTAL_VIDEO_10S_VIEWS_UNIQUE("total_video_10s_views_unique"),
        VALUE_TOTAL_VIDEO_15S_VIEWS("total_video_15s_views"),
        VALUE_TOTAL_VIDEO_30S_VIEWS("total_video_30s_views"),
        VALUE_TOTAL_VIDEO_30S_VIEWS_AUTO_PLAYED("total_video_30s_views_auto_played"),
        VALUE_TOTAL_VIDEO_30S_VIEWS_CLICKED_TO_PLAY("total_video_30s_views_clicked_to_play"),
        VALUE_TOTAL_VIDEO_30S_VIEWS_ORGANIC("total_video_30s_views_organic"),
        VALUE_TOTAL_VIDEO_30S_VIEWS_PAID("total_video_30s_views_paid"),
        VALUE_TOTAL_VIDEO_30S_VIEWS_UNIQUE("total_video_30s_views_unique"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS("total_video_60s_excludes_shorter_views"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_BY_AGE_BUCKET_AND_GENDER("total_video_60s_excludes_shorter_views_by_age_bucket_and_gender"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_BY_DISTRIBUTION_SOURCE("total_video_60s_excludes_shorter_views_by_distribution_source"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_BY_GROWTH_ACCOUNTING_BUCKET("total_video_60s_excludes_shorter_views_by_growth_accounting_bucket"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_BY_GROWTH_ACCOUNTING_BUCKET_AND_TIME_SINCE_CREATION_BUCKET("total_video_60s_excludes_shorter_views_by_growth_accounting_bucket_and_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_BY_IS_60S_RETURNING_VIEWER("total_video_60s_excludes_shorter_views_by_is_60s_returning_viewer"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_BY_IS_60S_RETURNING_VIEWER_AND_TIME_SINCE_CREATION_BUCKET("total_video_60s_excludes_shorter_views_by_is_60s_returning_viewer_and_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_LIVE("total_video_60s_excludes_shorter_views_live"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_UNIQUE("total_video_60s_excludes_shorter_views_unique"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_UNIQUE_BY_AGE_BUCKET_AND_GENDER("total_video_60s_excludes_shorter_views_unique_by_age_bucket_and_gender"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_UNIQUE_BY_GROWTH_ACCOUNTING_BUCKET("total_video_60s_excludes_shorter_views_unique_by_growth_accounting_bucket"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_UNIQUE_BY_GROWTH_ACCOUNTING_BUCKET_AND_TIME_SINCE_CREATION_BUCKET("total_video_60s_excludes_shorter_views_unique_by_growth_accounting_bucket_and_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_UNIQUE_BY_IS_60S_RETURNING_VIEWER("total_video_60s_excludes_shorter_views_unique_by_is_60s_returning_viewer"),
        VALUE_TOTAL_VIDEO_60S_EXCLUDES_SHORTER_VIEWS_UNIQUE_BY_IS_60S_RETURNING_VIEWER_AND_TIME_SINCE_CREATION_BUCKET("total_video_60s_excludes_shorter_views_unique_by_is_60s_returning_viewer_and_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_AD_BREAK_AD_CPM("total_video_ad_break_ad_cpm"),
        VALUE_TOTAL_VIDEO_AD_BREAK_AD_IMPRESSIONS("total_video_ad_break_ad_impressions"),
        VALUE_TOTAL_VIDEO_AD_BREAK_EARNINGS("total_video_ad_break_earnings"),
        VALUE_TOTAL_VIDEO_AD_BREAK_EARNINGS_WITH_SUBSIDY("total_video_ad_break_earnings_with_subsidy"),
        VALUE_TOTAL_VIDEO_AD_IMPRESSIONS_BY_MONETIZATION_TYPE("total_video_ad_impressions_by_monetization_type"),
        VALUE_TOTAL_VIDEO_AVG_TIME_WATCHED("total_video_avg_time_watched"),
        VALUE_TOTAL_VIDEO_AVG_TIME_WATCHED_BY_DISTRIBUTION_SOURCE("total_video_avg_time_watched_by_distribution_source"),
        VALUE_TOTAL_VIDEO_AVG_TIME_WATCHED_BY_IS_60S_RETURNING_VIEWER("total_video_avg_time_watched_by_is_60s_returning_viewer"),
        VALUE_TOTAL_VIDEO_AVG_TIME_WATCHED_BY_TIME_SINCE_CREATION_BUCKET("total_video_avg_time_watched_by_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_AVG_TIME_WATCHED_FOLLOWERS("total_video_avg_time_watched_followers"),
        VALUE_TOTAL_VIDEO_AVG_TIME_WATCHED_LIVE("total_video_avg_time_watched_live"),
        VALUE_TOTAL_VIDEO_COMMENT_SENTIMENT("total_video_comment_sentiment"),
        VALUE_TOTAL_VIDEO_COMMENT_SENTIMENT_BY_FACTORS("total_video_comment_sentiment_by_factors"),
        VALUE_TOTAL_VIDEO_COMPLETE_VIEWS("total_video_complete_views"),
        VALUE_TOTAL_VIDEO_COMPLETE_VIEWS_AUTO_PLAYED("total_video_complete_views_auto_played"),
        VALUE_TOTAL_VIDEO_COMPLETE_VIEWS_CLICKED_TO_PLAY("total_video_complete_views_clicked_to_play"),
        VALUE_TOTAL_VIDEO_COMPLETE_VIEWS_ORGANIC("total_video_complete_views_organic"),
        VALUE_TOTAL_VIDEO_COMPLETE_VIEWS_ORGANIC_UNIQUE("total_video_complete_views_organic_unique"),
        VALUE_TOTAL_VIDEO_COMPLETE_VIEWS_PAID("total_video_complete_views_paid"),
        VALUE_TOTAL_VIDEO_COMPLETE_VIEWS_PAID_UNIQUE("total_video_complete_views_paid_unique"),
        VALUE_TOTAL_VIDEO_COMPLETE_VIEWS_UNIQUE("total_video_complete_views_unique"),
        VALUE_TOTAL_VIDEO_CONSUMPTION_RATE("total_video_consumption_rate"),
        VALUE_TOTAL_VIDEO_FOLLOWERS_UNIQUE("total_video_followers_unique"),
        VALUE_TOTAL_VIDEO_GROWTH_SCORE("total_video_growth_score"),
        VALUE_TOTAL_VIDEO_GROWTH_SCORE_BY_FACTORS("total_video_growth_score_by_factors"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS("total_video_impressions"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_FAN("total_video_impressions_fan"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_FAN_PAID("total_video_impressions_fan_paid"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_FAN_PAID_UNIQUE("total_video_impressions_fan_paid_unique"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_FAN_UNIQUE("total_video_impressions_fan_unique"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_ORGANIC("total_video_impressions_organic"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_ORGANIC_UNIQUE("total_video_impressions_organic_unique"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_PAID("total_video_impressions_paid"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_PAID_UNIQUE("total_video_impressions_paid_unique"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_UNIQUE("total_video_impressions_unique"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_VIRAL("total_video_impressions_viral"),
        VALUE_TOTAL_VIDEO_IMPRESSIONS_VIRAL_UNIQUE("total_video_impressions_viral_unique"),
        VALUE_TOTAL_VIDEO_IMPS_COUNT_UNIQUE_BY_AGE_BUCKET("total_video_imps_count_unique_by_age_bucket"),
        VALUE_TOTAL_VIDEO_IMPS_COUNT_UNIQUE_BY_AGE_BUCKET_AND_GENDER("total_video_imps_count_unique_by_age_bucket_and_gender"),
        VALUE_TOTAL_VIDEO_IMPS_COUNT_UNIQUE_BY_GENDER("total_video_imps_count_unique_by_gender"),
        VALUE_TOTAL_VIDEO_LIKES_BY_REACTION_TYPE("total_video_likes_by_reaction_type"),
        VALUE_TOTAL_VIDEO_NEGATIVE_FEEDBACK("total_video_negative_feedback"),
        VALUE_TOTAL_VIDEO_NET_FOLLOWERS("total_video_net_followers"),
        VALUE_TOTAL_VIDEO_NET_FOLLOWERS_UNIQUE("total_video_net_followers_unique"),
        VALUE_TOTAL_VIDEO_NET_FOLLOWERS_UNIQUE_BY_TIME_SINCE_CREATION_BUCKET("total_video_net_followers_unique_by_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_PLAY_COUNT("total_video_play_count"),
        VALUE_TOTAL_VIDEO_PLAY_COUNT_BY_IS_60S_RETURNING_VIEWER_AND_TIME_SINCE_CREATION_BUCKET("total_video_play_count_by_is_60s_returning_viewer_and_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_PLAY_COUNT_BY_TIME_SINCE_CREATION_BUCKET("total_video_play_count_by_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_REACTIONS_BY_TYPE_TOTAL("total_video_reactions_by_type_total"),
        VALUE_TOTAL_VIDEO_RELATIVE_RETENTION_GRAPH("total_video_relative_retention_graph"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH("total_video_retention_graph"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_15S("total_video_retention_graph_15s"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_15S_FOLLOWERS("total_video_retention_graph_15s_followers"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_15S_NEWSFEED("total_video_retention_graph_15s_newsfeed"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_15S_RECOMMENDED("total_video_retention_graph_15s_recommended"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_15S_SHARES("total_video_retention_graph_15s_shares"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_15S_WATCH("total_video_retention_graph_15s_watch"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_AUTOPLAYED("total_video_retention_graph_autoplayed"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_CLICKED_TO_PLAY("total_video_retention_graph_clicked_to_play"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_GENDER_FEMALE("total_video_retention_graph_gender_female"),
        VALUE_TOTAL_VIDEO_RETENTION_GRAPH_GENDER_MALE("total_video_retention_graph_gender_male"),
        VALUE_TOTAL_VIDEO_SOCIAL_ACTIONS("total_video_social_actions"),
        VALUE_TOTAL_VIDEO_SOCIAL_ACTIONS_COMMENT_BY_DISTRIBUTION_TYPE("total_video_social_actions_comment_by_distribution_type"),
        VALUE_TOTAL_VIDEO_SOCIAL_ACTIONS_COUNT_UNIQUE("total_video_social_actions_count_unique"),
        VALUE_TOTAL_VIDEO_SOCIAL_ACTIONS_COUNT_UNIQUE_BY_AGE_BUCKET("total_video_social_actions_count_unique_by_age_bucket"),
        VALUE_TOTAL_VIDEO_SOCIAL_ACTIONS_COUNT_UNIQUE_BY_AGE_BUCKET_AND_GENDER("total_video_social_actions_count_unique_by_age_bucket_and_gender"),
        VALUE_TOTAL_VIDEO_SOCIAL_ACTIONS_COUNT_UNIQUE_BY_GENDER("total_video_social_actions_count_unique_by_gender"),
        VALUE_TOTAL_VIDEO_SOCIAL_ACTIONS_REACTION_BY_DISTRIBUTION_TYPE("total_video_social_actions_reaction_by_distribution_type"),
        VALUE_TOTAL_VIDEO_STORIES_BY_ACTION_TYPE("total_video_stories_by_action_type"),
        VALUE_TOTAL_VIDEO_UNFOLLOWERS("total_video_unfollowers"),
        VALUE_TOTAL_VIDEO_UNFOLLOWERS_UNIQUE("total_video_unfollowers_unique"),
        VALUE_TOTAL_VIDEO_VIEW_COUNT_UNIQUE_BY_AGE_BUCKET("total_video_view_count_unique_by_age_bucket"),
        VALUE_TOTAL_VIDEO_VIEW_COUNT_UNIQUE_BY_AGE_BUCKET_AND_GENDER("total_video_view_count_unique_by_age_bucket_and_gender"),
        VALUE_TOTAL_VIDEO_VIEW_COUNT_UNIQUE_BY_GENDER("total_video_view_count_unique_by_gender"),
        VALUE_TOTAL_VIDEO_VIEW_TIME_BY_AGE_BUCKET_AND_GENDER("total_video_view_time_by_age_bucket_and_gender"),
        VALUE_TOTAL_VIDEO_VIEW_TIME_BY_COUNTRY_ID("total_video_view_time_by_country_id"),
        VALUE_TOTAL_VIDEO_VIEW_TIME_BY_DISTRIBUTION_SOURCE("total_video_view_time_by_distribution_source"),
        VALUE_TOTAL_VIDEO_VIEW_TIME_BY_DISTRIBUTION_TYPE("total_video_view_time_by_distribution_type"),
        VALUE_TOTAL_VIDEO_VIEW_TIME_BY_IS_60S_RETURNING_VIEWER_AND_TIME_SINCE_CREATION_BUCKET("total_video_view_time_by_is_60s_returning_viewer_and_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_VIEW_TIME_BY_REGION_ID("total_video_view_time_by_region_id"),
        VALUE_TOTAL_VIDEO_VIEW_TIME_BY_TIME_SINCE_CREATION_BUCKET("total_video_view_time_by_time_since_creation_bucket"),
        VALUE_TOTAL_VIDEO_VIEW_TOTAL_TIME("total_video_view_total_time"),
        VALUE_TOTAL_VIDEO_VIEW_TOTAL_TIME_BY_IS_60S_RETURNING_VIEWER("total_video_view_total_time_by_is_60s_returning_viewer"),
        VALUE_TOTAL_VIDEO_VIEW_TOTAL_TIME_BY_PAID_NON_PAID("total_video_view_total_time_by_paid_non_paid"),
        VALUE_TOTAL_VIDEO_VIEW_TOTAL_TIME_LIVE("total_video_view_total_time_live"),
        VALUE_TOTAL_VIDEO_VIEW_TOTAL_TIME_ORGANIC("total_video_view_total_time_organic"),
        VALUE_TOTAL_VIDEO_VIEW_TOTAL_TIME_PAID("total_video_view_total_time_paid"),
        VALUE_TOTAL_VIDEO_VIEW_TOTAL_TIME_VOD("total_video_view_total_time_vod"),
        VALUE_TOTAL_VIDEO_VIEWS("total_video_views"),
        VALUE_TOTAL_VIDEO_VIEWS_AUTOPLAYED("total_video_views_autoplayed"),
        VALUE_TOTAL_VIDEO_VIEWS_BY_AGE_BUCKET_AND_GENDER("total_video_views_by_age_bucket_and_gender"),
        VALUE_TOTAL_VIDEO_VIEWS_BY_COUNTRY_ID("total_video_views_by_country_id"),
        VALUE_TOTAL_VIDEO_VIEWS_BY_DISTRIBUTION_TYPE("total_video_views_by_distribution_type"),
        VALUE_TOTAL_VIDEO_VIEWS_BY_PAID_NON_PAID("total_video_views_by_paid_non_paid"),
        VALUE_TOTAL_VIDEO_VIEWS_BY_REGION_ID("total_video_views_by_region_id"),
        VALUE_TOTAL_VIDEO_VIEWS_BY_REGION_ID_PROPER("total_video_views_by_region_id_proper"),
        VALUE_TOTAL_VIDEO_VIEWS_CLICKED_TO_PLAY("total_video_views_clicked_to_play"),
        VALUE_TOTAL_VIDEO_VIEWS_GENDER_FEMALE("total_video_views_gender_female"),
        VALUE_TOTAL_VIDEO_VIEWS_GENDER_FEMALE_LIVE("total_video_views_gender_female_live"),
        VALUE_TOTAL_VIDEO_VIEWS_GENDER_MALE("total_video_views_gender_male"),
        VALUE_TOTAL_VIDEO_VIEWS_GENDER_MALE_LIVE("total_video_views_gender_male_live"),
        VALUE_TOTAL_VIDEO_VIEWS_LIVE("total_video_views_live"),
        VALUE_TOTAL_VIDEO_VIEWS_LIVE_AUTOPLAYED("total_video_views_live_autoplayed"),
        VALUE_TOTAL_VIDEO_VIEWS_LIVE_CLICKED_TO_PLAY("total_video_views_live_clicked_to_play"),
        VALUE_TOTAL_VIDEO_VIEWS_ORGANIC("total_video_views_organic"),
        VALUE_TOTAL_VIDEO_VIEWS_ORGANIC_UNIQUE("total_video_views_organic_unique"),
        VALUE_TOTAL_VIDEO_VIEWS_PAID("total_video_views_paid"),
        VALUE_TOTAL_VIDEO_VIEWS_PAID_UNIQUE("total_video_views_paid_unique"),
        VALUE_TOTAL_VIDEO_VIEWS_SOUND_ON("total_video_views_sound_on"),
        VALUE_TOTAL_VIDEO_VIEWS_UNIQUE("total_video_views_unique"),
        VALUE_TOTAL_VIDEO_VIEWS_VOD("total_video_views_vod"),
        VALUE_VIDEO_ASSET_60S_VIDEO_VIEW_TOTAL_COUNT_BY_IS_MONETIZABLE("video_asset_60s_video_view_total_count_by_is_monetizable");

        private String value;

        private EnumMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumPeriod {
        VALUE_DAY("day"),
        VALUE_DAYS_28("days_28"),
        VALUE_LIFETIME("lifetime"),
        VALUE_MONTH("month"),
        VALUE_TOTAL_OVER_RANGE("total_over_range"),
        VALUE_WEEK("week");

        private String value;

        private EnumPeriod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumDatePreset {
        VALUE_DATA_MAXIMUM("data_maximum"),
        VALUE_LAST_14D("last_14d"),
        VALUE_LAST_28D("last_28d"),
        VALUE_LAST_30D("last_30d"),
        VALUE_LAST_3D("last_3d"),
        VALUE_LAST_7D("last_7d"),
        VALUE_LAST_90D("last_90d"),
        VALUE_LAST_MONTH("last_month"),
        VALUE_LAST_QUARTER("last_quarter"),
        VALUE_LAST_WEEK_MON_SUN("last_week_mon_sun"),
        VALUE_LAST_WEEK_SUN_SAT("last_week_sun_sat"),
        VALUE_LAST_YEAR("last_year"),
        VALUE_MAXIMUM("maximum"),
        VALUE_THIS_MONTH("this_month"),
        VALUE_THIS_QUARTER("this_quarter"),
        VALUE_THIS_WEEK_MON_TODAY("this_week_mon_today"),
        VALUE_THIS_WEEK_SUN_TODAY("this_week_sun_today"),
        VALUE_THIS_YEAR("this_year"),
        VALUE_TODAY("today"),
        VALUE_YESTERDAY("yesterday");

        private String value;

        private EnumDatePreset(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

