/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class DeliveryInfo
extends APINode {
    @SerializedName(value="active_accelerated_campaign_count")
    private Long mActiveAcceleratedCampaignCount = null;
    @SerializedName(value="active_day_parted_campaign_count")
    private Long mActiveDayPartedCampaignCount = null;
    @SerializedName(value="ad_penalty_map")
    private List<Map<String, Boolean>> mAdPenaltyMap = null;
    @SerializedName(value="are_all_daily_budgets_spent")
    private Boolean mAreAllDailyBudgetsSpent = null;
    @SerializedName(value="credit_needed_ads_count")
    private Long mCreditNeededAdsCount = null;
    @SerializedName(value="eligible_for_delivery_insights")
    private Boolean mEligibleForDeliveryInsights = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="has_account_hit_spend_limit")
    private Boolean mHasAccountHitSpendLimit = null;
    @SerializedName(value="has_campaign_group_hit_spend_limit")
    private Boolean mHasCampaignGroupHitSpendLimit = null;
    @SerializedName(value="has_no_active_ads")
    private Boolean mHasNoActiveAds = null;
    @SerializedName(value="has_no_ads")
    private Boolean mHasNoAds = null;
    @SerializedName(value="inactive_ads_count")
    private Long mInactiveAdsCount = null;
    @SerializedName(value="inactive_campaign_count")
    private Long mInactiveCampaignCount = null;
    @SerializedName(value="is_account_closed")
    private Boolean mIsAccountClosed = null;
    @SerializedName(value="is_account_disabled")
    private Boolean mIsAccountDisabled = null;
    @SerializedName(value="is_ad_uneconomical")
    private Boolean mIsAdUneconomical = null;
    @SerializedName(value="is_adfarm_penalized")
    private Boolean mIsAdfarmPenalized = null;
    @SerializedName(value="is_adgroup_partially_rejected")
    private Boolean mIsAdgroupPartiallyRejected = null;
    @SerializedName(value="is_campaign_accelerated")
    private Boolean mIsCampaignAccelerated = null;
    @SerializedName(value="is_campaign_completed")
    private Boolean mIsCampaignCompleted = null;
    @SerializedName(value="is_campaign_day_parted")
    private Boolean mIsCampaignDayParted = null;
    @SerializedName(value="is_campaign_disabled")
    private Boolean mIsCampaignDisabled = null;
    @SerializedName(value="is_campaign_group_disabled")
    private Boolean mIsCampaignGroupDisabled = null;
    @SerializedName(value="is_clickbait_penalized")
    private Boolean mIsClickbaitPenalized = null;
    @SerializedName(value="is_daily_budget_spent")
    private Boolean mIsDailyBudgetSpent = null;
    @SerializedName(value="is_engagement_bait_penalized")
    private Boolean mIsEngagementBaitPenalized = null;
    @SerializedName(value="is_lqwe_penalized")
    private Boolean mIsLqwePenalized = null;
    @SerializedName(value="is_reach_and_frequency_misconfigured")
    private Boolean mIsReachAndFrequencyMisconfigured = null;
    @SerializedName(value="is_sensationalism_penalized")
    private Boolean mIsSensationalismPenalized = null;
    @SerializedName(value="is_split_test_active")
    private Boolean mIsSplitTestActive = null;
    @SerializedName(value="is_split_test_valid")
    private Boolean mIsSplitTestValid = null;
    @SerializedName(value="lift_study_time_period")
    private String mLiftStudyTimePeriod = null;
    @SerializedName(value="needs_credit")
    private Boolean mNeedsCredit = null;
    @SerializedName(value="needs_tax_number")
    private Boolean mNeedsTaxNumber = null;
    @SerializedName(value="non_deleted_ads_count")
    private Long mNonDeletedAdsCount = null;
    @SerializedName(value="not_delivering_campaign_count")
    private Long mNotDeliveringCampaignCount = null;
    @SerializedName(value="pending_ads_count")
    private Long mPendingAdsCount = null;
    @SerializedName(value="reach_frequency_campaign_underdelivery_reason")
    private String mReachFrequencyCampaignUnderdeliveryReason = null;
    @SerializedName(value="rejected_ads_count")
    private Long mRejectedAdsCount = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="text_penalty_level")
    private String mTextPenaltyLevel = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static DeliveryInfo loadJSON(String json, APIContext context, String header) {
        DeliveryInfo deliveryInfo = (DeliveryInfo)DeliveryInfo.getGson().fromJson(json, DeliveryInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(deliveryInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        deliveryInfo.context = context;
        deliveryInfo.rawValue = json;
        deliveryInfo.header = header;
        return deliveryInfo;
    }

    public static APINodeList<DeliveryInfo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<DeliveryInfo> deliveryInfos = new APINodeList<DeliveryInfo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        deliveryInfos.add(DeliveryInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return deliveryInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            deliveryInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        deliveryInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            deliveryInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            deliveryInfos.add(DeliveryInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                deliveryInfos.add(DeliveryInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            deliveryInfos.add(DeliveryInfo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return deliveryInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        deliveryInfos.add(DeliveryInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return deliveryInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        deliveryInfos.add(DeliveryInfo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return deliveryInfos;
                }
                deliveryInfos.clear();
                deliveryInfos.add(DeliveryInfo.loadJSON(json, context, header));
                return deliveryInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DeliveryInfo.getGson().toJson((Object)this);
    }

    public Long getFieldActiveAcceleratedCampaignCount() {
        return this.mActiveAcceleratedCampaignCount;
    }

    public DeliveryInfo setFieldActiveAcceleratedCampaignCount(Long value) {
        this.mActiveAcceleratedCampaignCount = value;
        return this;
    }

    public Long getFieldActiveDayPartedCampaignCount() {
        return this.mActiveDayPartedCampaignCount;
    }

    public DeliveryInfo setFieldActiveDayPartedCampaignCount(Long value) {
        this.mActiveDayPartedCampaignCount = value;
        return this;
    }

    public List<Map<String, Boolean>> getFieldAdPenaltyMap() {
        return this.mAdPenaltyMap;
    }

    public DeliveryInfo setFieldAdPenaltyMap(List<Map<String, Boolean>> value) {
        this.mAdPenaltyMap = value;
        return this;
    }

    public Boolean getFieldAreAllDailyBudgetsSpent() {
        return this.mAreAllDailyBudgetsSpent;
    }

    public DeliveryInfo setFieldAreAllDailyBudgetsSpent(Boolean value) {
        this.mAreAllDailyBudgetsSpent = value;
        return this;
    }

    public Long getFieldCreditNeededAdsCount() {
        return this.mCreditNeededAdsCount;
    }

    public DeliveryInfo setFieldCreditNeededAdsCount(Long value) {
        this.mCreditNeededAdsCount = value;
        return this;
    }

    public Boolean getFieldEligibleForDeliveryInsights() {
        return this.mEligibleForDeliveryInsights;
    }

    public DeliveryInfo setFieldEligibleForDeliveryInsights(Boolean value) {
        this.mEligibleForDeliveryInsights = value;
        return this;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public DeliveryInfo setFieldEndTime(String value) {
        this.mEndTime = value;
        return this;
    }

    public Boolean getFieldHasAccountHitSpendLimit() {
        return this.mHasAccountHitSpendLimit;
    }

    public DeliveryInfo setFieldHasAccountHitSpendLimit(Boolean value) {
        this.mHasAccountHitSpendLimit = value;
        return this;
    }

    public Boolean getFieldHasCampaignGroupHitSpendLimit() {
        return this.mHasCampaignGroupHitSpendLimit;
    }

    public DeliveryInfo setFieldHasCampaignGroupHitSpendLimit(Boolean value) {
        this.mHasCampaignGroupHitSpendLimit = value;
        return this;
    }

    public Boolean getFieldHasNoActiveAds() {
        return this.mHasNoActiveAds;
    }

    public DeliveryInfo setFieldHasNoActiveAds(Boolean value) {
        this.mHasNoActiveAds = value;
        return this;
    }

    public Boolean getFieldHasNoAds() {
        return this.mHasNoAds;
    }

    public DeliveryInfo setFieldHasNoAds(Boolean value) {
        this.mHasNoAds = value;
        return this;
    }

    public Long getFieldInactiveAdsCount() {
        return this.mInactiveAdsCount;
    }

    public DeliveryInfo setFieldInactiveAdsCount(Long value) {
        this.mInactiveAdsCount = value;
        return this;
    }

    public Long getFieldInactiveCampaignCount() {
        return this.mInactiveCampaignCount;
    }

    public DeliveryInfo setFieldInactiveCampaignCount(Long value) {
        this.mInactiveCampaignCount = value;
        return this;
    }

    public Boolean getFieldIsAccountClosed() {
        return this.mIsAccountClosed;
    }

    public DeliveryInfo setFieldIsAccountClosed(Boolean value) {
        this.mIsAccountClosed = value;
        return this;
    }

    public Boolean getFieldIsAccountDisabled() {
        return this.mIsAccountDisabled;
    }

    public DeliveryInfo setFieldIsAccountDisabled(Boolean value) {
        this.mIsAccountDisabled = value;
        return this;
    }

    public Boolean getFieldIsAdUneconomical() {
        return this.mIsAdUneconomical;
    }

    public DeliveryInfo setFieldIsAdUneconomical(Boolean value) {
        this.mIsAdUneconomical = value;
        return this;
    }

    public Boolean getFieldIsAdfarmPenalized() {
        return this.mIsAdfarmPenalized;
    }

    public DeliveryInfo setFieldIsAdfarmPenalized(Boolean value) {
        this.mIsAdfarmPenalized = value;
        return this;
    }

    public Boolean getFieldIsAdgroupPartiallyRejected() {
        return this.mIsAdgroupPartiallyRejected;
    }

    public DeliveryInfo setFieldIsAdgroupPartiallyRejected(Boolean value) {
        this.mIsAdgroupPartiallyRejected = value;
        return this;
    }

    public Boolean getFieldIsCampaignAccelerated() {
        return this.mIsCampaignAccelerated;
    }

    public DeliveryInfo setFieldIsCampaignAccelerated(Boolean value) {
        this.mIsCampaignAccelerated = value;
        return this;
    }

    public Boolean getFieldIsCampaignCompleted() {
        return this.mIsCampaignCompleted;
    }

    public DeliveryInfo setFieldIsCampaignCompleted(Boolean value) {
        this.mIsCampaignCompleted = value;
        return this;
    }

    public Boolean getFieldIsCampaignDayParted() {
        return this.mIsCampaignDayParted;
    }

    public DeliveryInfo setFieldIsCampaignDayParted(Boolean value) {
        this.mIsCampaignDayParted = value;
        return this;
    }

    public Boolean getFieldIsCampaignDisabled() {
        return this.mIsCampaignDisabled;
    }

    public DeliveryInfo setFieldIsCampaignDisabled(Boolean value) {
        this.mIsCampaignDisabled = value;
        return this;
    }

    public Boolean getFieldIsCampaignGroupDisabled() {
        return this.mIsCampaignGroupDisabled;
    }

    public DeliveryInfo setFieldIsCampaignGroupDisabled(Boolean value) {
        this.mIsCampaignGroupDisabled = value;
        return this;
    }

    public Boolean getFieldIsClickbaitPenalized() {
        return this.mIsClickbaitPenalized;
    }

    public DeliveryInfo setFieldIsClickbaitPenalized(Boolean value) {
        this.mIsClickbaitPenalized = value;
        return this;
    }

    public Boolean getFieldIsDailyBudgetSpent() {
        return this.mIsDailyBudgetSpent;
    }

    public DeliveryInfo setFieldIsDailyBudgetSpent(Boolean value) {
        this.mIsDailyBudgetSpent = value;
        return this;
    }

    public Boolean getFieldIsEngagementBaitPenalized() {
        return this.mIsEngagementBaitPenalized;
    }

    public DeliveryInfo setFieldIsEngagementBaitPenalized(Boolean value) {
        this.mIsEngagementBaitPenalized = value;
        return this;
    }

    public Boolean getFieldIsLqwePenalized() {
        return this.mIsLqwePenalized;
    }

    public DeliveryInfo setFieldIsLqwePenalized(Boolean value) {
        this.mIsLqwePenalized = value;
        return this;
    }

    public Boolean getFieldIsReachAndFrequencyMisconfigured() {
        return this.mIsReachAndFrequencyMisconfigured;
    }

    public DeliveryInfo setFieldIsReachAndFrequencyMisconfigured(Boolean value) {
        this.mIsReachAndFrequencyMisconfigured = value;
        return this;
    }

    public Boolean getFieldIsSensationalismPenalized() {
        return this.mIsSensationalismPenalized;
    }

    public DeliveryInfo setFieldIsSensationalismPenalized(Boolean value) {
        this.mIsSensationalismPenalized = value;
        return this;
    }

    public Boolean getFieldIsSplitTestActive() {
        return this.mIsSplitTestActive;
    }

    public DeliveryInfo setFieldIsSplitTestActive(Boolean value) {
        this.mIsSplitTestActive = value;
        return this;
    }

    public Boolean getFieldIsSplitTestValid() {
        return this.mIsSplitTestValid;
    }

    public DeliveryInfo setFieldIsSplitTestValid(Boolean value) {
        this.mIsSplitTestValid = value;
        return this;
    }

    public String getFieldLiftStudyTimePeriod() {
        return this.mLiftStudyTimePeriod;
    }

    public DeliveryInfo setFieldLiftStudyTimePeriod(String value) {
        this.mLiftStudyTimePeriod = value;
        return this;
    }

    public Boolean getFieldNeedsCredit() {
        return this.mNeedsCredit;
    }

    public DeliveryInfo setFieldNeedsCredit(Boolean value) {
        this.mNeedsCredit = value;
        return this;
    }

    public Boolean getFieldNeedsTaxNumber() {
        return this.mNeedsTaxNumber;
    }

    public DeliveryInfo setFieldNeedsTaxNumber(Boolean value) {
        this.mNeedsTaxNumber = value;
        return this;
    }

    public Long getFieldNonDeletedAdsCount() {
        return this.mNonDeletedAdsCount;
    }

    public DeliveryInfo setFieldNonDeletedAdsCount(Long value) {
        this.mNonDeletedAdsCount = value;
        return this;
    }

    public Long getFieldNotDeliveringCampaignCount() {
        return this.mNotDeliveringCampaignCount;
    }

    public DeliveryInfo setFieldNotDeliveringCampaignCount(Long value) {
        this.mNotDeliveringCampaignCount = value;
        return this;
    }

    public Long getFieldPendingAdsCount() {
        return this.mPendingAdsCount;
    }

    public DeliveryInfo setFieldPendingAdsCount(Long value) {
        this.mPendingAdsCount = value;
        return this;
    }

    public String getFieldReachFrequencyCampaignUnderdeliveryReason() {
        return this.mReachFrequencyCampaignUnderdeliveryReason;
    }

    public DeliveryInfo setFieldReachFrequencyCampaignUnderdeliveryReason(String value) {
        this.mReachFrequencyCampaignUnderdeliveryReason = value;
        return this;
    }

    public Long getFieldRejectedAdsCount() {
        return this.mRejectedAdsCount;
    }

    public DeliveryInfo setFieldRejectedAdsCount(Long value) {
        this.mRejectedAdsCount = value;
        return this;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public DeliveryInfo setFieldStartTime(String value) {
        this.mStartTime = value;
        return this;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public DeliveryInfo setFieldStatus(String value) {
        this.mStatus = value;
        return this;
    }

    public String getFieldTextPenaltyLevel() {
        return this.mTextPenaltyLevel;
    }

    public DeliveryInfo setFieldTextPenaltyLevel(String value) {
        this.mTextPenaltyLevel = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DeliveryInfo copyFrom(DeliveryInfo instance) {
        this.mActiveAcceleratedCampaignCount = instance.mActiveAcceleratedCampaignCount;
        this.mActiveDayPartedCampaignCount = instance.mActiveDayPartedCampaignCount;
        this.mAdPenaltyMap = instance.mAdPenaltyMap;
        this.mAreAllDailyBudgetsSpent = instance.mAreAllDailyBudgetsSpent;
        this.mCreditNeededAdsCount = instance.mCreditNeededAdsCount;
        this.mEligibleForDeliveryInsights = instance.mEligibleForDeliveryInsights;
        this.mEndTime = instance.mEndTime;
        this.mHasAccountHitSpendLimit = instance.mHasAccountHitSpendLimit;
        this.mHasCampaignGroupHitSpendLimit = instance.mHasCampaignGroupHitSpendLimit;
        this.mHasNoActiveAds = instance.mHasNoActiveAds;
        this.mHasNoAds = instance.mHasNoAds;
        this.mInactiveAdsCount = instance.mInactiveAdsCount;
        this.mInactiveCampaignCount = instance.mInactiveCampaignCount;
        this.mIsAccountClosed = instance.mIsAccountClosed;
        this.mIsAccountDisabled = instance.mIsAccountDisabled;
        this.mIsAdUneconomical = instance.mIsAdUneconomical;
        this.mIsAdfarmPenalized = instance.mIsAdfarmPenalized;
        this.mIsAdgroupPartiallyRejected = instance.mIsAdgroupPartiallyRejected;
        this.mIsCampaignAccelerated = instance.mIsCampaignAccelerated;
        this.mIsCampaignCompleted = instance.mIsCampaignCompleted;
        this.mIsCampaignDayParted = instance.mIsCampaignDayParted;
        this.mIsCampaignDisabled = instance.mIsCampaignDisabled;
        this.mIsCampaignGroupDisabled = instance.mIsCampaignGroupDisabled;
        this.mIsClickbaitPenalized = instance.mIsClickbaitPenalized;
        this.mIsDailyBudgetSpent = instance.mIsDailyBudgetSpent;
        this.mIsEngagementBaitPenalized = instance.mIsEngagementBaitPenalized;
        this.mIsLqwePenalized = instance.mIsLqwePenalized;
        this.mIsReachAndFrequencyMisconfigured = instance.mIsReachAndFrequencyMisconfigured;
        this.mIsSensationalismPenalized = instance.mIsSensationalismPenalized;
        this.mIsSplitTestActive = instance.mIsSplitTestActive;
        this.mIsSplitTestValid = instance.mIsSplitTestValid;
        this.mLiftStudyTimePeriod = instance.mLiftStudyTimePeriod;
        this.mNeedsCredit = instance.mNeedsCredit;
        this.mNeedsTaxNumber = instance.mNeedsTaxNumber;
        this.mNonDeletedAdsCount = instance.mNonDeletedAdsCount;
        this.mNotDeliveringCampaignCount = instance.mNotDeliveringCampaignCount;
        this.mPendingAdsCount = instance.mPendingAdsCount;
        this.mReachFrequencyCampaignUnderdeliveryReason = instance.mReachFrequencyCampaignUnderdeliveryReason;
        this.mRejectedAdsCount = instance.mRejectedAdsCount;
        this.mStartTime = instance.mStartTime;
        this.mStatus = instance.mStatus;
        this.mTextPenaltyLevel = instance.mTextPenaltyLevel;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DeliveryInfo> getParser() {
        return new APIRequest.ResponseParser<DeliveryInfo>(){

            @Override
            public APINodeList<DeliveryInfo> parseResponse(String response, APIContext context, APIRequest<DeliveryInfo> request, String header) throws APIException.MalformedResponseException {
                return DeliveryInfo.parseResponse(response, context, request, header);
            }
        };
    }
}

