/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdPreview
extends APINode {
    @SerializedName(value="body")
    private String mBody = null;
    @SerializedName(value="transformation_spec")
    private Object mTransformationSpec = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdPreview loadJSON(String json, APIContext context, String header) {
        AdPreview adPreview = (AdPreview)AdPreview.getGson().fromJson(json, AdPreview.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adPreview.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adPreview.context = context;
        adPreview.rawValue = json;
        adPreview.header = header;
        return adPreview;
    }

    public static APINodeList<AdPreview> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdPreview> adPreviews = new APINodeList<AdPreview>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adPreviews.add(AdPreview.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adPreviews;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adPreviews.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adPreviews.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adPreviews.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adPreviews.add(AdPreview.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adPreviews.add(AdPreview.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adPreviews.add(AdPreview.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adPreviews;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adPreviews.add(AdPreview.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adPreviews;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adPreviews.add(AdPreview.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adPreviews;
                }
                adPreviews.clear();
                adPreviews.add(AdPreview.loadJSON(json, context, header));
                return adPreviews;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdPreview.getGson().toJson((Object)this);
    }

    public String getFieldBody() {
        return this.mBody;
    }

    public AdPreview setFieldBody(String value) {
        this.mBody = value;
        return this;
    }

    public Object getFieldTransformationSpec() {
        return this.mTransformationSpec;
    }

    public AdPreview setFieldTransformationSpec(Object value) {
        this.mTransformationSpec = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdPreview copyFrom(AdPreview instance) {
        this.mBody = instance.mBody;
        this.mTransformationSpec = instance.mTransformationSpec;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdPreview> getParser() {
        return new APIRequest.ResponseParser<AdPreview>(){

            @Override
            public APINodeList<AdPreview> parseResponse(String response, APIContext context, APIRequest<AdPreview> request, String header) throws APIException.MalformedResponseException {
                return AdPreview.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumRenderType {
        VALUE_FALLBACK("FALLBACK");

        private String value;

        private EnumRenderType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCreativeFeature {
        VALUE_PRODUCT_METADATA_AUTOMATION("product_metadata_automation"),
        VALUE_PROFILE_CARD("profile_card"),
        VALUE_STANDARD_ENHANCEMENTS_CATALOG("standard_enhancements_catalog");

        private String value;

        private EnumCreativeFeature(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAdFormat {
        VALUE_AUDIENCE_NETWORK_INSTREAM_VIDEO("AUDIENCE_NETWORK_INSTREAM_VIDEO"),
        VALUE_AUDIENCE_NETWORK_INSTREAM_VIDEO_MOBILE("AUDIENCE_NETWORK_INSTREAM_VIDEO_MOBILE"),
        VALUE_AUDIENCE_NETWORK_OUTSTREAM_VIDEO("AUDIENCE_NETWORK_OUTSTREAM_VIDEO"),
        VALUE_AUDIENCE_NETWORK_REWARDED_VIDEO("AUDIENCE_NETWORK_REWARDED_VIDEO"),
        VALUE_BIZ_DISCO_FEED_MOBILE("BIZ_DISCO_FEED_MOBILE"),
        VALUE_DESKTOP_FEED_STANDARD("DESKTOP_FEED_STANDARD"),
        VALUE_FACEBOOK_PROFILE_FEED_DESKTOP("FACEBOOK_PROFILE_FEED_DESKTOP"),
        VALUE_FACEBOOK_PROFILE_FEED_MOBILE("FACEBOOK_PROFILE_FEED_MOBILE"),
        VALUE_FACEBOOK_PROFILE_REELS_MOBILE("FACEBOOK_PROFILE_REELS_MOBILE"),
        VALUE_FACEBOOK_REELS_BANNER("FACEBOOK_REELS_BANNER"),
        VALUE_FACEBOOK_REELS_BANNER_DESKTOP("FACEBOOK_REELS_BANNER_DESKTOP"),
        VALUE_FACEBOOK_REELS_MOBILE("FACEBOOK_REELS_MOBILE"),
        VALUE_FACEBOOK_REELS_POSTLOOP("FACEBOOK_REELS_POSTLOOP"),
        VALUE_FACEBOOK_REELS_STICKER("FACEBOOK_REELS_STICKER"),
        VALUE_FACEBOOK_STORY_MOBILE("FACEBOOK_STORY_MOBILE"),
        VALUE_FACEBOOK_STORY_STICKER_MOBILE("FACEBOOK_STORY_STICKER_MOBILE"),
        VALUE_INSTAGRAM_EXPLORE_CONTEXTUAL("INSTAGRAM_EXPLORE_CONTEXTUAL"),
        VALUE_INSTAGRAM_EXPLORE_GRID_HOME("INSTAGRAM_EXPLORE_GRID_HOME"),
        VALUE_INSTAGRAM_EXPLORE_IMMERSIVE("INSTAGRAM_EXPLORE_IMMERSIVE"),
        VALUE_INSTAGRAM_FEED_WEB("INSTAGRAM_FEED_WEB"),
        VALUE_INSTAGRAM_FEED_WEB_M_SITE("INSTAGRAM_FEED_WEB_M_SITE"),
        VALUE_INSTAGRAM_LEAD_GEN_MULTI_SUBMIT_ADS("INSTAGRAM_LEAD_GEN_MULTI_SUBMIT_ADS"),
        VALUE_INSTAGRAM_PROFILE_FEED("INSTAGRAM_PROFILE_FEED"),
        VALUE_INSTAGRAM_PROFILE_REELS("INSTAGRAM_PROFILE_REELS"),
        VALUE_INSTAGRAM_REELS("INSTAGRAM_REELS"),
        VALUE_INSTAGRAM_REELS_OVERLAY("INSTAGRAM_REELS_OVERLAY"),
        VALUE_INSTAGRAM_SEARCH_CHAIN("INSTAGRAM_SEARCH_CHAIN"),
        VALUE_INSTAGRAM_SEARCH_GRID("INSTAGRAM_SEARCH_GRID"),
        VALUE_INSTAGRAM_STANDARD("INSTAGRAM_STANDARD"),
        VALUE_INSTAGRAM_STORY("INSTAGRAM_STORY"),
        VALUE_INSTAGRAM_STORY_EFFECT_TRAY("INSTAGRAM_STORY_EFFECT_TRAY"),
        VALUE_INSTAGRAM_STORY_WEB("INSTAGRAM_STORY_WEB"),
        VALUE_INSTAGRAM_STORY_WEB_M_SITE("INSTAGRAM_STORY_WEB_M_SITE"),
        VALUE_INSTANT_ARTICLE_RECIRCULATION_AD("INSTANT_ARTICLE_RECIRCULATION_AD"),
        VALUE_INSTANT_ARTICLE_STANDARD("INSTANT_ARTICLE_STANDARD"),
        VALUE_INSTREAM_BANNER_DESKTOP("INSTREAM_BANNER_DESKTOP"),
        VALUE_INSTREAM_BANNER_FULLSCREEN_MOBILE("INSTREAM_BANNER_FULLSCREEN_MOBILE"),
        VALUE_INSTREAM_BANNER_IMMERSIVE_MOBILE("INSTREAM_BANNER_IMMERSIVE_MOBILE"),
        VALUE_INSTREAM_BANNER_MOBILE("INSTREAM_BANNER_MOBILE"),
        VALUE_INSTREAM_VIDEO_DESKTOP("INSTREAM_VIDEO_DESKTOP"),
        VALUE_INSTREAM_VIDEO_FULLSCREEN_MOBILE("INSTREAM_VIDEO_FULLSCREEN_MOBILE"),
        VALUE_INSTREAM_VIDEO_IMAGE("INSTREAM_VIDEO_IMAGE"),
        VALUE_INSTREAM_VIDEO_IMMERSIVE_MOBILE("INSTREAM_VIDEO_IMMERSIVE_MOBILE"),
        VALUE_INSTREAM_VIDEO_MOBILE("INSTREAM_VIDEO_MOBILE"),
        VALUE_JOB_BROWSER_DESKTOP("JOB_BROWSER_DESKTOP"),
        VALUE_JOB_BROWSER_MOBILE("JOB_BROWSER_MOBILE"),
        VALUE_MARKETPLACE_MOBILE("MARKETPLACE_MOBILE"),
        VALUE_MESSENGER_MOBILE_INBOX_MEDIA("MESSENGER_MOBILE_INBOX_MEDIA"),
        VALUE_MESSENGER_MOBILE_STORY_MEDIA("MESSENGER_MOBILE_STORY_MEDIA"),
        VALUE_MOBILE_BANNER("MOBILE_BANNER"),
        VALUE_MOBILE_FEED_BASIC("MOBILE_FEED_BASIC"),
        VALUE_MOBILE_FEED_STANDARD("MOBILE_FEED_STANDARD"),
        VALUE_MOBILE_FULLWIDTH("MOBILE_FULLWIDTH"),
        VALUE_MOBILE_INTERSTITIAL("MOBILE_INTERSTITIAL"),
        VALUE_MOBILE_MEDIUM_RECTANGLE("MOBILE_MEDIUM_RECTANGLE"),
        VALUE_MOBILE_NATIVE("MOBILE_NATIVE"),
        VALUE_RIGHT_COLUMN_STANDARD("RIGHT_COLUMN_STANDARD"),
        VALUE_SUGGESTED_VIDEO_DESKTOP("SUGGESTED_VIDEO_DESKTOP"),
        VALUE_SUGGESTED_VIDEO_FULLSCREEN_MOBILE("SUGGESTED_VIDEO_FULLSCREEN_MOBILE"),
        VALUE_SUGGESTED_VIDEO_IMMERSIVE_MOBILE("SUGGESTED_VIDEO_IMMERSIVE_MOBILE"),
        VALUE_SUGGESTED_VIDEO_MOBILE("SUGGESTED_VIDEO_MOBILE"),
        VALUE_WATCH_FEED_HOME("WATCH_FEED_HOME"),
        VALUE_WATCH_FEED_MOBILE("WATCH_FEED_MOBILE");

        private String value;

        private EnumAdFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

