/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAsyncRequestSet;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdDraft
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="api_version")
    private String mApiVersion = null;
    @SerializedName(value="async_request_set")
    private AdAsyncRequestSet mAsyncRequestSet = null;
    @SerializedName(value="author_id")
    private String mAuthorId = null;
    @SerializedName(value="created_by")
    private String mCreatedBy = null;
    @SerializedName(value="draft_version")
    private String mDraftVersion = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_active")
    private Boolean mIsActive = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="ownership_type")
    private String mOwnershipType = null;
    @SerializedName(value="publish_status")
    private Object mPublishStatus = null;
    @SerializedName(value="state")
    private String mState = null;
    @SerializedName(value="summary")
    private String mSummary = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    protected static Gson gson = null;

    AdDraft() {
    }

    public AdDraft(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdDraft(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdDraft fetch() throws APIException {
        AdDraft newInstance = AdDraft.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdDraft fetchById(Long id, APIContext context) throws APIException {
        return AdDraft.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdDraft> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdDraft.fetchByIdAsync(id.toString(), context);
    }

    public static AdDraft fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdDraft> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdDraft> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdDraft>(context, "", "/", "GET", AdDraft.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdDraft>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdDraft>(context, "", "/", "GET", AdDraft.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdDraft loadJSON(String json, APIContext context, String header) {
        AdDraft adDraft = (AdDraft)AdDraft.getGson().fromJson(json, AdDraft.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adDraft.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adDraft.context = context;
        adDraft.rawValue = json;
        adDraft.header = header;
        return adDraft;
    }

    public static APINodeList<AdDraft> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdDraft> adDrafts = new APINodeList<AdDraft>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adDrafts.add(AdDraft.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adDrafts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adDrafts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adDrafts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adDrafts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adDrafts.add(AdDraft.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adDrafts.add(AdDraft.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adDrafts.add(AdDraft.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adDrafts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adDrafts.add(AdDraft.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adDrafts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adDrafts.add(AdDraft.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adDrafts;
                }
                adDrafts.clear();
                adDrafts.add(AdDraft.loadJSON(json, context, header));
                return adDrafts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdDraft.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public String getFieldApiVersion() {
        return this.mApiVersion;
    }

    public AdAsyncRequestSet getFieldAsyncRequestSet() {
        if (this.mAsyncRequestSet != null) {
            this.mAsyncRequestSet.context = this.getContext();
        }
        return this.mAsyncRequestSet;
    }

    public String getFieldAuthorId() {
        return this.mAuthorId;
    }

    public String getFieldCreatedBy() {
        return this.mCreatedBy;
    }

    public String getFieldDraftVersion() {
        return this.mDraftVersion;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsActive() {
        return this.mIsActive;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldOwnershipType() {
        return this.mOwnershipType;
    }

    public Object getFieldPublishStatus() {
        return this.mPublishStatus;
    }

    public String getFieldState() {
        return this.mState;
    }

    public String getFieldSummary() {
        return this.mSummary;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdDraft copyFrom(AdDraft instance) {
        this.mAccountId = instance.mAccountId;
        this.mApiVersion = instance.mApiVersion;
        this.mAsyncRequestSet = instance.mAsyncRequestSet;
        this.mAuthorId = instance.mAuthorId;
        this.mCreatedBy = instance.mCreatedBy;
        this.mDraftVersion = instance.mDraftVersion;
        this.mId = instance.mId;
        this.mIsActive = instance.mIsActive;
        this.mName = instance.mName;
        this.mOwnershipType = instance.mOwnershipType;
        this.mPublishStatus = instance.mPublishStatus;
        this.mState = instance.mState;
        this.mSummary = instance.mSummary;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdDraft> getParser() {
        return new APIRequest.ResponseParser<AdDraft>(){

            @Override
            public APINodeList<AdDraft> parseResponse(String response, APIContext context, APIRequest<AdDraft> request, String header) throws APIException.MalformedResponseException {
                return AdDraft.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdDraft> {
        AdDraft lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "api_version", "async_request_set", "author_id", "created_by", "draft_version", "id", "is_active", "name", "ownership_type", "publish_status", "state", "summary", "time_created", "time_updated"};

        @Override
        public AdDraft getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdDraft parseResponse(String response, String header) throws APIException {
            return AdDraft.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdDraft execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdDraft execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdDraft> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdDraft> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdDraft>(){

                public AdDraft apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestApiVersionField() {
            return this.requestApiVersionField(true);
        }

        public APIRequestGet requestApiVersionField(boolean value) {
            this.requestField("api_version", value);
            return this;
        }

        public APIRequestGet requestAsyncRequestSetField() {
            return this.requestAsyncRequestSetField(true);
        }

        public APIRequestGet requestAsyncRequestSetField(boolean value) {
            this.requestField("async_request_set", value);
            return this;
        }

        public APIRequestGet requestAuthorIdField() {
            return this.requestAuthorIdField(true);
        }

        public APIRequestGet requestAuthorIdField(boolean value) {
            this.requestField("author_id", value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestDraftVersionField() {
            return this.requestDraftVersionField(true);
        }

        public APIRequestGet requestDraftVersionField(boolean value) {
            this.requestField("draft_version", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsActiveField() {
            return this.requestIsActiveField(true);
        }

        public APIRequestGet requestIsActiveField(boolean value) {
            this.requestField("is_active", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOwnershipTypeField() {
            return this.requestOwnershipTypeField(true);
        }

        public APIRequestGet requestOwnershipTypeField(boolean value) {
            this.requestField("ownership_type", value);
            return this;
        }

        public APIRequestGet requestPublishStatusField() {
            return this.requestPublishStatusField(true);
        }

        public APIRequestGet requestPublishStatusField(boolean value) {
            this.requestField("publish_status", value);
            return this;
        }

        public APIRequestGet requestStateField() {
            return this.requestStateField(true);
        }

        public APIRequestGet requestStateField(boolean value) {
            this.requestField("state", value);
            return this;
        }

        public APIRequestGet requestSummaryField() {
            return this.requestSummaryField(true);
        }

        public APIRequestGet requestSummaryField(boolean value) {
            this.requestField("summary", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }
}

