/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateCard
extends APINode {
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="rate")
    private Double mRate = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static RateCard loadJSON(String json, APIContext context) {
        RateCard rateCard = (RateCard)RateCard.getGson().fromJson(json, RateCard.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(rateCard.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        rateCard.context = context;
        rateCard.rawValue = json;
        return rateCard;
    }

    public static APINodeList<RateCard> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<RateCard> rateCards = new APINodeList<RateCard>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        rateCards.add(RateCard.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return rateCards;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        rateCards.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            rateCards.add(RateCard.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                rateCards.add(RateCard.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            rateCards.add(RateCard.loadJSON(obj.toString(), context));
                        }
                    }
                    return rateCards;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        rateCards.add(RateCard.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return rateCards;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        rateCards.add(RateCard.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return rateCards;
                }
                rateCards.clear();
                rateCards.add(RateCard.loadJSON(json, context));
                return rateCards;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return RateCard.getGson().toJson((Object)this);
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public RateCard setFieldCountry(String value) {
        this.mCountry = value;
        return this;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public RateCard setFieldCurrency(String value) {
        this.mCurrency = value;
        return this;
    }

    public Double getFieldRate() {
        return this.mRate;
    }

    public RateCard setFieldRate(Double value) {
        this.mRate = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public RateCard copyFrom(RateCard instance) {
        this.mCountry = instance.mCountry;
        this.mCurrency = instance.mCurrency;
        this.mRate = instance.mRate;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<RateCard> getParser() {
        return new APIRequest.ResponseParser<RateCard>(){

            @Override
            public APINodeList<RateCard> parseResponse(String response, APIContext context, APIRequest<RateCard> request) throws APIException.MalformedResponseException {
                return RateCard.parseResponse(response, context, request);
            }
        };
    }
}

