/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProductFeedUploadErrorSample;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductFeedUploadError
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="error_type")
    private String mErrorType = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="severity")
    private EnumSeverity mSeverity = null;
    @SerializedName(value="summary")
    private String mSummary = null;
    @SerializedName(value="total_count")
    private Long mTotalCount = null;
    protected static Gson gson = null;

    ProductFeedUploadError() {
    }

    public ProductFeedUploadError(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductFeedUploadError(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductFeedUploadError fetch() throws APIException {
        ProductFeedUploadError newInstance = ProductFeedUploadError.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductFeedUploadError fetchById(Long id, APIContext context) throws APIException {
        return ProductFeedUploadError.fetchById(id.toString(), context);
    }

    public static ProductFeedUploadError fetchById(String id, APIContext context) throws APIException {
        ProductFeedUploadError productFeedUploadError = new APIRequestGet(id, context).requestAllFields().execute();
        return productFeedUploadError;
    }

    public static APINodeList<ProductFeedUploadError> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductFeedUploadError>(context, "", "/", "GET", ProductFeedUploadError.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductFeedUploadError loadJSON(String json, APIContext context) {
        ProductFeedUploadError productFeedUploadError = (ProductFeedUploadError)ProductFeedUploadError.getGson().fromJson(json, ProductFeedUploadError.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productFeedUploadError.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productFeedUploadError.context = context;
        productFeedUploadError.rawValue = json;
        return productFeedUploadError;
    }

    public static APINodeList<ProductFeedUploadError> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<ProductFeedUploadError> productFeedUploadErrors = new APINodeList<ProductFeedUploadError>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productFeedUploadErrors.add(ProductFeedUploadError.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productFeedUploadErrors;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        productFeedUploadErrors.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productFeedUploadErrors.add(ProductFeedUploadError.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productFeedUploadErrors.add(ProductFeedUploadError.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productFeedUploadErrors.add(ProductFeedUploadError.loadJSON(obj.toString(), context));
                        }
                    }
                    return productFeedUploadErrors;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productFeedUploadErrors.add(ProductFeedUploadError.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productFeedUploadErrors;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productFeedUploadErrors.add(ProductFeedUploadError.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productFeedUploadErrors;
                }
                productFeedUploadErrors.clear();
                productFeedUploadErrors.add(ProductFeedUploadError.loadJSON(json, context));
                return productFeedUploadErrors;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductFeedUploadError.getGson().toJson((Object)this);
    }

    public APIRequestGetSamples getSamples() {
        return new APIRequestGetSamples(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldErrorType() {
        return this.mErrorType;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumSeverity getFieldSeverity() {
        return this.mSeverity;
    }

    public String getFieldSummary() {
        return this.mSummary;
    }

    public Long getFieldTotalCount() {
        return this.mTotalCount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductFeedUploadError copyFrom(ProductFeedUploadError instance) {
        this.mDescription = instance.mDescription;
        this.mErrorType = instance.mErrorType;
        this.mId = instance.mId;
        this.mSeverity = instance.mSeverity;
        this.mSummary = instance.mSummary;
        this.mTotalCount = instance.mTotalCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductFeedUploadError> getParser() {
        return new APIRequest.ResponseParser<ProductFeedUploadError>(){

            @Override
            public APINodeList<ProductFeedUploadError> parseResponse(String response, APIContext context, APIRequest<ProductFeedUploadError> request) throws APIException.MalformedResponseException {
                return ProductFeedUploadError.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSeverity {
        VALUE_FATAL("fatal"),
        VALUE_WARNING("warning"),
        NULL(null);

        private String value;

        private EnumSeverity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProductFeedUploadError> {
        ProductFeedUploadError lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "error_type", "id", "severity", "summary", "total_count"};

        @Override
        public ProductFeedUploadError getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductFeedUploadError parseResponse(String response) throws APIException {
            return ProductFeedUploadError.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductFeedUploadError execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductFeedUploadError execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestErrorTypeField() {
            return this.requestErrorTypeField(true);
        }

        public APIRequestGet requestErrorTypeField(boolean value) {
            this.requestField("error_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestSeverityField() {
            return this.requestSeverityField(true);
        }

        public APIRequestGet requestSeverityField(boolean value) {
            this.requestField("severity", value);
            return this;
        }

        public APIRequestGet requestSummaryField() {
            return this.requestSummaryField(true);
        }

        public APIRequestGet requestSummaryField(boolean value) {
            this.requestField("summary", value);
            return this;
        }

        public APIRequestGet requestTotalCountField() {
            return this.requestTotalCountField(true);
        }

        public APIRequestGet requestTotalCountField(boolean value) {
            this.requestField("total_count", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSamples
    extends APIRequest<ProductFeedUploadErrorSample> {
        APINodeList<ProductFeedUploadErrorSample> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "retailer_id", "row_number"};

        @Override
        public APINodeList<ProductFeedUploadErrorSample> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProductFeedUploadErrorSample> parseResponse(String response) throws APIException {
            return ProductFeedUploadErrorSample.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ProductFeedUploadErrorSample> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProductFeedUploadErrorSample> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetSamples(String nodeId, APIContext context) {
            super(context, nodeId, "/samples", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSamples setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSamples setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSamples requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSamples requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSamples requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSamples requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSamples requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSamples requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSamples requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSamples requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSamples requestRetailerIdField() {
            return this.requestRetailerIdField(true);
        }

        public APIRequestGetSamples requestRetailerIdField(boolean value) {
            this.requestField("retailer_id", value);
            return this;
        }

        public APIRequestGetSamples requestRowNumberField() {
            return this.requestRowNumberField(true);
        }

        public APIRequestGetSamples requestRowNumberField(boolean value) {
            this.requestField("row_number", value);
            return this;
        }
    }
}

