/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimumBudget
extends APINode {
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="min_daily_budget_high_freq")
    private Long mMinDailyBudgetHighFreq = null;
    @SerializedName(value="min_daily_budget_imp")
    private Long mMinDailyBudgetImp = null;
    @SerializedName(value="min_daily_budget_low_freq")
    private Long mMinDailyBudgetLowFreq = null;
    @SerializedName(value="min_daily_budget_video_views")
    private Long mMinDailyBudgetVideoViews = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static MinimumBudget loadJSON(String json, APIContext context) {
        MinimumBudget minimumBudget = (MinimumBudget)MinimumBudget.getGson().fromJson(json, MinimumBudget.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(minimumBudget.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        minimumBudget.context = context;
        minimumBudget.rawValue = json;
        return minimumBudget;
    }

    public static APINodeList<MinimumBudget> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<MinimumBudget> minimumBudgets = new APINodeList<MinimumBudget>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        minimumBudgets.add(MinimumBudget.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return minimumBudgets;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        minimumBudgets.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            minimumBudgets.add(MinimumBudget.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                minimumBudgets.add(MinimumBudget.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            minimumBudgets.add(MinimumBudget.loadJSON(obj.toString(), context));
                        }
                    }
                    return minimumBudgets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        minimumBudgets.add(MinimumBudget.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return minimumBudgets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        minimumBudgets.add(MinimumBudget.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return minimumBudgets;
                }
                minimumBudgets.clear();
                minimumBudgets.add(MinimumBudget.loadJSON(json, context));
                return minimumBudgets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MinimumBudget.getGson().toJson((Object)this);
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public MinimumBudget setFieldCurrency(String value) {
        this.mCurrency = value;
        return this;
    }

    public Long getFieldMinDailyBudgetHighFreq() {
        return this.mMinDailyBudgetHighFreq;
    }

    public MinimumBudget setFieldMinDailyBudgetHighFreq(Long value) {
        this.mMinDailyBudgetHighFreq = value;
        return this;
    }

    public Long getFieldMinDailyBudgetImp() {
        return this.mMinDailyBudgetImp;
    }

    public MinimumBudget setFieldMinDailyBudgetImp(Long value) {
        this.mMinDailyBudgetImp = value;
        return this;
    }

    public Long getFieldMinDailyBudgetLowFreq() {
        return this.mMinDailyBudgetLowFreq;
    }

    public MinimumBudget setFieldMinDailyBudgetLowFreq(Long value) {
        this.mMinDailyBudgetLowFreq = value;
        return this;
    }

    public Long getFieldMinDailyBudgetVideoViews() {
        return this.mMinDailyBudgetVideoViews;
    }

    public MinimumBudget setFieldMinDailyBudgetVideoViews(Long value) {
        this.mMinDailyBudgetVideoViews = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MinimumBudget copyFrom(MinimumBudget instance) {
        this.mCurrency = instance.mCurrency;
        this.mMinDailyBudgetHighFreq = instance.mMinDailyBudgetHighFreq;
        this.mMinDailyBudgetImp = instance.mMinDailyBudgetImp;
        this.mMinDailyBudgetLowFreq = instance.mMinDailyBudgetLowFreq;
        this.mMinDailyBudgetVideoViews = instance.mMinDailyBudgetVideoViews;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MinimumBudget> getParser() {
        return new APIRequest.ResponseParser<MinimumBudget>(){

            @Override
            public APINodeList<MinimumBudget> parseResponse(String response, APIContext context, APIRequest<MinimumBudget> request) throws APIException.MalformedResponseException {
                return MinimumBudget.parseResponse(response, context, request);
            }
        };
    }
}

