/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DayPart
extends APINode {
    @SerializedName(value="days")
    private List<Long> mDays = null;
    @SerializedName(value="end_minute")
    private Long mEndMinute = null;
    @SerializedName(value="start_minute")
    private Long mStartMinute = null;
    @SerializedName(value="timezone_type")
    private String mTimezoneType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static DayPart loadJSON(String json, APIContext context) {
        DayPart dayPart = (DayPart)DayPart.getGson().fromJson(json, DayPart.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(dayPart.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        dayPart.context = context;
        dayPart.rawValue = json;
        return dayPart;
    }

    public static APINodeList<DayPart> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<DayPart> dayParts = new APINodeList<DayPart>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        dayParts.add(DayPart.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return dayParts;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        dayParts.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            dayParts.add(DayPart.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                dayParts.add(DayPart.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            dayParts.add(DayPart.loadJSON(obj.toString(), context));
                        }
                    }
                    return dayParts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        dayParts.add(DayPart.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return dayParts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        dayParts.add(DayPart.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return dayParts;
                }
                dayParts.clear();
                dayParts.add(DayPart.loadJSON(json, context));
                return dayParts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DayPart.getGson().toJson((Object)this);
    }

    public List<Long> getFieldDays() {
        return this.mDays;
    }

    public DayPart setFieldDays(List<Long> value) {
        this.mDays = value;
        return this;
    }

    public Long getFieldEndMinute() {
        return this.mEndMinute;
    }

    public DayPart setFieldEndMinute(Long value) {
        this.mEndMinute = value;
        return this;
    }

    public Long getFieldStartMinute() {
        return this.mStartMinute;
    }

    public DayPart setFieldStartMinute(Long value) {
        this.mStartMinute = value;
        return this;
    }

    public String getFieldTimezoneType() {
        return this.mTimezoneType;
    }

    public DayPart setFieldTimezoneType(String value) {
        this.mTimezoneType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DayPart copyFrom(DayPart instance) {
        this.mDays = instance.mDays;
        this.mEndMinute = instance.mEndMinute;
        this.mStartMinute = instance.mStartMinute;
        this.mTimezoneType = instance.mTimezoneType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DayPart> getParser() {
        return new APIRequest.ResponseParser<DayPart>(){

            @Override
            public APINodeList<DayPart> parseResponse(String response, APIContext context, APIRequest<DayPart> request) throws APIException.MalformedResponseException {
                return DayPart.parseResponse(response, context, request);
            }
        };
    }
}

