/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdStudy;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.BusinessAdAccountRequest;
import com.facebook.ads.sdk.EventSourceGroup;
import com.facebook.ads.sdk.LegacyBusinessAdAccountRequest;
import com.facebook.ads.sdk.OfflineConversionDataSet;
import com.facebook.ads.sdk.ProfilePictureSource;
import com.facebook.ads.sdk.ReachFrequencyPrediction;
import com.facebook.ads.sdk.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Business
extends APINode {
    @SerializedName(value="created_by")
    private User mCreatedBy = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="payment_account_id")
    private String mPaymentAccountId = null;
    @SerializedName(value="primary_page")
    private Object mPrimaryPage = null;
    @SerializedName(value="profile_picture_uri")
    private String mProfilePictureUri = null;
    @SerializedName(value="timezone_id")
    private Long mTimezoneId = null;
    @SerializedName(value="two_factor_type")
    private String mTwoFactorType = null;
    @SerializedName(value="updated_by")
    private User mUpdatedBy = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="vertical")
    private String mVertical = null;
    protected static Gson gson = null;

    Business() {
    }

    public Business(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Business(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Business fetch() throws APIException {
        Business newInstance = Business.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Business fetchById(Long id, APIContext context) throws APIException {
        return Business.fetchById(id.toString(), context);
    }

    public static Business fetchById(String id, APIContext context) throws APIException {
        Business business = new APIRequestGet(id, context).requestAllFields().execute();
        return business;
    }

    public static APINodeList<Business> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Business>(context, "", "/", "GET", Business.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Business loadJSON(String json, APIContext context) {
        Business business = (Business)Business.getGson().fromJson(json, Business.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(business.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        business.context = context;
        business.rawValue = json;
        return business;
    }

    public static APINodeList<Business> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<Business> businesss = new APINodeList<Business>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businesss.add(Business.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return businesss;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        businesss.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businesss.add(Business.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businesss.add(Business.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businesss.add(Business.loadJSON(obj.toString(), context));
                        }
                    }
                    return businesss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businesss.add(Business.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return businesss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businesss.add(Business.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businesss;
                }
                businesss.clear();
                businesss.add(Business.loadJSON(json, context));
                return businesss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Business.getGson().toJson((Object)this);
    }

    public APIRequestCreateAdStudy createAdStudy() {
        return new APIRequestCreateAdStudy(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdAccount createAdAccount() {
        return new APIRequestCreateAdAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdsPixels getAdsPixels() {
        return new APIRequestGetAdsPixels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdsPixel createAdsPixel() {
        return new APIRequestCreateAdsPixel(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteApps deleteApps() {
        return new APIRequestDeleteApps(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetClientAdAccounts getClientAdAccounts() {
        return new APIRequestGetClientAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetClientPages getClientPages() {
        return new APIRequestGetClientPages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetEventSourceGroups getEventSourceGroups() {
        return new APIRequestGetEventSourceGroups(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateEventSourceGroup createEventSourceGroup() {
        return new APIRequestCreateEventSourceGroup(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetGrpPlans getGrpPlans() {
        return new APIRequestGetGrpPlans(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInstagramAccounts getInstagramAccounts() {
        return new APIRequestGetInstagramAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMeasurementReports getMeasurementReports() {
        return new APIRequestGetMeasurementReports(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMeasurementReport createMeasurementReport() {
        return new APIRequestCreateMeasurementReport(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOfflineConversionDataSets getOfflineConversionDataSets() {
        return new APIRequestGetOfflineConversionDataSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateOfflineConversionDataSet createOfflineConversionDataSet() {
        return new APIRequestCreateOfflineConversionDataSet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOwnedAdAccounts getOwnedAdAccounts() {
        return new APIRequestGetOwnedAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOwnedInstagramAccounts getOwnedInstagramAccounts() {
        return new APIRequestGetOwnedInstagramAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOwnedPages getOwnedPages() {
        return new APIRequestGetOwnedPages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOwnedPixels getOwnedPixels() {
        return new APIRequestGetOwnedPixels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPendingClientAdAccounts getPendingClientAdAccounts() {
        return new APIRequestGetPendingClientAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPendingOwnedAdAccounts getPendingOwnedAdAccounts() {
        return new APIRequestGetPendingOwnedAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPicture getPicture() {
        return new APIRequestGetPicture(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetReceivedAudiencePermissions getReceivedAudiencePermissions() {
        return new APIRequestGetReceivedAudiencePermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSharedAudiencePermissions getSharedAudiencePermissions() {
        return new APIRequestGetSharedAudiencePermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateUserPermission createUserPermission() {
        return new APIRequestCreateUserPermission(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public User getFieldCreatedBy() {
        if (this.mCreatedBy != null) {
            this.mCreatedBy.context = this.getContext();
        }
        return this.mCreatedBy;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPaymentAccountId() {
        return this.mPaymentAccountId;
    }

    public Object getFieldPrimaryPage() {
        return this.mPrimaryPage;
    }

    public String getFieldProfilePictureUri() {
        return this.mProfilePictureUri;
    }

    public Long getFieldTimezoneId() {
        return this.mTimezoneId;
    }

    public String getFieldTwoFactorType() {
        return this.mTwoFactorType;
    }

    public User getFieldUpdatedBy() {
        if (this.mUpdatedBy != null) {
            this.mUpdatedBy.context = this.getContext();
        }
        return this.mUpdatedBy;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public String getFieldVertical() {
        return this.mVertical;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Business copyFrom(Business instance) {
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedTime = instance.mCreatedTime;
        this.mId = instance.mId;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mPaymentAccountId = instance.mPaymentAccountId;
        this.mPrimaryPage = instance.mPrimaryPage;
        this.mProfilePictureUri = instance.mProfilePictureUri;
        this.mTimezoneId = instance.mTimezoneId;
        this.mTwoFactorType = instance.mTwoFactorType;
        this.mUpdatedBy = instance.mUpdatedBy;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mVertical = instance.mVertical;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Business> getParser() {
        return new APIRequest.ResponseParser<Business>(){

            @Override
            public APINodeList<Business> parseResponse(String response, APIContext context, APIRequest<Business> request) throws APIException.MalformedResponseException {
                return Business.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumRole {
        VALUE_FINANCE_EDITOR("FINANCE_EDITOR"),
        VALUE_FINANCE_ANALYST("FINANCE_ANALYST"),
        VALUE_ADS_RIGHTS_REVIEWER("ADS_RIGHTS_REVIEWER"),
        VALUE_ADMIN("ADMIN"),
        VALUE_EMPLOYEE("EMPLOYEE"),
        VALUE_FB_EMPLOYEE_SALES_REP("FB_EMPLOYEE_SALES_REP"),
        NULL(null);

        private String value;

        private EnumRole(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumReportType {
        VALUE_MULTI_CHANNEL_REPORT("multi_channel_report"),
        VALUE_VIDEO_METRICS_REPORT("video_metrics_report"),
        VALUE_FRUIT_ROLLUP_REPORT("fruit_rollup_report"),
        VALUE_THIRD_PARTY_MTA_REPORT("third_party_mta_report"),
        VALUE_PARTNER_LIFT_STUDY_REPORT("partner_lift_study_report"),
        NULL(null);

        private String value;

        private EnumReportType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Business> {
        Business lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"created_by", "created_time", "id", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "vertical"};

        @Override
        public Business getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Business parseResponse(String response) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Business execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Business execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGet requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGet requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGet requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGet requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGet requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGet requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGet requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGet requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGet requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGet requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateUserPermission
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"email", "role", "user"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateUserPermission(String nodeId, APIContext context) {
            super(context, nodeId, "/userpermissions", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateUserPermission setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateUserPermission setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateUserPermission setEmail(String email) {
            this.setParam("email", email);
            return this;
        }

        public APIRequestCreateUserPermission setRole(EnumRole role) {
            this.setParam("role", (Object)role);
            return this;
        }

        public APIRequestCreateUserPermission setRole(String role) {
            this.setParam("role", role);
            return this;
        }

        public APIRequestCreateUserPermission setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateUserPermission setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateUserPermission requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateUserPermission requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateUserPermission requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSharedAudiencePermissions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"partner_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetSharedAudiencePermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_audience_permissions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSharedAudiencePermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSharedAudiencePermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSharedAudiencePermissions setPartnerId(String partnerId) {
            this.setParam("partner_id", partnerId);
            return this;
        }

        public APIRequestGetSharedAudiencePermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSharedAudiencePermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAudiencePermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSharedAudiencePermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAudiencePermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSharedAudiencePermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetReceivedAudiencePermissions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"partner_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetReceivedAudiencePermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/received_audience_permissions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetReceivedAudiencePermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetReceivedAudiencePermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetReceivedAudiencePermissions setPartnerId(String partnerId) {
            this.setParam("partner_id", partnerId);
            return this;
        }

        public APIRequestGetReceivedAudiencePermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetReceivedAudiencePermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReceivedAudiencePermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetReceivedAudiencePermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReceivedAudiencePermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetReceivedAudiencePermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPicture
    extends APIRequest<ProfilePictureSource> {
        APINodeList<ProfilePictureSource> lastResponse = null;
        public static final String[] PARAMS = new String[]{"height", "redirect", "type", "width"};
        public static final String[] FIELDS = new String[]{"bottom", "height", "is_silhouette", "left", "right", "top", "url", "width"};

        @Override
        public APINodeList<ProfilePictureSource> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProfilePictureSource> parseResponse(String response) throws APIException {
            return ProfilePictureSource.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ProfilePictureSource> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetPicture(String nodeId, APIContext context) {
            super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPicture setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPicture setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPicture setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setRedirect(Boolean redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setRedirect(String redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setType(ProfilePictureSource.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPicture setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPicture setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPicture requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPicture requestBottomField() {
            return this.requestBottomField(true);
        }

        public APIRequestGetPicture requestBottomField(boolean value) {
            this.requestField("bottom", value);
            return this;
        }

        public APIRequestGetPicture requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPicture requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPicture requestIsSilhouetteField() {
            return this.requestIsSilhouetteField(true);
        }

        public APIRequestGetPicture requestIsSilhouetteField(boolean value) {
            this.requestField("is_silhouette", value);
            return this;
        }

        public APIRequestGetPicture requestLeftField() {
            return this.requestLeftField(true);
        }

        public APIRequestGetPicture requestLeftField(boolean value) {
            this.requestField("left", value);
            return this;
        }

        public APIRequestGetPicture requestRightField() {
            return this.requestRightField(true);
        }

        public APIRequestGetPicture requestRightField(boolean value) {
            this.requestField("right", value);
            return this;
        }

        public APIRequestGetPicture requestTopField() {
            return this.requestTopField(true);
        }

        public APIRequestGetPicture requestTopField(boolean value) {
            this.requestField("top", value);
            return this;
        }

        public APIRequestGetPicture requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetPicture requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetPicture requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPicture requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPendingOwnedAdAccounts
    extends APIRequest<LegacyBusinessAdAccountRequest> {
        APINodeList<LegacyBusinessAdAccountRequest> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account", "id", "permitted_roles"};

        @Override
        public APINodeList<LegacyBusinessAdAccountRequest> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<LegacyBusinessAdAccountRequest> parseResponse(String response) throws APIException {
            return LegacyBusinessAdAccountRequest.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<LegacyBusinessAdAccountRequest> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<LegacyBusinessAdAccountRequest> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetPendingOwnedAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/pending_owned_ad_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPendingOwnedAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPendingOwnedAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPendingOwnedAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPendingOwnedAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPendingOwnedAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPendingOwnedAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPendingOwnedAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPendingOwnedAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPendingOwnedAdAccounts requestAdAccountField() {
            return this.requestAdAccountField(true);
        }

        public APIRequestGetPendingOwnedAdAccounts requestAdAccountField(boolean value) {
            this.requestField("ad_account", value);
            return this;
        }

        public APIRequestGetPendingOwnedAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPendingOwnedAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPendingOwnedAdAccounts requestPermittedRolesField() {
            return this.requestPermittedRolesField(true);
        }

        public APIRequestGetPendingOwnedAdAccounts requestPermittedRolesField(boolean value) {
            this.requestField("permitted_roles", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPendingClientAdAccounts
    extends APIRequest<BusinessAdAccountRequest> {
        APINodeList<BusinessAdAccountRequest> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account", "id"};

        @Override
        public APINodeList<BusinessAdAccountRequest> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BusinessAdAccountRequest> parseResponse(String response) throws APIException {
            return BusinessAdAccountRequest.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<BusinessAdAccountRequest> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BusinessAdAccountRequest> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetPendingClientAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/pending_client_ad_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPendingClientAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPendingClientAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPendingClientAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPendingClientAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPendingClientAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPendingClientAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPendingClientAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPendingClientAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPendingClientAdAccounts requestAdAccountField() {
            return this.requestAdAccountField(true);
        }

        public APIRequestGetPendingClientAdAccounts requestAdAccountField(boolean value) {
            this.requestField("ad_account", value);
            return this;
        }

        public APIRequestGetPendingClientAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPendingClientAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOwnedPixels
    extends APIRequest<AdsPixel> {
        APINodeList<AdsPixel> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"code", "creation_time", "creator", "id", "is_created_by_business", "last_fired_time", "name", "owner_ad_account", "owner_business"};

        @Override
        public APINodeList<AdsPixel> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsPixel> parseResponse(String response) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdsPixel> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsPixel> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetOwnedPixels(String nodeId, APIContext context) {
            super(context, nodeId, "/owned_pixels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOwnedPixels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOwnedPixels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOwnedPixels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOwnedPixels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwnedPixels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOwnedPixels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwnedPixels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOwnedPixels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOwnedPixels requestCodeField() {
            return this.requestCodeField(true);
        }

        public APIRequestGetOwnedPixels requestCodeField(boolean value) {
            this.requestField("code", value);
            return this;
        }

        public APIRequestGetOwnedPixels requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetOwnedPixels requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetOwnedPixels requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGetOwnedPixels requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGetOwnedPixels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOwnedPixels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOwnedPixels requestIsCreatedByBusinessField() {
            return this.requestIsCreatedByBusinessField(true);
        }

        public APIRequestGetOwnedPixels requestIsCreatedByBusinessField(boolean value) {
            this.requestField("is_created_by_business", value);
            return this;
        }

        public APIRequestGetOwnedPixels requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGetOwnedPixels requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGetOwnedPixels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetOwnedPixels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetOwnedPixels requestOwnerAdAccountField() {
            return this.requestOwnerAdAccountField(true);
        }

        public APIRequestGetOwnedPixels requestOwnerAdAccountField(boolean value) {
            this.requestField("owner_ad_account", value);
            return this;
        }

        public APIRequestGetOwnedPixels requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetOwnedPixels requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOwnedPages
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetOwnedPages(String nodeId, APIContext context) {
            super(context, nodeId, "/owned_pages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOwnedPages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOwnedPages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOwnedPages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOwnedPages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwnedPages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOwnedPages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwnedPages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOwnedPages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOwnedInstagramAccounts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetOwnedInstagramAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/owned_instagram_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOwnedInstagramAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOwnedInstagramAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOwnedInstagramAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOwnedInstagramAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwnedInstagramAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOwnedInstagramAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwnedInstagramAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOwnedInstagramAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOwnedAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "disable_reason", "end_advertiser", "end_advertiser_name", "failed_delivery_checks", "funding_source", "funding_source_details", "has_migrated_permissions", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "next_bill_date", "offsite_pixels_tos_accepted", "owner", "partner", "rf_spec", "salesforce_invoice_group_id", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_role"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetOwnedAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/owned_ad_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOwnedAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOwnedAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOwnedAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwnedAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOwnedAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOwnedAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOwnedAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetOwnedAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetOwnedAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetOwnedAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetOwnedAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetOwnedAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetOwnedAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetOwnedAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetOwnedAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetOwnedAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetOwnedAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetOwnedAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetOwnedAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetOwnedAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetOwnedAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetOwnedAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetOwnedAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetOwnedAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetOwnedAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetOwnedAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetOwnedAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetOwnedAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetOwnedAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetOwnedAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetOwnedAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetOwnedAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOwnedAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetOwnedAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetOwnedAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetOwnedAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetOwnedAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetOwnedAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetOwnedAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetOwnedAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetOwnedAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetOwnedAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetOwnedAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetOwnedAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetOwnedAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestNextBillDateField() {
            return this.requestNextBillDateField(true);
        }

        public APIRequestGetOwnedAdAccounts requestNextBillDateField(boolean value) {
            this.requestField("next_bill_date", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetOwnedAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetOwnedAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetOwnedAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetOwnedAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestSalesforceInvoiceGroupIdField() {
            return this.requestSalesforceInvoiceGroupIdField(true);
        }

        public APIRequestGetOwnedAdAccounts requestSalesforceInvoiceGroupIdField(boolean value) {
            this.requestField("salesforce_invoice_group_id", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetOwnedAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetOwnedAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetOwnedAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetOwnedAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetOwnedAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetOwnedAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetOwnedAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetOwnedAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetOwnedAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetOwnedAdAccounts requestUserRoleField() {
            return this.requestUserRoleField(true);
        }

        public APIRequestGetOwnedAdAccounts requestUserRoleField(boolean value) {
            this.requestField("user_role", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateOfflineConversionDataSet
    extends APIRequest<OfflineConversionDataSet> {
        OfflineConversionDataSet lastResponse = null;
        public static final String[] PARAMS = new String[]{"auto_assign_to_new_accounts_only", "description", "enable_auto_assign_to_accounts", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public OfflineConversionDataSet getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OfflineConversionDataSet parseResponse(String response) throws APIException {
            return OfflineConversionDataSet.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public OfflineConversionDataSet execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OfflineConversionDataSet execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateOfflineConversionDataSet(String nodeId, APIContext context) {
            super(context, nodeId, "/offline_conversion_data_sets", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateOfflineConversionDataSet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateOfflineConversionDataSet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateOfflineConversionDataSet setAutoAssignToNewAccountsOnly(Boolean autoAssignToNewAccountsOnly) {
            this.setParam("auto_assign_to_new_accounts_only", autoAssignToNewAccountsOnly);
            return this;
        }

        public APIRequestCreateOfflineConversionDataSet setAutoAssignToNewAccountsOnly(String autoAssignToNewAccountsOnly) {
            this.setParam("auto_assign_to_new_accounts_only", autoAssignToNewAccountsOnly);
            return this;
        }

        public APIRequestCreateOfflineConversionDataSet setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateOfflineConversionDataSet setEnableAutoAssignToAccounts(Boolean enableAutoAssignToAccounts) {
            this.setParam("enable_auto_assign_to_accounts", enableAutoAssignToAccounts);
            return this;
        }

        public APIRequestCreateOfflineConversionDataSet setEnableAutoAssignToAccounts(String enableAutoAssignToAccounts) {
            this.setParam("enable_auto_assign_to_accounts", enableAutoAssignToAccounts);
            return this;
        }

        public APIRequestCreateOfflineConversionDataSet setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateOfflineConversionDataSet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateOfflineConversionDataSet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateOfflineConversionDataSet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateOfflineConversionDataSet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateOfflineConversionDataSet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateOfflineConversionDataSet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOfflineConversionDataSets
    extends APIRequest<OfflineConversionDataSet> {
        APINodeList<OfflineConversionDataSet> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"attribute_stats", "business", "config", "creation_time", "description", "duplicate_entries", "enable_auto_assign_to_accounts", "event_stats", "event_time_max", "event_time_min", "id", "is_restricted_use", "last_upload_app", "matched_entries", "matched_unique_users", "name", "usage", "valid_entries"};

        @Override
        public APINodeList<OfflineConversionDataSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OfflineConversionDataSet> parseResponse(String response) throws APIException {
            return OfflineConversionDataSet.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<OfflineConversionDataSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OfflineConversionDataSet> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetOfflineConversionDataSets(String nodeId, APIContext context) {
            super(context, nodeId, "/offline_conversion_data_sets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOfflineConversionDataSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOfflineConversionDataSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestAttributeStatsField() {
            return this.requestAttributeStatsField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestAttributeStatsField(boolean value) {
            this.requestField("attribute_stats", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestConfigField() {
            return this.requestConfigField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestConfigField(boolean value) {
            this.requestField("config", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestDuplicateEntriesField() {
            return this.requestDuplicateEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestDuplicateEntriesField(boolean value) {
            this.requestField("duplicate_entries", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEnableAutoAssignToAccountsField() {
            return this.requestEnableAutoAssignToAccountsField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEnableAutoAssignToAccountsField(boolean value) {
            this.requestField("enable_auto_assign_to_accounts", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventStatsField() {
            return this.requestEventStatsField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventStatsField(boolean value) {
            this.requestField("event_stats", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMaxField() {
            return this.requestEventTimeMaxField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMaxField(boolean value) {
            this.requestField("event_time_max", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMinField() {
            return this.requestEventTimeMinField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMinField(boolean value) {
            this.requestField("event_time_min", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestIsRestrictedUseField() {
            return this.requestIsRestrictedUseField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestIsRestrictedUseField(boolean value) {
            this.requestField("is_restricted_use", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppField() {
            return this.requestLastUploadAppField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppField(boolean value) {
            this.requestField("last_upload_app", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedEntriesField() {
            return this.requestMatchedEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedEntriesField(boolean value) {
            this.requestField("matched_entries", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedUniqueUsersField() {
            return this.requestMatchedUniqueUsersField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedUniqueUsersField(boolean value) {
            this.requestField("matched_unique_users", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestUsageField() {
            return this.requestUsageField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestUsageField(boolean value) {
            this.requestField("usage", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestValidEntriesField() {
            return this.requestValidEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestValidEntriesField(boolean value) {
            this.requestField("valid_entries", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateMeasurementReport
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"metadata", "report_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateMeasurementReport(String nodeId, APIContext context) {
            super(context, nodeId, "/measurement_reports", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMeasurementReport setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMeasurementReport setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMeasurementReport setMetadata(String metadata) {
            this.setParam("metadata", metadata);
            return this;
        }

        public APIRequestCreateMeasurementReport setReportType(EnumReportType reportType) {
            this.setParam("report_type", (Object)reportType);
            return this;
        }

        public APIRequestCreateMeasurementReport setReportType(String reportType) {
            this.setParam("report_type", reportType);
            return this;
        }

        public APIRequestCreateMeasurementReport requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMeasurementReport requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMeasurementReport requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMeasurementReport requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMeasurementReport requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMeasurementReport requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetMeasurementReports
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"filters", "report_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetMeasurementReports(String nodeId, APIContext context) {
            super(context, nodeId, "/measurement_reports", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMeasurementReports setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMeasurementReports setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMeasurementReports setFilters(List<Object> filters) {
            this.setParam("filters", filters);
            return this;
        }

        public APIRequestGetMeasurementReports setFilters(String filters) {
            this.setParam("filters", filters);
            return this;
        }

        public APIRequestGetMeasurementReports setReportType(EnumReportType reportType) {
            this.setParam("report_type", (Object)reportType);
            return this;
        }

        public APIRequestGetMeasurementReports setReportType(String reportType) {
            this.setParam("report_type", reportType);
            return this;
        }

        public APIRequestGetMeasurementReports requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMeasurementReports requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMeasurementReports requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMeasurementReports requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMeasurementReports requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMeasurementReports requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInstagramAccounts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetInstagramAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/instagram_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInstagramAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInstagramAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInstagramAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInstagramAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInstagramAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInstagramAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInstagramAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInstagramAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetGrpPlans
    extends APIRequest<ReachFrequencyPrediction> {
        APINodeList<ReachFrequencyPrediction> lastResponse = null;
        public static final String[] PARAMS = new String[]{"status"};
        public static final String[] FIELDS = new String[]{"account_id", "campaign_group_id", "campaign_id", "campaign_time_start", "campaign_time_stop", "curve_budget_reach", "daily_impression_curve", "destination_id", "expiration_time", "external_budget", "external_impression", "external_maximum_budget", "external_maximum_impression", "external_maximum_reach", "external_minimum_budget", "external_minimum_impression", "external_minimum_reach", "external_reach", "frequency_cap", "grp_dmas_audience_size", "holdout_percentage", "id", "instagram_destination_id", "interval_frequency_cap", "interval_frequency_cap_reset_period", "name", "pause_periods", "placement_breakdown", "prediction_mode", "prediction_progress", "reservation_status", "status", "story_event_type", "target_audience_size", "target_spec", "time_created", "time_updated"};

        @Override
        public APINodeList<ReachFrequencyPrediction> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ReachFrequencyPrediction> parseResponse(String response) throws APIException {
            return ReachFrequencyPrediction.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ReachFrequencyPrediction> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ReachFrequencyPrediction> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetGrpPlans(String nodeId, APIContext context) {
            super(context, nodeId, "/grp_plans", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetGrpPlans setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetGrpPlans setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetGrpPlans setStatus(ReachFrequencyPrediction.EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestGetGrpPlans setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetGrpPlans requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetGrpPlans requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGrpPlans requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetGrpPlans requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGrpPlans requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetGrpPlans requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetGrpPlans requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetGrpPlans requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetGrpPlans requestCampaignGroupIdField() {
            return this.requestCampaignGroupIdField(true);
        }

        public APIRequestGetGrpPlans requestCampaignGroupIdField(boolean value) {
            this.requestField("campaign_group_id", value);
            return this;
        }

        public APIRequestGetGrpPlans requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetGrpPlans requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetGrpPlans requestCampaignTimeStartField() {
            return this.requestCampaignTimeStartField(true);
        }

        public APIRequestGetGrpPlans requestCampaignTimeStartField(boolean value) {
            this.requestField("campaign_time_start", value);
            return this;
        }

        public APIRequestGetGrpPlans requestCampaignTimeStopField() {
            return this.requestCampaignTimeStopField(true);
        }

        public APIRequestGetGrpPlans requestCampaignTimeStopField(boolean value) {
            this.requestField("campaign_time_stop", value);
            return this;
        }

        public APIRequestGetGrpPlans requestCurveBudgetReachField() {
            return this.requestCurveBudgetReachField(true);
        }

        public APIRequestGetGrpPlans requestCurveBudgetReachField(boolean value) {
            this.requestField("curve_budget_reach", value);
            return this;
        }

        public APIRequestGetGrpPlans requestDailyImpressionCurveField() {
            return this.requestDailyImpressionCurveField(true);
        }

        public APIRequestGetGrpPlans requestDailyImpressionCurveField(boolean value) {
            this.requestField("daily_impression_curve", value);
            return this;
        }

        public APIRequestGetGrpPlans requestDestinationIdField() {
            return this.requestDestinationIdField(true);
        }

        public APIRequestGetGrpPlans requestDestinationIdField(boolean value) {
            this.requestField("destination_id", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExpirationTimeField() {
            return this.requestExpirationTimeField(true);
        }

        public APIRequestGetGrpPlans requestExpirationTimeField(boolean value) {
            this.requestField("expiration_time", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalBudgetField() {
            return this.requestExternalBudgetField(true);
        }

        public APIRequestGetGrpPlans requestExternalBudgetField(boolean value) {
            this.requestField("external_budget", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalImpressionField() {
            return this.requestExternalImpressionField(true);
        }

        public APIRequestGetGrpPlans requestExternalImpressionField(boolean value) {
            this.requestField("external_impression", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalMaximumBudgetField() {
            return this.requestExternalMaximumBudgetField(true);
        }

        public APIRequestGetGrpPlans requestExternalMaximumBudgetField(boolean value) {
            this.requestField("external_maximum_budget", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalMaximumImpressionField() {
            return this.requestExternalMaximumImpressionField(true);
        }

        public APIRequestGetGrpPlans requestExternalMaximumImpressionField(boolean value) {
            this.requestField("external_maximum_impression", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalMaximumReachField() {
            return this.requestExternalMaximumReachField(true);
        }

        public APIRequestGetGrpPlans requestExternalMaximumReachField(boolean value) {
            this.requestField("external_maximum_reach", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalMinimumBudgetField() {
            return this.requestExternalMinimumBudgetField(true);
        }

        public APIRequestGetGrpPlans requestExternalMinimumBudgetField(boolean value) {
            this.requestField("external_minimum_budget", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalMinimumImpressionField() {
            return this.requestExternalMinimumImpressionField(true);
        }

        public APIRequestGetGrpPlans requestExternalMinimumImpressionField(boolean value) {
            this.requestField("external_minimum_impression", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalMinimumReachField() {
            return this.requestExternalMinimumReachField(true);
        }

        public APIRequestGetGrpPlans requestExternalMinimumReachField(boolean value) {
            this.requestField("external_minimum_reach", value);
            return this;
        }

        public APIRequestGetGrpPlans requestExternalReachField() {
            return this.requestExternalReachField(true);
        }

        public APIRequestGetGrpPlans requestExternalReachField(boolean value) {
            this.requestField("external_reach", value);
            return this;
        }

        public APIRequestGetGrpPlans requestFrequencyCapField() {
            return this.requestFrequencyCapField(true);
        }

        public APIRequestGetGrpPlans requestFrequencyCapField(boolean value) {
            this.requestField("frequency_cap", value);
            return this;
        }

        public APIRequestGetGrpPlans requestGrpDmasAudienceSizeField() {
            return this.requestGrpDmasAudienceSizeField(true);
        }

        public APIRequestGetGrpPlans requestGrpDmasAudienceSizeField(boolean value) {
            this.requestField("grp_dmas_audience_size", value);
            return this;
        }

        public APIRequestGetGrpPlans requestHoldoutPercentageField() {
            return this.requestHoldoutPercentageField(true);
        }

        public APIRequestGetGrpPlans requestHoldoutPercentageField(boolean value) {
            this.requestField("holdout_percentage", value);
            return this;
        }

        public APIRequestGetGrpPlans requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetGrpPlans requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetGrpPlans requestInstagramDestinationIdField() {
            return this.requestInstagramDestinationIdField(true);
        }

        public APIRequestGetGrpPlans requestInstagramDestinationIdField(boolean value) {
            this.requestField("instagram_destination_id", value);
            return this;
        }

        public APIRequestGetGrpPlans requestIntervalFrequencyCapField() {
            return this.requestIntervalFrequencyCapField(true);
        }

        public APIRequestGetGrpPlans requestIntervalFrequencyCapField(boolean value) {
            this.requestField("interval_frequency_cap", value);
            return this;
        }

        public APIRequestGetGrpPlans requestIntervalFrequencyCapResetPeriodField() {
            return this.requestIntervalFrequencyCapResetPeriodField(true);
        }

        public APIRequestGetGrpPlans requestIntervalFrequencyCapResetPeriodField(boolean value) {
            this.requestField("interval_frequency_cap_reset_period", value);
            return this;
        }

        public APIRequestGetGrpPlans requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetGrpPlans requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetGrpPlans requestPausePeriodsField() {
            return this.requestPausePeriodsField(true);
        }

        public APIRequestGetGrpPlans requestPausePeriodsField(boolean value) {
            this.requestField("pause_periods", value);
            return this;
        }

        public APIRequestGetGrpPlans requestPlacementBreakdownField() {
            return this.requestPlacementBreakdownField(true);
        }

        public APIRequestGetGrpPlans requestPlacementBreakdownField(boolean value) {
            this.requestField("placement_breakdown", value);
            return this;
        }

        public APIRequestGetGrpPlans requestPredictionModeField() {
            return this.requestPredictionModeField(true);
        }

        public APIRequestGetGrpPlans requestPredictionModeField(boolean value) {
            this.requestField("prediction_mode", value);
            return this;
        }

        public APIRequestGetGrpPlans requestPredictionProgressField() {
            return this.requestPredictionProgressField(true);
        }

        public APIRequestGetGrpPlans requestPredictionProgressField(boolean value) {
            this.requestField("prediction_progress", value);
            return this;
        }

        public APIRequestGetGrpPlans requestReservationStatusField() {
            return this.requestReservationStatusField(true);
        }

        public APIRequestGetGrpPlans requestReservationStatusField(boolean value) {
            this.requestField("reservation_status", value);
            return this;
        }

        public APIRequestGetGrpPlans requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetGrpPlans requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetGrpPlans requestStoryEventTypeField() {
            return this.requestStoryEventTypeField(true);
        }

        public APIRequestGetGrpPlans requestStoryEventTypeField(boolean value) {
            this.requestField("story_event_type", value);
            return this;
        }

        public APIRequestGetGrpPlans requestTargetAudienceSizeField() {
            return this.requestTargetAudienceSizeField(true);
        }

        public APIRequestGetGrpPlans requestTargetAudienceSizeField(boolean value) {
            this.requestField("target_audience_size", value);
            return this;
        }

        public APIRequestGetGrpPlans requestTargetSpecField() {
            return this.requestTargetSpecField(true);
        }

        public APIRequestGetGrpPlans requestTargetSpecField(boolean value) {
            this.requestField("target_spec", value);
            return this;
        }

        public APIRequestGetGrpPlans requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGetGrpPlans requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGetGrpPlans requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGetGrpPlans requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateEventSourceGroup
    extends APIRequest<EventSourceGroup> {
        EventSourceGroup lastResponse = null;
        public static final String[] PARAMS = new String[]{"event_sources", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public EventSourceGroup getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public EventSourceGroup parseResponse(String response) throws APIException {
            return EventSourceGroup.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public EventSourceGroup execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public EventSourceGroup execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateEventSourceGroup(String nodeId, APIContext context) {
            super(context, nodeId, "/event_source_groups", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateEventSourceGroup setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateEventSourceGroup setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateEventSourceGroup setEventSources(List<String> eventSources) {
            this.setParam("event_sources", eventSources);
            return this;
        }

        public APIRequestCreateEventSourceGroup setEventSources(String eventSources) {
            this.setParam("event_sources", eventSources);
            return this;
        }

        public APIRequestCreateEventSourceGroup setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateEventSourceGroup requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateEventSourceGroup requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEventSourceGroup requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateEventSourceGroup requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEventSourceGroup requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateEventSourceGroup requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetEventSourceGroups
    extends APIRequest<EventSourceGroup> {
        APINodeList<EventSourceGroup> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "event_sources", "id", "name"};

        @Override
        public APINodeList<EventSourceGroup> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<EventSourceGroup> parseResponse(String response) throws APIException {
            return EventSourceGroup.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<EventSourceGroup> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<EventSourceGroup> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetEventSourceGroups(String nodeId, APIContext context) {
            super(context, nodeId, "/event_source_groups", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetEventSourceGroups setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetEventSourceGroups setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetEventSourceGroups requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetEventSourceGroups requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetEventSourceGroups requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetEventSourceGroups requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetEventSourceGroups requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetEventSourceGroups requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetEventSourceGroups requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetEventSourceGroups requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetEventSourceGroups requestEventSourcesField() {
            return this.requestEventSourcesField(true);
        }

        public APIRequestGetEventSourceGroups requestEventSourcesField(boolean value) {
            this.requestField("event_sources", value);
            return this;
        }

        public APIRequestGetEventSourceGroups requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetEventSourceGroups requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetEventSourceGroups requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetEventSourceGroups requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetClientPages
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetClientPages(String nodeId, APIContext context) {
            super(context, nodeId, "/client_pages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetClientPages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetClientPages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetClientPages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetClientPages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetClientPages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetClientPages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetClientPages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetClientPages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetClientAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "disable_reason", "end_advertiser", "end_advertiser_name", "failed_delivery_checks", "funding_source", "funding_source_details", "has_migrated_permissions", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "next_bill_date", "offsite_pixels_tos_accepted", "owner", "partner", "rf_spec", "salesforce_invoice_group_id", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_role"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetClientAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/client_ad_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetClientAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetClientAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetClientAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetClientAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetClientAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetClientAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetClientAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetClientAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetClientAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetClientAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetClientAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetClientAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetClientAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetClientAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetClientAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetClientAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetClientAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetClientAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetClientAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetClientAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetClientAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetClientAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetClientAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetClientAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetClientAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetClientAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetClientAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetClientAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetClientAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetClientAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetClientAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetClientAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetClientAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetClientAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetClientAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetClientAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetClientAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetClientAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetClientAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetClientAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetClientAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetClientAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetClientAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetClientAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetClientAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetClientAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestNextBillDateField() {
            return this.requestNextBillDateField(true);
        }

        public APIRequestGetClientAdAccounts requestNextBillDateField(boolean value) {
            this.requestField("next_bill_date", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetClientAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetClientAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetClientAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetClientAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestSalesforceInvoiceGroupIdField() {
            return this.requestSalesforceInvoiceGroupIdField(true);
        }

        public APIRequestGetClientAdAccounts requestSalesforceInvoiceGroupIdField(boolean value) {
            this.requestField("salesforce_invoice_group_id", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetClientAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetClientAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetClientAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetClientAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetClientAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetClientAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetClientAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetClientAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetClientAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetClientAdAccounts requestUserRoleField() {
            return this.requestUserRoleField(true);
        }

        public APIRequestGetClientAdAccounts requestUserRoleField(boolean value) {
            this.requestField("user_role", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteApps
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestDeleteApps(String nodeId, APIContext context) {
            super(context, nodeId, "/apps", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteApps setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteApps setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteApps setAppId(Long appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestDeleteApps setAppId(String appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestDeleteApps requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteApps requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteApps requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteApps requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteApps requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteApps requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdsPixel
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateAdsPixel(String nodeId, APIContext context) {
            super(context, nodeId, "/adspixels", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdsPixel setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdsPixel setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdsPixel setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAdsPixel requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdsPixel requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdsPixel requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdsPixel requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdsPixel requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdsPixel requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdsPixels
    extends APIRequest<AdsPixel> {
        APINodeList<AdsPixel> lastResponse = null;
        public static final String[] PARAMS = new String[]{"id_filter", "name_filter"};
        public static final String[] FIELDS = new String[]{"code", "creation_time", "creator", "id", "is_created_by_business", "last_fired_time", "name", "owner_ad_account", "owner_business"};

        @Override
        public APINodeList<AdsPixel> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsPixel> parseResponse(String response) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdsPixel> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsPixel> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetAdsPixels(String nodeId, APIContext context) {
            super(context, nodeId, "/adspixels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdsPixels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdsPixels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdsPixels setIdFilter(String idFilter) {
            this.setParam("id_filter", idFilter);
            return this;
        }

        public APIRequestGetAdsPixels setNameFilter(String nameFilter) {
            this.setParam("name_filter", nameFilter);
            return this;
        }

        public APIRequestGetAdsPixels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdsPixels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdsPixels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdsPixels requestCodeField() {
            return this.requestCodeField(true);
        }

        public APIRequestGetAdsPixels requestCodeField(boolean value) {
            this.requestField("code", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetAdsPixels requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGetAdsPixels requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGetAdsPixels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdsPixels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdsPixels requestIsCreatedByBusinessField() {
            return this.requestIsCreatedByBusinessField(true);
        }

        public APIRequestGetAdsPixels requestIsCreatedByBusinessField(boolean value) {
            this.requestField("is_created_by_business", value);
            return this;
        }

        public APIRequestGetAdsPixels requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGetAdsPixels requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGetAdsPixels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdsPixels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdsPixels requestOwnerAdAccountField() {
            return this.requestOwnerAdAccountField(true);
        }

        public APIRequestGetAdsPixels requestOwnerAdAccountField(boolean value) {
            this.requestField("owner_ad_account", value);
            return this;
        }

        public APIRequestGetAdsPixels requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAdsPixels requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdAccount
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"billing_address_id", "currency", "end_advertiser", "funding_id", "invoice", "io", "media_agency", "name", "partner", "po_number", "timezone_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateAdAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccount", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdAccount setBillingAddressId(String billingAddressId) {
            this.setParam("billing_address_id", billingAddressId);
            return this;
        }

        public APIRequestCreateAdAccount setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestCreateAdAccount setEndAdvertiser(Object endAdvertiser) {
            this.setParam("end_advertiser", endAdvertiser);
            return this;
        }

        public APIRequestCreateAdAccount setEndAdvertiser(String endAdvertiser) {
            this.setParam("end_advertiser", endAdvertiser);
            return this;
        }

        public APIRequestCreateAdAccount setFundingId(String fundingId) {
            this.setParam("funding_id", fundingId);
            return this;
        }

        public APIRequestCreateAdAccount setInvoice(Boolean invoice) {
            this.setParam("invoice", invoice);
            return this;
        }

        public APIRequestCreateAdAccount setInvoice(String invoice) {
            this.setParam("invoice", invoice);
            return this;
        }

        public APIRequestCreateAdAccount setIo(Boolean io) {
            this.setParam("io", io);
            return this;
        }

        public APIRequestCreateAdAccount setIo(String io) {
            this.setParam("io", io);
            return this;
        }

        public APIRequestCreateAdAccount setMediaAgency(String mediaAgency) {
            this.setParam("media_agency", mediaAgency);
            return this;
        }

        public APIRequestCreateAdAccount setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAdAccount setPartner(String partner) {
            this.setParam("partner", partner);
            return this;
        }

        public APIRequestCreateAdAccount setPoNumber(String poNumber) {
            this.setParam("po_number", poNumber);
            return this;
        }

        public APIRequestCreateAdAccount setTimezoneId(Long timezoneId) {
            this.setParam("timezone_id", timezoneId);
            return this;
        }

        public APIRequestCreateAdAccount setTimezoneId(String timezoneId) {
            this.setParam("timezone_id", timezoneId);
            return this;
        }

        public APIRequestCreateAdAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdStudy
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[]{"cells", "confidence_level", "cooldown_start_time", "description", "end_time", "name", "objectives", "observation_end_time", "start_time", "type", "viewers"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateAdStudy(String nodeId, APIContext context) {
            super(context, nodeId, "/ad_studies", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdStudy setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdStudy setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdStudy setCells(List<Object> cells) {
            this.setParam("cells", cells);
            return this;
        }

        public APIRequestCreateAdStudy setCells(String cells) {
            this.setParam("cells", cells);
            return this;
        }

        public APIRequestCreateAdStudy setConfidenceLevel(Double confidenceLevel) {
            this.setParam("confidence_level", confidenceLevel);
            return this;
        }

        public APIRequestCreateAdStudy setConfidenceLevel(String confidenceLevel) {
            this.setParam("confidence_level", confidenceLevel);
            return this;
        }

        public APIRequestCreateAdStudy setCooldownStartTime(Long cooldownStartTime) {
            this.setParam("cooldown_start_time", cooldownStartTime);
            return this;
        }

        public APIRequestCreateAdStudy setCooldownStartTime(String cooldownStartTime) {
            this.setParam("cooldown_start_time", cooldownStartTime);
            return this;
        }

        public APIRequestCreateAdStudy setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateAdStudy setEndTime(Long endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateAdStudy setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateAdStudy setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAdStudy setObjectives(List<Object> objectives) {
            this.setParam("objectives", objectives);
            return this;
        }

        public APIRequestCreateAdStudy setObjectives(String objectives) {
            this.setParam("objectives", objectives);
            return this;
        }

        public APIRequestCreateAdStudy setObservationEndTime(Long observationEndTime) {
            this.setParam("observation_end_time", observationEndTime);
            return this;
        }

        public APIRequestCreateAdStudy setObservationEndTime(String observationEndTime) {
            this.setParam("observation_end_time", observationEndTime);
            return this;
        }

        public APIRequestCreateAdStudy setStartTime(Long startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateAdStudy setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateAdStudy setType(AdStudy.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreateAdStudy setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateAdStudy setViewers(List<Long> viewers) {
            this.setParam("viewers", viewers);
            return this;
        }

        public APIRequestCreateAdStudy setViewers(String viewers) {
            this.setParam("viewers", viewers);
            return this;
        }

        public APIRequestCreateAdStudy requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdStudy requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdStudy requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdStudy requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdStudy requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdStudy requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

