/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRecommendationData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRecommendation
extends APINode {
    @SerializedName(value="blame_field")
    private String mBlameField = null;
    @SerializedName(value="code")
    private Long mCode = null;
    @SerializedName(value="confidence")
    private EnumConfidence mConfidence = null;
    @SerializedName(value="importance")
    private EnumImportance mImportance = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="recommendation_data")
    private AdRecommendationData mRecommendationData = null;
    @SerializedName(value="title")
    private String mTitle = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdRecommendation loadJSON(String json, APIContext context) {
        AdRecommendation adRecommendation = (AdRecommendation)AdRecommendation.getGson().fromJson(json, AdRecommendation.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRecommendation.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRecommendation.context = context;
        adRecommendation.rawValue = json;
        return adRecommendation;
    }

    public static APINodeList<AdRecommendation> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdRecommendation> adRecommendations = new APINodeList<AdRecommendation>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRecommendations.add(AdRecommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adRecommendations;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adRecommendations.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRecommendations.add(AdRecommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRecommendations.add(AdRecommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRecommendations.add(AdRecommendation.loadJSON(obj.toString(), context));
                        }
                    }
                    return adRecommendations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRecommendations.add(AdRecommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adRecommendations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRecommendations.add(AdRecommendation.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRecommendations;
                }
                adRecommendations.clear();
                adRecommendations.add(AdRecommendation.loadJSON(json, context));
                return adRecommendations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRecommendation.getGson().toJson((Object)this);
    }

    public String getFieldBlameField() {
        return this.mBlameField;
    }

    public AdRecommendation setFieldBlameField(String value) {
        this.mBlameField = value;
        return this;
    }

    public Long getFieldCode() {
        return this.mCode;
    }

    public AdRecommendation setFieldCode(Long value) {
        this.mCode = value;
        return this;
    }

    public EnumConfidence getFieldConfidence() {
        return this.mConfidence;
    }

    public AdRecommendation setFieldConfidence(EnumConfidence value) {
        this.mConfidence = value;
        return this;
    }

    public EnumImportance getFieldImportance() {
        return this.mImportance;
    }

    public AdRecommendation setFieldImportance(EnumImportance value) {
        this.mImportance = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public AdRecommendation setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public AdRecommendationData getFieldRecommendationData() {
        return this.mRecommendationData;
    }

    public AdRecommendation setFieldRecommendationData(AdRecommendationData value) {
        this.mRecommendationData = value;
        return this;
    }

    public AdRecommendation setFieldRecommendationData(String value) {
        Type type = new TypeToken<AdRecommendationData>(){}.getType();
        this.mRecommendationData = (AdRecommendationData)AdRecommendationData.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public AdRecommendation setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRecommendation copyFrom(AdRecommendation instance) {
        this.mBlameField = instance.mBlameField;
        this.mCode = instance.mCode;
        this.mConfidence = instance.mConfidence;
        this.mImportance = instance.mImportance;
        this.mMessage = instance.mMessage;
        this.mRecommendationData = instance.mRecommendationData;
        this.mTitle = instance.mTitle;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRecommendation> getParser() {
        return new APIRequest.ResponseParser<AdRecommendation>(){

            @Override
            public APINodeList<AdRecommendation> parseResponse(String response, APIContext context, APIRequest<AdRecommendation> request) throws APIException.MalformedResponseException {
                return AdRecommendation.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumImportance {
        VALUE_HIGH("HIGH"),
        VALUE_MEDIUM("MEDIUM"),
        VALUE_LOW("LOW"),
        NULL(null);

        private String value;

        private EnumImportance(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumConfidence {
        VALUE_HIGH("HIGH"),
        VALUE_MEDIUM("MEDIUM"),
        VALUE_LOW("LOW"),
        NULL(null);

        private String value;

        private EnumConfidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

