/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.BatchRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIRequest<T extends APINode> {
    public static final String USER_AGENT = "fb-java-ads-api-sdk-v2.11.1";
    private static IRequestExecutor executor = new DefaultRequestExecutor();
    protected APIContext context;
    protected boolean useVideoEndpoint = false;
    protected String nodeId;
    protected String endpoint;
    protected String method;
    protected List<String> paramNames;
    protected ResponseParser<T> parser;
    protected Map<String, Object> params = new HashMap<String, Object>();
    protected List<String> returnFields;
    private APIResponse lastResponse = null;

    public static void changeRequestExecutor(IRequestExecutor newExecutor) {
        executor = newExecutor;
    }

    public static IRequestExecutor getExecutor() {
        return executor;
    }

    public APIRequest(APIContext context, String nodeId, String endpoint, String method) {
        this(context, nodeId, endpoint, method, null, null);
    }

    public APIRequest(APIContext context, String nodeId, String endpoint, String method, ResponseParser<T> parser) {
        this(context, nodeId, endpoint, method, null, parser);
    }

    public APIRequest(APIContext context, String nodeId, String endpoint, String method, List<String> paramNames) {
        this(context, nodeId, endpoint, method, paramNames, null);
    }

    public APIRequest(APIContext context, String nodeId, String endpoint, String method, List<String> paramNames, ResponseParser<T> parser) {
        this.context = context;
        this.nodeId = nodeId;
        this.endpoint = endpoint;
        this.method = method;
        this.paramNames = paramNames;
        this.parser = parser;
    }

    public APIResponse getLastResponse() {
        return this.lastResponse;
    }

    public APIResponse parseResponse(String response) throws APIException {
        if (this.parser != null) {
            return this.parser.parseResponse(response, this.context, this);
        }
        return APINode.parseResponse(response, this.context, new APIRequest<APINode>(this.context, this.nodeId, this.endpoint, this.method, this.paramNames));
    }

    public APIResponse execute() throws APIException {
        return this.execute(new HashMap<String, Object>());
    }

    public APIResponse execute(Map<String, Object> extraParams) throws APIException {
        this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
        return this.lastResponse;
    }

    public APIRequest<T> setParam(String param, Object value) {
        this.setParamInternal(param, value);
        return this;
    }

    public APIRequest setParams(Map<String, Object> params) {
        this.setParamsInternal(params);
        return this;
    }

    public APIRequest requestFields(List<String> fields) {
        return this.requestFields(fields, true);
    }

    public APIRequest requestFields(List<String> fields, boolean value) {
        for (String field : fields) {
            this.requestField(field, value);
        }
        return this;
    }

    public APIRequest requestField(String field) {
        this.requestField(field, true);
        return this;
    }

    public APIRequest requestField(String field, boolean value) {
        this.requestFieldInternal(field, value);
        return this;
    }

    public APIRequest setUseVideoEndpoint(boolean useVideoEndpoint) {
        this.useVideoEndpoint = useVideoEndpoint;
        return this;
    }

    protected String executeInternal() throws APIException {
        return this.executeInternal(null);
    }

    protected String executeInternal(Map<String, Object> extraParams) throws APIException {
        String response = null;
        try {
            this.context.log("========Start of API Call========");
            response = executor.execute(this.method, this.getApiUrl(), this.getAllParams(extraParams), this.context);
            this.context.log("Response:");
            this.context.log(response);
            this.context.log("========End of API Call========");
        }
        catch (IOException e) {
            throw new APIException.FailedRequestException(e);
        }
        return response;
    }

    public APIContext getContext() {
        return this.context;
    }

    public void setContext(APIContext context) {
        this.context = context;
    }

    protected void setParamInternal(String param, Object value) {
        this.params.put(param, value);
    }

    protected void setParamsInternal(Map<String, Object> params) {
        this.params = params;
    }

    protected void requestFieldInternal(String field, boolean value) {
        if (this.returnFields == null) {
            this.returnFields = new ArrayList<String>();
        }
        if (value && !this.returnFields.contains(field)) {
            this.returnFields.add(field);
        } else {
            this.returnFields.remove(field);
        }
    }

    private Map<String, Object> getAllParams(Map<String, Object> extraParams) {
        HashMap<String, Object> allParams = new HashMap<String, Object>(this.params);
        if (extraParams != null) {
            allParams.putAll(extraParams);
        }
        allParams.put("access_token", this.context.getAccessToken());
        if (this.context.hasAppSecret()) {
            allParams.put("appsecret_proof", this.context.getAppSecretProof());
        }
        if (this.returnFields != null) {
            allParams.put("fields", APIRequest.joinStringList(this.returnFields));
        }
        return allParams;
    }

    private static String readResponse(HttpsURLConnection con) throws APIException, IOException {
        try {
            String inputLine;
            int responseCode = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        catch (Exception e) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            throw new APIException.FailedRequestException(response.toString(), e);
        }
    }

    private String getApiUrl() {
        String endpointBas = this.useVideoEndpoint ? this.context.getVideoEndpointBase() : this.context.getEndpointBase();
        return endpointBas + "/" + this.context.getVersion() + "/" + this.nodeId + this.endpoint;
    }

    public static String joinStringList(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        for (String s : list) {
            if (!isFirst) {
                result.append(",");
            }
            result.append(s);
            isFirst = false;
        }
        return result.toString();
    }

    private static String convertToString(Object input) {
        if (input == null) {
            return "null";
        }
        if (input instanceof Map) {
            Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
            return gson.toJson((Object)((Map)input));
        }
        if (input instanceof List) {
            Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
            return gson.toJson((Object)((List)input));
        }
        return input.toString();
    }

    public APIRequest addToBatch(BatchRequest batch) {
        batch.addRequest(this);
        return this;
    }

    public APIRequest addToBatch(BatchRequest batch, String name) {
        batch.addRequest(name, this);
        return this;
    }

    BatchRequest.BatchModeRequestInfo getBatchModeRequestInfo() throws IOException {
        BatchRequest.BatchModeRequestInfo info = new BatchRequest.BatchModeRequestInfo();
        HashMap<String, Object> allParams = new HashMap<String, Object>(this.params);
        if (this.returnFields != null) {
            allParams.put("fields", APIRequest.joinStringList(this.returnFields));
        }
        info.method = this.method;
        StringBuilder relativeUrl = new StringBuilder(this.context.getVersion() + "/" + this.nodeId + this.endpoint);
        if (this.method.equals("POST")) {
            info.files = new HashMap<String, File>();
            info.relativeUrl = relativeUrl.toString();
            StringBuilder body = new StringBuilder();
            boolean firstEntry = true;
            for (Map.Entry entry : allParams.entrySet()) {
                if (entry.getValue() instanceof File) {
                    info.files.put((String)entry.getKey(), (File)entry.getValue());
                    continue;
                }
                body.append((firstEntry ? "" : "&") + URLEncoder.encode(entry.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(APIRequest.convertToString(entry.getValue()), "UTF-8"));
                firstEntry = false;
            }
            info.body = body.toString();
        } else {
            boolean firstEntry = true;
            for (Map.Entry entry : allParams.entrySet()) {
                relativeUrl.append((firstEntry ? "?" : "&") + URLEncoder.encode(entry.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(APIRequest.convertToString(entry.getValue()), "UTF-8"));
                firstEntry = false;
            }
            info.relativeUrl = relativeUrl.toString();
        }
        return info;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultRequestExecutor
    implements IRequestExecutor {
        private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
        public static Map<String, String> fileToContentTypeMap = new HashMap<String, String>();

        @Override
        public String execute(String method, String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            if ("GET".equals(method)) {
                return this.sendGet(apiUrl, allParams, context);
            }
            if ("POST".equals(method)) {
                return this.sendPost(apiUrl, allParams, context);
            }
            if ("DELETE".equals(method)) {
                return this.sendDelete(apiUrl, allParams, context);
            }
            throw new IllegalArgumentException("Unsupported http method. Currently only GET, POST, and DELETE are supported");
        }

        @Override
        public String sendGet(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            StringBuilder urlString = new StringBuilder(apiUrl);
            boolean firstEntry = true;
            for (Map.Entry<String, Object> entry : allParams.entrySet()) {
                urlString.append((firstEntry ? "?" : "&") + URLEncoder.encode(entry.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(APIRequest.convertToString(entry.getValue()), "UTF-8"));
                firstEntry = false;
            }
            URL url = new URL(urlString.toString());
            context.log("Request:");
            context.log("GET: " + url.toString());
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", APIRequest.USER_AGENT);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            return APIRequest.readResponse(con);
        }

        @Override
        public String sendPost(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            String boundary = "--------------------------" + new Random().nextLong();
            URL url = new URL(apiUrl);
            context.log("Post: " + url.toString());
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", APIRequest.USER_AGENT);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setDoOutput(true);
            int contentLength = DefaultRequestExecutor.getContentLength(allParams, boundary, context);
            con.setRequestProperty("Content-Length", "" + contentLength);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            for (Map.Entry<String, Object> entry : allParams.entrySet()) {
                DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "--" + boundary + "\r\n");
                if (entry.getValue() instanceof File) {
                    File file = (File)entry.getValue();
                    String contentType = DefaultRequestExecutor.getContentTypeForFile(file);
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + file.getName() + "\"\r\n");
                    if (contentType != null) {
                        DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "Content-Type: " + contentType + "\r\n");
                    }
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "\r\n");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] buffer = new byte[1024];
                    int count = 0;
                    while ((count = fileInputStream.read(buffer)) >= 0) {
                        wr.write(buffer, 0, count);
                    }
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "\r\n");
                    fileInputStream.close();
                    continue;
                }
                if (entry.getValue() instanceof byte[]) {
                    byte[] bytes = (byte[])entry.getValue();
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + "chunkfile" + "\"\r\n\r\n");
                    wr.write(bytes, 0, bytes.length);
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "\r\n");
                    continue;
                }
                DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
                DefaultRequestExecutor.writeStringInUTF8Bytes(wr, APIRequest.convertToString(entry.getValue()));
                DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "\r\n");
            }
            DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "--" + boundary + "--\r\n");
            wr.flush();
            wr.close();
            return APIRequest.readResponse(con);
        }

        @Override
        public String sendDelete(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            StringBuilder urlString = new StringBuilder(apiUrl);
            boolean firstEntry = true;
            for (Map.Entry<String, Object> entry : allParams.entrySet()) {
                urlString.append((firstEntry ? "?" : "&") + URLEncoder.encode(entry.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(APIRequest.convertToString(entry.getValue()), "UTF-8"));
                firstEntry = false;
            }
            URL url = new URL(urlString.toString());
            context.log("Delete: " + url.toString());
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("DELETE");
            con.setRequestProperty("User-Agent", APIRequest.USER_AGENT);
            return APIRequest.readResponse(con);
        }

        private static String getContentTypeForFile(File file) {
            String contentType = fileToContentTypeMap.get(DefaultRequestExecutor.getFileExtension(file));
            if (contentType != null) {
                return contentType;
            }
            try {
                contentType = Files.probeContentType(file.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return contentType != null ? contentType : DEFAULT_CONTENT_TYPE;
        }

        private static String getFileExtension(File file) {
            String fileName = file.getName();
            int index = fileName.lastIndexOf(46);
            if (index == -1) {
                return "";
            }
            return fileName.substring(index, fileName.length());
        }

        private static int getContentLength(Map<String, Object> allParams, String boundary, APIContext context) throws IOException {
            int contentLength = 0;
            for (Map.Entry<String, Object> entry : allParams.entrySet()) {
                contentLength += ("--" + boundary + "\r\n").length();
                if (entry.getValue() instanceof File) {
                    File file = (File)entry.getValue();
                    String contentType = DefaultRequestExecutor.getContentTypeForFile(file);
                    contentLength += DefaultRequestExecutor.getLengthAndLog(context, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + file.getName() + "\"\r\n");
                    if (contentType != null) {
                        contentLength += DefaultRequestExecutor.getLengthAndLog(context, "Content-Type: " + contentType + "\r\n");
                    }
                    contentLength += DefaultRequestExecutor.getLengthAndLog(context, "\r\n");
                    contentLength = (int)((long)contentLength + file.length());
                    contentLength += DefaultRequestExecutor.getLengthAndLog(context, "\r\n");
                    continue;
                }
                if (entry.getValue() instanceof byte[]) {
                    byte[] bytes = (byte[])entry.getValue();
                    contentLength += DefaultRequestExecutor.getLengthAndLog(context, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + "chunkfile" + "\"\r\n");
                    contentLength += bytes.length;
                    contentLength += DefaultRequestExecutor.getLengthAndLog(context, "\r\n");
                    continue;
                }
                contentLength += DefaultRequestExecutor.getLengthAndLog(context, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
                contentLength += DefaultRequestExecutor.getLengthAndLog(context, APIRequest.convertToString(entry.getValue()));
                contentLength += DefaultRequestExecutor.getLengthAndLog(context, "\r\n");
            }
            return contentLength += DefaultRequestExecutor.getLengthAndLog(context, "--" + boundary + "--\r\n");
        }

        private static int getLengthAndLog(APIContext context, String input) throws IOException {
            context.log(input);
            return input.getBytes("UTF-8").length;
        }

        private static void writeStringInUTF8Bytes(DataOutputStream wr, String input) throws IOException {
            wr.write(input.getBytes("UTF-8"));
        }

        static {
            fileToContentTypeMap.put(".atom", "application/atom+xml");
            fileToContentTypeMap.put(".rss", "application/rss+xml");
            fileToContentTypeMap.put(".xml", "application/xml");
            fileToContentTypeMap.put(".csv", "text/csv");
            fileToContentTypeMap.put(".txt", "text/plain");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRequestExecutor {
        public String execute(String var1, String var2, Map<String, Object> var3, APIContext var4) throws APIException, IOException;

        public String sendGet(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;

        public String sendPost(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;

        public String sendDelete(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResponseParser<T extends APINode> {
        public APINodeList<T> parseResponse(String var1, APIContext var2, APIRequest<T> var3) throws APIException.MalformedResponseException;
    }
}

