/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ReachFrequencyActivity;
import com.facebook.ads.sdk.ReachFrequencyAdFormat;
import com.facebook.ads.sdk.ReachFrequencyDayPart;
import com.facebook.ads.sdk.ReachFrequencyEstimatesCurve;
import com.facebook.ads.sdk.ReachFrequencyEstimatesPlacementBreakdown;
import com.facebook.ads.sdk.Targeting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ReachFrequencyPrediction
extends APINode {
    @SerializedName(value="account_id")
    private Long mAccountId = null;
    @SerializedName(value="activity_status")
    private ReachFrequencyActivity mActivityStatus = null;
    @SerializedName(value="ad_formats")
    private List<ReachFrequencyAdFormat> mAdFormats = null;
    @SerializedName(value="auction_entry_option_index")
    private Long mAuctionEntryOptionIndex = null;
    @SerializedName(value="audience_size_lower_bound")
    private Long mAudienceSizeLowerBound = null;
    @SerializedName(value="audience_size_upper_bound")
    private Long mAudienceSizeUpperBound = null;
    @SerializedName(value="business_id")
    private Long mBusinessId = null;
    @SerializedName(value="buying_type")
    private String mBuyingType = null;
    @SerializedName(value="campaign_group_id")
    private Long mCampaignGroupId = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="campaign_time_start")
    private String mCampaignTimeStart = null;
    @SerializedName(value="campaign_time_stop")
    private String mCampaignTimeStop = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="curve_budget_reach")
    private ReachFrequencyEstimatesCurve mCurveBudgetReach = null;
    @SerializedName(value="curve_reach")
    private List<Long> mCurveReach = null;
    @SerializedName(value="daily_grp_curve")
    private List<Double> mDailyGrpCurve = null;
    @SerializedName(value="daily_impression_curve")
    private List<Double> mDailyImpressionCurve = null;
    @SerializedName(value="daily_impression_curve_map")
    private List<Map<Long, List<Double>>> mDailyImpressionCurveMap = null;
    @SerializedName(value="day_parting_schedule")
    private List<ReachFrequencyDayPart> mDayPartingSchedule = null;
    @SerializedName(value="destination_id")
    private String mDestinationId = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="expiration_time")
    private String mExpirationTime = null;
    @SerializedName(value="external_budget")
    private Long mExternalBudget = null;
    @SerializedName(value="external_impression")
    private Long mExternalImpression = null;
    @SerializedName(value="external_maximum_budget")
    private Long mExternalMaximumBudget = null;
    @SerializedName(value="external_maximum_impression")
    private String mExternalMaximumImpression = null;
    @SerializedName(value="external_maximum_reach")
    private Long mExternalMaximumReach = null;
    @SerializedName(value="external_minimum_budget")
    private Long mExternalMinimumBudget = null;
    @SerializedName(value="external_minimum_impression")
    private Long mExternalMinimumImpression = null;
    @SerializedName(value="external_minimum_reach")
    private Long mExternalMinimumReach = null;
    @SerializedName(value="external_reach")
    private Long mExternalReach = null;
    @SerializedName(value="feed_ratio_0000")
    private Long mFeedRatio0000 = null;
    @SerializedName(value="frequency_cap")
    private Long mFrequencyCap = null;
    @SerializedName(value="frequency_distribution_map")
    private List<Map<Long, List<Double>>> mFrequencyDistributionMap = null;
    @SerializedName(value="frequency_distribution_map_agg")
    private List<Map<Long, List<Long>>> mFrequencyDistributionMapAgg = null;
    @SerializedName(value="grp_audience_size")
    private Double mGrpAudienceSize = null;
    @SerializedName(value="grp_avg_probability_map")
    private String mGrpAvgProbabilityMap = null;
    @SerializedName(value="grp_country_audience_size")
    private Double mGrpCountryAudienceSize = null;
    @SerializedName(value="grp_curve")
    private List<Double> mGrpCurve = null;
    @SerializedName(value="grp_dmas_audience_size")
    private Double mGrpDmasAudienceSize = null;
    @SerializedName(value="grp_filtering_threshold_00")
    private Long mGrpFilteringThreshold00 = null;
    @SerializedName(value="grp_points")
    private Double mGrpPoints = null;
    @SerializedName(value="grp_ratio")
    private Double mGrpRatio = null;
    @SerializedName(value="grp_reach_ratio")
    private Double mGrpReachRatio = null;
    @SerializedName(value="grp_status")
    private String mGrpStatus = null;
    @SerializedName(value="holdout_percentage")
    private Long mHoldoutPercentage = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="impression_curve")
    private List<Long> mImpressionCurve = null;
    @SerializedName(value="instagram_destination_id")
    private String mInstagramDestinationId = null;
    @SerializedName(value="instream_packages")
    private List<String> mInstreamPackages = null;
    @SerializedName(value="interval_frequency_cap")
    private Long mIntervalFrequencyCap = null;
    @SerializedName(value="interval_frequency_cap_reset_period")
    private Long mIntervalFrequencyCapResetPeriod = null;
    @SerializedName(value="is_bonus_media")
    private Long mIsBonusMedia = null;
    @SerializedName(value="is_conversion_goal")
    private Long mIsConversionGoal = null;
    @SerializedName(value="is_higher_average_frequency")
    private Boolean mIsHigherAverageFrequency = null;
    @SerializedName(value="is_io")
    private Boolean mIsIo = null;
    @SerializedName(value="is_reserved_buying")
    private Long mIsReservedBuying = null;
    @SerializedName(value="is_trp")
    private Boolean mIsTrp = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="objective")
    private Long mObjective = null;
    @SerializedName(value="objective_name")
    private String mObjectiveName = null;
    @SerializedName(value="odax_objective")
    private Long mOdaxObjective = null;
    @SerializedName(value="odax_objective_name")
    private String mOdaxObjectiveName = null;
    @SerializedName(value="optimization_goal")
    private Long mOptimizationGoal = null;
    @SerializedName(value="optimization_goal_name")
    private String mOptimizationGoalName = null;
    @SerializedName(value="pause_periods")
    private List<Object> mPausePeriods = null;
    @SerializedName(value="placement_breakdown")
    private ReachFrequencyEstimatesPlacementBreakdown mPlacementBreakdown = null;
    @SerializedName(value="placement_breakdown_map")
    private List<Map<Long, ReachFrequencyEstimatesPlacementBreakdown>> mPlacementBreakdownMap = null;
    @SerializedName(value="plan_name")
    private String mPlanName = null;
    @SerializedName(value="plan_type")
    private String mPlanType = null;
    @SerializedName(value="prediction_mode")
    private Long mPredictionMode = null;
    @SerializedName(value="prediction_progress")
    private Long mPredictionProgress = null;
    @SerializedName(value="reference_id")
    private String mReferenceId = null;
    @SerializedName(value="reservation_status")
    private Long mReservationStatus = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="status")
    private Long mStatus = null;
    @SerializedName(value="story_event_type")
    private Long mStoryEventType = null;
    @SerializedName(value="target_cpm")
    private Long mTargetCpm = null;
    @SerializedName(value="target_spec")
    private Targeting mTargetSpec = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    @SerializedName(value="timezone_id")
    private Long mTimezoneId = null;
    @SerializedName(value="timezone_name")
    private String mTimezoneName = null;
    @SerializedName(value="topline_id")
    private Long mToplineId = null;
    @SerializedName(value="video_view_length_constraint")
    private Long mVideoViewLengthConstraint = null;
    @SerializedName(value="viewtag")
    private String mViewtag = null;
    protected static Gson gson = null;

    ReachFrequencyPrediction() {
    }

    public ReachFrequencyPrediction(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ReachFrequencyPrediction(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ReachFrequencyPrediction fetch() throws APIException {
        ReachFrequencyPrediction newInstance = ReachFrequencyPrediction.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ReachFrequencyPrediction fetchById(Long id, APIContext context) throws APIException {
        return ReachFrequencyPrediction.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ReachFrequencyPrediction> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ReachFrequencyPrediction.fetchByIdAsync(id.toString(), context);
    }

    public static ReachFrequencyPrediction fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ReachFrequencyPrediction> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ReachFrequencyPrediction> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ReachFrequencyPrediction>(context, "", "/", "GET", ReachFrequencyPrediction.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ReachFrequencyPrediction>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ReachFrequencyPrediction>(context, "", "/", "GET", ReachFrequencyPrediction.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ReachFrequencyPrediction loadJSON(String json, APIContext context, String header) {
        ReachFrequencyPrediction reachFrequencyPrediction = (ReachFrequencyPrediction)ReachFrequencyPrediction.getGson().fromJson(json, ReachFrequencyPrediction.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencyPrediction.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencyPrediction.context = context;
        reachFrequencyPrediction.rawValue = json;
        reachFrequencyPrediction.header = header;
        return reachFrequencyPrediction;
    }

    public static APINodeList<ReachFrequencyPrediction> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReachFrequencyPrediction> reachFrequencyPredictions = new APINodeList<ReachFrequencyPrediction>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return reachFrequencyPredictions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencyPredictions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencyPredictions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reachFrequencyPredictions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return reachFrequencyPredictions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return reachFrequencyPredictions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencyPredictions;
                }
                reachFrequencyPredictions.clear();
                reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(json, context, header));
                return reachFrequencyPredictions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencyPrediction.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAccountId() {
        return this.mAccountId;
    }

    public ReachFrequencyActivity getFieldActivityStatus() {
        return this.mActivityStatus;
    }

    public List<ReachFrequencyAdFormat> getFieldAdFormats() {
        return this.mAdFormats;
    }

    public Long getFieldAuctionEntryOptionIndex() {
        return this.mAuctionEntryOptionIndex;
    }

    public Long getFieldAudienceSizeLowerBound() {
        return this.mAudienceSizeLowerBound;
    }

    public Long getFieldAudienceSizeUpperBound() {
        return this.mAudienceSizeUpperBound;
    }

    public Long getFieldBusinessId() {
        return this.mBusinessId;
    }

    public String getFieldBuyingType() {
        return this.mBuyingType;
    }

    public Long getFieldCampaignGroupId() {
        return this.mCampaignGroupId;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public String getFieldCampaignTimeStart() {
        return this.mCampaignTimeStart;
    }

    public String getFieldCampaignTimeStop() {
        return this.mCampaignTimeStop;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public ReachFrequencyEstimatesCurve getFieldCurveBudgetReach() {
        return this.mCurveBudgetReach;
    }

    public List<Long> getFieldCurveReach() {
        return this.mCurveReach;
    }

    public List<Double> getFieldDailyGrpCurve() {
        return this.mDailyGrpCurve;
    }

    public List<Double> getFieldDailyImpressionCurve() {
        return this.mDailyImpressionCurve;
    }

    public List<Map<Long, List<Double>>> getFieldDailyImpressionCurveMap() {
        return this.mDailyImpressionCurveMap;
    }

    public List<ReachFrequencyDayPart> getFieldDayPartingSchedule() {
        return this.mDayPartingSchedule;
    }

    public String getFieldDestinationId() {
        return this.mDestinationId;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldExpirationTime() {
        return this.mExpirationTime;
    }

    public Long getFieldExternalBudget() {
        return this.mExternalBudget;
    }

    public Long getFieldExternalImpression() {
        return this.mExternalImpression;
    }

    public Long getFieldExternalMaximumBudget() {
        return this.mExternalMaximumBudget;
    }

    public String getFieldExternalMaximumImpression() {
        return this.mExternalMaximumImpression;
    }

    public Long getFieldExternalMaximumReach() {
        return this.mExternalMaximumReach;
    }

    public Long getFieldExternalMinimumBudget() {
        return this.mExternalMinimumBudget;
    }

    public Long getFieldExternalMinimumImpression() {
        return this.mExternalMinimumImpression;
    }

    public Long getFieldExternalMinimumReach() {
        return this.mExternalMinimumReach;
    }

    public Long getFieldExternalReach() {
        return this.mExternalReach;
    }

    public Long getFieldFeedRatio0000() {
        return this.mFeedRatio0000;
    }

    public Long getFieldFrequencyCap() {
        return this.mFrequencyCap;
    }

    public List<Map<Long, List<Double>>> getFieldFrequencyDistributionMap() {
        return this.mFrequencyDistributionMap;
    }

    public List<Map<Long, List<Long>>> getFieldFrequencyDistributionMapAgg() {
        return this.mFrequencyDistributionMapAgg;
    }

    public Double getFieldGrpAudienceSize() {
        return this.mGrpAudienceSize;
    }

    public String getFieldGrpAvgProbabilityMap() {
        return this.mGrpAvgProbabilityMap;
    }

    public Double getFieldGrpCountryAudienceSize() {
        return this.mGrpCountryAudienceSize;
    }

    public List<Double> getFieldGrpCurve() {
        return this.mGrpCurve;
    }

    public Double getFieldGrpDmasAudienceSize() {
        return this.mGrpDmasAudienceSize;
    }

    public Long getFieldGrpFilteringThreshold00() {
        return this.mGrpFilteringThreshold00;
    }

    public Double getFieldGrpPoints() {
        return this.mGrpPoints;
    }

    public Double getFieldGrpRatio() {
        return this.mGrpRatio;
    }

    public Double getFieldGrpReachRatio() {
        return this.mGrpReachRatio;
    }

    public String getFieldGrpStatus() {
        return this.mGrpStatus;
    }

    public Long getFieldHoldoutPercentage() {
        return this.mHoldoutPercentage;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Long> getFieldImpressionCurve() {
        return this.mImpressionCurve;
    }

    public String getFieldInstagramDestinationId() {
        return this.mInstagramDestinationId;
    }

    public List<String> getFieldInstreamPackages() {
        return this.mInstreamPackages;
    }

    public Long getFieldIntervalFrequencyCap() {
        return this.mIntervalFrequencyCap;
    }

    public Long getFieldIntervalFrequencyCapResetPeriod() {
        return this.mIntervalFrequencyCapResetPeriod;
    }

    public Long getFieldIsBonusMedia() {
        return this.mIsBonusMedia;
    }

    public Long getFieldIsConversionGoal() {
        return this.mIsConversionGoal;
    }

    public Boolean getFieldIsHigherAverageFrequency() {
        return this.mIsHigherAverageFrequency;
    }

    public Boolean getFieldIsIo() {
        return this.mIsIo;
    }

    public Long getFieldIsReservedBuying() {
        return this.mIsReservedBuying;
    }

    public Boolean getFieldIsTrp() {
        return this.mIsTrp;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldObjective() {
        return this.mObjective;
    }

    public String getFieldObjectiveName() {
        return this.mObjectiveName;
    }

    public Long getFieldOdaxObjective() {
        return this.mOdaxObjective;
    }

    public String getFieldOdaxObjectiveName() {
        return this.mOdaxObjectiveName;
    }

    public Long getFieldOptimizationGoal() {
        return this.mOptimizationGoal;
    }

    public String getFieldOptimizationGoalName() {
        return this.mOptimizationGoalName;
    }

    public List<Object> getFieldPausePeriods() {
        return this.mPausePeriods;
    }

    public ReachFrequencyEstimatesPlacementBreakdown getFieldPlacementBreakdown() {
        return this.mPlacementBreakdown;
    }

    public List<Map<Long, ReachFrequencyEstimatesPlacementBreakdown>> getFieldPlacementBreakdownMap() {
        return this.mPlacementBreakdownMap;
    }

    public String getFieldPlanName() {
        return this.mPlanName;
    }

    public String getFieldPlanType() {
        return this.mPlanType;
    }

    public Long getFieldPredictionMode() {
        return this.mPredictionMode;
    }

    public Long getFieldPredictionProgress() {
        return this.mPredictionProgress;
    }

    public String getFieldReferenceId() {
        return this.mReferenceId;
    }

    public Long getFieldReservationStatus() {
        return this.mReservationStatus;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public Long getFieldStatus() {
        return this.mStatus;
    }

    public Long getFieldStoryEventType() {
        return this.mStoryEventType;
    }

    public Long getFieldTargetCpm() {
        return this.mTargetCpm;
    }

    public Targeting getFieldTargetSpec() {
        return this.mTargetSpec;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    public Long getFieldTimezoneId() {
        return this.mTimezoneId;
    }

    public String getFieldTimezoneName() {
        return this.mTimezoneName;
    }

    public Long getFieldToplineId() {
        return this.mToplineId;
    }

    public Long getFieldVideoViewLengthConstraint() {
        return this.mVideoViewLengthConstraint;
    }

    public String getFieldViewtag() {
        return this.mViewtag;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencyPrediction copyFrom(ReachFrequencyPrediction instance) {
        this.mAccountId = instance.mAccountId;
        this.mActivityStatus = instance.mActivityStatus;
        this.mAdFormats = instance.mAdFormats;
        this.mAuctionEntryOptionIndex = instance.mAuctionEntryOptionIndex;
        this.mAudienceSizeLowerBound = instance.mAudienceSizeLowerBound;
        this.mAudienceSizeUpperBound = instance.mAudienceSizeUpperBound;
        this.mBusinessId = instance.mBusinessId;
        this.mBuyingType = instance.mBuyingType;
        this.mCampaignGroupId = instance.mCampaignGroupId;
        this.mCampaignId = instance.mCampaignId;
        this.mCampaignTimeStart = instance.mCampaignTimeStart;
        this.mCampaignTimeStop = instance.mCampaignTimeStop;
        this.mCurrency = instance.mCurrency;
        this.mCurveBudgetReach = instance.mCurveBudgetReach;
        this.mCurveReach = instance.mCurveReach;
        this.mDailyGrpCurve = instance.mDailyGrpCurve;
        this.mDailyImpressionCurve = instance.mDailyImpressionCurve;
        this.mDailyImpressionCurveMap = instance.mDailyImpressionCurveMap;
        this.mDayPartingSchedule = instance.mDayPartingSchedule;
        this.mDestinationId = instance.mDestinationId;
        this.mEndTime = instance.mEndTime;
        this.mExpirationTime = instance.mExpirationTime;
        this.mExternalBudget = instance.mExternalBudget;
        this.mExternalImpression = instance.mExternalImpression;
        this.mExternalMaximumBudget = instance.mExternalMaximumBudget;
        this.mExternalMaximumImpression = instance.mExternalMaximumImpression;
        this.mExternalMaximumReach = instance.mExternalMaximumReach;
        this.mExternalMinimumBudget = instance.mExternalMinimumBudget;
        this.mExternalMinimumImpression = instance.mExternalMinimumImpression;
        this.mExternalMinimumReach = instance.mExternalMinimumReach;
        this.mExternalReach = instance.mExternalReach;
        this.mFeedRatio0000 = instance.mFeedRatio0000;
        this.mFrequencyCap = instance.mFrequencyCap;
        this.mFrequencyDistributionMap = instance.mFrequencyDistributionMap;
        this.mFrequencyDistributionMapAgg = instance.mFrequencyDistributionMapAgg;
        this.mGrpAudienceSize = instance.mGrpAudienceSize;
        this.mGrpAvgProbabilityMap = instance.mGrpAvgProbabilityMap;
        this.mGrpCountryAudienceSize = instance.mGrpCountryAudienceSize;
        this.mGrpCurve = instance.mGrpCurve;
        this.mGrpDmasAudienceSize = instance.mGrpDmasAudienceSize;
        this.mGrpFilteringThreshold00 = instance.mGrpFilteringThreshold00;
        this.mGrpPoints = instance.mGrpPoints;
        this.mGrpRatio = instance.mGrpRatio;
        this.mGrpReachRatio = instance.mGrpReachRatio;
        this.mGrpStatus = instance.mGrpStatus;
        this.mHoldoutPercentage = instance.mHoldoutPercentage;
        this.mId = instance.mId;
        this.mImpressionCurve = instance.mImpressionCurve;
        this.mInstagramDestinationId = instance.mInstagramDestinationId;
        this.mInstreamPackages = instance.mInstreamPackages;
        this.mIntervalFrequencyCap = instance.mIntervalFrequencyCap;
        this.mIntervalFrequencyCapResetPeriod = instance.mIntervalFrequencyCapResetPeriod;
        this.mIsBonusMedia = instance.mIsBonusMedia;
        this.mIsConversionGoal = instance.mIsConversionGoal;
        this.mIsHigherAverageFrequency = instance.mIsHigherAverageFrequency;
        this.mIsIo = instance.mIsIo;
        this.mIsReservedBuying = instance.mIsReservedBuying;
        this.mIsTrp = instance.mIsTrp;
        this.mName = instance.mName;
        this.mObjective = instance.mObjective;
        this.mObjectiveName = instance.mObjectiveName;
        this.mOdaxObjective = instance.mOdaxObjective;
        this.mOdaxObjectiveName = instance.mOdaxObjectiveName;
        this.mOptimizationGoal = instance.mOptimizationGoal;
        this.mOptimizationGoalName = instance.mOptimizationGoalName;
        this.mPausePeriods = instance.mPausePeriods;
        this.mPlacementBreakdown = instance.mPlacementBreakdown;
        this.mPlacementBreakdownMap = instance.mPlacementBreakdownMap;
        this.mPlanName = instance.mPlanName;
        this.mPlanType = instance.mPlanType;
        this.mPredictionMode = instance.mPredictionMode;
        this.mPredictionProgress = instance.mPredictionProgress;
        this.mReferenceId = instance.mReferenceId;
        this.mReservationStatus = instance.mReservationStatus;
        this.mStartTime = instance.mStartTime;
        this.mStatus = instance.mStatus;
        this.mStoryEventType = instance.mStoryEventType;
        this.mTargetCpm = instance.mTargetCpm;
        this.mTargetSpec = instance.mTargetSpec;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.mTimezoneId = instance.mTimezoneId;
        this.mTimezoneName = instance.mTimezoneName;
        this.mToplineId = instance.mToplineId;
        this.mVideoViewLengthConstraint = instance.mVideoViewLengthConstraint;
        this.mViewtag = instance.mViewtag;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencyPrediction> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencyPrediction>(){

            @Override
            public APINodeList<ReachFrequencyPrediction> parseResponse(String response, APIContext context, APIRequest<ReachFrequencyPrediction> request, String header) throws APIException.MalformedResponseException {
                return ReachFrequencyPrediction.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumInstreamPackages {
        VALUE_BEAUTY("BEAUTY"),
        VALUE_ENTERTAINMENT("ENTERTAINMENT"),
        VALUE_FOOD("FOOD"),
        VALUE_NORMAL("NORMAL"),
        VALUE_PREMIUM("PREMIUM"),
        VALUE_REGULAR_ANIMALS_PETS("REGULAR_ANIMALS_PETS"),
        VALUE_REGULAR_FOOD("REGULAR_FOOD"),
        VALUE_REGULAR_GAMES("REGULAR_GAMES"),
        VALUE_REGULAR_POLITICS("REGULAR_POLITICS"),
        VALUE_REGULAR_SPORTS("REGULAR_SPORTS"),
        VALUE_REGULAR_STYLE("REGULAR_STYLE"),
        VALUE_REGULAR_TV_MOVIES("REGULAR_TV_MOVIES"),
        VALUE_SPANISH("SPANISH"),
        VALUE_SPORTS("SPORTS");

        private String value;

        private EnumInstreamPackages(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumBuyingType {
        VALUE_AUCTION("AUCTION"),
        VALUE_DEPRECATED_REACH_BLOCK("DEPRECATED_REACH_BLOCK"),
        VALUE_FIXED_CPM("FIXED_CPM"),
        VALUE_MIXED("MIXED"),
        VALUE_REACHBLOCK("REACHBLOCK"),
        VALUE_RESEARCH_POLL("RESEARCH_POLL"),
        VALUE_RESERVED("RESERVED");

        private String value;

        private EnumBuyingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAction {
        VALUE_CANCEL("cancel"),
        VALUE_QUOTE("quote"),
        VALUE_RESERVE("reserve");

        private String value;

        private EnumAction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ReachFrequencyPrediction> {
        ReachFrequencyPrediction lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "activity_status", "ad_formats", "auction_entry_option_index", "audience_size_lower_bound", "audience_size_upper_bound", "business_id", "buying_type", "campaign_group_id", "campaign_id", "campaign_time_start", "campaign_time_stop", "currency", "curve_budget_reach", "curve_reach", "daily_grp_curve", "daily_impression_curve", "daily_impression_curve_map", "day_parting_schedule", "destination_id", "end_time", "expiration_time", "external_budget", "external_impression", "external_maximum_budget", "external_maximum_impression", "external_maximum_reach", "external_minimum_budget", "external_minimum_impression", "external_minimum_reach", "external_reach", "feed_ratio_0000", "frequency_cap", "frequency_distribution_map", "frequency_distribution_map_agg", "grp_audience_size", "grp_avg_probability_map", "grp_country_audience_size", "grp_curve", "grp_dmas_audience_size", "grp_filtering_threshold_00", "grp_points", "grp_ratio", "grp_reach_ratio", "grp_status", "holdout_percentage", "id", "impression_curve", "instagram_destination_id", "instream_packages", "interval_frequency_cap", "interval_frequency_cap_reset_period", "is_bonus_media", "is_conversion_goal", "is_higher_average_frequency", "is_io", "is_reserved_buying", "is_trp", "name", "objective", "objective_name", "odax_objective", "odax_objective_name", "optimization_goal", "optimization_goal_name", "pause_periods", "placement_breakdown", "placement_breakdown_map", "plan_name", "plan_type", "prediction_mode", "prediction_progress", "reference_id", "reservation_status", "start_time", "status", "story_event_type", "target_cpm", "target_spec", "time_created", "time_updated", "timezone_id", "timezone_name", "topline_id", "video_view_length_constraint", "viewtag"};

        @Override
        public ReachFrequencyPrediction getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ReachFrequencyPrediction parseResponse(String response, String header) throws APIException {
            return ReachFrequencyPrediction.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ReachFrequencyPrediction execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ReachFrequencyPrediction execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ReachFrequencyPrediction> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ReachFrequencyPrediction> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ReachFrequencyPrediction>(){

                public ReachFrequencyPrediction apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestActivityStatusField() {
            return this.requestActivityStatusField(true);
        }

        public APIRequestGet requestActivityStatusField(boolean value) {
            this.requestField("activity_status", value);
            return this;
        }

        public APIRequestGet requestAdFormatsField() {
            return this.requestAdFormatsField(true);
        }

        public APIRequestGet requestAdFormatsField(boolean value) {
            this.requestField("ad_formats", value);
            return this;
        }

        public APIRequestGet requestAuctionEntryOptionIndexField() {
            return this.requestAuctionEntryOptionIndexField(true);
        }

        public APIRequestGet requestAuctionEntryOptionIndexField(boolean value) {
            this.requestField("auction_entry_option_index", value);
            return this;
        }

        public APIRequestGet requestAudienceSizeLowerBoundField() {
            return this.requestAudienceSizeLowerBoundField(true);
        }

        public APIRequestGet requestAudienceSizeLowerBoundField(boolean value) {
            this.requestField("audience_size_lower_bound", value);
            return this;
        }

        public APIRequestGet requestAudienceSizeUpperBoundField() {
            return this.requestAudienceSizeUpperBoundField(true);
        }

        public APIRequestGet requestAudienceSizeUpperBoundField(boolean value) {
            this.requestField("audience_size_upper_bound", value);
            return this;
        }

        public APIRequestGet requestBusinessIdField() {
            return this.requestBusinessIdField(true);
        }

        public APIRequestGet requestBusinessIdField(boolean value) {
            this.requestField("business_id", value);
            return this;
        }

        public APIRequestGet requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGet requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGet requestCampaignGroupIdField() {
            return this.requestCampaignGroupIdField(true);
        }

        public APIRequestGet requestCampaignGroupIdField(boolean value) {
            this.requestField("campaign_group_id", value);
            return this;
        }

        public APIRequestGet requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGet requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGet requestCampaignTimeStartField() {
            return this.requestCampaignTimeStartField(true);
        }

        public APIRequestGet requestCampaignTimeStartField(boolean value) {
            this.requestField("campaign_time_start", value);
            return this;
        }

        public APIRequestGet requestCampaignTimeStopField() {
            return this.requestCampaignTimeStopField(true);
        }

        public APIRequestGet requestCampaignTimeStopField(boolean value) {
            this.requestField("campaign_time_stop", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestCurveBudgetReachField() {
            return this.requestCurveBudgetReachField(true);
        }

        public APIRequestGet requestCurveBudgetReachField(boolean value) {
            this.requestField("curve_budget_reach", value);
            return this;
        }

        public APIRequestGet requestCurveReachField() {
            return this.requestCurveReachField(true);
        }

        public APIRequestGet requestCurveReachField(boolean value) {
            this.requestField("curve_reach", value);
            return this;
        }

        public APIRequestGet requestDailyGrpCurveField() {
            return this.requestDailyGrpCurveField(true);
        }

        public APIRequestGet requestDailyGrpCurveField(boolean value) {
            this.requestField("daily_grp_curve", value);
            return this;
        }

        public APIRequestGet requestDailyImpressionCurveField() {
            return this.requestDailyImpressionCurveField(true);
        }

        public APIRequestGet requestDailyImpressionCurveField(boolean value) {
            this.requestField("daily_impression_curve", value);
            return this;
        }

        public APIRequestGet requestDailyImpressionCurveMapField() {
            return this.requestDailyImpressionCurveMapField(true);
        }

        public APIRequestGet requestDailyImpressionCurveMapField(boolean value) {
            this.requestField("daily_impression_curve_map", value);
            return this;
        }

        public APIRequestGet requestDayPartingScheduleField() {
            return this.requestDayPartingScheduleField(true);
        }

        public APIRequestGet requestDayPartingScheduleField(boolean value) {
            this.requestField("day_parting_schedule", value);
            return this;
        }

        public APIRequestGet requestDestinationIdField() {
            return this.requestDestinationIdField(true);
        }

        public APIRequestGet requestDestinationIdField(boolean value) {
            this.requestField("destination_id", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestExpirationTimeField() {
            return this.requestExpirationTimeField(true);
        }

        public APIRequestGet requestExpirationTimeField(boolean value) {
            this.requestField("expiration_time", value);
            return this;
        }

        public APIRequestGet requestExternalBudgetField() {
            return this.requestExternalBudgetField(true);
        }

        public APIRequestGet requestExternalBudgetField(boolean value) {
            this.requestField("external_budget", value);
            return this;
        }

        public APIRequestGet requestExternalImpressionField() {
            return this.requestExternalImpressionField(true);
        }

        public APIRequestGet requestExternalImpressionField(boolean value) {
            this.requestField("external_impression", value);
            return this;
        }

        public APIRequestGet requestExternalMaximumBudgetField() {
            return this.requestExternalMaximumBudgetField(true);
        }

        public APIRequestGet requestExternalMaximumBudgetField(boolean value) {
            this.requestField("external_maximum_budget", value);
            return this;
        }

        public APIRequestGet requestExternalMaximumImpressionField() {
            return this.requestExternalMaximumImpressionField(true);
        }

        public APIRequestGet requestExternalMaximumImpressionField(boolean value) {
            this.requestField("external_maximum_impression", value);
            return this;
        }

        public APIRequestGet requestExternalMaximumReachField() {
            return this.requestExternalMaximumReachField(true);
        }

        public APIRequestGet requestExternalMaximumReachField(boolean value) {
            this.requestField("external_maximum_reach", value);
            return this;
        }

        public APIRequestGet requestExternalMinimumBudgetField() {
            return this.requestExternalMinimumBudgetField(true);
        }

        public APIRequestGet requestExternalMinimumBudgetField(boolean value) {
            this.requestField("external_minimum_budget", value);
            return this;
        }

        public APIRequestGet requestExternalMinimumImpressionField() {
            return this.requestExternalMinimumImpressionField(true);
        }

        public APIRequestGet requestExternalMinimumImpressionField(boolean value) {
            this.requestField("external_minimum_impression", value);
            return this;
        }

        public APIRequestGet requestExternalMinimumReachField() {
            return this.requestExternalMinimumReachField(true);
        }

        public APIRequestGet requestExternalMinimumReachField(boolean value) {
            this.requestField("external_minimum_reach", value);
            return this;
        }

        public APIRequestGet requestExternalReachField() {
            return this.requestExternalReachField(true);
        }

        public APIRequestGet requestExternalReachField(boolean value) {
            this.requestField("external_reach", value);
            return this;
        }

        public APIRequestGet requestFeedRatio0000Field() {
            return this.requestFeedRatio0000Field(true);
        }

        public APIRequestGet requestFeedRatio0000Field(boolean value) {
            this.requestField("feed_ratio_0000", value);
            return this;
        }

        public APIRequestGet requestFrequencyCapField() {
            return this.requestFrequencyCapField(true);
        }

        public APIRequestGet requestFrequencyCapField(boolean value) {
            this.requestField("frequency_cap", value);
            return this;
        }

        public APIRequestGet requestFrequencyDistributionMapField() {
            return this.requestFrequencyDistributionMapField(true);
        }

        public APIRequestGet requestFrequencyDistributionMapField(boolean value) {
            this.requestField("frequency_distribution_map", value);
            return this;
        }

        public APIRequestGet requestFrequencyDistributionMapAggField() {
            return this.requestFrequencyDistributionMapAggField(true);
        }

        public APIRequestGet requestFrequencyDistributionMapAggField(boolean value) {
            this.requestField("frequency_distribution_map_agg", value);
            return this;
        }

        public APIRequestGet requestGrpAudienceSizeField() {
            return this.requestGrpAudienceSizeField(true);
        }

        public APIRequestGet requestGrpAudienceSizeField(boolean value) {
            this.requestField("grp_audience_size", value);
            return this;
        }

        public APIRequestGet requestGrpAvgProbabilityMapField() {
            return this.requestGrpAvgProbabilityMapField(true);
        }

        public APIRequestGet requestGrpAvgProbabilityMapField(boolean value) {
            this.requestField("grp_avg_probability_map", value);
            return this;
        }

        public APIRequestGet requestGrpCountryAudienceSizeField() {
            return this.requestGrpCountryAudienceSizeField(true);
        }

        public APIRequestGet requestGrpCountryAudienceSizeField(boolean value) {
            this.requestField("grp_country_audience_size", value);
            return this;
        }

        public APIRequestGet requestGrpCurveField() {
            return this.requestGrpCurveField(true);
        }

        public APIRequestGet requestGrpCurveField(boolean value) {
            this.requestField("grp_curve", value);
            return this;
        }

        public APIRequestGet requestGrpDmasAudienceSizeField() {
            return this.requestGrpDmasAudienceSizeField(true);
        }

        public APIRequestGet requestGrpDmasAudienceSizeField(boolean value) {
            this.requestField("grp_dmas_audience_size", value);
            return this;
        }

        public APIRequestGet requestGrpFilteringThreshold00Field() {
            return this.requestGrpFilteringThreshold00Field(true);
        }

        public APIRequestGet requestGrpFilteringThreshold00Field(boolean value) {
            this.requestField("grp_filtering_threshold_00", value);
            return this;
        }

        public APIRequestGet requestGrpPointsField() {
            return this.requestGrpPointsField(true);
        }

        public APIRequestGet requestGrpPointsField(boolean value) {
            this.requestField("grp_points", value);
            return this;
        }

        public APIRequestGet requestGrpRatioField() {
            return this.requestGrpRatioField(true);
        }

        public APIRequestGet requestGrpRatioField(boolean value) {
            this.requestField("grp_ratio", value);
            return this;
        }

        public APIRequestGet requestGrpReachRatioField() {
            return this.requestGrpReachRatioField(true);
        }

        public APIRequestGet requestGrpReachRatioField(boolean value) {
            this.requestField("grp_reach_ratio", value);
            return this;
        }

        public APIRequestGet requestGrpStatusField() {
            return this.requestGrpStatusField(true);
        }

        public APIRequestGet requestGrpStatusField(boolean value) {
            this.requestField("grp_status", value);
            return this;
        }

        public APIRequestGet requestHoldoutPercentageField() {
            return this.requestHoldoutPercentageField(true);
        }

        public APIRequestGet requestHoldoutPercentageField(boolean value) {
            this.requestField("holdout_percentage", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImpressionCurveField() {
            return this.requestImpressionCurveField(true);
        }

        public APIRequestGet requestImpressionCurveField(boolean value) {
            this.requestField("impression_curve", value);
            return this;
        }

        public APIRequestGet requestInstagramDestinationIdField() {
            return this.requestInstagramDestinationIdField(true);
        }

        public APIRequestGet requestInstagramDestinationIdField(boolean value) {
            this.requestField("instagram_destination_id", value);
            return this;
        }

        public APIRequestGet requestInstreamPackagesField() {
            return this.requestInstreamPackagesField(true);
        }

        public APIRequestGet requestInstreamPackagesField(boolean value) {
            this.requestField("instream_packages", value);
            return this;
        }

        public APIRequestGet requestIntervalFrequencyCapField() {
            return this.requestIntervalFrequencyCapField(true);
        }

        public APIRequestGet requestIntervalFrequencyCapField(boolean value) {
            this.requestField("interval_frequency_cap", value);
            return this;
        }

        public APIRequestGet requestIntervalFrequencyCapResetPeriodField() {
            return this.requestIntervalFrequencyCapResetPeriodField(true);
        }

        public APIRequestGet requestIntervalFrequencyCapResetPeriodField(boolean value) {
            this.requestField("interval_frequency_cap_reset_period", value);
            return this;
        }

        public APIRequestGet requestIsBonusMediaField() {
            return this.requestIsBonusMediaField(true);
        }

        public APIRequestGet requestIsBonusMediaField(boolean value) {
            this.requestField("is_bonus_media", value);
            return this;
        }

        public APIRequestGet requestIsConversionGoalField() {
            return this.requestIsConversionGoalField(true);
        }

        public APIRequestGet requestIsConversionGoalField(boolean value) {
            this.requestField("is_conversion_goal", value);
            return this;
        }

        public APIRequestGet requestIsHigherAverageFrequencyField() {
            return this.requestIsHigherAverageFrequencyField(true);
        }

        public APIRequestGet requestIsHigherAverageFrequencyField(boolean value) {
            this.requestField("is_higher_average_frequency", value);
            return this;
        }

        public APIRequestGet requestIsIoField() {
            return this.requestIsIoField(true);
        }

        public APIRequestGet requestIsIoField(boolean value) {
            this.requestField("is_io", value);
            return this;
        }

        public APIRequestGet requestIsReservedBuyingField() {
            return this.requestIsReservedBuyingField(true);
        }

        public APIRequestGet requestIsReservedBuyingField(boolean value) {
            this.requestField("is_reserved_buying", value);
            return this;
        }

        public APIRequestGet requestIsTrpField() {
            return this.requestIsTrpField(true);
        }

        public APIRequestGet requestIsTrpField(boolean value) {
            this.requestField("is_trp", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGet requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGet requestObjectiveNameField() {
            return this.requestObjectiveNameField(true);
        }

        public APIRequestGet requestObjectiveNameField(boolean value) {
            this.requestField("objective_name", value);
            return this;
        }

        public APIRequestGet requestOdaxObjectiveField() {
            return this.requestOdaxObjectiveField(true);
        }

        public APIRequestGet requestOdaxObjectiveField(boolean value) {
            this.requestField("odax_objective", value);
            return this;
        }

        public APIRequestGet requestOdaxObjectiveNameField() {
            return this.requestOdaxObjectiveNameField(true);
        }

        public APIRequestGet requestOdaxObjectiveNameField(boolean value) {
            this.requestField("odax_objective_name", value);
            return this;
        }

        public APIRequestGet requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGet requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGet requestOptimizationGoalNameField() {
            return this.requestOptimizationGoalNameField(true);
        }

        public APIRequestGet requestOptimizationGoalNameField(boolean value) {
            this.requestField("optimization_goal_name", value);
            return this;
        }

        public APIRequestGet requestPausePeriodsField() {
            return this.requestPausePeriodsField(true);
        }

        public APIRequestGet requestPausePeriodsField(boolean value) {
            this.requestField("pause_periods", value);
            return this;
        }

        public APIRequestGet requestPlacementBreakdownField() {
            return this.requestPlacementBreakdownField(true);
        }

        public APIRequestGet requestPlacementBreakdownField(boolean value) {
            this.requestField("placement_breakdown", value);
            return this;
        }

        public APIRequestGet requestPlacementBreakdownMapField() {
            return this.requestPlacementBreakdownMapField(true);
        }

        public APIRequestGet requestPlacementBreakdownMapField(boolean value) {
            this.requestField("placement_breakdown_map", value);
            return this;
        }

        public APIRequestGet requestPlanNameField() {
            return this.requestPlanNameField(true);
        }

        public APIRequestGet requestPlanNameField(boolean value) {
            this.requestField("plan_name", value);
            return this;
        }

        public APIRequestGet requestPlanTypeField() {
            return this.requestPlanTypeField(true);
        }

        public APIRequestGet requestPlanTypeField(boolean value) {
            this.requestField("plan_type", value);
            return this;
        }

        public APIRequestGet requestPredictionModeField() {
            return this.requestPredictionModeField(true);
        }

        public APIRequestGet requestPredictionModeField(boolean value) {
            this.requestField("prediction_mode", value);
            return this;
        }

        public APIRequestGet requestPredictionProgressField() {
            return this.requestPredictionProgressField(true);
        }

        public APIRequestGet requestPredictionProgressField(boolean value) {
            this.requestField("prediction_progress", value);
            return this;
        }

        public APIRequestGet requestReferenceIdField() {
            return this.requestReferenceIdField(true);
        }

        public APIRequestGet requestReferenceIdField(boolean value) {
            this.requestField("reference_id", value);
            return this;
        }

        public APIRequestGet requestReservationStatusField() {
            return this.requestReservationStatusField(true);
        }

        public APIRequestGet requestReservationStatusField(boolean value) {
            this.requestField("reservation_status", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStoryEventTypeField() {
            return this.requestStoryEventTypeField(true);
        }

        public APIRequestGet requestStoryEventTypeField(boolean value) {
            this.requestField("story_event_type", value);
            return this;
        }

        public APIRequestGet requestTargetCpmField() {
            return this.requestTargetCpmField(true);
        }

        public APIRequestGet requestTargetCpmField(boolean value) {
            this.requestField("target_cpm", value);
            return this;
        }

        public APIRequestGet requestTargetSpecField() {
            return this.requestTargetSpecField(true);
        }

        public APIRequestGet requestTargetSpecField(boolean value) {
            this.requestField("target_spec", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }

        public APIRequestGet requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGet requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGet requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGet requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGet requestToplineIdField() {
            return this.requestToplineIdField(true);
        }

        public APIRequestGet requestToplineIdField(boolean value) {
            this.requestField("topline_id", value);
            return this;
        }

        public APIRequestGet requestVideoViewLengthConstraintField() {
            return this.requestVideoViewLengthConstraintField(true);
        }

        public APIRequestGet requestVideoViewLengthConstraintField(boolean value) {
            this.requestField("video_view_length_constraint", value);
            return this;
        }

        public APIRequestGet requestViewtagField() {
            return this.requestViewtagField(true);
        }

        public APIRequestGet requestViewtagField(boolean value) {
            this.requestField("viewtag", value);
            return this;
        }
    }
}

