/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class FundingSourceDetailsCoupon
extends APINode {
    @SerializedName(value="amount")
    private Long mAmount = null;
    @SerializedName(value="campaign_ids")
    private List<Long> mCampaignIds = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="display_amount")
    private String mDisplayAmount = null;
    @SerializedName(value="expiration")
    private String mExpiration = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static FundingSourceDetailsCoupon loadJSON(String json, APIContext context, String header) {
        FundingSourceDetailsCoupon fundingSourceDetailsCoupon = (FundingSourceDetailsCoupon)FundingSourceDetailsCoupon.getGson().fromJson(json, FundingSourceDetailsCoupon.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(fundingSourceDetailsCoupon.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        fundingSourceDetailsCoupon.context = context;
        fundingSourceDetailsCoupon.rawValue = json;
        fundingSourceDetailsCoupon.header = header;
        return fundingSourceDetailsCoupon;
    }

    public static APINodeList<FundingSourceDetailsCoupon> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<FundingSourceDetailsCoupon> fundingSourceDetailsCoupons = new APINodeList<FundingSourceDetailsCoupon>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        fundingSourceDetailsCoupons.add(FundingSourceDetailsCoupon.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return fundingSourceDetailsCoupons;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            fundingSourceDetailsCoupons.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        fundingSourceDetailsCoupons.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            fundingSourceDetailsCoupons.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            fundingSourceDetailsCoupons.add(FundingSourceDetailsCoupon.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                fundingSourceDetailsCoupons.add(FundingSourceDetailsCoupon.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            fundingSourceDetailsCoupons.add(FundingSourceDetailsCoupon.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return fundingSourceDetailsCoupons;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        fundingSourceDetailsCoupons.add(FundingSourceDetailsCoupon.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return fundingSourceDetailsCoupons;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        fundingSourceDetailsCoupons.add(FundingSourceDetailsCoupon.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return fundingSourceDetailsCoupons;
                }
                fundingSourceDetailsCoupons.clear();
                fundingSourceDetailsCoupons.add(FundingSourceDetailsCoupon.loadJSON(json, context, header));
                return fundingSourceDetailsCoupons;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FundingSourceDetailsCoupon.getGson().toJson((Object)this);
    }

    public Long getFieldAmount() {
        return this.mAmount;
    }

    public FundingSourceDetailsCoupon setFieldAmount(Long value) {
        this.mAmount = value;
        return this;
    }

    public List<Long> getFieldCampaignIds() {
        return this.mCampaignIds;
    }

    public FundingSourceDetailsCoupon setFieldCampaignIds(List<Long> value) {
        this.mCampaignIds = value;
        return this;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public FundingSourceDetailsCoupon setFieldCurrency(String value) {
        this.mCurrency = value;
        return this;
    }

    public String getFieldDisplayAmount() {
        return this.mDisplayAmount;
    }

    public FundingSourceDetailsCoupon setFieldDisplayAmount(String value) {
        this.mDisplayAmount = value;
        return this;
    }

    public String getFieldExpiration() {
        return this.mExpiration;
    }

    public FundingSourceDetailsCoupon setFieldExpiration(String value) {
        this.mExpiration = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FundingSourceDetailsCoupon copyFrom(FundingSourceDetailsCoupon instance) {
        this.mAmount = instance.mAmount;
        this.mCampaignIds = instance.mCampaignIds;
        this.mCurrency = instance.mCurrency;
        this.mDisplayAmount = instance.mDisplayAmount;
        this.mExpiration = instance.mExpiration;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FundingSourceDetailsCoupon> getParser() {
        return new APIRequest.ResponseParser<FundingSourceDetailsCoupon>(){

            @Override
            public APINodeList<FundingSourceDetailsCoupon> parseResponse(String response, APIContext context, APIRequest<FundingSourceDetailsCoupon> request, String header) throws APIException.MalformedResponseException {
                return FundingSourceDetailsCoupon.parseResponse(response, context, request, header);
            }
        };
    }
}

