/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdCreativePromotionMetadataSpec
extends APINode {
    @SerializedName(value="end_date")
    private String mEndDate = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="promotion_source")
    private String mPromotionSource = null;
    @SerializedName(value="promotion_type")
    private String mPromotionType = null;
    @SerializedName(value="promotion_value")
    private Double mPromotionValue = null;
    @SerializedName(value="required_code")
    private String mRequiredCode = null;
    @SerializedName(value="start_date")
    private String mStartDate = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativePromotionMetadataSpec loadJSON(String json, APIContext context, String header) {
        AdCreativePromotionMetadataSpec adCreativePromotionMetadataSpec = (AdCreativePromotionMetadataSpec)AdCreativePromotionMetadataSpec.getGson().fromJson(json, AdCreativePromotionMetadataSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativePromotionMetadataSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativePromotionMetadataSpec.context = context;
        adCreativePromotionMetadataSpec.rawValue = json;
        adCreativePromotionMetadataSpec.header = header;
        return adCreativePromotionMetadataSpec;
    }

    public static APINodeList<AdCreativePromotionMetadataSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativePromotionMetadataSpec> adCreativePromotionMetadataSpecs = new APINodeList<AdCreativePromotionMetadataSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativePromotionMetadataSpecs.add(AdCreativePromotionMetadataSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativePromotionMetadataSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativePromotionMetadataSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativePromotionMetadataSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativePromotionMetadataSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativePromotionMetadataSpecs.add(AdCreativePromotionMetadataSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativePromotionMetadataSpecs.add(AdCreativePromotionMetadataSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativePromotionMetadataSpecs.add(AdCreativePromotionMetadataSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativePromotionMetadataSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativePromotionMetadataSpecs.add(AdCreativePromotionMetadataSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativePromotionMetadataSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativePromotionMetadataSpecs.add(AdCreativePromotionMetadataSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativePromotionMetadataSpecs;
                }
                adCreativePromotionMetadataSpecs.clear();
                adCreativePromotionMetadataSpecs.add(AdCreativePromotionMetadataSpec.loadJSON(json, context, header));
                return adCreativePromotionMetadataSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativePromotionMetadataSpec.getGson().toJson((Object)this);
    }

    public String getFieldEndDate() {
        return this.mEndDate;
    }

    public AdCreativePromotionMetadataSpec setFieldEndDate(String value) {
        this.mEndDate = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdCreativePromotionMetadataSpec setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldPromotionSource() {
        return this.mPromotionSource;
    }

    public AdCreativePromotionMetadataSpec setFieldPromotionSource(String value) {
        this.mPromotionSource = value;
        return this;
    }

    public String getFieldPromotionType() {
        return this.mPromotionType;
    }

    public AdCreativePromotionMetadataSpec setFieldPromotionType(String value) {
        this.mPromotionType = value;
        return this;
    }

    public Double getFieldPromotionValue() {
        return this.mPromotionValue;
    }

    public AdCreativePromotionMetadataSpec setFieldPromotionValue(Double value) {
        this.mPromotionValue = value;
        return this;
    }

    public String getFieldRequiredCode() {
        return this.mRequiredCode;
    }

    public AdCreativePromotionMetadataSpec setFieldRequiredCode(String value) {
        this.mRequiredCode = value;
        return this;
    }

    public String getFieldStartDate() {
        return this.mStartDate;
    }

    public AdCreativePromotionMetadataSpec setFieldStartDate(String value) {
        this.mStartDate = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativePromotionMetadataSpec copyFrom(AdCreativePromotionMetadataSpec instance) {
        this.mEndDate = instance.mEndDate;
        this.mId = instance.mId;
        this.mPromotionSource = instance.mPromotionSource;
        this.mPromotionType = instance.mPromotionType;
        this.mPromotionValue = instance.mPromotionValue;
        this.mRequiredCode = instance.mRequiredCode;
        this.mStartDate = instance.mStartDate;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativePromotionMetadataSpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativePromotionMetadataSpec>(){

            @Override
            public APINodeList<AdCreativePromotionMetadataSpec> parseResponse(String response, APIContext context, APIRequest<AdCreativePromotionMetadataSpec> request, String header) throws APIException.MalformedResponseException {
                return AdCreativePromotionMetadataSpec.parseResponse(response, context, request, header);
            }
        };
    }
}

