/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class CustomAudienceDataSource
extends APINode {
    @SerializedName(value="creation_params")
    private String mCreationParams = null;
    @SerializedName(value="sub_type")
    private EnumSubType mSubType = null;
    @SerializedName(value="type")
    private EnumType mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static CustomAudienceDataSource loadJSON(String json, APIContext context, String header) {
        CustomAudienceDataSource customAudienceDataSource = (CustomAudienceDataSource)CustomAudienceDataSource.getGson().fromJson(json, CustomAudienceDataSource.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customAudienceDataSource.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customAudienceDataSource.context = context;
        customAudienceDataSource.rawValue = json;
        customAudienceDataSource.header = header;
        return customAudienceDataSource;
    }

    public static APINodeList<CustomAudienceDataSource> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CustomAudienceDataSource> customAudienceDataSources = new APINodeList<CustomAudienceDataSource>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customAudienceDataSources.add(CustomAudienceDataSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return customAudienceDataSources;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customAudienceDataSources.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customAudienceDataSources.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            customAudienceDataSources.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customAudienceDataSources.add(CustomAudienceDataSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customAudienceDataSources.add(CustomAudienceDataSource.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customAudienceDataSources.add(CustomAudienceDataSource.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return customAudienceDataSources;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customAudienceDataSources.add(CustomAudienceDataSource.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return customAudienceDataSources;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customAudienceDataSources.add(CustomAudienceDataSource.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customAudienceDataSources;
                }
                customAudienceDataSources.clear();
                customAudienceDataSources.add(CustomAudienceDataSource.loadJSON(json, context, header));
                return customAudienceDataSources;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomAudienceDataSource.getGson().toJson((Object)this);
    }

    public String getFieldCreationParams() {
        return this.mCreationParams;
    }

    public CustomAudienceDataSource setFieldCreationParams(String value) {
        this.mCreationParams = value;
        return this;
    }

    public EnumSubType getFieldSubType() {
        return this.mSubType;
    }

    public CustomAudienceDataSource setFieldSubType(EnumSubType value) {
        this.mSubType = value;
        return this;
    }

    public EnumType getFieldType() {
        return this.mType;
    }

    public CustomAudienceDataSource setFieldType(EnumType value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomAudienceDataSource copyFrom(CustomAudienceDataSource instance) {
        this.mCreationParams = instance.mCreationParams;
        this.mSubType = instance.mSubType;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomAudienceDataSource> getParser() {
        return new APIRequest.ResponseParser<CustomAudienceDataSource>(){

            @Override
            public APINodeList<CustomAudienceDataSource> parseResponse(String response, APIContext context, APIRequest<CustomAudienceDataSource> request, String header) throws APIException.MalformedResponseException {
                return CustomAudienceDataSource.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumType {
        VALUE_CONTACT_IMPORTER("CONTACT_IMPORTER"),
        VALUE_COPY_PASTE("COPY_PASTE"),
        VALUE_EVENT_BASED("EVENT_BASED"),
        VALUE_FILE_IMPORTED("FILE_IMPORTED"),
        VALUE_HOUSEHOLD_AUDIENCE("HOUSEHOLD_AUDIENCE"),
        VALUE_SEED_BASED("SEED_BASED"),
        VALUE_THIRD_PARTY_IMPORTED("THIRD_PARTY_IMPORTED"),
        VALUE_UNKNOWN("UNKNOWN");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSubType {
        VALUE_ANYTHING("ANYTHING"),
        VALUE_APP_USERS("APP_USERS"),
        VALUE_AR_EFFECTS_EVENTS("AR_EFFECTS_EVENTS"),
        VALUE_AR_EXPERIENCE_EVENTS("AR_EXPERIENCE_EVENTS"),
        VALUE_CAMPAIGN_CONVERSIONS("CAMPAIGN_CONVERSIONS"),
        VALUE_COMBINATION_CUSTOM_AUDIENCE_USERS("COMBINATION_CUSTOM_AUDIENCE_USERS"),
        VALUE_CONSTANT_CONTACTS_EMAIL_HASHES("CONSTANT_CONTACTS_EMAIL_HASHES"),
        VALUE_CONTACT_IMPORTER("CONTACT_IMPORTER"),
        VALUE_CONVERSION_PIXEL_HITS("CONVERSION_PIXEL_HITS"),
        VALUE_COPY_PASTE_EMAIL_HASHES("COPY_PASTE_EMAIL_HASHES"),
        VALUE_CUSTOM_AUDIENCE_USERS("CUSTOM_AUDIENCE_USERS"),
        VALUE_CUSTOM_DATA_TARGETING("CUSTOM_DATA_TARGETING"),
        VALUE_DATA_FILE("DATA_FILE"),
        VALUE_DYNAMIC_RULE("DYNAMIC_RULE"),
        VALUE_ENGAGEMENT_EVENT_USERS("ENGAGEMENT_EVENT_USERS"),
        VALUE_EXPANDED_AUDIENCE("EXPANDED_AUDIENCE"),
        VALUE_EXTERNAL_IDS("EXTERNAL_IDS"),
        VALUE_EXTERNAL_IDS_MIX("EXTERNAL_IDS_MIX"),
        VALUE_FACEBOOK_WIFI_EVENTS("FACEBOOK_WIFI_EVENTS"),
        VALUE_FB_EVENT_SIGNALS("FB_EVENT_SIGNALS"),
        VALUE_FB_PIXEL_HITS("FB_PIXEL_HITS"),
        VALUE_HASHES("HASHES"),
        VALUE_HASHES_OR_USER_IDS("HASHES_OR_USER_IDS"),
        VALUE_HOUSEHOLD_EXPANSION("HOUSEHOLD_EXPANSION"),
        VALUE_IG_BUSINESS_EVENTS("IG_BUSINESS_EVENTS"),
        VALUE_IG_PROMOTED_POST("IG_PROMOTED_POST"),
        VALUE_INSTANT_ARTICLE_EVENTS("INSTANT_ARTICLE_EVENTS"),
        VALUE_LOOKALIKE_PLATFORM("LOOKALIKE_PLATFORM"),
        VALUE_MAIL_CHIMP_EMAIL_HASHES("MAIL_CHIMP_EMAIL_HASHES"),
        VALUE_MESSENGER_ONSITE_SUBSCRIPTION("MESSENGER_ONSITE_SUBSCRIPTION"),
        VALUE_MOBILE_ADVERTISER_IDS("MOBILE_ADVERTISER_IDS"),
        VALUE_MOBILE_APP_COMBINATION_EVENTS("MOBILE_APP_COMBINATION_EVENTS"),
        VALUE_MOBILE_APP_CUSTOM_AUDIENCE_USERS("MOBILE_APP_CUSTOM_AUDIENCE_USERS"),
        VALUE_MOBILE_APP_EVENTS("MOBILE_APP_EVENTS"),
        VALUE_MULTICOUNTRY_COMBINATION("MULTICOUNTRY_COMBINATION"),
        VALUE_MULTI_DATA_EVENTS("MULTI_DATA_EVENTS"),
        VALUE_MULTI_EVENT_SOURCE("MULTI_EVENT_SOURCE"),
        VALUE_MULTI_HASHES("MULTI_HASHES"),
        VALUE_NOTHING("NOTHING"),
        VALUE_OFFLINE_EVENT_USERS("OFFLINE_EVENT_USERS"),
        VALUE_PAGE_FANS("PAGE_FANS"),
        VALUE_PAGE_SMART_AUDIENCE("PAGE_SMART_AUDIENCE"),
        VALUE_PARTNER_CATEGORY_USERS("PARTNER_CATEGORY_USERS"),
        VALUE_PLACE_VISITS("PLACE_VISITS"),
        VALUE_PLATFORM("PLATFORM"),
        VALUE_PLATFORM_USERS("PLATFORM_USERS"),
        VALUE_SEED_LIST("SEED_LIST"),
        VALUE_SIGNAL_SOURCE("SIGNAL_SOURCE"),
        VALUE_SMART_AUDIENCE("SMART_AUDIENCE"),
        VALUE_STORE_VISIT_EVENTS("STORE_VISIT_EVENTS"),
        VALUE_SUBSCRIBER_LIST("SUBSCRIBER_LIST"),
        VALUE_S_EXPR("S_EXPR"),
        VALUE_TOKENS("TOKENS"),
        VALUE_USER_IDS("USER_IDS"),
        VALUE_VIDEO_EVENTS("VIDEO_EVENTS"),
        VALUE_VIDEO_EVENT_USERS("VIDEO_EVENT_USERS"),
        VALUE_WEB_PIXEL_COMBINATION_EVENTS("WEB_PIXEL_COMBINATION_EVENTS"),
        VALUE_WEB_PIXEL_HITS("WEB_PIXEL_HITS"),
        VALUE_WEB_PIXEL_HITS_CUSTOM_AUDIENCE_USERS("WEB_PIXEL_HITS_CUSTOM_AUDIENCE_USERS"),
        VALUE_WHATSAPP_SUBSCRIBER_POOL("WHATSAPP_SUBSCRIBER_POOL");

        private String value;

        private EnumSubType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

