/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProductItemLocalInfoLatLongShape;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProductItemLocalInfo
extends APINode {
    @SerializedName(value="availability_circle_origin")
    private ProductItemLocalInfoLatLongShape mAvailabilityCircleOrigin = null;
    @SerializedName(value="availability_circle_radius")
    private Double mAvailabilityCircleRadius = null;
    @SerializedName(value="availability_circle_radius_unit")
    private String mAvailabilityCircleRadiusUnit = null;
    @SerializedName(value="availability_polygon_coordinates")
    private List<ProductItemLocalInfoLatLongShape> mAvailabilityPolygonCoordinates = null;
    @SerializedName(value="availability_postal_codes")
    private List<String> mAvailabilityPostalCodes = null;
    @SerializedName(value="availability_source")
    private String mAvailabilitySource = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="inferred_circle_origin")
    private ProductItemLocalInfoLatLongShape mInferredCircleOrigin = null;
    @SerializedName(value="inferred_circle_radius")
    private Double mInferredCircleRadius = null;
    protected static Gson gson = null;

    ProductItemLocalInfo() {
    }

    public ProductItemLocalInfo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductItemLocalInfo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductItemLocalInfo fetch() throws APIException {
        ProductItemLocalInfo newInstance = ProductItemLocalInfo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductItemLocalInfo fetchById(Long id, APIContext context) throws APIException {
        return ProductItemLocalInfo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductItemLocalInfo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductItemLocalInfo.fetchByIdAsync(id.toString(), context);
    }

    public static ProductItemLocalInfo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductItemLocalInfo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductItemLocalInfo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductItemLocalInfo>(context, "", "/", "GET", ProductItemLocalInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductItemLocalInfo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductItemLocalInfo>(context, "", "/", "GET", ProductItemLocalInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductItemLocalInfo loadJSON(String json, APIContext context, String header) {
        ProductItemLocalInfo productItemLocalInfo = (ProductItemLocalInfo)ProductItemLocalInfo.getGson().fromJson(json, ProductItemLocalInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productItemLocalInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productItemLocalInfo.context = context;
        productItemLocalInfo.rawValue = json;
        productItemLocalInfo.header = header;
        return productItemLocalInfo;
    }

    public static APINodeList<ProductItemLocalInfo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductItemLocalInfo> productItemLocalInfos = new APINodeList<ProductItemLocalInfo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productItemLocalInfos.add(ProductItemLocalInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productItemLocalInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productItemLocalInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productItemLocalInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productItemLocalInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productItemLocalInfos.add(ProductItemLocalInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productItemLocalInfos.add(ProductItemLocalInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productItemLocalInfos.add(ProductItemLocalInfo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productItemLocalInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productItemLocalInfos.add(ProductItemLocalInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productItemLocalInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productItemLocalInfos.add(ProductItemLocalInfo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productItemLocalInfos;
                }
                productItemLocalInfos.clear();
                productItemLocalInfos.add(ProductItemLocalInfo.loadJSON(json, context, header));
                return productItemLocalInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductItemLocalInfo.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public ProductItemLocalInfoLatLongShape getFieldAvailabilityCircleOrigin() {
        return this.mAvailabilityCircleOrigin;
    }

    public Double getFieldAvailabilityCircleRadius() {
        return this.mAvailabilityCircleRadius;
    }

    public String getFieldAvailabilityCircleRadiusUnit() {
        return this.mAvailabilityCircleRadiusUnit;
    }

    public List<ProductItemLocalInfoLatLongShape> getFieldAvailabilityPolygonCoordinates() {
        return this.mAvailabilityPolygonCoordinates;
    }

    public List<String> getFieldAvailabilityPostalCodes() {
        return this.mAvailabilityPostalCodes;
    }

    public String getFieldAvailabilitySource() {
        return this.mAvailabilitySource;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ProductItemLocalInfoLatLongShape getFieldInferredCircleOrigin() {
        return this.mInferredCircleOrigin;
    }

    public Double getFieldInferredCircleRadius() {
        return this.mInferredCircleRadius;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductItemLocalInfo copyFrom(ProductItemLocalInfo instance) {
        this.mAvailabilityCircleOrigin = instance.mAvailabilityCircleOrigin;
        this.mAvailabilityCircleRadius = instance.mAvailabilityCircleRadius;
        this.mAvailabilityCircleRadiusUnit = instance.mAvailabilityCircleRadiusUnit;
        this.mAvailabilityPolygonCoordinates = instance.mAvailabilityPolygonCoordinates;
        this.mAvailabilityPostalCodes = instance.mAvailabilityPostalCodes;
        this.mAvailabilitySource = instance.mAvailabilitySource;
        this.mId = instance.mId;
        this.mInferredCircleOrigin = instance.mInferredCircleOrigin;
        this.mInferredCircleRadius = instance.mInferredCircleRadius;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductItemLocalInfo> getParser() {
        return new APIRequest.ResponseParser<ProductItemLocalInfo>(){

            @Override
            public APINodeList<ProductItemLocalInfo> parseResponse(String response, APIContext context, APIRequest<ProductItemLocalInfo> request, String header) throws APIException.MalformedResponseException {
                return ProductItemLocalInfo.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ProductItemLocalInfo> {
        ProductItemLocalInfo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"availability_circle_origin", "availability_circle_radius", "availability_circle_radius_unit", "availability_polygon_coordinates", "availability_postal_codes", "availability_source", "id", "inferred_circle_origin", "inferred_circle_radius"};

        @Override
        public ProductItemLocalInfo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductItemLocalInfo parseResponse(String response, String header) throws APIException {
            return ProductItemLocalInfo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ProductItemLocalInfo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductItemLocalInfo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ProductItemLocalInfo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductItemLocalInfo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ProductItemLocalInfo>(){

                public ProductItemLocalInfo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAvailabilityCircleOriginField() {
            return this.requestAvailabilityCircleOriginField(true);
        }

        public APIRequestGet requestAvailabilityCircleOriginField(boolean value) {
            this.requestField("availability_circle_origin", value);
            return this;
        }

        public APIRequestGet requestAvailabilityCircleRadiusField() {
            return this.requestAvailabilityCircleRadiusField(true);
        }

        public APIRequestGet requestAvailabilityCircleRadiusField(boolean value) {
            this.requestField("availability_circle_radius", value);
            return this;
        }

        public APIRequestGet requestAvailabilityCircleRadiusUnitField() {
            return this.requestAvailabilityCircleRadiusUnitField(true);
        }

        public APIRequestGet requestAvailabilityCircleRadiusUnitField(boolean value) {
            this.requestField("availability_circle_radius_unit", value);
            return this;
        }

        public APIRequestGet requestAvailabilityPolygonCoordinatesField() {
            return this.requestAvailabilityPolygonCoordinatesField(true);
        }

        public APIRequestGet requestAvailabilityPolygonCoordinatesField(boolean value) {
            this.requestField("availability_polygon_coordinates", value);
            return this;
        }

        public APIRequestGet requestAvailabilityPostalCodesField() {
            return this.requestAvailabilityPostalCodesField(true);
        }

        public APIRequestGet requestAvailabilityPostalCodesField(boolean value) {
            this.requestField("availability_postal_codes", value);
            return this;
        }

        public APIRequestGet requestAvailabilitySourceField() {
            return this.requestAvailabilitySourceField(true);
        }

        public APIRequestGet requestAvailabilitySourceField(boolean value) {
            this.requestField("availability_source", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInferredCircleOriginField() {
            return this.requestInferredCircleOriginField(true);
        }

        public APIRequestGet requestInferredCircleOriginField(boolean value) {
            this.requestField("inferred_circle_origin", value);
            return this;
        }

        public APIRequestGet requestInferredCircleRadiusField() {
            return this.requestInferredCircleRadiusField(true);
        }

        public APIRequestGet requestInferredCircleRadiusField(boolean value) {
            this.requestField("inferred_circle_radius", value);
            return this;
        }
    }
}

