/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BusinessCreativeFolder
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creative_insight_permissions")
    private List<Map<String, String>> mCreativeInsightPermissions = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="media_library_url")
    private String mMediaLibraryUrl = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="owner_business")
    private Business mOwnerBusiness = null;
    protected static Gson gson = null;

    BusinessCreativeFolder() {
    }

    public BusinessCreativeFolder(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessCreativeFolder(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessCreativeFolder fetch() throws APIException {
        BusinessCreativeFolder newInstance = BusinessCreativeFolder.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessCreativeFolder fetchById(Long id, APIContext context) throws APIException {
        return BusinessCreativeFolder.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessCreativeFolder> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessCreativeFolder.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessCreativeFolder fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessCreativeFolder> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessCreativeFolder> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessCreativeFolder>(context, "", "/", "GET", BusinessCreativeFolder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessCreativeFolder>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessCreativeFolder>(context, "", "/", "GET", BusinessCreativeFolder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessCreativeFolder loadJSON(String json, APIContext context, String header) {
        BusinessCreativeFolder businessCreativeFolder = (BusinessCreativeFolder)BusinessCreativeFolder.getGson().fromJson(json, BusinessCreativeFolder.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessCreativeFolder.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessCreativeFolder.context = context;
        businessCreativeFolder.rawValue = json;
        businessCreativeFolder.header = header;
        return businessCreativeFolder;
    }

    public static APINodeList<BusinessCreativeFolder> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessCreativeFolder> businessCreativeFolders = new APINodeList<BusinessCreativeFolder>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessCreativeFolders;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessCreativeFolders.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessCreativeFolders.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessCreativeFolders.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessCreativeFolders;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessCreativeFolders;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessCreativeFolders;
                }
                businessCreativeFolders.clear();
                businessCreativeFolders.add(BusinessCreativeFolder.loadJSON(json, context, header));
                return businessCreativeFolders;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessCreativeFolder.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public List<Map<String, String>> getFieldCreativeInsightPermissions() {
        return this.mCreativeInsightPermissions;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldMediaLibraryUrl() {
        return this.mMediaLibraryUrl;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Business getFieldOwnerBusiness() {
        if (this.mOwnerBusiness != null) {
            this.mOwnerBusiness.context = this.getContext();
        }
        return this.mOwnerBusiness;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessCreativeFolder copyFrom(BusinessCreativeFolder instance) {
        this.mBusiness = instance.mBusiness;
        this.mCreationTime = instance.mCreationTime;
        this.mCreativeInsightPermissions = instance.mCreativeInsightPermissions;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mMediaLibraryUrl = instance.mMediaLibraryUrl;
        this.mName = instance.mName;
        this.mOwnerBusiness = instance.mOwnerBusiness;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessCreativeFolder> getParser() {
        return new APIRequest.ResponseParser<BusinessCreativeFolder>(){

            @Override
            public APINodeList<BusinessCreativeFolder> parseResponse(String response, APIContext context, APIRequest<BusinessCreativeFolder> request, String header) throws APIException.MalformedResponseException {
                return BusinessCreativeFolder.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<BusinessCreativeFolder> {
        BusinessCreativeFolder lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "creation_time", "creative_insight_permissions", "description", "id", "media_library_url", "name", "owner_business"};

        @Override
        public BusinessCreativeFolder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessCreativeFolder parseResponse(String response, String header) throws APIException {
            return BusinessCreativeFolder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessCreativeFolder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessCreativeFolder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessCreativeFolder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessCreativeFolder>(){

                public BusinessCreativeFolder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreativeInsightPermissionsField() {
            return this.requestCreativeInsightPermissionsField(true);
        }

        public APIRequestGet requestCreativeInsightPermissionsField(boolean value) {
            this.requestField("creative_insight_permissions", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMediaLibraryUrlField() {
            return this.requestMediaLibraryUrlField(true);
        }

        public APIRequestGet requestMediaLibraryUrlField(boolean value) {
            this.requestField("media_library_url", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGet requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }
    }
}

