/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreditCard
extends APINode {
    @SerializedName(value="billing_address")
    private Object mBillingAddress = null;
    @SerializedName(value="card_cobadging")
    private String mCardCobadging = null;
    @SerializedName(value="card_holder_name")
    private String mCardHolderName = null;
    @SerializedName(value="card_type")
    private String mCardType = null;
    @SerializedName(value="credential_id")
    private Long mCredentialId = null;
    @SerializedName(value="default_receiving_method_products")
    private List<String> mDefaultReceivingMethodProducts = null;
    @SerializedName(value="expiry_month")
    private String mExpiryMonth = null;
    @SerializedName(value="expiry_year")
    private String mExpiryYear = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_cvv_tricky_bin")
    private Boolean mIsCvvTrickyBin = null;
    @SerializedName(value="is_enabled")
    private Boolean mIsEnabled = null;
    @SerializedName(value="is_last_used")
    private Boolean mIsLastUsed = null;
    @SerializedName(value="is_network_tokenized_in_india")
    private Boolean mIsNetworkTokenizedInIndia = null;
    @SerializedName(value="is_soft_disabled")
    private Boolean mIsSoftDisabled = null;
    @SerializedName(value="is_user_verified")
    private Boolean mIsUserVerified = null;
    @SerializedName(value="is_zip_verified")
    private Boolean mIsZipVerified = null;
    @SerializedName(value="last4")
    private String mLast4 = null;
    @SerializedName(value="readable_card_type")
    private String mReadableCardType = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_created_ts")
    private Long mTimeCreatedTs = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    CreditCard() {
    }

    public CreditCard(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CreditCard(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CreditCard fetch() throws APIException {
        CreditCard newInstance = CreditCard.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CreditCard fetchById(Long id, APIContext context) throws APIException {
        return CreditCard.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CreditCard> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CreditCard.fetchByIdAsync(id.toString(), context);
    }

    public static CreditCard fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CreditCard> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CreditCard> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CreditCard>(context, "", "/", "GET", CreditCard.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CreditCard>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CreditCard>(context, "", "/", "GET", CreditCard.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CreditCard loadJSON(String json, APIContext context, String header) {
        CreditCard creditCard = (CreditCard)CreditCard.getGson().fromJson(json, CreditCard.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(creditCard.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        creditCard.context = context;
        creditCard.rawValue = json;
        creditCard.header = header;
        return creditCard;
    }

    public static APINodeList<CreditCard> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CreditCard> creditCards = new APINodeList<CreditCard>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        creditCards.add(CreditCard.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return creditCards;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            creditCards.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        creditCards.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            creditCards.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            creditCards.add(CreditCard.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                creditCards.add(CreditCard.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            creditCards.add(CreditCard.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return creditCards;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        creditCards.add(CreditCard.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return creditCards;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        creditCards.add(CreditCard.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return creditCards;
                }
                creditCards.clear();
                creditCards.add(CreditCard.loadJSON(json, context, header));
                return creditCards;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CreditCard.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldBillingAddress() {
        return this.mBillingAddress;
    }

    public String getFieldCardCobadging() {
        return this.mCardCobadging;
    }

    public String getFieldCardHolderName() {
        return this.mCardHolderName;
    }

    public String getFieldCardType() {
        return this.mCardType;
    }

    public Long getFieldCredentialId() {
        return this.mCredentialId;
    }

    public List<String> getFieldDefaultReceivingMethodProducts() {
        return this.mDefaultReceivingMethodProducts;
    }

    public String getFieldExpiryMonth() {
        return this.mExpiryMonth;
    }

    public String getFieldExpiryYear() {
        return this.mExpiryYear;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsCvvTrickyBin() {
        return this.mIsCvvTrickyBin;
    }

    public Boolean getFieldIsEnabled() {
        return this.mIsEnabled;
    }

    public Boolean getFieldIsLastUsed() {
        return this.mIsLastUsed;
    }

    public Boolean getFieldIsNetworkTokenizedInIndia() {
        return this.mIsNetworkTokenizedInIndia;
    }

    public Boolean getFieldIsSoftDisabled() {
        return this.mIsSoftDisabled;
    }

    public Boolean getFieldIsUserVerified() {
        return this.mIsUserVerified;
    }

    public Boolean getFieldIsZipVerified() {
        return this.mIsZipVerified;
    }

    public String getFieldLast4() {
        return this.mLast4;
    }

    public String getFieldReadableCardType() {
        return this.mReadableCardType;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public Long getFieldTimeCreatedTs() {
        return this.mTimeCreatedTs;
    }

    public String getFieldType() {
        return this.mType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CreditCard copyFrom(CreditCard instance) {
        this.mBillingAddress = instance.mBillingAddress;
        this.mCardCobadging = instance.mCardCobadging;
        this.mCardHolderName = instance.mCardHolderName;
        this.mCardType = instance.mCardType;
        this.mCredentialId = instance.mCredentialId;
        this.mDefaultReceivingMethodProducts = instance.mDefaultReceivingMethodProducts;
        this.mExpiryMonth = instance.mExpiryMonth;
        this.mExpiryYear = instance.mExpiryYear;
        this.mId = instance.mId;
        this.mIsCvvTrickyBin = instance.mIsCvvTrickyBin;
        this.mIsEnabled = instance.mIsEnabled;
        this.mIsLastUsed = instance.mIsLastUsed;
        this.mIsNetworkTokenizedInIndia = instance.mIsNetworkTokenizedInIndia;
        this.mIsSoftDisabled = instance.mIsSoftDisabled;
        this.mIsUserVerified = instance.mIsUserVerified;
        this.mIsZipVerified = instance.mIsZipVerified;
        this.mLast4 = instance.mLast4;
        this.mReadableCardType = instance.mReadableCardType;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeCreatedTs = instance.mTimeCreatedTs;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CreditCard> getParser() {
        return new APIRequest.ResponseParser<CreditCard>(){

            @Override
            public APINodeList<CreditCard> parseResponse(String response, APIContext context, APIRequest<CreditCard> request, String header) throws APIException.MalformedResponseException {
                return CreditCard.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CreditCard> {
        CreditCard lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"billing_address", "card_cobadging", "card_holder_name", "card_type", "credential_id", "default_receiving_method_products", "expiry_month", "expiry_year", "id", "is_cvv_tricky_bin", "is_enabled", "is_last_used", "is_network_tokenized_in_india", "is_soft_disabled", "is_user_verified", "is_zip_verified", "last4", "readable_card_type", "time_created", "time_created_ts", "type"};

        @Override
        public CreditCard getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CreditCard parseResponse(String response, String header) throws APIException {
            return CreditCard.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CreditCard execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CreditCard execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CreditCard> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CreditCard> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CreditCard>(){

                public CreditCard apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBillingAddressField() {
            return this.requestBillingAddressField(true);
        }

        public APIRequestGet requestBillingAddressField(boolean value) {
            this.requestField("billing_address", value);
            return this;
        }

        public APIRequestGet requestCardCobadgingField() {
            return this.requestCardCobadgingField(true);
        }

        public APIRequestGet requestCardCobadgingField(boolean value) {
            this.requestField("card_cobadging", value);
            return this;
        }

        public APIRequestGet requestCardHolderNameField() {
            return this.requestCardHolderNameField(true);
        }

        public APIRequestGet requestCardHolderNameField(boolean value) {
            this.requestField("card_holder_name", value);
            return this;
        }

        public APIRequestGet requestCardTypeField() {
            return this.requestCardTypeField(true);
        }

        public APIRequestGet requestCardTypeField(boolean value) {
            this.requestField("card_type", value);
            return this;
        }

        public APIRequestGet requestCredentialIdField() {
            return this.requestCredentialIdField(true);
        }

        public APIRequestGet requestCredentialIdField(boolean value) {
            this.requestField("credential_id", value);
            return this;
        }

        public APIRequestGet requestDefaultReceivingMethodProductsField() {
            return this.requestDefaultReceivingMethodProductsField(true);
        }

        public APIRequestGet requestDefaultReceivingMethodProductsField(boolean value) {
            this.requestField("default_receiving_method_products", value);
            return this;
        }

        public APIRequestGet requestExpiryMonthField() {
            return this.requestExpiryMonthField(true);
        }

        public APIRequestGet requestExpiryMonthField(boolean value) {
            this.requestField("expiry_month", value);
            return this;
        }

        public APIRequestGet requestExpiryYearField() {
            return this.requestExpiryYearField(true);
        }

        public APIRequestGet requestExpiryYearField(boolean value) {
            this.requestField("expiry_year", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsCvvTrickyBinField() {
            return this.requestIsCvvTrickyBinField(true);
        }

        public APIRequestGet requestIsCvvTrickyBinField(boolean value) {
            this.requestField("is_cvv_tricky_bin", value);
            return this;
        }

        public APIRequestGet requestIsEnabledField() {
            return this.requestIsEnabledField(true);
        }

        public APIRequestGet requestIsEnabledField(boolean value) {
            this.requestField("is_enabled", value);
            return this;
        }

        public APIRequestGet requestIsLastUsedField() {
            return this.requestIsLastUsedField(true);
        }

        public APIRequestGet requestIsLastUsedField(boolean value) {
            this.requestField("is_last_used", value);
            return this;
        }

        public APIRequestGet requestIsNetworkTokenizedInIndiaField() {
            return this.requestIsNetworkTokenizedInIndiaField(true);
        }

        public APIRequestGet requestIsNetworkTokenizedInIndiaField(boolean value) {
            this.requestField("is_network_tokenized_in_india", value);
            return this;
        }

        public APIRequestGet requestIsSoftDisabledField() {
            return this.requestIsSoftDisabledField(true);
        }

        public APIRequestGet requestIsSoftDisabledField(boolean value) {
            this.requestField("is_soft_disabled", value);
            return this;
        }

        public APIRequestGet requestIsUserVerifiedField() {
            return this.requestIsUserVerifiedField(true);
        }

        public APIRequestGet requestIsUserVerifiedField(boolean value) {
            this.requestField("is_user_verified", value);
            return this;
        }

        public APIRequestGet requestIsZipVerifiedField() {
            return this.requestIsZipVerifiedField(true);
        }

        public APIRequestGet requestIsZipVerifiedField(boolean value) {
            this.requestField("is_zip_verified", value);
            return this;
        }

        public APIRequestGet requestLast4Field() {
            return this.requestLast4Field(true);
        }

        public APIRequestGet requestLast4Field(boolean value) {
            this.requestField("last4", value);
            return this;
        }

        public APIRequestGet requestReadableCardTypeField() {
            return this.requestReadableCardTypeField(true);
        }

        public APIRequestGet requestReadableCardTypeField(boolean value) {
            this.requestField("readable_card_type", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedTsField() {
            return this.requestTimeCreatedTsField(true);
        }

        public APIRequestGet requestTimeCreatedTsField(boolean value) {
            this.requestField("time_created_ts", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }
}

