/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GameItem
extends APINode {
    @SerializedName(value="count")
    private Long mCount = null;
    @SerializedName(value="created")
    private String mCreated = null;
    @SerializedName(value="ext_id")
    private String mExtId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="item_def")
    private String mItemDef = null;
    @SerializedName(value="owner")
    private User mOwner = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="updated")
    private String mUpdated = null;
    protected static Gson gson = null;

    GameItem() {
    }

    public GameItem(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public GameItem(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public GameItem fetch() throws APIException {
        GameItem newInstance = GameItem.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static GameItem fetchById(Long id, APIContext context) throws APIException {
        return GameItem.fetchById(id.toString(), context);
    }

    public static ListenableFuture<GameItem> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return GameItem.fetchByIdAsync(id.toString(), context);
    }

    public static GameItem fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<GameItem> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<GameItem> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<GameItem>(context, "", "/", "GET", GameItem.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<GameItem>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<GameItem>(context, "", "/", "GET", GameItem.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static GameItem loadJSON(String json, APIContext context, String header) {
        GameItem gameItem = (GameItem)GameItem.getGson().fromJson(json, GameItem.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(gameItem.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        gameItem.context = context;
        gameItem.rawValue = json;
        gameItem.header = header;
        return gameItem;
    }

    public static APINodeList<GameItem> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<GameItem> gameItems = new APINodeList<GameItem>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        gameItems.add(GameItem.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return gameItems;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            gameItems.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        gameItems.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            gameItems.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            gameItems.add(GameItem.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                gameItems.add(GameItem.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            gameItems.add(GameItem.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return gameItems;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        gameItems.add(GameItem.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return gameItems;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        gameItems.add(GameItem.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return gameItems;
                }
                gameItems.clear();
                gameItems.add(GameItem.loadJSON(json, context, header));
                return gameItems;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return GameItem.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldCount() {
        return this.mCount;
    }

    public String getFieldCreated() {
        return this.mCreated;
    }

    public String getFieldExtId() {
        return this.mExtId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldItemDef() {
        return this.mItemDef;
    }

    public User getFieldOwner() {
        if (this.mOwner != null) {
            this.mOwner.context = this.getContext();
        }
        return this.mOwner;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldUpdated() {
        return this.mUpdated;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public GameItem copyFrom(GameItem instance) {
        this.mCount = instance.mCount;
        this.mCreated = instance.mCreated;
        this.mExtId = instance.mExtId;
        this.mId = instance.mId;
        this.mItemDef = instance.mItemDef;
        this.mOwner = instance.mOwner;
        this.mStatus = instance.mStatus;
        this.mUpdated = instance.mUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<GameItem> getParser() {
        return new APIRequest.ResponseParser<GameItem>(){

            @Override
            public APINodeList<GameItem> parseResponse(String response, APIContext context, APIRequest<GameItem> request, String header) throws APIException.MalformedResponseException {
                return GameItem.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumAction {
        VALUE_CONSUME("CONSUME"),
        VALUE_DROP("DROP"),
        VALUE_MARK("MARK");

        private String value;

        private EnumAction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<GameItem> {
        GameItem lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"count", "created", "ext_id", "id", "item_def", "owner", "status", "updated"};

        @Override
        public GameItem getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public GameItem parseResponse(String response, String header) throws APIException {
            return GameItem.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public GameItem execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public GameItem execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<GameItem> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<GameItem> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, GameItem>(){

                public GameItem apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCountField() {
            return this.requestCountField(true);
        }

        public APIRequestGet requestCountField(boolean value) {
            this.requestField("count", value);
            return this;
        }

        public APIRequestGet requestCreatedField() {
            return this.requestCreatedField(true);
        }

        public APIRequestGet requestCreatedField(boolean value) {
            this.requestField("created", value);
            return this;
        }

        public APIRequestGet requestExtIdField() {
            return this.requestExtIdField(true);
        }

        public APIRequestGet requestExtIdField(boolean value) {
            this.requestField("ext_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestItemDefField() {
            return this.requestItemDefField(true);
        }

        public APIRequestGet requestItemDefField(boolean value) {
            this.requestField("item_def", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUpdatedField() {
            return this.requestUpdatedField(true);
        }

        public APIRequestGet requestUpdatedField(boolean value) {
            this.requestField("updated", value);
            return this;
        }
    }
}

