/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.widget;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogFeature;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.share.Sharer;
import com.facebook.share.internal.LegacyNativeDialogParameters;
import com.facebook.share.internal.MessageDialogFeature;
import com.facebook.share.internal.NativeDialogParameters;
import com.facebook.share.internal.OpenGraphMessageDialogFeature;
import com.facebook.share.internal.ShareContentValidation;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareMessengerGenericTemplateContent;
import com.facebook.share.model.ShareMessengerMediaTemplateContent;
import com.facebook.share.model.ShareMessengerOpenGraphMusicTemplateContent;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class MessageDialog
extends FacebookDialogBase<ShareContent, Sharer.Result>
implements Sharer {
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.Message.toRequestCode();
    private boolean shouldFailOnDataError = false;

    public static void show(Activity activity, ShareContent shareContent) {
        new MessageDialog(activity).show(shareContent);
    }

    public static void show(android.support.v4.app.Fragment fragment, ShareContent shareContent) {
        MessageDialog.show(new FragmentWrapper(fragment), shareContent);
    }

    public static void show(Fragment fragment, ShareContent shareContent) {
        MessageDialog.show(new FragmentWrapper(fragment), shareContent);
    }

    private static void show(FragmentWrapper fragmentWrapper, ShareContent shareContent) {
        new MessageDialog(fragmentWrapper).show(shareContent);
    }

    public static boolean canShow(Class<? extends ShareContent> contentType) {
        DialogFeature feature = MessageDialog.getFeature(contentType);
        return feature != null && DialogPresenter.canPresentNativeDialogWithFeature((DialogFeature)feature);
    }

    public MessageDialog(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
        ShareInternalUtility.registerStaticShareCallback((int)DEFAULT_REQUEST_CODE);
    }

    public MessageDialog(android.support.v4.app.Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    public MessageDialog(Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    private MessageDialog(FragmentWrapper fragmentWrapper) {
        super(fragmentWrapper, DEFAULT_REQUEST_CODE);
        ShareInternalUtility.registerStaticShareCallback((int)DEFAULT_REQUEST_CODE);
    }

    MessageDialog(Activity activity, int requestCode) {
        super(activity, requestCode);
        ShareInternalUtility.registerStaticShareCallback((int)requestCode);
    }

    MessageDialog(android.support.v4.app.Fragment fragment, int requestCode) {
        this(new FragmentWrapper(fragment), requestCode);
    }

    MessageDialog(Fragment fragment, int requestCode) {
        this(new FragmentWrapper(fragment), requestCode);
    }

    private MessageDialog(FragmentWrapper fragmentWrapper, int requestCode) {
        super(fragmentWrapper, requestCode);
        ShareInternalUtility.registerStaticShareCallback((int)requestCode);
    }

    protected void registerCallbackImpl(CallbackManagerImpl callbackManager, FacebookCallback<Sharer.Result> callback) {
        ShareInternalUtility.registerSharerCallback((int)this.getRequestCode(), (CallbackManager)callbackManager, callback);
    }

    public boolean getShouldFailOnDataError() {
        return this.shouldFailOnDataError;
    }

    public void setShouldFailOnDataError(boolean shouldFailOnDataError) {
        this.shouldFailOnDataError = shouldFailOnDataError;
    }

    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode());
    }

    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        ArrayList<FacebookDialogBase.ModeHandler> handlers = new ArrayList<FacebookDialogBase.ModeHandler>();
        handlers.add(new NativeHandler());
        return handlers;
    }

    private static DialogFeature getFeature(Class<? extends ShareContent> type) {
        if (ShareLinkContent.class.isAssignableFrom(type)) {
            return MessageDialogFeature.MESSAGE_DIALOG;
        }
        if (SharePhotoContent.class.isAssignableFrom(type)) {
            return MessageDialogFeature.PHOTOS;
        }
        if (ShareVideoContent.class.isAssignableFrom(type)) {
            return MessageDialogFeature.VIDEO;
        }
        if (ShareOpenGraphContent.class.isAssignableFrom(type)) {
            return OpenGraphMessageDialogFeature.OG_MESSAGE_DIALOG;
        }
        if (ShareMessengerGenericTemplateContent.class.isAssignableFrom(type)) {
            return MessageDialogFeature.MESSENGER_GENERIC_TEMPLATE;
        }
        if (ShareMessengerOpenGraphMusicTemplateContent.class.isAssignableFrom(type)) {
            return MessageDialogFeature.MESSENGER_OPEN_GRAPH_MUSIC_TEMPLATE;
        }
        if (ShareMessengerMediaTemplateContent.class.isAssignableFrom(type)) {
            return MessageDialogFeature.MESSENGER_MEDIA_TEMPLATE;
        }
        return null;
    }

    private static void logDialogShare(Context context, ShareContent content, AppCall appCall) {
        DialogFeature dialogFeature = MessageDialog.getFeature(content.getClass());
        String contentType = dialogFeature == MessageDialogFeature.MESSAGE_DIALOG ? "status" : (dialogFeature == MessageDialogFeature.PHOTOS ? "photo" : (dialogFeature == MessageDialogFeature.VIDEO ? "video" : (dialogFeature == OpenGraphMessageDialogFeature.OG_MESSAGE_DIALOG ? "open_graph" : (dialogFeature == MessageDialogFeature.MESSENGER_GENERIC_TEMPLATE ? "GenericTemplate" : (dialogFeature == MessageDialogFeature.MESSENGER_MEDIA_TEMPLATE ? "MediaTemplate" : (dialogFeature == MessageDialogFeature.MESSENGER_OPEN_GRAPH_MUSIC_TEMPLATE ? "OpenGraphMusicTemplate" : "unknown"))))));
        AppEventsLogger logger = AppEventsLogger.newLogger((Context)context);
        Bundle parameters = new Bundle();
        parameters.putString("fb_share_dialog_content_type", contentType);
        parameters.putString("fb_share_dialog_content_uuid", appCall.getCallId().toString());
        parameters.putString("fb_share_dialog_content_page_id", content.getPageId());
        logger.logSdkEvent("fb_messenger_share_dialog_show", null, parameters);
    }

    private class NativeHandler
    extends FacebookDialogBase.ModeHandler {
        private NativeHandler() {
            super((FacebookDialogBase)MessageDialog.this);
        }

        public boolean canShow(ShareContent shareContent, boolean isBestEffort) {
            return shareContent != null && MessageDialog.canShow(shareContent.getClass());
        }

        public AppCall createAppCall(final ShareContent content) {
            ShareContentValidation.validateForMessage((ShareContent)content);
            final AppCall appCall = MessageDialog.this.createBaseAppCall();
            final boolean shouldFailOnDataError = MessageDialog.this.getShouldFailOnDataError();
            MessageDialog.logDialogShare((Context)MessageDialog.this.getActivityContext(), content, appCall);
            DialogPresenter.setupAppCallForNativeDialog((AppCall)appCall, (DialogPresenter.ParameterProvider)new DialogPresenter.ParameterProvider(){

                public Bundle getParameters() {
                    return NativeDialogParameters.create((UUID)appCall.getCallId(), (ShareContent)content, (boolean)shouldFailOnDataError);
                }

                public Bundle getLegacyParameters() {
                    return LegacyNativeDialogParameters.create((UUID)appCall.getCallId(), (ShareContent)content, (boolean)shouldFailOnDataError);
                }
            }, (DialogFeature)MessageDialog.getFeature(content.getClass()));
            return appCall;
        }
    }
}

