/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.places.internal;

import android.content.Context;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.places.internal.BleScanner;
import com.facebook.places.internal.LocationPackage;
import com.facebook.places.internal.LocationPackageRequestParams;
import com.facebook.places.internal.LocationScanner;
import com.facebook.places.internal.ScannerException;
import com.facebook.places.internal.ScannerFactory;
import com.facebook.places.internal.WifiScanner;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class LocationPackageManager {
    private static final String TAG = "LocationPackageManager";

    public static void requestLocationPackage(final LocationPackageRequestParams requestParams, final Listener listener) {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                LocationPackage locationPackage = new LocationPackage();
                try {
                    FutureTask locationScanTask = null;
                    FutureTask wifiScanTask = null;
                    FutureTask bleScanTask = null;
                    if (requestParams.isLocationScanEnabled()) {
                        LocationScanner locationScanner = ScannerFactory.newLocationScanner(FacebookSdk.getApplicationContext(), requestParams);
                        locationScanner.initAndCheckEligibility();
                        locationScanTask = LocationPackageManager.newLocationScanFuture(locationScanner, requestParams);
                        FacebookSdk.getExecutor().execute(locationScanTask);
                    }
                    if (requestParams.isWifiScanEnabled()) {
                        wifiScanTask = LocationPackageManager.newWifiScanFuture(requestParams);
                        FacebookSdk.getExecutor().execute(wifiScanTask);
                    }
                    if (requestParams.isBluetoothScanEnabled()) {
                        bleScanTask = LocationPackageManager.newBluetoothScanFuture(requestParams);
                        FacebookSdk.getExecutor().execute(bleScanTask);
                    }
                    if (bleScanTask != null) {
                        try {
                            LocationPackage bleSensorData = (LocationPackage)bleScanTask.get();
                            locationPackage.ambientBluetoothLe = bleSensorData.ambientBluetoothLe;
                            locationPackage.isBluetoothScanningEnabled = bleSensorData.isBluetoothScanningEnabled;
                        }
                        catch (Exception e) {
                            LocationPackageManager.logException("Exception scanning for bluetooth beacons", e);
                        }
                    }
                    if (wifiScanTask != null) {
                        try {
                            LocationPackage wifiSensorData = (LocationPackage)wifiScanTask.get();
                            locationPackage.isWifiScanningEnabled = wifiSensorData.isWifiScanningEnabled;
                            locationPackage.connectedWifi = wifiSensorData.connectedWifi;
                            locationPackage.ambientWifi = wifiSensorData.ambientWifi;
                        }
                        catch (Exception e) {
                            LocationPackageManager.logException("Exception scanning for wifi access points", e);
                        }
                    }
                    if (locationScanTask != null) {
                        try {
                            LocationPackage locationSensorData = (LocationPackage)locationScanTask.get();
                            locationPackage.locationError = locationSensorData.locationError;
                            locationPackage.location = locationSensorData.location;
                        }
                        catch (Exception e) {
                            LocationPackageManager.logException("Exception getting location", e);
                        }
                    }
                }
                catch (ScannerException e) {
                    LocationPackageManager.logException("Exception scanning for locations", e);
                    locationPackage.locationError = e.type;
                }
                catch (Exception e) {
                    LocationPackageManager.logException("Exception requesting a location package", e);
                }
                listener.onLocationPackage(locationPackage);
            }
        });
    }

    private static FutureTask<LocationPackage> newLocationScanFuture(final LocationScanner locationScanner, LocationPackageRequestParams requestParams) {
        return new FutureTask<LocationPackage>(new Callable<LocationPackage>(){

            @Override
            public LocationPackage call() throws Exception {
                LocationPackage locationPackage = new LocationPackage();
                try {
                    locationPackage.location = locationScanner.getLocation();
                }
                catch (ScannerException e) {
                    locationPackage.locationError = e.type;
                    LocationPackageManager.logException("Exception while getting location", e);
                }
                catch (Exception e) {
                    locationPackage.locationError = ScannerException.Type.UNKNOWN_ERROR;
                }
                return locationPackage;
            }
        });
    }

    private static FutureTask<LocationPackage> newBluetoothScanFuture(final LocationPackageRequestParams requestParams) {
        return new FutureTask<LocationPackage>(new Callable<LocationPackage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LocationPackage call() throws Exception {
                LocationPackage locationPackage = new LocationPackage();
                try {
                    Context context = FacebookSdk.getApplicationContext();
                    BleScanner bleScanner = ScannerFactory.newBleScanner(context, requestParams);
                    bleScanner.initAndCheckEligibility();
                    try {
                        bleScanner.startScanning();
                        try {
                            Thread.sleep(requestParams.getBluetoothScanDurationMs());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    finally {
                        bleScanner.stopScanning();
                    }
                    int errorCode = bleScanner.getErrorCode();
                    if (errorCode == 0) {
                        locationPackage.ambientBluetoothLe = bleScanner.getScanResults();
                        locationPackage.isBluetoothScanningEnabled = true;
                    } else {
                        if (FacebookSdk.isDebugEnabled()) {
                            Utility.logd((String)LocationPackageManager.TAG, (String)String.format(Locale.getDefault(), "Bluetooth LE scan failed with error: %d", errorCode));
                        }
                        locationPackage.isBluetoothScanningEnabled = false;
                    }
                }
                catch (Exception e) {
                    LocationPackageManager.logException("Exception scanning for bluetooth beacons", e);
                    locationPackage.isBluetoothScanningEnabled = false;
                }
                return locationPackage;
            }
        });
    }

    private static FutureTask<LocationPackage> newWifiScanFuture(final LocationPackageRequestParams requestParams) {
        return new FutureTask<LocationPackage>(new Callable<LocationPackage>(){

            @Override
            public LocationPackage call() throws Exception {
                LocationPackage locationPackage = new LocationPackage();
                try {
                    Context context = FacebookSdk.getApplicationContext();
                    WifiScanner wifiScanner = ScannerFactory.newWifiScanner(context, requestParams);
                    wifiScanner.initAndCheckEligibility();
                    locationPackage.connectedWifi = wifiScanner.getConnectedWifi();
                    locationPackage.isWifiScanningEnabled = wifiScanner.isWifiScanningEnabled();
                    if (locationPackage.isWifiScanningEnabled) {
                        locationPackage.ambientWifi = wifiScanner.getWifiScans();
                    }
                }
                catch (Exception e) {
                    LocationPackageManager.logException("Exception scanning for wifi access points", e);
                    locationPackage.isWifiScanningEnabled = false;
                }
                return locationPackage;
            }
        });
    }

    private static void logException(String message, Throwable throwable) {
        if (FacebookSdk.isDebugEnabled()) {
            Log.e((String)TAG, (String)message, (Throwable)throwable);
        }
    }

    public static interface Listener {
        public void onLocationPackage(LocationPackage var1);
    }
}

