/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.messenger;

import android.net.Uri;
import com.facebook.messenger.ShareToMessengerParamsBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ShareToMessengerParams {
    public static final Set<String> VALID_URI_SCHEMES;
    public static final Set<String> VALID_MIME_TYPES;
    public static final Set<String> VALID_EXTERNAL_URI_SCHEMES;
    public final Uri uri;
    public final String mimeType;
    public final String metaData;
    public final Uri externalUri;

    ShareToMessengerParams(ShareToMessengerParamsBuilder builder) {
        this.uri = builder.getUri();
        this.mimeType = builder.getMimeType();
        this.metaData = builder.getMetaData();
        this.externalUri = builder.getExternalUri();
        if (this.uri == null) {
            throw new NullPointerException("Must provide non-null uri");
        }
        if (this.mimeType == null) {
            throw new NullPointerException("Must provide mimeType");
        }
        if (!VALID_URI_SCHEMES.contains(this.uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported URI scheme: " + this.uri.getScheme());
        }
        if (!VALID_MIME_TYPES.contains(this.mimeType)) {
            throw new IllegalArgumentException("Unsupported mime-type: " + this.mimeType);
        }
        if (this.externalUri != null && !VALID_EXTERNAL_URI_SCHEMES.contains(this.externalUri.getScheme())) {
            throw new IllegalArgumentException("Unsupported external uri scheme: " + this.externalUri.getScheme());
        }
    }

    public static ShareToMessengerParamsBuilder newBuilder(Uri uri, String mimeType) {
        return new ShareToMessengerParamsBuilder(uri, mimeType);
    }

    static {
        HashSet<String> validMimeTypes = new HashSet<String>();
        validMimeTypes.add("image/*");
        validMimeTypes.add("image/jpeg");
        validMimeTypes.add("image/png");
        validMimeTypes.add("image/gif");
        validMimeTypes.add("image/webp");
        validMimeTypes.add("video/*");
        validMimeTypes.add("video/mp4");
        validMimeTypes.add("audio/*");
        validMimeTypes.add("audio/mpeg");
        VALID_MIME_TYPES = Collections.unmodifiableSet(validMimeTypes);
        HashSet<String> validUriSchemes = new HashSet<String>();
        validUriSchemes.add("content");
        validUriSchemes.add("android.resource");
        validUriSchemes.add("file");
        VALID_URI_SCHEMES = Collections.unmodifiableSet(validUriSchemes);
        HashSet<String> validExternalUriSchemes = new HashSet<String>();
        validExternalUriSchemes.add("http");
        validExternalUriSchemes.add("https");
        VALID_EXTERNAL_URI_SCHEMES = Collections.unmodifiableSet(validExternalUriSchemes);
    }
}

