/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.login.R;

public class ProfilePictureView
extends FrameLayout {
    public static final String TAG = ProfilePictureView.class.getSimpleName();
    public static final int CUSTOM = -1;
    public static final int SMALL = -2;
    public static final int NORMAL = -3;
    public static final int LARGE = -4;
    private static final int MIN_SIZE = 1;
    private static final boolean IS_CROPPED_DEFAULT_VALUE = true;
    private static final String SUPER_STATE_KEY = "ProfilePictureView_superState";
    private static final String PROFILE_ID_KEY = "ProfilePictureView_profileId";
    private static final String PRESET_SIZE_KEY = "ProfilePictureView_presetSize";
    private static final String IS_CROPPED_KEY = "ProfilePictureView_isCropped";
    private static final String BITMAP_KEY = "ProfilePictureView_bitmap";
    private static final String BITMAP_WIDTH_KEY = "ProfilePictureView_width";
    private static final String BITMAP_HEIGHT_KEY = "ProfilePictureView_height";
    private static final String PENDING_REFRESH_KEY = "ProfilePictureView_refresh";
    private String profileId;
    private int queryHeight = 0;
    private int queryWidth = 0;
    private boolean isCropped = true;
    private Bitmap imageContents;
    private ImageView image;
    private int presetSizeType = -1;
    private ImageRequest lastRequest;
    private OnErrorListener onErrorListener;
    private Bitmap customizedDefaultProfilePicture = null;

    public ProfilePictureView(Context context) {
        super(context);
        this.initialize(context);
    }

    public ProfilePictureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
        this.parseAttributes(attrs);
    }

    public ProfilePictureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(context);
        this.parseAttributes(attrs);
    }

    public final int getPresetSize() {
        return this.presetSizeType;
    }

    public final void setPresetSize(int sizeType) {
        switch (sizeType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                this.presetSizeType = sizeType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Must use a predefined preset size");
            }
        }
        this.requestLayout();
    }

    public final boolean isCropped() {
        return this.isCropped;
    }

    public final void setCropped(boolean showCroppedVersion) {
        this.isCropped = showCroppedVersion;
        this.refreshImage(false);
    }

    public final String getProfileId() {
        return this.profileId;
    }

    public final void setProfileId(@Nullable String profileId) {
        boolean force = false;
        if (Utility.isNullOrEmpty((String)this.profileId) || !this.profileId.equalsIgnoreCase(profileId)) {
            this.setBlankProfilePicture();
            force = true;
        }
        this.profileId = profileId;
        this.refreshImage(force);
    }

    public final OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public final void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public final void setDefaultProfilePicture(Bitmap inputBitmap) {
        this.customizedDefaultProfilePicture = inputBitmap;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        boolean customMeasure = false;
        int newHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int newWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000 && params.height == -2) {
            newHeight = this.getPresetSizeInPixels(true);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
            customMeasure = true;
        }
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 && params.width == -2) {
            newWidth = this.getPresetSizeInPixels(true);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
            customMeasure = true;
        }
        if (customMeasure) {
            this.setMeasuredDimension(newWidth, newHeight);
            this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.refreshImage(false);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle instanceState = new Bundle();
        instanceState.putParcelable(SUPER_STATE_KEY, superState);
        instanceState.putString(PROFILE_ID_KEY, this.profileId);
        instanceState.putInt(PRESET_SIZE_KEY, this.presetSizeType);
        instanceState.putBoolean(IS_CROPPED_KEY, this.isCropped);
        instanceState.putInt(BITMAP_WIDTH_KEY, this.queryWidth);
        instanceState.putInt(BITMAP_HEIGHT_KEY, this.queryHeight);
        instanceState.putBoolean(PENDING_REFRESH_KEY, this.lastRequest != null);
        return instanceState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state.getClass() != Bundle.class) {
            super.onRestoreInstanceState(state);
        } else {
            Bundle instanceState = (Bundle)state;
            super.onRestoreInstanceState(instanceState.getParcelable(SUPER_STATE_KEY));
            this.profileId = instanceState.getString(PROFILE_ID_KEY);
            this.presetSizeType = instanceState.getInt(PRESET_SIZE_KEY);
            this.isCropped = instanceState.getBoolean(IS_CROPPED_KEY);
            this.queryWidth = instanceState.getInt(BITMAP_WIDTH_KEY);
            this.queryHeight = instanceState.getInt(BITMAP_HEIGHT_KEY);
            this.refreshImage(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.lastRequest = null;
    }

    private void initialize(Context context) {
        this.removeAllViews();
        this.image = new ImageView(context);
        FrameLayout.LayoutParams imageLayout = new FrameLayout.LayoutParams(-1, -1);
        this.image.setLayoutParams((ViewGroup.LayoutParams)imageLayout);
        this.image.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.addView((View)this.image);
    }

    private void parseAttributes(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.com_facebook_profile_picture_view);
        this.setPresetSize(a.getInt(R.styleable.com_facebook_profile_picture_view_com_facebook_preset_size, -1));
        this.isCropped = a.getBoolean(R.styleable.com_facebook_profile_picture_view_com_facebook_is_cropped, true);
        a.recycle();
    }

    private void refreshImage(boolean force) {
        boolean changed = this.updateImageQueryParameters();
        if (this.profileId == null || this.profileId.length() == 0 || this.queryWidth == 0 && this.queryHeight == 0) {
            this.setBlankProfilePicture();
        } else if (changed || force) {
            this.sendImageRequest(true);
        }
    }

    private void setBlankProfilePicture() {
        if (this.lastRequest != null) {
            ImageDownloader.cancelRequest((ImageRequest)this.lastRequest);
        }
        if (this.customizedDefaultProfilePicture == null) {
            int blankImageResource = this.isCropped() ? R.drawable.com_facebook_profile_picture_blank_square : R.drawable.com_facebook_profile_picture_blank_portrait;
            this.setImageBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)blankImageResource));
        } else {
            this.updateImageQueryParameters();
            Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)this.customizedDefaultProfilePicture, (int)this.queryWidth, (int)this.queryHeight, (boolean)false);
            this.setImageBitmap(scaledBitmap);
        }
    }

    private void setImageBitmap(Bitmap imageBitmap) {
        if (this.image != null && imageBitmap != null) {
            this.imageContents = imageBitmap;
            this.image.setImageBitmap(imageBitmap);
        }
    }

    private void sendImageRequest(boolean allowCachedResponse) {
        ImageRequest.Builder requestBuilder = new ImageRequest.Builder(this.getContext(), ImageRequest.getProfilePictureUri((String)this.profileId, (int)this.queryWidth, (int)this.queryHeight));
        ImageRequest request = requestBuilder.setAllowCachedRedirects(allowCachedResponse).setCallerTag((Object)this).setCallback(new ImageRequest.Callback(){

            public void onCompleted(ImageResponse response) {
                ProfilePictureView.this.processResponse(response);
            }
        }).build();
        if (this.lastRequest != null) {
            ImageDownloader.cancelRequest((ImageRequest)this.lastRequest);
        }
        this.lastRequest = request;
        ImageDownloader.downloadAsync((ImageRequest)request);
    }

    private void processResponse(ImageResponse response) {
        if (response.getRequest() == this.lastRequest) {
            this.lastRequest = null;
            Bitmap responseImage = response.getBitmap();
            Exception error = response.getError();
            if (error != null) {
                OnErrorListener listener = this.onErrorListener;
                if (listener != null) {
                    listener.onError(new FacebookException("Error in downloading profile picture for profileId: " + this.getProfileId(), (Throwable)error));
                } else {
                    Logger.log((LoggingBehavior)LoggingBehavior.REQUESTS, (int)6, (String)TAG, (String)error.toString());
                }
            } else if (responseImage != null) {
                this.setImageBitmap(responseImage);
                if (response.isCachedRedirect()) {
                    this.sendImageRequest(false);
                }
            }
        }
    }

    private boolean updateImageQueryParameters() {
        int newHeightPx = this.getHeight();
        int newWidthPx = this.getWidth();
        if (newWidthPx < 1 || newHeightPx < 1) {
            return false;
        }
        int presetSize = this.getPresetSizeInPixels(false);
        if (presetSize != 0) {
            newWidthPx = presetSize;
            newHeightPx = presetSize;
        }
        if (newWidthPx <= newHeightPx) {
            newHeightPx = this.isCropped() ? newWidthPx : 0;
        } else {
            newWidthPx = this.isCropped() ? newHeightPx : 0;
        }
        boolean changed = newWidthPx != this.queryWidth || newHeightPx != this.queryHeight;
        this.queryWidth = newWidthPx;
        this.queryHeight = newHeightPx;
        return changed;
    }

    private int getPresetSizeInPixels(boolean forcePreset) {
        int dimensionId;
        switch (this.presetSizeType) {
            case -2: {
                dimensionId = R.dimen.com_facebook_profilepictureview_preset_size_small;
                break;
            }
            case -3: {
                dimensionId = R.dimen.com_facebook_profilepictureview_preset_size_normal;
                break;
            }
            case -4: {
                dimensionId = R.dimen.com_facebook_profilepictureview_preset_size_large;
                break;
            }
            case -1: {
                if (!forcePreset) {
                    return 0;
                }
                dimensionId = R.dimen.com_facebook_profilepictureview_preset_size_normal;
                break;
            }
            default: {
                return 0;
            }
        }
        return this.getResources().getDimensionPixelSize(dimensionId);
    }

    public static interface OnErrorListener {
        public void onError(FacebookException var1);
    }
}

