/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login.widget;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.facebook.AccessToken;
import com.facebook.AccessTokenTracker;
import com.facebook.CallbackManager;
import com.facebook.FacebookButtonBase;
import com.facebook.FacebookCallback;
import com.facebook.FacebookSdk;
import com.facebook.Profile;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.common.R;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.facebook.login.LoginTargetApp;
import com.facebook.login.R;
import com.facebook.login.widget.LoginButton;
import com.facebook.login.widget.ToolTipPopup;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00a9\u00012\u00020\u0001:\b\u00a9\u0001\u00aa\u0001\u00ab\u0001\u00ac\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB9\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010|\u001a\u00020}H\u0003J\u0006\u0010~\u001a\u00020}J*\u0010\u007f\u001a\u00020}2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0015J\u0007\u0010\u0080\u0001\u001a\u00020}J\u0012\u0010\u0081\u0001\u001a\u00020}2\u0007\u0010\u0082\u0001\u001a\u00020\u000eH\u0003J\u0012\u0010\u0083\u0001\u001a\u00020\t2\u0007\u0010\u0084\u0001\u001a\u00020\tH\u0005J\u0012\u0010\u0085\u0001\u001a\u00020\t2\u0007\u0010\u0086\u0001\u001a\u00020\u000eH\u0003J\t\u0010\u0087\u0001\u001a\u00020}H\u0015J\t\u0010\u0088\u0001\u001a\u00020}H\u0015J\u0013\u0010\u0089\u0001\u001a\u00020}2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0015J6\u0010\u008c\u0001\u001a\u00020}2\u0007\u0010\u008d\u0001\u001a\u00020\"2\u0007\u0010\u008e\u0001\u001a\u00020\t2\u0007\u0010\u008f\u0001\u001a\u00020\t2\u0007\u0010\u0090\u0001\u001a\u00020\t2\u0007\u0010\u0091\u0001\u001a\u00020\tH\u0015J\u001b\u0010\u0092\u0001\u001a\u00020}2\u0007\u0010\u0084\u0001\u001a\u00020\t2\u0007\u0010\u0093\u0001\u001a\u00020\tH\u0015J\u001c\u0010\u0094\u0001\u001a\u00020}2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u0097\u0001\u001a\u00020\tH\u0015J+\u0010\u0098\u0001\u001a\u00020}2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0005J \u0010\u0099\u0001\u001a\u00020}2\u0006\u0010\u001e\u001a\u00020\u001d2\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009c\u00010\u009b\u0001J\t\u0010\u009d\u0001\u001a\u00020}H\u0005J\t\u0010\u009e\u0001\u001a\u00020}H\u0005J\t\u0010\u009f\u0001\u001a\u00020}H\u0005J\t\u0010\u00a0\u0001\u001a\u00020}H\u0005J%\u0010Z\u001a\u00020}2\u0017\u0010W\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\u00a1\u0001\"\u0004\u0018\u00010\u000e\u00a2\u0006\u0003\u0010\u00a2\u0001J(\u0010\u00a3\u0001\u001a\u00020}2\u0017\u0010W\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\u00a1\u0001\"\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0003\u0010\u00a2\u0001J\u0017\u0010\u00a3\u0001\u001a\u00020}2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u000e0VH\u0007J(\u0010\u00a4\u0001\u001a\u00020}2\u0017\u0010W\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\u00a1\u0001\"\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0003\u0010\u00a2\u0001J\u0017\u0010\u00a4\u0001\u001a\u00020}2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u000e0VH\u0007J\u0015\u0010\u00a5\u0001\u001a\u00020}2\n\u0010\u00a6\u0001\u001a\u0005\u0018\u00010\u00a7\u0001H\u0003J\u000f\u0010\u00a8\u0001\u001a\u00020}2\u0006\u0010\u001e\u001a\u00020\u001dR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010%R\u000e\u0010&\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\t8UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010/R\u0011\u00102\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0019R$\u00105\u001a\u0002042\u0006\u0010\u0016\u001a\u0002048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\t8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010/R \u0010<\u001a\b\u0012\u0004\u0012\u00020>0=X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR$\u0010D\u001a\u00020C2\u0006\u0010\u0016\u001a\u00020C8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR(\u0010I\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u0019\"\u0004\bK\u0010\u001bR(\u0010L\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u0019\"\u0004\bN\u0010\u001bR(\u0010O\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010\u0019\"\u0004\bQ\u0010\u001bR\u0018\u0010R\u001a\u00060SR\u00020\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR0\u0010W\u001a\b\u0012\u0004\u0012\u00020\u000e0V2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0V8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u0014\u0010\\\u001a\u00020]X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R$\u0010`\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u0011\u0010e\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\bf\u0010bR\u000e\u0010g\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010h\u001a\u00020iX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR\u001a\u0010n\u001a\u00020oX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010q\"\u0004\br\u0010sR\u0010\u0010t\u001a\u0004\u0018\u00010uX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010v\u001a\u00020wX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010y\"\u0004\bz\u0010{\u00a8\u0006\u00ad\u0001"}, d2={"Lcom/facebook/login/widget/LoginButton;", "Lcom/facebook/FacebookButtonBase;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleAttr", "defStyleRes", "analyticsButtonCreatedEventName", "", "analyticsButtonTappedEventName", "(Landroid/content/Context;Landroid/util/AttributeSet;IILjava/lang/String;Ljava/lang/String;)V", "accessTokenTracker", "Lcom/facebook/AccessTokenTracker;", "androidXLoginCaller", "Landroidx/activity/result/ActivityResultLauncher;", "", "value", "authType", "getAuthType", "()Ljava/lang/String;", "setAuthType", "(Ljava/lang/String;)V", "<set-?>", "Lcom/facebook/CallbackManager;", "callbackManager", "getCallbackManager", "()Lcom/facebook/CallbackManager;", "confirmLogout", "", "customButtonRadius", "", "Ljava/lang/Float;", "customButtonTransparency", "Lcom/facebook/login/DefaultAudience;", "defaultAudience", "getDefaultAudience", "()Lcom/facebook/login/DefaultAudience;", "setDefaultAudience", "(Lcom/facebook/login/DefaultAudience;)V", "defaultRequestCode", "getDefaultRequestCode", "()I", "defaultStyleResource", "getDefaultStyleResource", "loggerID", "getLoggerID", "Lcom/facebook/login/LoginBehavior;", "loginBehavior", "getLoginBehavior", "()Lcom/facebook/login/LoginBehavior;", "setLoginBehavior", "(Lcom/facebook/login/LoginBehavior;)V", "loginButtonContinueLabel", "getLoginButtonContinueLabel", "loginManagerLazy", "Lkotlin/Lazy;", "Lcom/facebook/login/LoginManager;", "getLoginManagerLazy", "()Lkotlin/Lazy;", "setLoginManagerLazy", "(Lkotlin/Lazy;)V", "Lcom/facebook/login/LoginTargetApp;", "loginTargetApp", "getLoginTargetApp", "()Lcom/facebook/login/LoginTargetApp;", "setLoginTargetApp", "(Lcom/facebook/login/LoginTargetApp;)V", "loginText", "getLoginText", "setLoginText", "logoutText", "getLogoutText", "setLogoutText", "messengerPageId", "getMessengerPageId", "setMessengerPageId", "newLoginClickListener", "Lcom/facebook/login/widget/LoginButton$LoginClickListener;", "getNewLoginClickListener", "()Lcom/facebook/login/widget/LoginButton$LoginClickListener;", "", "permissions", "getPermissions", "()Ljava/util/List;", "setPermissions", "(Ljava/util/List;)V", "properties", "Lcom/facebook/login/widget/LoginButton$LoginButtonProperties;", "getProperties", "()Lcom/facebook/login/widget/LoginButton$LoginButtonProperties;", "resetMessengerState", "getResetMessengerState", "()Z", "setResetMessengerState", "(Z)V", "shouldSkipAccountDeduplication", "getShouldSkipAccountDeduplication", "toolTipChecked", "toolTipDisplayTime", "", "getToolTipDisplayTime", "()J", "setToolTipDisplayTime", "(J)V", "toolTipMode", "Lcom/facebook/login/widget/LoginButton$ToolTipMode;", "getToolTipMode", "()Lcom/facebook/login/widget/LoginButton$ToolTipMode;", "setToolTipMode", "(Lcom/facebook/login/widget/LoginButton$ToolTipMode;)V", "toolTipPopup", "Lcom/facebook/login/widget/ToolTipPopup;", "toolTipStyle", "Lcom/facebook/login/widget/ToolTipPopup$Style;", "getToolTipStyle", "()Lcom/facebook/login/widget/ToolTipPopup$Style;", "setToolTipStyle", "(Lcom/facebook/login/widget/ToolTipPopup$Style;)V", "checkToolTipSettings", "", "clearPermissions", "configureButton", "dismissToolTip", "displayToolTip", "toolTipString", "getLoginButtonWidth", "widthMeasureSpec", "measureButtonWidth", "text", "onAttachedToWindow", "onDetachedFromWindow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "heightMeasureSpec", "onVisibilityChanged", "changedView", "Landroid/view/View;", "visibility", "parseLoginButtonAttributes", "registerCallback", "callback", "Lcom/facebook/FacebookCallback;", "Lcom/facebook/login/LoginResult;", "setButtonIcon", "setButtonRadius", "setButtonText", "setButtonTransparency", "", "([Ljava/lang/String;)V", "setPublishPermissions", "setReadPermissions", "showToolTipPerSettings", "settings", "Lcom/facebook/internal/FetchedAppSettings;", "unregisterCallback", "Companion", "LoginButtonProperties", "LoginClickListener", "ToolTipMode", "facebook-login_release"})
public class LoginButton
extends FacebookButtonBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean confirmLogout;
    @Nullable
    private String loginText;
    @Nullable
    private String logoutText;
    @NotNull
    private final LoginButtonProperties properties;
    private boolean toolTipChecked;
    @NotNull
    private ToolTipPopup.Style toolTipStyle;
    @NotNull
    private ToolTipMode toolTipMode;
    private long toolTipDisplayTime;
    @Nullable
    private ToolTipPopup toolTipPopup;
    @Nullable
    private AccessTokenTracker accessTokenTracker;
    @NotNull
    private Lazy<? extends LoginManager> loginManagerLazy;
    @Nullable
    private Float customButtonRadius;
    private int customButtonTransparency;
    @NotNull
    private final String loggerID;
    @Nullable
    private CallbackManager callbackManager;
    @Nullable
    private ActivityResultLauncher<Collection<String>> androidXLoginCaller;
    private static final String TAG = LoginButton.class.getName();
    private static final int MAX_BUTTON_TRANSPARENCY = 255;
    private static final int MIN_BUTTON_TRANSPARENCY = 0;

    protected LoginButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes, @NotNull String analyticsButtonCreatedEventName, @NotNull String analyticsButtonTappedEventName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsButtonCreatedEventName, (String)"analyticsButtonCreatedEventName");
        Intrinsics.checkNotNullParameter((Object)analyticsButtonTappedEventName, (String)"analyticsButtonTappedEventName");
        super(context, attrs, defStyleAttr, defStyleRes, analyticsButtonCreatedEventName, analyticsButtonTappedEventName);
        this.properties = new LoginButtonProperties();
        this.toolTipStyle = ToolTipPopup.Style.BLUE;
        this.toolTipMode = ToolTipMode.Companion.getDEFAULT();
        this.toolTipDisplayTime = 6000L;
        this.loginManagerLazy = LazyKt.lazy((Function0)loginManagerLazy.1.INSTANCE);
        this.customButtonTransparency = 255;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
        this.loggerID = string2;
    }

    @Nullable
    public final String getLoginText() {
        return this.loginText;
    }

    public final void setLoginText(@Nullable String value) {
        this.loginText = value;
        this.setButtonText();
    }

    @Nullable
    public final String getLogoutText() {
        return this.logoutText;
    }

    public final void setLogoutText(@Nullable String value) {
        this.logoutText = value;
        this.setButtonText();
    }

    @NotNull
    protected final LoginButtonProperties getProperties() {
        return this.properties;
    }

    @NotNull
    public final ToolTipPopup.Style getToolTipStyle() {
        return this.toolTipStyle;
    }

    public final void setToolTipStyle(@NotNull ToolTipPopup.Style style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"<set-?>");
        this.toolTipStyle = style;
    }

    @NotNull
    public final ToolTipMode getToolTipMode() {
        return this.toolTipMode;
    }

    public final void setToolTipMode(@NotNull ToolTipMode toolTipMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)toolTipMode), (String)"<set-?>");
        this.toolTipMode = toolTipMode;
    }

    public final long getToolTipDisplayTime() {
        return this.toolTipDisplayTime;
    }

    public final void setToolTipDisplayTime(long l) {
        this.toolTipDisplayTime = l;
    }

    @NotNull
    protected final Lazy<LoginManager> getLoginManagerLazy() {
        return this.loginManagerLazy;
    }

    protected final void setLoginManagerLazy(@NotNull Lazy<? extends LoginManager> lazy) {
        Intrinsics.checkNotNullParameter(lazy, (String)"<set-?>");
        this.loginManagerLazy = lazy;
    }

    @NotNull
    public final String getLoggerID() {
        return this.loggerID;
    }

    @Nullable
    public final CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public LoginButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    public LoginButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    public LoginButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyle, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    @NotNull
    public final DefaultAudience getDefaultAudience() {
        return this.properties.getDefaultAudience();
    }

    public final void setDefaultAudience(@NotNull DefaultAudience value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.properties.setDefaultAudience(value);
    }

    @Deprecated(message="Use setPermissions instead", replaceWith=@ReplaceWith(expression="setPermissions", imports={}))
    public final void setReadPermissions(@NotNull List<String> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.properties.setPermissions(permissions);
    }

    @Deprecated(message="Use setPermissions instead", replaceWith=@ReplaceWith(expression="setPermissions", imports={}))
    public final void setReadPermissions(String ... permissions) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.properties.setPermissions(CollectionsKt.listOfNotNull((Object[])Arrays.copyOf(permissions, permissions.length)));
    }

    public final void setPermissions(String ... permissions) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.properties.setPermissions(CollectionsKt.listOfNotNull((Object[])Arrays.copyOf(permissions, permissions.length)));
    }

    @Deprecated(message="Use setPermissions instead", replaceWith=@ReplaceWith(expression="setPermissions", imports={}))
    public final void setPublishPermissions(@NotNull List<String> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.properties.setPermissions(permissions);
    }

    @Deprecated(message="Use setPermissions instead", replaceWith=@ReplaceWith(expression="setPermissions", imports={}))
    public final void setPublishPermissions(String ... permissions) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.properties.setPermissions(CollectionsKt.listOfNotNull((Object[])Arrays.copyOf(permissions, permissions.length)));
    }

    public final void clearPermissions() {
        this.properties.clearPermissions();
    }

    @NotNull
    public final LoginBehavior getLoginBehavior() {
        return this.properties.getLoginBehavior();
    }

    public final void setLoginBehavior(@NotNull LoginBehavior value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.properties.setLoginBehavior(value);
    }

    @NotNull
    public final LoginTargetApp getLoginTargetApp() {
        return this.properties.getLoginTargetApp();
    }

    public final void setLoginTargetApp(@NotNull LoginTargetApp value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.properties.setLoginTargetApp(value);
    }

    @NotNull
    public final String getAuthType() {
        return this.properties.getAuthType();
    }

    public final void setAuthType(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.properties.setAuthType(value);
    }

    @Nullable
    public final String getMessengerPageId() {
        return this.properties.getMessengerPageId();
    }

    public final void setMessengerPageId(@Nullable String value) {
        this.properties.setMessengerPageId(value);
    }

    public final boolean getResetMessengerState() {
        return this.properties.getResetMessengerState();
    }

    public final void setResetMessengerState(boolean value) {
        this.properties.setResetMessengerState(value);
    }

    public final boolean getShouldSkipAccountDeduplication() {
        return this.properties.getShouldSkipAccountDeduplication();
    }

    public final void dismissToolTip() {
        ToolTipPopup toolTipPopup = this.toolTipPopup;
        if (toolTipPopup != null) {
            toolTipPopup.dismiss();
        }
        this.toolTipPopup = null;
    }

    public final void registerCallback(@NotNull CallbackManager callbackManager, @NotNull FacebookCallback<LoginResult> callback) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ((LoginManager)this.loginManagerLazy.getValue()).registerCallback(callbackManager, callback);
        if (this.callbackManager == null) {
            this.callbackManager = callbackManager;
        } else if (this.callbackManager != callbackManager) {
            Log.w((String)TAG, (String)"You're registering a callback on the one Facebook login button with two different callback managers. It's almost wrong and may cause unexpected results. Only the first callback manager will be used for handling activity result with androidx.");
        }
    }

    public final void unregisterCallback(@NotNull CallbackManager callbackManager) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        ((LoginManager)this.loginManagerLazy.getValue()).unregisterCallback(callbackManager);
    }

    @StringRes
    protected final int getLoginButtonContinueLabel() {
        return R.string.com_facebook_loginview_log_in_button_continue;
    }

    protected void onAttachedToWindow() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            AccessTokenTracker accessTokenTracker;
            Context context;
            super.onAttachedToWindow();
            if (this.getContext() instanceof ActivityResultRegistryOwner) {
                context = this.getContext();
                if (context == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.activity.result.ActivityResultRegistryOwner");
                }
                ActivityResultRegistryOwner context2 = (ActivityResultRegistryOwner)context;
                this.androidXLoginCaller = context2.getActivityResultRegistry().register("facebook-login", (ActivityResultContract)((LoginManager)this.loginManagerLazy.getValue()).createLogInActivityResultContract(this.callbackManager, this.loggerID), LoginButton::onAttachedToWindow$lambda-0);
            }
            if ((accessTokenTracker = this.accessTokenTracker) != null) {
                context = accessTokenTracker;
                boolean bl = false;
                boolean bl2 = false;
                Context it = context;
                boolean bl3 = false;
                if (it.isTracking()) {
                    it.startTracking();
                    this.setButtonText();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void canvas2;
            Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
            super.onDraw((Canvas)canvas2);
            if (!this.toolTipChecked && !this.isInEditMode()) {
                this.toolTipChecked = true;
                this.checkToolTipSettings();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showToolTipPerSettings(FetchedAppSettings fetchedAppSettings) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void settings;
            if (settings != null && settings.getNuxEnabled() && this.getVisibility() == 0) {
                this.displayToolTip(settings.getNuxContent());
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void displayToolTip(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void toolTipString;
            ToolTipPopup toolTipPopup = new ToolTipPopup((String)toolTipString, (View)this);
            toolTipPopup.setStyle(this.toolTipStyle);
            toolTipPopup.setNuxDisplayTime(this.toolTipDisplayTime);
            toolTipPopup.show();
            this.toolTipPopup = toolTipPopup;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    private final void checkToolTipSettings() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            ToolTipMode toolTipMode = this.toolTipMode;
            int n = WhenMappings.$EnumSwitchMapping$0[toolTipMode.ordinal()];
            switch (n) {
                case 1: {
                    String appId = Utility.getMetadataApplicationId((Context)this.getContext());
                    FacebookSdk.INSTANCE.getExecutor().execute(() -> LoginButton.checkToolTipSettings$lambda-3(appId, this));
                    break;
                }
                case 2: {
                    String string2 = this.getResources().getString(R.string.com_facebook_tooltip_default);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.string.com_facebook_tooltip_default)");
                    String toolTipString = string2;
                    this.displayToolTip(toolTipString);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void bottom;
            void right;
            void top;
            void left;
            void changed;
            super.onLayout((boolean)changed, (int)left, (int)top, (int)right, (int)bottom);
            this.setButtonText();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected void onDetachedFromWindow() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            super.onDetachedFromWindow();
            AccessTokenTracker accessTokenTracker = this.androidXLoginCaller;
            if (accessTokenTracker != null) {
                accessTokenTracker.unregister();
            }
            accessTokenTracker = this.accessTokenTracker;
            if (accessTokenTracker != null) {
                accessTokenTracker.stopTracking();
            }
            this.dismissToolTip();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onVisibilityChanged(@NotNull View view, int n) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void visibility;
            void changedView;
            Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
            super.onVisibilityChanged((View)changedView, (int)visibility);
            if (visibility != false) {
                this.dismissToolTip();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    @NotNull
    public final List<String> getPermissions() {
        return this.properties.getPermissions();
    }

    public final void setPermissions(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.properties.setPermissions(value);
    }

    /*
     * WARNING - void declaration
     */
    protected void configureButton(@NotNull Context context, @Nullable AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super.configureButton((Context)context2, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
            this.setInternalOnClickListener(this.getNewLoginClickListener());
            this.parseLoginButtonAttributes((Context)context2, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
            if (this.isInEditMode()) {
                this.setBackgroundColor(this.getResources().getColor(R.color.com_facebook_blue));
                this.setLoginText("Continue with Facebook");
            } else {
                this.accessTokenTracker = new AccessTokenTracker(this){
                    final /* synthetic */ LoginButton this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    protected void onCurrentAccessTokenChanged(@Nullable AccessToken oldAccessToken, @Nullable AccessToken currentAccessToken) {
                        this.this$0.setButtonText();
                        this.this$0.setButtonIcon();
                    }
                };
            }
            this.setButtonText();
            this.setButtonRadius();
            this.setButtonTransparency();
            this.setButtonIcon();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    @NotNull
    protected LoginClickListener getNewLoginClickListener() {
        return new LoginClickListener();
    }

    protected int getDefaultStyleResource() {
        return R.style.com_facebook_loginview_default_style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void parseLoginButtonAttributes(@NotNull Context context, @Nullable AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.toolTipMode = ToolTipMode.Companion.getDEFAULT();
            Object object = context2.getTheme().obtainStyledAttributes((AttributeSet)attrs, R.styleable.com_facebook_login_view, (int)defStyleAttr, (int)defStyleRes);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context\n            .theme\n            .obtainStyledAttributes(\n                attrs, R.styleable.com_facebook_login_view, defStyleAttr, defStyleRes)");
            TypedArray styleAttributes = object;
            try {
                this.confirmLogout = styleAttributes.getBoolean(R.styleable.com_facebook_login_view_com_facebook_confirm_logout, true);
                this.setLoginText(styleAttributes.getString(R.styleable.com_facebook_login_view_com_facebook_login_text));
                this.setLogoutText(styleAttributes.getString(R.styleable.com_facebook_login_view_com_facebook_logout_text));
                object = ToolTipMode.Companion.fromInt(styleAttributes.getInt(R.styleable.com_facebook_login_view_com_facebook_tooltip_mode, ToolTipMode.Companion.getDEFAULT().getIntValue()));
                Object object2 = this.toolTipMode = object == null ? ToolTipMode.Companion.getDEFAULT() : object;
                if (styleAttributes.hasValue(R.styleable.com_facebook_login_view_com_facebook_login_button_radius)) {
                    this.customButtonRadius = Float.valueOf(styleAttributes.getDimension(R.styleable.com_facebook_login_view_com_facebook_login_button_radius, 0.0f));
                }
                this.customButtonTransparency = styleAttributes.getInteger(R.styleable.com_facebook_login_view_com_facebook_login_button_transparency, 255);
                int n3 = 0;
                int n4 = this.customButtonTransparency;
                boolean bl = false;
                this.customButtonTransparency = Math.max(n3, n4);
                n3 = 255;
                n4 = this.customButtonTransparency;
                bl = false;
                this.customButtonTransparency = Math.min(n3, n4);
            }
            finally {
                styleAttributes.recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            String string2;
            void widthMeasureSpec;
            Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
            float f = fontMetrics.top;
            boolean bl = false;
            float f2 = Math.abs(f);
            f = fontMetrics.bottom;
            bl = false;
            double d = f2 + Math.abs(f);
            boolean bl2 = false;
            int height = this.getCompoundPaddingTop() + (int)Math.ceil(d) + this.getCompoundPaddingBottom();
            Resources resources = this.getResources();
            int logInWidth = this.getLoginButtonWidth((int)widthMeasureSpec);
            String string3 = this.logoutText;
            if (string3 == null) {
                String string4 = resources.getString(R.string.com_facebook_loginview_log_out_button);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resources.getString(R.string.com_facebook_loginview_log_out_button)");
                string2 = string4;
            } else {
                string2 = string3;
            }
            String text = string2;
            int logOutWidth = this.measureButtonWidth(text);
            boolean bl3 = false;
            int width = Button.resolveSize((int)Math.max(logInWidth, logOutWidth), (int)widthMeasureSpec);
            this.setMeasuredDimension(width, height);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final int getLoginButtonWidth(int n) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            void widthMeasureSpec;
            Resources resources = this.getResources();
            int logInWidth = 0;
            String text = this.loginText;
            int width = 0;
            if (text == null && (width = Button.resolveSize((int)(logInWidth = this.measureButtonWidth(text = resources.getString(R.string.com_facebook_loginview_log_in_button_continue))), (int)widthMeasureSpec)) < logInWidth) {
                text = resources.getString(R.string.com_facebook_loginview_log_in_button);
            }
            logInWidth = this.measureButtonWidth(text);
            return logInWidth;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int measureButtonWidth(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            void text;
            int textWidth = this.measureTextWidth((String)text);
            return this.getCompoundPaddingLeft() + this.getCompoundDrawablePadding() + textWidth + this.getCompoundPaddingRight();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    protected final void setButtonText() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            Resources resources = this.getResources();
            if (!this.isInEditMode() && AccessToken.Companion.isCurrentAccessTokenActive()) {
                String string2 = this.logoutText;
                this.setText(string2 == null ? (CharSequence)resources.getString(R.string.com_facebook_loginview_log_out_button) : (CharSequence)string2);
            } else if (this.loginText != null) {
                this.setText(this.loginText);
            } else {
                int measuredWidth;
                String string3 = resources.getString(this.getLoginButtonContinueLabel());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(loginButtonContinueLabel)");
                String text = string3;
                int width = this.getWidth();
                if (width != 0 && (measuredWidth = this.measureButtonWidth(text)) > width) {
                    String string4 = resources.getString(R.string.com_facebook_loginview_log_in_button);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resources.getString(R.string.com_facebook_loginview_log_in_button)");
                    text = string4;
                }
                this.setText(text);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected final void setButtonIcon() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            this.setCompoundDrawablesWithIntrinsicBounds(AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.com_facebook_button_icon), null, null, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    @TargetApi(value=29)
    protected final void setButtonRadius() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            int n;
            int n2;
            Float f = this.customButtonRadius;
            if (f == null) {
                return;
            }
            float customButtonRadius = f.floatValue();
            Drawable buttonDrawable = this.getBackground();
            if (Build.VERSION.SDK_INT >= 29 && buttonDrawable instanceof StateListDrawable && (n2 = 0) < (n = ((StateListDrawable)buttonDrawable).getStateCount())) {
                do {
                    int i;
                    GradientDrawable childDrawable;
                    Drawable drawable2;
                    if ((drawable2 = (childDrawable = (drawable2 = ((StateListDrawable)buttonDrawable).getStateDrawable(i = n2++)) instanceof GradientDrawable ? (GradientDrawable)drawable2 : null)) == null) continue;
                    Drawable drawable3 = drawable2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Drawable it = drawable3;
                    boolean bl3 = false;
                    it.setCornerRadius(customButtonRadius);
                } while (n2 < n);
            }
            if (buttonDrawable instanceof GradientDrawable) {
                ((GradientDrawable)buttonDrawable).setCornerRadius(customButtonRadius);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected final void setButtonTransparency() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            this.getBackground().setAlpha(this.customButtonTransparency);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected int getDefaultRequestCode() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            return CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    private static final void onAttachedToWindow$lambda-0(CallbackManager.ActivityResultParameters it) {
    }

    private static final void checkToolTipSettings$lambda-3$lambda-2(LoginButton this$0, FetchedAppSettings $settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.showToolTipPerSettings($settings);
    }

    private static final void checkToolTipSettings$lambda-3(String $appId, LoginButton this$0) {
        Intrinsics.checkNotNullParameter((Object)$appId, (String)"$appId");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings((String)$appId, (boolean)false);
        this$0.getActivity().runOnUiThread(() -> LoginButton.checkToolTipSettings$lambda-3$lambda-2(this$0, settings));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/facebook/login/widget/LoginButton$ToolTipMode;", "", "stringValue", "", "intValue", "", "(Ljava/lang/String;ILjava/lang/String;I)V", "getIntValue", "()I", "toString", "AUTOMATIC", "DISPLAY_ALWAYS", "NEVER_DISPLAY", "Companion", "facebook-login_release"})
    public static final class ToolTipMode
    extends Enum<ToolTipMode> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String stringValue;
        private final int intValue;
        @NotNull
        private static final ToolTipMode DEFAULT;
        public static final /* enum */ ToolTipMode AUTOMATIC;
        public static final /* enum */ ToolTipMode DISPLAY_ALWAYS;
        public static final /* enum */ ToolTipMode NEVER_DISPLAY;
        private static final /* synthetic */ ToolTipMode[] $VALUES;

        private ToolTipMode(String stringValue, int intValue) {
            this.stringValue = stringValue;
            this.intValue = intValue;
        }

        public final int getIntValue() {
            return this.intValue;
        }

        @NotNull
        public String toString() {
            return this.stringValue;
        }

        public static ToolTipMode[] values() {
            ToolTipMode[] toolTipModeArray = $VALUES;
            return Arrays.copyOf(toolTipModeArray, toolTipModeArray.length);
        }

        public static ToolTipMode valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(ToolTipMode.class, value);
        }

        static {
            AUTOMATIC = new ToolTipMode("automatic", 0);
            DISPLAY_ALWAYS = new ToolTipMode("display_always", 1);
            NEVER_DISPLAY = new ToolTipMode("never_display", 2);
            $VALUES = toolTipModeArray = new ToolTipMode[]{ToolTipMode.AUTOMATIC, ToolTipMode.DISPLAY_ALWAYS, ToolTipMode.NEVER_DISPLAY};
            Companion = new Companion(null);
            DEFAULT = AUTOMATIC;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/facebook/login/widget/LoginButton$ToolTipMode$Companion;", "", "()V", "DEFAULT", "Lcom/facebook/login/widget/LoginButton$ToolTipMode;", "getDEFAULT", "()Lcom/facebook/login/widget/LoginButton$ToolTipMode;", "fromInt", "enumValue", "", "facebook-login_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ToolTipMode getDEFAULT() {
                return DEFAULT;
            }

            @Nullable
            public final ToolTipMode fromInt(int enumValue) {
                ToolTipMode toolTipMode;
                block1: {
                    ToolTipMode[] toolTipModeArray = ToolTipMode.values();
                    boolean bl = false;
                    ToolTipMode[] toolTipModeArray2 = toolTipModeArray;
                    boolean bl2 = false;
                    ToolTipMode[] toolTipModeArray3 = toolTipModeArray2;
                    int n = toolTipModeArray3.length;
                    for (int i = 0; i < n; ++i) {
                        ToolTipMode toolTipMode2;
                        ToolTipMode it = toolTipMode2 = toolTipModeArray3[i];
                        boolean bl3 = false;
                        if (!(it.getIntValue() == enumValue)) continue;
                        toolTipMode = toolTipMode2;
                        break block1;
                    }
                    toolTipMode = null;
                }
                return toolTipMode;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010.\u001a\u00020/R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010+\u001a\u00020%2\u0006\u0010*\u001a\u00020%@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010'\"\u0004\b-\u0010)\u00a8\u00060"}, d2={"Lcom/facebook/login/widget/LoginButton$LoginButtonProperties;", "", "()V", "authType", "", "getAuthType", "()Ljava/lang/String;", "setAuthType", "(Ljava/lang/String;)V", "defaultAudience", "Lcom/facebook/login/DefaultAudience;", "getDefaultAudience", "()Lcom/facebook/login/DefaultAudience;", "setDefaultAudience", "(Lcom/facebook/login/DefaultAudience;)V", "loginBehavior", "Lcom/facebook/login/LoginBehavior;", "getLoginBehavior", "()Lcom/facebook/login/LoginBehavior;", "setLoginBehavior", "(Lcom/facebook/login/LoginBehavior;)V", "loginTargetApp", "Lcom/facebook/login/LoginTargetApp;", "getLoginTargetApp", "()Lcom/facebook/login/LoginTargetApp;", "setLoginTargetApp", "(Lcom/facebook/login/LoginTargetApp;)V", "messengerPageId", "getMessengerPageId", "setMessengerPageId", "permissions", "", "getPermissions", "()Ljava/util/List;", "setPermissions", "(Ljava/util/List;)V", "resetMessengerState", "", "getResetMessengerState", "()Z", "setResetMessengerState", "(Z)V", "<set-?>", "shouldSkipAccountDeduplication", "getShouldSkipAccountDeduplication", "setShouldSkipAccountDeduplication", "clearPermissions", "", "facebook-login_release"})
    public static class LoginButtonProperties {
        @NotNull
        private DefaultAudience defaultAudience = DefaultAudience.FRIENDS;
        @NotNull
        private List<String> permissions = CollectionsKt.emptyList();
        @NotNull
        private LoginBehavior loginBehavior = LoginBehavior.NATIVE_WITH_FALLBACK;
        @NotNull
        private String authType = "rerequest";
        @NotNull
        private LoginTargetApp loginTargetApp = LoginTargetApp.FACEBOOK;
        private boolean shouldSkipAccountDeduplication;
        @Nullable
        private String messengerPageId;
        private boolean resetMessengerState;

        @NotNull
        public final DefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        public final void setDefaultAudience(@NotNull DefaultAudience defaultAudience) {
            Intrinsics.checkNotNullParameter((Object)defaultAudience, (String)"<set-?>");
            this.defaultAudience = defaultAudience;
        }

        @NotNull
        public final List<String> getPermissions() {
            return this.permissions;
        }

        public final void setPermissions(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.permissions = list;
        }

        @NotNull
        public final LoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        public final void setLoginBehavior(@NotNull LoginBehavior loginBehavior) {
            Intrinsics.checkNotNullParameter((Object)loginBehavior, (String)"<set-?>");
            this.loginBehavior = loginBehavior;
        }

        @NotNull
        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.authType = string;
        }

        @NotNull
        public final LoginTargetApp getLoginTargetApp() {
            return this.loginTargetApp;
        }

        public final void setLoginTargetApp(@NotNull LoginTargetApp loginTargetApp) {
            Intrinsics.checkNotNullParameter((Object)loginTargetApp, (String)"<set-?>");
            this.loginTargetApp = loginTargetApp;
        }

        public final boolean getShouldSkipAccountDeduplication() {
            return this.shouldSkipAccountDeduplication;
        }

        protected final void setShouldSkipAccountDeduplication(boolean bl) {
            this.shouldSkipAccountDeduplication = bl;
        }

        @Nullable
        public final String getMessengerPageId() {
            return this.messengerPageId;
        }

        public final void setMessengerPageId(@Nullable String string) {
            this.messengerPageId = string;
        }

        public final boolean getResetMessengerState() {
            return this.resetMessengerState;
        }

        public final void setResetMessengerState(boolean bl) {
            this.resetMessengerState = bl;
        }

        public final void clearPermissions() {
            this.permissions = CollectionsKt.emptyList();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0095\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0004J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004R\u0014\u0010\u0003\u001a\u00020\u00048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/facebook/login/widget/LoginButton$LoginClickListener;", "Landroid/view/View$OnClickListener;", "(Lcom/facebook/login/widget/LoginButton;)V", "isFamilyLogin", "", "()Z", "loginTargetApp", "Lcom/facebook/login/LoginTargetApp;", "getLoginTargetApp", "()Lcom/facebook/login/LoginTargetApp;", "getLoginManager", "Lcom/facebook/login/LoginManager;", "onClick", "", "v", "Landroid/view/View;", "performLogin", "performLogout", "context", "Landroid/content/Context;", "facebook-login_release"})
    protected class LoginClickListener
    implements View.OnClickListener {
        public LoginClickListener() {
            Intrinsics.checkNotNullParameter((Object)((Object)LoginButton.this), (String)"this$0");
        }

        /*
         * WARNING - void declaration
         */
        public void onClick(@NotNull View view) {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                void v;
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                LoginButton.this.callExternalOnClickListener((View)v);
                AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
                boolean accessTokenActive = AccessToken.Companion.isCurrentAccessTokenActive();
                if (accessTokenActive) {
                    Context context = LoginButton.this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    this.performLogout(context);
                } else {
                    this.performLogin();
                }
                InternalAppEventsLogger logger = new InternalAppEventsLogger(LoginButton.this.getContext());
                Bundle parameters = new Bundle();
                parameters.putInt("logging_in", accessToken != null ? 0 : 1);
                parameters.putInt("access_token_expired", accessTokenActive ? 1 : 0);
                logger.logEventImplicitly("fb_login_view_usage", parameters);
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }

        protected final void performLogin() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                LoginManager loginManager = this.getLoginManager();
                ActivityResultLauncher androidXLoginCaller = LoginButton.this.androidXLoginCaller;
                if (androidXLoginCaller != null) {
                    LoginManager.FacebookLoginActivityResultContract resultContact = (LoginManager.FacebookLoginActivityResultContract)androidXLoginCaller.getContract();
                    CallbackManager callbackManager = LoginButton.this.getCallbackManager();
                    resultContact.setCallbackManager(callbackManager == null ? (CallbackManager)new CallbackManagerImpl() : callbackManager);
                    androidXLoginCaller.launch(LoginButton.this.getProperties().getPermissions());
                } else if (LoginButton.this.getFragment() != null) {
                    androidx.fragment.app.Fragment fragment = LoginButton.this.getFragment();
                    if (fragment != null) {
                        androidx.fragment.app.Fragment fragment2 = fragment;
                        LoginButton loginButton = LoginButton.this;
                        boolean bl = false;
                        boolean bl2 = false;
                        androidx.fragment.app.Fragment it = fragment2;
                        boolean bl3 = false;
                        loginManager.logIn(it, (Collection)loginButton.getProperties().getPermissions(), loginButton.getLoggerID());
                    }
                } else if (LoginButton.this.getNativeFragment() != null) {
                    Fragment fragment = LoginButton.this.getNativeFragment();
                    if (fragment != null) {
                        Fragment fragment3 = fragment;
                        LoginButton loginButton = LoginButton.this;
                        boolean bl = false;
                        boolean bl4 = false;
                        Fragment it = fragment3;
                        boolean bl5 = false;
                        loginManager.logIn(it, (Collection)loginButton.getProperties().getPermissions(), loginButton.getLoggerID());
                    }
                } else {
                    loginManager.logIn(LoginButton.this.getActivity(), (Collection)LoginButton.this.getProperties().getPermissions(), LoginButton.this.getLoggerID());
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected final void performLogout(@NotNull Context context) {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                void context2;
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                LoginManager loginManager = this.getLoginManager();
                if (LoginButton.this.confirmLogout) {
                    Object object;
                    Profile profile;
                    String string2 = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_log_out_action);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.string.com_facebook_loginview_log_out_action)");
                    String logout = string2;
                    String string3 = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_cancel_action);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(R.string.com_facebook_loginview_cancel_action)");
                    String cancel = string3;
                    Object message = null;
                    Object object2 = profile = Profile.Companion.getCurrentProfile();
                    if ((object2 == null ? null : object2.getName()) != null) {
                        object2 = StringCompanionObject.INSTANCE;
                        String string4 = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_as);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resources.getString(R.string.com_facebook_loginview_logged_in_as)");
                        Object[] objectArray = new Object[]{profile.getName()};
                        boolean bl = false;
                        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                        object = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                    } else {
                        object2 = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_using_facebook);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n          resources.getString(R.string.com_facebook_loginview_logged_in_using_facebook)\n        }");
                        object = object2;
                    }
                    message = object;
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)context2);
                    builder.setMessage((CharSequence)message).setCancelable(true).setPositiveButton((CharSequence)logout, (arg_0, arg_1) -> LoginClickListener.performLogout$lambda-2(loginManager, arg_0, arg_1)).setNegativeButton((CharSequence)cancel, null);
                    builder.create().show();
                } else {
                    loginManager.logOut();
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }

        @NotNull
        protected LoginManager getLoginManager() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return null;
            }
            try {
                LoginManager manager = LoginManager.Companion.getInstance();
                manager.setDefaultAudience(LoginButton.this.getDefaultAudience());
                manager.setLoginBehavior(LoginButton.this.getLoginBehavior());
                manager.setLoginTargetApp(this.getLoginTargetApp());
                manager.setAuthType(LoginButton.this.getAuthType());
                manager.setFamilyLogin(this.isFamilyLogin());
                manager.setShouldSkipAccountDeduplication(LoginButton.this.getShouldSkipAccountDeduplication());
                manager.setMessengerPageId(LoginButton.this.getMessengerPageId());
                manager.setResetMessengerState(LoginButton.this.getResetMessengerState());
                return manager;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return null;
            }
        }

        @NotNull
        protected final LoginTargetApp getLoginTargetApp() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return null;
            }
            try {
                return LoginTargetApp.FACEBOOK;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return null;
            }
        }

        protected final boolean isFamilyLogin() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return false;
            }
            try {
                return false;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return false;
            }
        }

        private static final void performLogout$lambda-2(LoginManager loginManager, DialogInterface dialogInterface, int n) {
            if (CrashShieldHandler.isObjectCrashing(LoginClickListener.class)) {
                return;
            }
            try {
                LoginManager $loginManager;
                Intrinsics.checkNotNullParameter((Object)$loginManager, (String)"$loginManager");
                $loginManager.logOut();
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, LoginClickListener.class);
                return;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/login/widget/LoginButton$Companion;", "", "()V", "MAX_BUTTON_TRANSPARENCY", "", "MIN_BUTTON_TRANSPARENCY", "TAG", "", "kotlin.jvm.PlatformType", "facebook-login_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolTipMode.values().length];
            nArray[ToolTipMode.AUTOMATIC.ordinal()] = 1;
            nArray[ToolTipMode.DISPLAY_ALWAYS.ordinal()] = 2;
            nArray[ToolTipMode.NEVER_DISPLAY.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

