/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login.widget;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.facebook.AccessToken;
import com.facebook.AccessTokenTracker;
import com.facebook.CallbackManager;
import com.facebook.FacebookButtonBase;
import com.facebook.FacebookCallback;
import com.facebook.FacebookSdk;
import com.facebook.Profile;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.common.R;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.facebook.login.LoginTargetApp;
import com.facebook.login.R;
import com.facebook.login.widget.ToolTipPopup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class LoginButton
extends FacebookButtonBase {
    private static final String TAG = LoginButton.class.getName();
    private static final int MAX_BUTTON_TRANSPARENCY = 255;
    private static final int MIN_BUTTON_TRANSPARENCY = 0;
    private boolean confirmLogout;
    private String loginText;
    private String logoutText;
    protected LoginButtonProperties properties = new LoginButtonProperties();
    private String loginLogoutEventName = "fb_login_view_usage";
    private boolean toolTipChecked;
    private ToolTipPopup.Style toolTipStyle = ToolTipPopup.Style.BLUE;
    private ToolTipMode toolTipMode;
    private long toolTipDisplayTime = 6000L;
    private ToolTipPopup toolTipPopup;
    private AccessTokenTracker accessTokenTracker;
    private LoginManager loginManager;
    private Float customButtonRadius;
    private int customButtonTransparency = 255;
    private final String loggerID = UUID.randomUUID().toString();
    @Nullable
    private CallbackManager callbackManager = null;
    @Nullable
    private ActivityResultLauncher<Collection<? extends String>> androidXLoginCaller = null;

    public LoginButton(Context context) {
        this(context, null, 0, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    public LoginButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    public LoginButton(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    protected LoginButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, String analyticsButtonCreatedEventName, String analyticsButtonTappedEventName) {
        super(context, attrs, defStyleAttr, defStyleRes, analyticsButtonCreatedEventName, analyticsButtonTappedEventName);
    }

    public void setLoginText(String loginText) {
        this.loginText = loginText;
        this.setButtonText();
    }

    public void setLogoutText(String logoutText) {
        this.logoutText = logoutText;
        this.setButtonText();
    }

    public void setDefaultAudience(DefaultAudience defaultAudience) {
        this.properties.setDefaultAudience(defaultAudience);
    }

    public DefaultAudience getDefaultAudience() {
        return this.properties.getDefaultAudience();
    }

    public void setReadPermissions(List<String> permissions) {
        this.properties.setPermissions(permissions);
    }

    public void setReadPermissions(String ... permissions) {
        this.properties.setPermissions(Arrays.asList(permissions));
    }

    public void setPermissions(List<String> permissions) {
        this.properties.setPermissions(permissions);
    }

    public void setPermissions(String ... permissions) {
        this.properties.setPermissions(Arrays.asList(permissions));
    }

    public void setPublishPermissions(List<String> permissions) {
        this.properties.setPermissions(permissions);
    }

    public void setPublishPermissions(String ... permissions) {
        this.properties.setPermissions(Arrays.asList(permissions));
    }

    public void clearPermissions() {
        this.properties.clearPermissions();
    }

    public void setLoginBehavior(LoginBehavior loginBehavior) {
        this.properties.setLoginBehavior(loginBehavior);
    }

    public LoginBehavior getLoginBehavior() {
        return this.properties.getLoginBehavior();
    }

    public void setLoginTargetApp(LoginTargetApp targetApp) {
        this.properties.setLoginTargetApp(targetApp);
    }

    public LoginTargetApp getLoginTargetApp() {
        return this.properties.getLoginTargetApp();
    }

    public String getAuthType() {
        return this.properties.getAuthType();
    }

    @Nullable
    public String getMessengerPageId() {
        return this.properties.getMessengerPageId();
    }

    public boolean getResetMessengerState() {
        return this.properties.getResetMessengerState();
    }

    public void setAuthType(String authType) {
        this.properties.setAuthType(authType);
    }

    public void setMessengerPageId(String messengerPageId) {
        this.properties.setMessengerPageId(messengerPageId);
    }

    public void setResetMessengerState(boolean resetMessengerState) {
        this.properties.setResetMessengerState(resetMessengerState);
    }

    public void setToolTipStyle(ToolTipPopup.Style toolTipStyle) {
        this.toolTipStyle = toolTipStyle;
    }

    public void setToolTipMode(ToolTipMode toolTipMode) {
        this.toolTipMode = toolTipMode;
    }

    public ToolTipMode getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipDisplayTime(long displayTime) {
        this.toolTipDisplayTime = displayTime;
    }

    public boolean getShouldSkipAccountDeduplication() {
        return this.properties.getShouldSkipAccountDeduplication();
    }

    public long getToolTipDisplayTime() {
        return this.toolTipDisplayTime;
    }

    public String getLoggerID() {
        return this.loggerID;
    }

    public void dismissToolTip() {
        if (this.toolTipPopup != null) {
            this.toolTipPopup.dismiss();
            this.toolTipPopup = null;
        }
    }

    public void registerCallback(CallbackManager callbackManager, FacebookCallback<LoginResult> callback) {
        this.getLoginManager().registerCallback(callbackManager, callback);
        if (this.callbackManager == null) {
            this.callbackManager = callbackManager;
        } else if (this.callbackManager != callbackManager) {
            Log.w((String)TAG, (String)"You're registering a callback on the one Facebook login button with two different callback managers. It's almost wrong and may cause unexpected results. Only the first callback manager will be used for handling activity result with androidx.");
        }
    }

    public void unregisterCallback(CallbackManager callbackManager) {
        this.getLoginManager().unregisterCallback(callbackManager);
    }

    @Nullable
    public CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    @StringRes
    protected int getLoginButtonContinueLabel() {
        return R.string.com_facebook_loginview_log_in_button_continue;
    }

    @AutoHandleExceptions
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getContext() instanceof ActivityResultRegistryOwner) {
            ActivityResultRegistryOwner context = (ActivityResultRegistryOwner)this.getContext();
            this.androidXLoginCaller = context.getActivityResultRegistry().register("facebook-login", (ActivityResultContract)this.getLoginManager().createLogInActivityResultContract(this.callbackManager, this.loggerID), (ActivityResultCallback)new ActivityResultCallback<CallbackManager.ActivityResultParameters>(){

                public void onActivityResult(CallbackManager.ActivityResultParameters result) {
                }
            });
        }
        if (this.accessTokenTracker != null && !this.accessTokenTracker.isTracking()) {
            this.accessTokenTracker.startTracking();
            this.setButtonText();
        }
    }

    @AutoHandleExceptions
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.toolTipChecked && !this.isInEditMode()) {
            this.toolTipChecked = true;
            this.checkToolTipSettings();
        }
    }

    @AutoHandleExceptions
    private void showToolTipPerSettings(FetchedAppSettings settings) {
        if (settings != null && settings.getNuxEnabled() && this.getVisibility() == 0) {
            String toolTipString = settings.getNuxContent();
            this.displayToolTip(toolTipString);
        }
    }

    @AutoHandleExceptions
    private void displayToolTip(String toolTipString) {
        this.toolTipPopup = new ToolTipPopup(toolTipString, (View)this);
        this.toolTipPopup.setStyle(this.toolTipStyle);
        this.toolTipPopup.setNuxDisplayTime(this.toolTipDisplayTime);
        this.toolTipPopup.show();
    }

    @AutoHandleExceptions
    private void checkToolTipSettings() {
        switch (this.toolTipMode) {
            case AUTOMATIC: {
                final String appId = Utility.getMetadataApplicationId((Context)this.getContext());
                FacebookSdk.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        final FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings((String)appId, (boolean)false);
                        LoginButton.this.getActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                LoginButton.this.showToolTipPerSettings(settings);
                            }
                        });
                    }
                });
                break;
            }
            case DISPLAY_ALWAYS: {
                String toolTipString = this.getResources().getString(R.string.com_facebook_tooltip_default);
                this.displayToolTip(toolTipString);
                break;
            }
        }
    }

    @AutoHandleExceptions
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setButtonText();
    }

    @AutoHandleExceptions
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.androidXLoginCaller != null) {
            this.androidXLoginCaller.unregister();
        }
        if (this.accessTokenTracker != null) {
            this.accessTokenTracker.stopTracking();
        }
        this.dismissToolTip();
    }

    @AutoHandleExceptions
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            this.dismissToolTip();
        }
    }

    List<String> getPermissions() {
        return this.properties.getPermissions();
    }

    void setProperties(LoginButtonProperties properties) {
        this.properties = properties;
    }

    @AutoHandleExceptions
    protected void configureButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super.configureButton(context, attrs, defStyleAttr, defStyleRes);
        this.setInternalOnClickListener(this.getNewLoginClickListener());
        this.parseLoginButtonAttributes(context, attrs, defStyleAttr, defStyleRes);
        if (this.isInEditMode()) {
            this.setBackgroundColor(this.getResources().getColor(R.color.com_facebook_blue));
            this.loginText = "Continue with Facebook";
        } else {
            this.accessTokenTracker = new AccessTokenTracker(){

                protected void onCurrentAccessTokenChanged(AccessToken oldAccessToken, AccessToken currentAccessToken) {
                    LoginButton.this.setButtonText();
                    LoginButton.this.setButtonIcon();
                }
            };
        }
        this.setButtonText();
        this.setButtonRadius();
        this.setButtonTransparency();
        this.setButtonIcon();
    }

    protected LoginClickListener getNewLoginClickListener() {
        return new LoginClickListener();
    }

    protected int getDefaultStyleResource() {
        return R.style.com_facebook_loginview_default_style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoHandleExceptions
    protected void parseLoginButtonAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.toolTipMode = ToolTipMode.DEFAULT;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.com_facebook_login_view, defStyleAttr, defStyleRes);
        try {
            this.confirmLogout = a.getBoolean(R.styleable.com_facebook_login_view_com_facebook_confirm_logout, true);
            this.loginText = a.getString(R.styleable.com_facebook_login_view_com_facebook_login_text);
            this.logoutText = a.getString(R.styleable.com_facebook_login_view_com_facebook_logout_text);
            this.toolTipMode = ToolTipMode.fromInt(a.getInt(R.styleable.com_facebook_login_view_com_facebook_tooltip_mode, ToolTipMode.DEFAULT.getValue()));
            if (a.hasValue(R.styleable.com_facebook_login_view_com_facebook_login_button_radius)) {
                this.customButtonRadius = Float.valueOf(a.getDimension(R.styleable.com_facebook_login_view_com_facebook_login_button_radius, 0.0f));
            }
            this.customButtonTransparency = a.getInteger(R.styleable.com_facebook_login_view_com_facebook_login_button_transparency, 255);
            if (this.customButtonTransparency < 0) {
                this.customButtonTransparency = 0;
            }
            if (this.customButtonTransparency > 255) {
                this.customButtonTransparency = 255;
            }
        }
        finally {
            a.recycle();
        }
    }

    @AutoHandleExceptions
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        int height = this.getCompoundPaddingTop() + (int)Math.ceil(Math.abs(fontMetrics.top) + Math.abs(fontMetrics.bottom)) + this.getCompoundPaddingBottom();
        Resources resources = this.getResources();
        int logInWidth = this.getLoginButtonWidth(widthMeasureSpec);
        String text = this.logoutText;
        if (text == null) {
            text = resources.getString(R.string.com_facebook_loginview_log_out_button);
        }
        int logOutWidth = this.measureButtonWidth(text);
        int width = LoginButton.resolveSize((int)Math.max(logInWidth, logOutWidth), (int)widthMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    @AutoHandleExceptions
    protected int getLoginButtonWidth(int widthMeasureSpec) {
        int logInWidth;
        int width;
        Resources resources = this.getResources();
        String text = this.loginText;
        if (text == null && (width = LoginButton.resolveSize((int)(logInWidth = this.measureButtonWidth(text = resources.getString(R.string.com_facebook_loginview_log_in_button_continue))), (int)widthMeasureSpec)) < logInWidth) {
            text = resources.getString(R.string.com_facebook_loginview_log_in_button);
        }
        logInWidth = this.measureButtonWidth(text);
        return logInWidth;
    }

    @AutoHandleExceptions
    private int measureButtonWidth(String text) {
        int textWidth = this.measureTextWidth(text);
        return this.getCompoundPaddingLeft() + this.getCompoundDrawablePadding() + textWidth + this.getCompoundPaddingRight();
    }

    @AutoHandleExceptions
    protected void setButtonText() {
        Resources resources = this.getResources();
        if (!this.isInEditMode() && AccessToken.isCurrentAccessTokenActive()) {
            this.setText(this.logoutText != null ? this.logoutText : resources.getString(R.string.com_facebook_loginview_log_out_button));
        } else if (this.loginText != null) {
            this.setText(this.loginText);
        } else {
            int measuredWidth;
            String text = resources.getString(this.getLoginButtonContinueLabel());
            int width = this.getWidth();
            if (width != 0 && (measuredWidth = this.measureButtonWidth(text)) > width) {
                text = resources.getString(R.string.com_facebook_loginview_log_in_button);
            }
            this.setText(text);
        }
    }

    @AutoHandleExceptions
    protected void setButtonIcon() {
        this.setCompoundDrawablesWithIntrinsicBounds(AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.com_facebook_button_icon), null, null, null);
    }

    @TargetApi(value=29)
    @AutoHandleExceptions
    protected void setButtonRadius() {
        if (this.customButtonRadius == null) {
            return;
        }
        Drawable buttonDrawable = this.getBackground();
        if (Build.VERSION.SDK_INT >= 29 && buttonDrawable instanceof StateListDrawable) {
            StateListDrawable parentDrawable = (StateListDrawable)buttonDrawable;
            for (int i = 0; i < parentDrawable.getStateCount(); ++i) {
                GradientDrawable childDrawable = (GradientDrawable)parentDrawable.getStateDrawable(i);
                if (childDrawable == null) continue;
                childDrawable.setCornerRadius(this.customButtonRadius.floatValue());
            }
        }
        if (buttonDrawable instanceof GradientDrawable) {
            GradientDrawable gradientDrawable = (GradientDrawable)buttonDrawable;
            gradientDrawable.setCornerRadius(this.customButtonRadius.floatValue());
        }
    }

    @AutoHandleExceptions
    protected void setButtonTransparency() {
        Drawable drawable2 = this.getBackground();
        drawable2.setAlpha(this.customButtonTransparency);
    }

    @AutoHandleExceptions
    protected int getDefaultRequestCode() {
        return CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode();
    }

    LoginManager getLoginManager() {
        if (this.loginManager == null) {
            this.loginManager = LoginManager.getInstance();
        }
        return this.loginManager;
    }

    void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @AutoHandleExceptions
    protected class LoginClickListener
    implements View.OnClickListener {
        protected LoginClickListener() {
        }

        public void onClick(View v) {
            LoginButton.this.callExternalOnClickListener(v);
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            if (AccessToken.isCurrentAccessTokenActive()) {
                this.performLogout(LoginButton.this.getContext());
            } else {
                this.performLogin();
            }
            InternalAppEventsLogger logger = new InternalAppEventsLogger(LoginButton.this.getContext());
            Bundle parameters = new Bundle();
            parameters.putInt("logging_in", accessToken != null ? 0 : 1);
            parameters.putInt("access_token_expired", AccessToken.isCurrentAccessTokenActive() ? 1 : 0);
            logger.logEventImplicitly(LoginButton.this.loginLogoutEventName, parameters);
        }

        protected void performLogin() {
            LoginManager loginManager = this.getLoginManager();
            if (LoginButton.this.androidXLoginCaller != null) {
                CallbackManagerImpl callbackManager = LoginButton.this.callbackManager != null ? LoginButton.this.callbackManager : new CallbackManagerImpl();
                ((LoginManager.FacebookLoginActivityResultContract)LoginButton.this.androidXLoginCaller.getContract()).setCallbackManager((CallbackManager)callbackManager);
                LoginButton.this.androidXLoginCaller.launch((Object)LoginButton.this.properties.permissions);
            } else if (LoginButton.this.getFragment() != null) {
                loginManager.logIn(LoginButton.this.getFragment(), (Collection)LoginButton.this.properties.permissions, LoginButton.this.getLoggerID());
            } else if (LoginButton.this.getNativeFragment() != null) {
                loginManager.logIn(LoginButton.this.getNativeFragment(), (Collection)LoginButton.this.properties.permissions, LoginButton.this.getLoggerID());
            } else {
                loginManager.logIn(LoginButton.this.getActivity(), (Collection)LoginButton.this.properties.permissions, LoginButton.this.getLoggerID());
            }
        }

        protected void performLogout(Context context) {
            final LoginManager loginManager = this.getLoginManager();
            if (LoginButton.this.confirmLogout) {
                String logout = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_log_out_action);
                String cancel = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_cancel_action);
                Profile profile = Profile.getCurrentProfile();
                String message = profile != null && profile.getName() != null ? String.format(LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_as), profile.getName()) : LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_using_facebook);
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setMessage((CharSequence)message).setCancelable(true).setPositiveButton((CharSequence)logout, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        loginManager.logOut();
                    }
                }).setNegativeButton((CharSequence)cancel, null);
                builder.create().show();
            } else {
                loginManager.logOut();
            }
        }

        protected LoginManager getLoginManager() {
            LoginManager manager = LoginManager.getInstance();
            manager.setDefaultAudience(LoginButton.this.getDefaultAudience());
            manager.setLoginBehavior(LoginButton.this.getLoginBehavior());
            manager.setLoginTargetApp(this.getLoginTargetApp());
            manager.setAuthType(LoginButton.this.getAuthType());
            manager.setFamilyLogin(this.isFamilyLogin());
            manager.setShouldSkipAccountDeduplication(LoginButton.this.getShouldSkipAccountDeduplication());
            manager.setMessengerPageId(LoginButton.this.getMessengerPageId());
            manager.setResetMessengerState(LoginButton.this.getResetMessengerState());
            return manager;
        }

        protected LoginTargetApp getLoginTargetApp() {
            return LoginTargetApp.FACEBOOK;
        }

        protected boolean isFamilyLogin() {
            return false;
        }
    }

    static class LoginButtonProperties {
        private DefaultAudience defaultAudience = DefaultAudience.FRIENDS;
        private List<String> permissions = Collections.emptyList();
        private LoginBehavior loginBehavior = LoginBehavior.NATIVE_WITH_FALLBACK;
        private String authType = "rerequest";
        private LoginTargetApp targetApp = LoginTargetApp.FACEBOOK;
        private boolean shouldSkipAccountDeduplication = false;
        @Nullable
        private String messengerPageId;
        private boolean resetMessengerState;

        LoginButtonProperties() {
        }

        public void setDefaultAudience(DefaultAudience defaultAudience) {
            this.defaultAudience = defaultAudience;
        }

        public DefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        public void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        public void clearPermissions() {
            this.permissions = null;
        }

        public void setLoginBehavior(LoginBehavior loginBehavior) {
            this.loginBehavior = loginBehavior;
        }

        public LoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        public void setLoginTargetApp(LoginTargetApp targetApp) {
            this.targetApp = targetApp;
        }

        public LoginTargetApp getLoginTargetApp() {
            return this.targetApp;
        }

        public String getAuthType() {
            return this.authType;
        }

        public void setAuthType(String authType) {
            this.authType = authType;
        }

        protected void setShouldSkipAccountDeduplication(boolean shouldSkip) {
            this.shouldSkipAccountDeduplication = shouldSkip;
        }

        public boolean getShouldSkipAccountDeduplication() {
            return this.shouldSkipAccountDeduplication;
        }

        @Nullable
        public String getMessengerPageId() {
            return this.messengerPageId;
        }

        public void setMessengerPageId(@Nullable String pageId) {
            this.messengerPageId = pageId;
        }

        public boolean getResetMessengerState() {
            return this.resetMessengerState;
        }

        public void setResetMessengerState(boolean resetMessengerState) {
            this.resetMessengerState = resetMessengerState;
        }
    }

    public static enum ToolTipMode {
        AUTOMATIC("automatic", 0),
        DISPLAY_ALWAYS("display_always", 1),
        NEVER_DISPLAY("never_display", 2);

        public static ToolTipMode DEFAULT;
        private String stringValue;
        private int intValue;

        public static ToolTipMode fromInt(int enumValue) {
            for (ToolTipMode mode : ToolTipMode.values()) {
                if (mode.getValue() != enumValue) continue;
                return mode;
            }
            return null;
        }

        private ToolTipMode(String stringValue, int value) {
            this.stringValue = stringValue;
            this.intValue = value;
        }

        public String toString() {
            return this.stringValue;
        }

        public int getValue() {
            return this.intValue;
        }

        static {
            DEFAULT = AUTOMATIC;
        }
    }
}

