/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices.cloudgaming;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.Nullable;
import com.facebook.FacebookRequestError;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.cloudgaming.internal.SDKLogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class DaemonReceiver {
    @Nullable
    private static DaemonReceiver single_instance = null;
    private static ConcurrentHashMap<String, CompletableFuture<GraphResponse>> requestStore;
    private static SDKLogger mLogger;

    @SuppressLint(value={"BadDependencyInjection"})
    private DaemonReceiver(Context context) {
        IntentFilter filter = new IntentFilter("com.facebook.gamingservices.DAEMON_RESPONSE");
        HandlerThread thread = new HandlerThread("com.facebook.gamingservices.DAEMON_RESPONSE_HANDLER");
        thread.start();
        context.registerReceiver((BroadcastReceiver)new DaemonBroadcastReceiver(), filter, null, new Handler(thread.getLooper()));
        requestStore = new ConcurrentHashMap();
        mLogger = SDKLogger.getInstance(context);
    }

    synchronized ConcurrentHashMap<String, CompletableFuture<GraphResponse>> getRequestStore() {
        return requestStore;
    }

    static synchronized DaemonReceiver getInstance(Context context) {
        if (single_instance == null) {
            single_instance = new DaemonReceiver(context);
        }
        return single_instance;
    }

    private static GraphResponse processResponse(JSONObject payload, String requestID) {
        if (!payload.isNull("success")) {
            return DaemonReceiver.createSuccessResponse(payload, requestID);
        }
        if (!payload.isNull("error")) {
            return DaemonReceiver.createErrorResponse(payload, requestID);
        }
        return DaemonReceiver.createDefaultErrorResponse(requestID);
    }

    private static GraphResponse createSuccessResponse(JSONObject response, String requestID) {
        if (response.optJSONObject("success") != null) {
            mLogger.logSendingSuccessResponse(requestID);
            return new GraphResponse(null, null, null, response.optJSONObject("success"));
        }
        if (response.optJSONArray("success") != null) {
            mLogger.logSendingSuccessResponse(requestID);
            return new GraphResponse(null, null, null, response.optJSONArray("success"));
        }
        return DaemonReceiver.createDefaultErrorResponse(requestID);
    }

    static GraphResponse createErrorResponse(FacebookRequestError error, @Nullable String requestID) {
        mLogger.logSendingErrorResponse(error, requestID);
        return new GraphResponse(null, null, error);
    }

    private static GraphResponse createErrorResponse(JSONObject response, String requestID) {
        JSONObject error = response.optJSONObject("error");
        if (error != null) {
            return DaemonReceiver.createErrorResponse(new FacebookRequestError(error.optInt("code"), error.optString("type"), error.optString("message")), requestID);
        }
        return DaemonReceiver.createDefaultErrorResponse(requestID);
    }

    private static GraphResponse createDefaultErrorResponse(String requestID) {
        return DaemonReceiver.createErrorResponse(new FacebookRequestError(20, "UNSUPPORTED_FORMAT", "The response format is invalid."), requestID);
    }

    private static class DaemonBroadcastReceiver
    extends BroadcastReceiver {
        private DaemonBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            try {
                CompletableFuture future;
                JSONObject payload = new JSONObject(intent.getStringExtra("returnPayload"));
                String requestID = payload.getString("requestID");
                if (requestStore.containsKey(requestID) && (future = (CompletableFuture)requestStore.remove(requestID)) != null) {
                    GraphResponse processedPayload = DaemonReceiver.processResponse(payload, requestID);
                    future.complete(processedPayload);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }
}

