/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.content.Context;
import android.net.Uri;
import com.facebook.GraphRequest;
import com.facebook.gamingservices.OpenGamingMediaDialog;
import com.facebook.share.internal.VideoUploader;
import com.facebook.share.model.ShareVideo;
import com.facebook.share.model.ShareVideoContent;
import java.io.FileNotFoundException;

public class GamingVideoUploader {
    private Context context;

    public GamingVideoUploader(Context context) {
        this.context = context;
    }

    public void uploadToMediaLibrary(String caption, Uri videoUri) throws FileNotFoundException {
        this.uploadToMediaLibrary(caption, videoUri, null);
    }

    public void uploadToMediaLibrary(String caption, Uri videoUri, GraphRequest.OnProgressCallback callback) throws FileNotFoundException {
        this.uploadToMediaLibrary(caption, videoUri, false, callback);
    }

    public void uploadToMediaLibrary(String caption, Uri videoUri, boolean shouldLaunchMediaDialog, GraphRequest.OnProgressCallback callback) throws FileNotFoundException {
        ShareVideo shareVideo = new ShareVideo.Builder().setLocalUrl(videoUri).build();
        ShareVideoContent videoContent = new ShareVideoContent.Builder().setVideo(shareVideo).setContentDescription(caption).build();
        GraphRequest.OnProgressCallback uploadCallback = callback;
        if (shouldLaunchMediaDialog) {
            uploadCallback = new OpenGamingMediaDialog(this.context, (GraphRequest.Callback)callback);
        }
        VideoUploader.uploadAsyncWithProgressCallback((ShareVideoContent)videoContent, (GraphRequest.OnProgressCallback)uploadCallback);
    }
}

